/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.net.Socket;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortValidator
implements DataValidator,
Validator {
    private static final Logger logger = Logger.getLogger(PortValidator.class.getName());
    private static final String PARAM_EXCLUDED_PORTS = "excluded";
    private InstallData installData;

    public PortValidator(InstallData installData) {
        this.installData = installData;
    }

    @Override
    public boolean validate(ProcessingClient client) {
        boolean result = false;
        String moduleName = client.getText();
        logger.log(Level.FINE, "validate  ModuleName: " + moduleName);
        String host = "localhost";
        int numfields = client.getNumFields();
        ArrayList<String> exludedPorts = new ArrayList<String>();
        boolean modifyinstallation = ModifyInstallationUtil.get(this.installData);
        String excludedPortVariable = client.getConfigurationOptionValue(PARAM_EXCLUDED_PORTS);
        logger.log(Level.FINE, "validate  excludedPortVariable: " + excludedPortVariable);
        if (!StringUtil.isNullOrBlank(excludedPortVariable)) {
            VariableSubstitutorImpl substitutor = new VariableSubstitutorImpl(this.installData.getVariables());
            String excludedPort = substitutor.substitute(excludedPortVariable, SubstitutionType.TYPE_PLAIN);
            logger.log(Level.FINE, "validate  excludedPort: " + excludedPort);
            if (!StringUtil.isNullOrBlank(excludedPort)) {
                exludedPorts.add(excludedPort);
            }
        }
        for (int i = 0; i < numfields; ++i) {
            String value = client.getFieldContents(i);
            if (StringUtil.isNullOrBlank(value)) {
                logger.log(Level.FINE, "PortValidator.validate  Port value is null");
                return false;
            }
            if (modifyinstallation && exludedPorts.contains(value.trim())) continue;
            try {
                Socket socket = new Socket("localhost", Integer.parseInt(value));
                socket.close();
                logger.log(Level.FINE, "Someone responding on port - seems not open");
                result = false;
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "No answer on port " + value + " - seems available");
                logger.log(Level.FINE, ex.getMessage());
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "portinuse";
    }

    @Override
    public String getWarningMessageId() {
        return "portinuse";
    }

    @Override
    public DataValidator.Status validateData(InstallData arg0) {
        return DataValidator.Status.OK;
    }
}

