/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.panels.packs.PacksPanelAutomationHelper;
import com.sage.izpack.InstallationInformationHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacksNewPanelAutomationHelper
extends PacksPanelAutomationHelper {
    private static final Logger logger = Logger.getLogger(PacksNewPanelAutomationHelper.class.getName());
    private static final String prefixLabel = "PacksNewPanelAutomationHelper - ";
    private final Resources resources;

    public PacksNewPanelAutomationHelper(Resources resources) {
        this.resources = resources;
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) {
        PacksNewPanelAutomationHelper.readInstallationInformation(installData);
        PacksNewPanelAutomationHelper.preselectRequired(installData);
        super.runAutomated(installData, panelRoot);
    }

    public static void preselectRequired(InstallData installData) {
        for (Pack p : installData.getAvailablePacks()) {
            if (p.isRequired()) {
                p.setHidden(false);
                p.setPreselected(true);
            }
            logger.log(Level.FINE, "PacksNewPanelAutomationHelper - createPacksTable - Pack '" + p.getName() + "' Required: " + p.isRequired() + " Preselected: " + p.isPreselected());
        }
    }

    public static void readInstallationInformation(InstallData installData) {
        if (installData.getInfo().isReadInstallationInformation() && !InstallationInformationHelper.hasAlreadyReadInformation(installData)) {
            InstallationInformationHelper.readInformation(installData);
            logger.log(Level.FINE, "PacksNewPanelAutomationHelper - ReadInstallationInformation: has been read.");
        }
    }
}

