/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Overrides;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.PacksNewPanelAutomationHelper;
import com.sage.izpack.StringUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InstallTypeNewPanelAutomation
implements PanelAutomation {
    private static final String INSTALLPATH = "installpath";
    public static final String COMPONENT_NODE_NAME = "component.node.name";
    public static final String COMPONENT_NODE_TYPE = "component.node.type";
    public static final String MONGODB_SSL_ENABLE = "mongodb.ssl.enable";
    public static final String NEED_SERVICE_CONFIGURATION_FIX = "need-service-configuration-fix";
    private static Logger logger = Logger.getLogger(InstallTypeNewPanelAutomation.class.getName());
    private static final String logPrefix = "InstallTypeNewPanelAutomation - ";

    @Override
    public void createInstallationRecord(InstallData installData, IXMLElement panelRoot) {
        XMLElementImpl ipath = new XMLElementImpl("modify.izpack.install", panelRoot);
        Boolean isModify = ModifyInstallationUtil.get(installData);
        ipath.setContent(isModify.toString());
        IXMLElement prev = panelRoot.getFirstChildNamed("modify.izpack.install");
        if (prev != null) {
            panelRoot.removeChild(prev);
        }
        panelRoot.addChild(ipath);
        XMLElementImpl ipath2 = new XMLElementImpl(INSTALLPATH, panelRoot);
        ipath2.setContent(installData.getInstallPath());
        IXMLElement prev2 = panelRoot.getFirstChildNamed(INSTALLPATH);
        if (prev2 != null) {
            panelRoot.removeChild(prev2);
        }
        panelRoot.addChild(ipath2);
        boolean isSpecialBehavior = Boolean.parseBoolean(installData.getVariable(NEED_SERVICE_CONFIGURATION_FIX));
        if (!isModify.booleanValue() || !isSpecialBehavior) {
            return;
        }
        logger.log(Level.FINE, "InstallTypeNewPanelAutomation - createInstallationRecord. isSpecialBehavior: " + isSpecialBehavior);
        PacksNewPanelAutomationHelper.readInstallationInformation(installData);
        this.setVariableValue(COMPONENT_NODE_NAME, installData, panelRoot);
        this.setVariableValue(COMPONENT_NODE_TYPE, installData, panelRoot);
        this.setVariableValue(MONGODB_SSL_ENABLE, installData, panelRoot);
    }

    private void setVariableValue(String componentVarName, InstallData installData, IXMLElement panelRoot) {
        String componentValue = installData.getVariable(componentVarName);
        if (!StringUtil.isNullOrBlank(componentValue)) {
            IXMLElement prevName = panelRoot.getFirstChildNamed(componentVarName);
            if (prevName != null) {
                panelRoot.removeChild(prevName);
            }
            XMLElementImpl nodeName = new XMLElementImpl(componentVarName, panelRoot);
            nodeName.setContent(componentValue);
            panelRoot.addChild(nodeName);
        }
    }

    @Override
    public void runAutomated(InstallData installData, IXMLElement panelRoot) throws InstallerException {
        String installpath;
        boolean isModify = ModifyInstallationUtil.get(panelRoot);
        ModifyInstallationUtil.set(installData, isModify);
        IXMLElement ipath2 = panelRoot.getFirstChildNamed(INSTALLPATH);
        try {
            installpath = ipath2.getContent().trim();
            installData.setInstallPath(installpath);
        }
        catch (Exception ex) {
            throw new InstallerException(ex.getLocalizedMessage());
        }
        System.out.println();
        System.out.println(installpath);
        System.out.println();
        boolean isSpecialBehavior = Boolean.parseBoolean(installData.getVariable(NEED_SERVICE_CONFIGURATION_FIX));
        if (isSpecialBehavior && isModify) {
            IXMLElement nodeSSL;
            IXMLElement nodeType;
            IXMLElement nodeName = panelRoot.getFirstChildNamed(COMPONENT_NODE_NAME);
            if (nodeName != null && nodeName.getContent() != null) {
                installData.setVariable(COMPONENT_NODE_NAME, nodeName.getContent().trim());
            }
            if ((nodeType = panelRoot.getFirstChildNamed(COMPONENT_NODE_TYPE)) != null && nodeType.getContent() != null) {
                installData.setVariable(COMPONENT_NODE_TYPE, nodeType.getContent().trim());
            }
            if ((nodeSSL = panelRoot.getFirstChildNamed(MONGODB_SSL_ENABLE)) != null && nodeSSL.getContent() != null) {
                installData.setVariable(MONGODB_SSL_ENABLE, nodeSSL.getContent().trim());
            }
        }
    }

    @Override
    public void processOptions(InstallData installData, Overrides overrides) {
        boolean isSpecialBehavior;
        String installpath;
        String modifyInstallation = overrides.fetch("modify.izpack.install");
        if (modifyInstallation == null) {
            modifyInstallation = overrides.fetch("modify.izpack.install".toUpperCase());
        }
        if (modifyInstallation != null) {
            ModifyInstallationUtil.set(installData, modifyInstallation);
        }
        if ((installpath = overrides.fetch(INSTALLPATH)) != null) {
            installData.setVariable(INSTALLPATH, installpath.trim());
        }
        if ((isSpecialBehavior = Boolean.parseBoolean(installData.getVariable(NEED_SERVICE_CONFIGURATION_FIX))) && Boolean.parseBoolean(modifyInstallation)) {
            String nodeType;
            String nodeName = overrides.fetch(COMPONENT_NODE_NAME);
            if (nodeName != null) {
                installData.setVariable(COMPONENT_NODE_NAME, nodeName.trim());
            }
            if ((nodeType = overrides.fetch(COMPONENT_NODE_TYPE)) != null) {
                installData.setVariable(COMPONENT_NODE_TYPE, nodeType.trim());
            }
        }
    }
}

