/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.ParameterizedType;

public class GUIComponentSearcher<T> {
    private final Class<T> pGenericType;
    private int pIndex = 0;
    private final Container pRootContainer;
    private final int pTargetIndex;

    public GUIComponentSearcher(Class<T> aGenericType, Container aRootContainer, int aTargetIndex) {
        this.pGenericType = aGenericType;
        this.pRootContainer = aRootContainer;
        this.pTargetIndex = aTargetIndex;
    }

    public T search() throws Exception {
        this.pIndex = 0;
        T wGUIComponent = this.searchOne(this.pRootContainer);
        if (wGUIComponent == null) {
            throw new Exception(String.format("Unable to retrieve the %dth component [%s] Result", this.pTargetIndex, ParameterizedType.class.getSimpleName()));
        }
        return wGUIComponent;
    }

    private T searchOne(Container aContainer) {
        for (Component wComponent : aContainer.getComponents()) {
            Component wGUIComponent;
            if (this.pGenericType.isInstance(wComponent)) {
                ++this.pIndex;
                wGUIComponent = wComponent;
                if (this.pIndex >= this.pTargetIndex) {
                    return (T)wGUIComponent;
                }
            }
            if (!(wComponent instanceof Container) || (wGUIComponent = this.searchOne((Container)wComponent)) == null) continue;
            return (T)wGUIComponent;
        }
        return null;
    }
}

