/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.action.ButtonAction;
import com.izforge.izpack.util.Console;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CopyClipBoardBtAction
extends ButtonAction {
    private static final Logger logger = Logger.getLogger(CopyClipBoardBtAction.class.getName());
    private static final String prefixLabel = "CopyClipBoardBtAction - ";
    protected String variableIdToCopy;

    public CopyClipBoardBtAction(InstallData installData) {
        super(installData);
    }

    @Override
    public boolean execute() {
        logger.log(Level.FINE, "CopyClipBoardBtAction - execute");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String content = this.installData.getVariable(this.variableIdToCopy);
        StringSelection stringSelection = new StringSelection(content);
        clipboard.setContents(stringSelection, null);
        logger.log(Level.FINE, "CopyClipBoardBtAction - clipboard read variable " + this.variableIdToCopy + " content=" + content);
        return true;
    }

    @Override
    public boolean execute(Console console) {
        if (!this.execute()) {
            console.println("ERROR");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(Prompt prompt) {
        if (!this.execute()) {
            prompt.warn("ERROR");
            return false;
        }
        return true;
    }
}

