/*
 * Decompiled with CFR 0.152.
 */
package com.sage.izpack;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoIterable;
import com.sage.izpack.ModifyInstallationUtil;
import com.sage.izpack.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bson.Document;
import org.bson.conversions.Bson;

public class CheckSyracuseMongoDBDataValidator
implements DataValidator {
    private static Logger logger = Logger.getLogger(CheckSyracuseMongoDBDataValidator.class.getName());
    private static final String prefixLabel = "CheckSyracuseMongoDBDataValidator - ";

    private static boolean isSupportedVersion(String version) {
        Integer majorVersion = 0;
        try {
            String[] verStr1 = version.split("\\.");
            if (StringUtil.isNullOrBlank(verStr1[0])) {
                verStr1[0] = "0";
            }
            majorVersion = Integer.valueOf(verStr1[0]);
        }
        catch (NumberFormatException e) {
            majorVersion = 0;
        }
        return majorVersion >= 3;
    }

    @Override
    public DataValidator.Status validateData(InstallData adata) {
        DataValidator.Status bReturn = DataValidator.Status.OK;
        try {
            Boolean modifyinstallation = ModifyInstallationUtil.get(adata);
            String hostName = new String(adata.getVariable("mongodb.service.hostname"));
            String hostPort = adata.getVariable("mongodb.service.port");
            boolean sslEnabled = "true".equalsIgnoreCase(adata.getVariable("mongodb.ssl.enable"));
            String mongoCertPassword = new String(adata.getVariable("mongodb.url.password"));
            String certFile = adata.getVariable("mongodb.ssl.client.certfile");
            String pemkeyFile = adata.getVariable("mongodb.ssl.client.pemkeyfile");
            String pemcaFile = adata.getVariable("mongodb.ssl.pemcafile");
            if (!sslEnabled) {
                bReturn = this.testMongoDBConnection(modifyinstallation, hostName, hostPort);
            } else {
                bReturn = this.testMongoDBSSLConnection(modifyinstallation, hostName, hostPort, certFile, pemkeyFile, pemcaFile, mongoCertPassword);
                if (bReturn.equals((Object)DataValidator.Status.ERROR) && hostName.indexOf(".") < 0) {
                    logger.log(Level.WARNING, "The hostname '" + hostName + "' is not a FQDN (Fully Qualified Domain Name). Please try with the absolute domain name.");
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, prefixLabel + ex.getMessage());
            logger.log(Level.WARNING, prefixLabel + ex.getStackTrace());
            bReturn = DataValidator.Status.ERROR;
        }
        return bReturn;
    }

    private DataValidator.Status testMongoDBSSLConnection(Boolean modifyinstallation, String hostName, String hostPort, String certFile, String pemkeyFile, String pemcaFile, String mongoCertPassword) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException, FileNotFoundException, PEMException {
        PEMEncryptedKeyPair ukp;
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: " + hostName + " certFile: " + certFile + " pemkeyFile:" + pemkeyFile);
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> chainArray = new ArrayList<X509Certificate>();
        if (!StringUtil.isNullOrBlank(pemcaFile)) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            FileInputStream inPemCaFile = new FileInputStream(pemcaFile);
            X509Certificate cacert = (X509Certificate)factory.generateCertificate(inPemCaFile);
            trustStore.setCertificateEntry("root", cacert);
            File trustStoreFile = File.createTempFile("tru", null);
            FileOutputStream trustStoreFileOutputStream = new FileOutputStream(trustStoreFile);
            trustStore.store(trustStoreFileOutputStream, "truststore".toCharArray());
            trustStoreFileOutputStream.close();
            chainArray.add(cacert);
            System.setProperty("javax.net.ssl.trustStore", trustStoreFile.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", "truststore");
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        FileInputStream inPemCertFile = new FileInputStream(certFile);
        X509Certificate cert = (X509Certificate)factory.generateCertificate(inPemCertFile);
        FileInputStream inPemKeyFile = new FileInputStream(pemkeyFile);
        PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(inPemKeyFile));
        Object object = pemParser.readObject();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKey privateKey = null;
        if (object instanceof PEMEncryptedKeyPair) {
            ukp = (PEMEncryptedKeyPair)object;
            char[] password = mongoCertPassword.toCharArray();
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: " + hostName + " pemkeyFile is encrypted (" + pemkeyFile + "). Need password " + password);
            PEMDecryptorProvider decryptorProvider = new JcePEMDecryptorProviderBuilder().build(password);
            KeyPair keyPair = new JcaPEMKeyConverter().getKeyPair(ukp.decryptKeyPair(decryptorProvider));
            privateKey = keyPair.getPrivate();
        } else {
            ukp = (PEMKeyPair)object;
            KeyPair kp = converter.getKeyPair((PEMKeyPair)ukp);
            privateKey = kp.getPrivate();
        }
        pemParser.close();
        keyStore.setCertificateEntry(cert.getSubjectX500Principal().toString(), cert);
        chainArray.add(cert);
        Certificate[] chain = new X509Certificate[chainArray.size()];
        chain[0] = cert;
        if (chainArray.size() > 1) {
            chain[1] = (X509Certificate)chainArray.get(0);
        }
        keyStore.setKeyEntry("importkey", privateKey, "keystore".toCharArray(), chain);
        File keyStoreFile = File.createTempFile("key", null);
        FileOutputStream keyStoreFileOutputStream = new FileOutputStream(keyStoreFile);
        keyStore.store(keyStoreFileOutputStream, "keystore".toCharArray());
        keyStoreFileOutputStream.close();
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBSSLConnection: 'javax.net.ssl.keyStore' set to '" + keyStoreFile.getAbsolutePath() + "'");
        System.setProperty("javax.net.ssl.keyStore", keyStoreFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "keystore");
        System.setProperty("jdk.tls.trustNameService", "true");
        MongoClientOptions.Builder opts = MongoClientOptions.builder();
        opts.sslEnabled(true);
        opts.serverSelectionTimeout(60000);
        ServerAddress address = new ServerAddress(hostName, Integer.parseInt(hostPort));
        MongoClient mongoClient = new MongoClient(address, opts.build());
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - Init MongoDb SSL connection: " + address.toString() + " opt: " + opts.toString());
        String version = mongoClient.getDatabase("test").runCommand((Bson)new Document("buildInfo", (Object)1)).getString((Object)"version");
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb SSL connection: " + address.toString() + " version: " + version);
        DataValidator.Status bReturn = this.checkSyracuseDb(modifyinstallation, address, mongoClient, version);
        mongoClient.close();
        return bReturn;
    }

    private DataValidator.Status testMongoDBConnection(Boolean modifyinstallation, String hostName, String hostPort) {
        ServerAddress address = new ServerAddress(hostName, Integer.parseInt(hostPort));
        MongoClient mongoClient = new MongoClient(address);
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBConnection: " + address.toString());
        String version = mongoClient.getDatabase("test").runCommand((Bson)new Document("buildInfo", (Object)1)).getString((Object)"version");
        logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - testMongoDBConnection: " + address.toString() + " version: " + version);
        DataValidator.Status result = this.checkSyracuseDb(modifyinstallation, address, mongoClient, version);
        mongoClient.close();
        return result;
    }

    private DataValidator.Status checkSyracuseDb(Boolean modifyinstallation, ServerAddress address, MongoClient mongoClient, String version) {
        DataValidator.Status result = DataValidator.Status.WARNING;
        if (!CheckSyracuseMongoDBDataValidator.isSupportedVersion(version)) {
            logger.log(Level.WARNING, "CheckSyracuseMongoDBDataValidator - MongoDb version not supported: " + version);
            result = DataValidator.Status.ERROR;
        } else {
            MongoIterable lstDb = mongoClient.listDatabaseNames();
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb db list: " + lstDb + "  version: " + version);
            boolean syracuseExists = false;
            for (String dbb : lstDb) {
                if (!dbb.equalsIgnoreCase("syracuse")) continue;
                syracuseExists = true;
                break;
            }
            result = this.getContextResult(modifyinstallation, address, syracuseExists);
        }
        return result;
    }

    private DataValidator.Status getContextResult(Boolean modifyinstallation, ServerAddress address, boolean syracuseExists) {
        DataValidator.Status bReturn;
        if (syracuseExists) {
            logger.log(Level.FINE, "CheckSyracuseMongoDBDataValidator - MongoDb 'syracuse' db exists on " + address.toString());
            bReturn = modifyinstallation.booleanValue() ? DataValidator.Status.OK : DataValidator.Status.WARNING;
        } else {
            logger.log(Level.WARNING, "CheckSyracuseMongoDBDataValidator - MongoDb 'syracuse' db not found on " + address.toString());
            bReturn = modifyinstallation != false ? DataValidator.Status.ERROR : DataValidator.Status.OK;
        }
        return bReturn;
    }

    @Override
    public String getErrorMessageId() {
        return "mongodbtesterror";
    }

    @Override
    public String getWarningMessageId() {
        return "mongodbtestwarn";
    }

    @Override
    public boolean getDefaultAnswer() {
        return Boolean.TRUE;
    }
}

