/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.title;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.panels.userinput.field.Alignment;
import com.izforge.izpack.panels.userinput.field.title.TitleField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.Font;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class GUITitleField
extends GUIField {
    private static final Logger logger = Logger.getLogger(GUITitleField.class.getName());
    private JLabel label = null;

    public GUITitleField(TitleField field, InstallData installData, IconsDatabase icons) {
        super(field);
        String title = field.getLabel();
        if (title != null) {
            String iconName = field.getIconName(installData.getMessages());
            if (iconName != null) {
                try {
                    ImageIcon icon = (ImageIcon)icons.get(iconName);
                    this.label = LabelFactory.create(title, icon, 11, true);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Icon " + iconName + " not found in icon list: " + e.getMessage(), e);
                }
            }
            if (this.label == null) {
                this.label = LabelFactory.create(title);
            }
            Font font = this.label.getFont();
            float size = font.getSize();
            int style = 0;
            if (field.isBold()) {
                ++style;
            }
            if (field.isItalic()) {
                style += 2;
            }
            float multiplier = field.getTitleSize();
            font = font.deriveFont(style, size * multiplier);
            this.label.setFont(font);
            this.label.setAlignmentX(0.0f);
            int justify = this.getAlignment(field.getAlignment());
            TwoColumnConstraints constraints = new TwoColumnConstraints(9, justify);
            this.addComponent(this.label, constraints);
        }
        this.addTooltip();
    }

    private int getAlignment(Alignment alignment) {
        int result = 47;
        if (alignment == Alignment.LEFT) {
            result = 31;
        } else if (alignment == Alignment.CENTER) {
            result = 35;
        }
        return result;
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return null;
    }
}

