/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.text;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.text.TextArea;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GUITextArea
extends GUIField
implements FocusListener,
DocumentListener {
    private final JTextArea textArea;
    private final JScrollPane scrollPane;
    private transient boolean changed = false;

    public GUITextArea(TextArea field) {
        super(field);
        this.textArea = new JTextArea(field.getInitialValue(), field.getHeight(), field.getSize());
        this.textArea.setName(field.getVariable());
        this.textArea.setCaretPosition(0);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addFocusListener(this);
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        this.textArea.setEditable(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea, 20, 31);
        this.addField(this.scrollPane);
        this.addTooltip();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        boolean result = false;
        String text = this.textArea.getText();
        Field field = this.getField();
        ValidationStatus status = field.validate(text);
        if (skipValidation || status.isValid()) {
            field.setValue(text);
            result = true;
        } else {
            String message = status.getMessage();
            if (message == null) {
                message = "Text entered did not pass validation.";
            }
            this.warning(message, prompt);
        }
        return result;
    }

    @Override
    public boolean updateView() {
        boolean result = super.updateView();
        Field f = this.getField();
        String value = f.getInitialValue();
        if (value != null) {
            this.replaceValue(value);
            result = true;
        } else {
            String defaultValue = f.getDefaultValue();
            if (defaultValue != null) {
                this.replaceValue(defaultValue);
            }
        }
        return result;
    }

    private void replaceValue(String value) {
        boolean changed = false;
        String oldValue = this.textArea.getText();
        if (!(oldValue != null ? oldValue.equals(value) : value == null)) {
            this.textArea.getDocument().removeDocumentListener(this);
            this.textArea.setText(this.replaceVariables(value));
            this.textArea.getDocument().addDocumentListener(this);
            changed = true;
        }
        this.setChanged(changed);
    }

    public synchronized void setChanged(boolean changed) {
        this.changed = changed;
    }

    private synchronized boolean isChanged() {
        return this.changed;
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.textArea.selectAll();
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.isChanged()) {
            this.notifyUpdateListener();
            this.setChanged(false);
        }
        this.textArea.select(0, 0);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setChanged(true);
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.textArea;
    }
}

