/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.FieldFactory;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.List;

public class UserInputPanelSpec {
    public static final String SPEC_FILE_NAME = "userInputSpec.xml";
    public static final String PANEL = "panel";
    public static final String FIELD = "field";
    private final Config config;
    private final InstallData installData;
    private final PlatformModelMatcher matcher;
    private static final String PANEL_IDENTIFIER = "id";

    public UserInputPanelSpec(Resources resources, InstallData installData, ObjectFactory factory, PlatformModelMatcher matcher) {
        this.config = new Config(SPEC_FILE_NAME, resources, installData, factory);
        this.installData = installData;
        this.matcher = matcher;
    }

    public IXMLElement getPanelSpec(Panel panel) {
        return this.getPanelSpec(panel.getPanelId());
    }

    public IXMLElement getPanelSpec(String panelId) {
        List<IXMLElement> panels = this.config.getRoot().getChildrenNamed(PANEL);
        IXMLElement result = null;
        for (IXMLElement spec : panels) {
            String id = spec.getAttribute(PANEL_IDENTIFIER);
            if (id == null || panelId == null || !panelId.equals(id)) continue;
            result = spec;
            break;
        }
        if (result == null) {
            throw new IzPackException("No user input specification with id=" + panelId);
        }
        return result;
    }

    public List<Field> createFields(IXMLElement panel) {
        ArrayList<Field> result = new ArrayList<Field>();
        List<IXMLElement> elements = panel.getChildrenNamed(FIELD);
        FieldFactory factory = new FieldFactory(this.config, this.installData, this.matcher);
        for (IXMLElement element : elements) {
            Field field = factory.create(element);
            result.add(field);
        }
        return result;
    }

    public Config getConfig() {
        return this.config;
    }
}

