/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.licence;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceException;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.AbstractTextConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.licence.LicenceLoader;
import com.izforge.izpack.util.Console;
import java.net.URL;
import java.util.logging.Logger;

public abstract class AbstractLicenceConsolePanel
extends AbstractTextConsolePanel {
    private final transient LicenceLoader licenceLoader;
    private final Resources resources;
    private static final Logger logger = Logger.getLogger(AbstractLicenceConsolePanel.class.getName());

    public AbstractLicenceConsolePanel(PanelView<ConsolePanel> panel, Resources resources) {
        super(panel);
        this.resources = resources;
        this.licenceLoader = new LicenceLoader(this.getPanel(), resources);
    }

    protected URL loadLicence() {
        try {
            return this.licenceLoader.asURL();
        }
        catch (ResourceException e) {
            logger.warning(e.getMessage());
            return null;
        }
    }

    protected String loadLicenceAsString() {
        return this.licenceLoader.asString();
    }

    @Override
    protected boolean promptEndPanel(InstallData installData, Console console) {
        boolean result;
        Messages messages = installData.getMessages();
        String prompt = messages.get("ConsoleInstaller.acceptRejectRedisplay", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 3, 2);
        switch (value) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                throw new UserInterruptException(messages.get("ConsoleInstaller.aborted.LicenseRejected", new Object[0]));
            }
            default: {
                result = this.run(installData, console);
            }
        }
        return result;
    }
}

