/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.installer.unpacker.Cancellable;
import com.izforge.izpack.installer.unpacker.FileUnpacker;
import com.izforge.izpack.util.StreamSupport;
import com.izforge.izpack.util.os.FileQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class CompressedFileUnpacker
extends FileUnpacker {
    private final PackCompression compressionFormat;

    public CompressedFileUnpacker(Cancellable cancellable, FileQueue queue, PackCompression compressionFormat) {
        super(cancellable, queue);
        this.compressionFormat = compressionFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(PackFile file, InputStream packInputStream, File target) throws IOException, InstallerException {
        long fileSize = file.size();
        long fileLength = file.length();
        long backReferenceFileLength = file.isBackReference() ? file.getLinkedPackFile().size() : fileSize;
        Path tmpfile = Files.createTempFile("izpack-uncompress", null, new FileAttribute[0]);
        try {
            try (OutputStream fo = Files.newOutputStream(tmpfile, new OpenOption[0]);){
                long bytesUnpacked = IOUtils.copyLarge(packInputStream, fo, 0L, fileSize);
                if (bytesUnpacked != fileSize && bytesUnpacked != backReferenceFileLength) {
                    throw new IOException("File size mismatch when reading from pack: " + file.getRelativeSourcePath());
                }
            }
            try (InputStream in = Files.newInputStream(tmpfile, new OpenOption[0]);
                 InputStream finalStream = StreamSupport.compressedInput(this.compressionFormat, in);){
                long bytesUncompressed = this.copy(file, finalStream, target);
                if (bytesUncompressed != fileLength) {
                    throw new IOException("File size mismatch when uncompressing from pack: " + file.getRelativeSourcePath());
                }
            }
        }
        finally {
            Files.deleteIfExists(tmpfile);
        }
    }
}

