/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.event.AbstractProgressInstallerListener;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import java.io.File;

public class ChmodInstallerListener
extends AbstractProgressInstallerListener {
    public ChmodInstallerListener(InstallData installData) {
        super(installData);
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    @Override
    public void afterFile(File filePath, PackFile pf, Pack pack) {
        if (pf.getAdditionals() == null) {
            return;
        }
        Object file = pf.getAdditionals().get("permission.file");
        int fileVal = -1;
        if (file != null && file instanceof Integer) {
            fileVal = (Integer)file;
        }
        if (fileVal != -1) {
            this.chmod(filePath, fileVal);
        }
    }

    @Override
    public void afterDir(File dirPath, PackFile pf, Pack pack) {
        if (pf.getAdditionals() == null) {
            return;
        }
        if (dirPath == null) {
            return;
        }
        Object dir = pf.getAdditionals().get("permission.dir");
        int dirVal = -1;
        if (dir != null && dir instanceof Integer) {
            dirVal = (Integer)dir;
        }
        if (dirVal != -1) {
            if ((dirVal & 0x1C0) < 448) {
                throw new InstallerException("Bad owner permission for directory " + dirPath.getAbsolutePath() + "; at installation time the owner needs full rights");
            }
            this.chmod(dirPath, dirVal);
        }
    }

    private void chmod(File path, int permissions) {
        String pathSep = System.getProperty("path.separator");
        if (OsVersion.IS_WINDOWS) {
            throw new InstallerException("Sorry, chmod not supported yet on windows; use this class OS dependant.");
        }
        if (path == null) {
            return;
        }
        String permStr = Integer.toOctalString(permissions);
        String[] params = new String[]{"chmod", permStr, path.getAbsolutePath()};
        String[] output = new String[2];
        FileExecutor fe = new FileExecutor();
        fe.executeCommand(params, output);
    }
}

