import { dialogMessage } from '@sage/x3-master-data/lib/client-functions/dialogs';
import { GeneralParameter } from '@sage/x3-system-api';
import { extractEdges, ExtractEdges } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';

export async function readParameterValue(
    parameter: string,
    user: string,
    stockSite: string,
    pageInstance: ui.Page,
): Promise<any | undefined> {
    try {
        let resp;
        const response = extractEdges(
            await pageInstance.$.graph
                .node('@sage/x3-system/GeneralParameter')
                .query(
                    ui.queryUtils.edgesSelector(
                        {
                            _id: true,
                            definitionLevel: true,
                            folderValue: true,
                            valueType: true,
                        },
                        {
                            filter: {
                                code: parameter,
                            },
                        },
                    ),
                )
                .execute(),
        ) as ExtractEdges<GeneralParameter[]>;
        // Call appropriate function depending on parameter level
        if (response[0].definitionLevel === 'user' && response[0].folderValue === false) {
            if (response[0].valueType === 'alphanumeric') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueString(
                        { value: true },
                        {
                            parameters: {
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            } else if (response[0].valueType === 'numeric' || response[0].valueType === 'localMenu') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueInteger(
                        { value: true },
                        {
                            parameters: {
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            } else if (response[0].valueType === 'date') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/UserParameterValue')
                    .mutations.readParameterValueDate(
                        { value: true },
                        {
                            parameters: {
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            }
        } else {
            if (response[0].valueType === 'alphanumeric') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueString(
                        { value: true },
                        {
                            parameters: {
                                company: '',
                                site: stockSite,
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            } else if (response[0].valueType === 'numeric' || response[0].valueType === 'localMenu') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueInteger(
                        { value: true },
                        {
                            parameters: {
                                company: '',
                                site: stockSite,
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            } else if (response[0].valueType === 'date') {
                resp = await pageInstance.$.graph
                    .node('@sage/x3-system/GeneralParametersData')
                    .mutations.readParameterValueDate(
                        { value: true },
                        {
                            parameters: {
                                company: '',
                                site: stockSite,
                                code: parameter,
                            },
                        },
                    )
                    .execute();
                return resp.value;
            }
            return '' as string;
        }
    } catch (e) {
        await dialogMessage(
            pageInstance,
            'error',
            ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'),
            ui.localize(
                '@sage/x3-purchasing/utils-error-reading-parameter-value',
                'Error reading parameter value: {{ param }}',
                { param: parameter },
            ),
        );
        return '' as string;
    }
}
