/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/defaultValue.ts":
/*!**********************************************!*\
  !*** ./lib/client-functions/defaultValue.ts ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.useByDateDefaultValue = exports.expirationDateDefaultValue = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\n/**\n * Return the default value corresponding to the product rule for the expiry date\n * @param product\n * @param effectiveDate\n * @return\n */\nfunction expirationDateDefaultValue(productExpirationManagementMode, productExpirationLeadTime, productExpirationLeadTimeUnit, effectiveDate) {\n    let _tmpDate = effectiveDate ? xtrem_date_time_1.date.parse(effectiveDate) : null;\n    let expiryDate;\n    if (typesLib.strictEq(_tmpDate, null))\n        return null;\n    if (typesLib.strictNe(productExpirationManagementMode, null)) {\n        // Check if the product is not managed in expiration mode\n        if (typesLib.strictEq(productExpirationManagementMode, 'notManaged') || typesLib.strictEq(productExpirationManagementMode, 'manualEntry')) {\n            // returns 2999-12-31\n            //expiryDate = date.make(2999, 12, 31);\n            return null;\n        }\n        else {\n            expiryDate = null;\n            if (typesLib.strictEq(productExpirationLeadTimeUnit, 'calendarDays')) {\n                // the expiry date is effectiveDate + expirationLeadTime duration value in days\n                expiryDate = _tmpDate.addDays(productExpirationLeadTime);\n            }\n            // Check if expiration time unit is months\n            if (typesLib.strictEq(productExpirationLeadTimeUnit, 'month')) {\n                // the expiry date is effectiveDate + expirationLeadTime in months\n                expiryDate = _tmpDate.addMonths(productExpirationLeadTime);\n            }\n            if (typesLib.strictEq(productExpirationManagementMode, 'roundingMonthEnd') || typesLib.strictEq(productExpirationManagementMode, 'roundingBeginningMonth1')) {\n                // Check if the product expiration mode indicate a rounding rule\n                if (typesLib.strictEq(productExpirationManagementMode, 'roundingMonthEnd')) {\n                    // if the rounding rule is month end\n                    expiryDate = _tmpDate.endOfMonth();\n                }\n                else if (typesLib.strictEq(productExpirationManagementMode, 'roundingBeginningMonth1')) {\n                    // if the rounding rule is next month begin\n                    expiryDate = _tmpDate.begOfMonth().addMonths(1);\n                }\n            }\n        }\n    }\n    else {\n        return null;\n    }\n    // if none of the above conditions are met:\n    return expiryDate ? expiryDate.format('YYYY-MM-DD') : null;\n}\nexports.expirationDateDefaultValue = expirationDateDefaultValue;\nfunction useByDateDefaultValue(expirationDate, referenceDate, productExpirationManagement, useByDateCoefficient) {\n    let _tmpExpirationDate = expirationDate ? xtrem_date_time_1.date.parse(expirationDate) : null;\n    let _tmpReferenceDate = referenceDate ? xtrem_date_time_1.date.parse(referenceDate) : null;\n    let useByDate;\n    if (typesLib.strictEq(_tmpExpirationDate, null) && typesLib.strictEq(_tmpReferenceDate, null))\n        return null;\n    if (typesLib.strictNe(productExpirationManagement, null)) {\n        // Check if the product is not managed in expiration mode\n        if (typesLib.strictEq(productExpirationManagement, 'notManaged') || typesLib.strictEq(productExpirationManagement, 'manualEntry')) {\n            return null;\n        }\n        if (typesLib.gt(useByDateCoefficient, 1) || typesLib.strictEq(useByDateCoefficient, 0) || typesLib.lt(useByDateCoefficient, 0)) {\n            useByDateCoefficient = 1;\n        }\n        if (_tmpExpirationDate) {\n            if (_tmpReferenceDate && typesLib.gt(_tmpExpirationDate, _tmpReferenceDate)) {\n                const delay = typesLib.round(typesLib.mul(useByDateCoefficient, _tmpExpirationDate.daysDiff(_tmpReferenceDate)));\n                useByDate = _tmpReferenceDate.addDays(delay);\n            }\n            else {\n                useByDate = _tmpExpirationDate;\n            }\n        }\n        else {\n            return null;\n        }\n    }\n    else {\n        return null;\n    }\n    return useByDate ? useByDate.format('YYYY-MM-DD') : null;\n}\nexports.useByDateDefaultValue = useByDateDefaultValue;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/defaultValue.ts\n");

/***/ }),

/***/ "./lib/client-functions/product-site-data.ts":
/*!***************************************************!*\
  !*** ./lib/client-functions/product-site-data.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ProductSiteData = void 0;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nclass ProductSiteData {\n    constructor(productCode, site, page) {\n        this.productCode = productCode;\n        this.site = site;\n        this.page = page;\n    }\n    async _lazyLoadProductSite() {\n        if (this._productSite) {\n            return this._productSite;\n        }\n        // read product site record\n        try {\n            const productSiteToReceive = (await this.page.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .read({\n                isLicensePlateNumberManaged: true,\n                isLocationManaged: true,\n                stockSite: {\n                    code: true,\n                },\n                defaultLocations: {\n                    query: {\n                        edges: {\n                            node: {\n                                defaultLocationType: true,\n                                locationNumber: true,\n                                defaultLocation: true,\n                            },\n                        },\n                    },\n                },\n                product: {\n                    code: true,\n                    productCategory: { code: true },\n                    serialNumberManagementMode: true,\n                    serialSequenceNumber: true,\n                    localizedDescription1: true,\n                    lotManagementMode: true,\n                    lotSequenceNumber: true,\n                    stockVersionMode: true,\n                    expirationManagementMode: true,\n                    stockManagementMode: true,\n                    defaultPotencyInPercentage: true,\n                    purchaseUnitToStockUnitConversionFactor: true,\n                    useByDateCoefficient: true,\n                    expirationLeadTime: true,\n                    expirationTimeUnit: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    purchaseUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                },\n                            },\n                        },\n                    },\n                },\n                defaultInternalContainer: {\n                    code: true,\n                },\n            }, `${this.productCode}|${this.site}`)\n                .execute());\n            this._productSite = productSiteToReceive;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this.page, 'error', ui.localize('@sage/x3-purchasing/error-loading-product-site', 'Error loading product-site'), String(e));\n            return undefined;\n        }\n        return this._productSite;\n    }\n    async _lazyLoadProduct() {\n        if (this._product) {\n            return this._product;\n        }\n        // read product site record\n        try {\n            const productToReceive = (await this.page.$.graph\n                .node('@sage/x3-master-data/Product')\n                .read({\n                code: true,\n                productCategory: { code: true },\n                serialNumberManagementMode: true,\n                serialSequenceNumber: true,\n                localizedDescription1: true,\n                lotManagementMode: true,\n                lotSequenceNumber: true,\n                stockVersionMode: true,\n                expirationManagementMode: true,\n                stockManagementMode: true,\n                defaultPotencyInPercentage: true,\n                purchaseUnitToStockUnitConversionFactor: true,\n                useByDateCoefficient: true,\n                expirationLeadTime: true,\n                expirationTimeUnit: true,\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                purchaseUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnits: {\n                    query: {\n                        edges: {\n                            node: {\n                                packingUnit: {\n                                    code: true,\n                                    numberOfDecimals: true,\n                                },\n                                packingUnitToStockUnitConversionFactor: true,\n                                isPackingFactorEntryAllowed: true,\n                            },\n                        },\n                    },\n                },\n            }, `${this.productCode}`)\n                .execute());\n            this._product = productToReceive;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(this.page, 'error', ui.localize('@sage/x3-purchasing/error-loading-product', 'Error loading product.'), String(e));\n            return undefined;\n        }\n        return this._product;\n    }\n    /*\n     * The GraphQL query that will be used to get values of the product-site node.\n     * This default query can be modified or completely overridden.\n     */\n    get productSite() {\n        return this._lazyLoadProductSite();\n    }\n    get product() {\n        return this._lazyLoadProduct();\n    }\n}\nexports.ProductSiteData = ProductSiteData;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/product-site-data.ts\n");

/***/ }),

/***/ "./lib/client-functions/purchase-receipt-details-control.ts":
/*!******************************************************************!*\
  !*** ./lib/client-functions/purchase-receipt-details-control.ts ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PurchaseReceiptDetailsRecordManager = exports.controlLotReceipt = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst xtrem_ui_1 = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function validate(page) {\n    // (X3-201046, X3-203885) TODO Issue: Have better validation error messages that specifically tell which fields have issues\n    const errors = await page.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    page.$.showToast(`${(0, xtrem_ui_1.localize)('@sage/x3-purchasing/dialog-error-title', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validate = validate;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    let stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockJournal')\n        .query(xtrem_ui_1.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast((0, xtrem_ui_1.localize)('@sage/x3-purchasing/notification-error-receipt-lot', 'the lot number {{ lot }} already exists for this product', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\nvar YesNoEnum;\n(function (YesNoEnum) {\n    YesNoEnum[YesNoEnum[\"no\"] = 1] = \"no\";\n    YesNoEnum[YesNoEnum[\"yes\"] = 2] = \"yes\";\n})(YesNoEnum || (YesNoEnum = {}));\nclass PurchaseReceiptDetailsRecordManager {\n    constructor(page, cleanupIncompleteSessionLines = false) {\n        this.page = page;\n        this._stockDetails = [];\n        this._receiptUnit = [];\n        this._unitIsSame = true;\n        // An incomplete purchase receipt line can be added to the session when user is transitioning from main page to enter detail page\n        if (cleanupIncompleteSessionLines)\n            this._cleanupSession();\n    }\n    static { this.PURCHASE_RECEIPT_KEY = 'purchaseReceipt'; }\n    get purchaseSession() {\n        if (this._purchaseSession) {\n            return this._purchaseSession;\n        }\n        const storedSession = this.page.$.storage.get(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        if (storedSession) {\n            const parsedSession = JSON.parse(storedSession);\n            if (this._checkStorage(parsedSession)) {\n                this._purchaseSession = parsedSession;\n            }\n            else {\n                // purchase receipt in the session storage is corrupted/malformed\n                this.clearSession();\n            }\n        }\n        return this._purchaseSession;\n    }\n    set purchaseSession(purchaseSession) {\n        if (!purchaseSession) {\n            return;\n        }\n        if (!this._checkStorage(purchaseSession)) {\n            throw new Error('Invalid Purchase Receipt session');\n        }\n        this.page.$.storage.set(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY, JSON.stringify(purchaseSession));\n        this._purchaseSession = purchaseSession;\n    }\n    _checkStorage(sessionData) {\n        // check if sessionData contains at least one purchase receipt line that has at least one stock detail line\n        if (!sessionData ||\n            !sessionData.purchaseEntryTransaction.code ||\n            !sessionData.purchaseReceipt.receiptDate ||\n            !sessionData.purchaseReceipt.lines || typesLib.strictEq(sessionData.purchaseReceipt.lines.length, 0) ||\n            !sessionData.purchaseReceipt.receiptSite ||\n            !sessionData.purchaseReceipt.supplier) {\n            return false;\n        }\n        return !sessionData.purchaseReceipt.lines.some((line) => {\n            // skip most recent line that is pending to be completed in detail page\n            if (!line.stockDetails) {\n                return false;\n            }\n            // check for each line, the receipt unit & quantity are defined\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined)) {\n                return true;\n            }\n            return line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n    }\n    _cleanupSession() {\n        this._purchaseSession = this.purchaseSession; // get the latest from session\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        // remove any incomplete purchase receipt lines (ex. a line without stockDetails)\n        const prevLineCount = this._purchaseSession.purchaseReceipt.lines?.length;\n        this._purchaseSession.purchaseReceipt.lines = this._purchaseSession.purchaseReceipt.lines.filter((line) => {\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined) ||\n                !line.stockDetails) {\n                return false;\n            }\n            return !line.stockDetails.some((detail) => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n        // if all lines have been removed, clear the session\n        if (typesLib.strictEq(this._purchaseSession.purchaseReceipt.lines?.length, 0)) {\n            this.clearSession();\n        }\n        else if (typesLib.strictNe(prevLineCount, this._purchaseSession.purchaseReceipt.lines.length)) {\n            // otherwise if any line got removed, overwrite the session\n            this.purchaseSession = this._purchaseSession;\n        }\n    }\n    clearSession() {\n        this.page.$.storage.remove(PurchaseReceiptDetailsRecordManager.PURCHASE_RECEIPT_KEY);\n        this._purchaseSession = null;\n    }\n    createLine(page, product) {\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currentLineNumber = typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1);\n        const currentLine = this._purchaseSession.purchaseReceipt.lines[currentLineNumber];\n        currentLine.stockDetails = this._stockDetails;\n        // If all receipt units are the same, use that unit for the line. If there are multiple receipt units,\n        // use stock unit for the line.\n        if (this._unitIsSame) {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, line.quantityInReceiptUnit);\n            }, 0);\n            currentLine.receiptUnit = this._receiptUnit[0].code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        else {\n            currentLine.quantityInReceiptUnitReceived = this._receiptUnit.reduce((totalQty, line) => {\n                return typesLib.add(totalQty, typesLib.mul(Number(line.quantityInReceiptUnit), Number(line.stockUnitConversionFactor)));\n            }, 0);\n            currentLine.receiptUnit = product.stockUnit.code;\n            currentLine.receiptUnitToStockUnitConversionFactor = Number(page.packingUnitToStockUnitConversionFactor.value);\n        }\n        //Set receipt line number\n        currentLine.lineNumber = typesLib.mul((typesLib.add(currentLineNumber, 1)), 1000);\n        /*  if (\n            currentLine.purchaseOrderNumber &&\n            currentLine.purchaseOrderLineNumber &&\n            currentLine.purchaseOrderLine\n        ) {\n            currentLine._forMutationOnlyDoClosePurchaseOrderLine =\n                page.closePoLine.options.indexOf(page.closePoLine.value) === 0 ? YesNoEnum.yes : YesNoEnum.no;\n        } _forMutationOnlyDoClosePurchaseOrderLine missing */\n        currentLine.balance = (typesLib.strictEq(page.closePoLine.value, ui.localize('@sage/x3-purchasing/Yes', 'Yes')) ? YesNoEnum.yes : YesNoEnum.no).toString();\n        currentLine.warehouse = page.warehouse.value ?? undefined;\n        currentLine.container = page.container?.value?.code;\n        this.purchaseSession = {\n            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n            orderUnitToPurchaseUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 0,\n        };\n    }\n    loadStockDetails(page, product) {\n        const quantityReceivedInStockUnit = typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n        // Saving receipt units is separate array because only stock and packing units are saved at stock details level.\n        this._receiptUnit.push({\n            code: page.receiptUnitCode.value ?? '',\n            quantityInReceiptUnit: page.quantityToReceive.value ?? 0,\n            stockUnitConversionFactor: page.packingUnitToStockUnitConversionFactor.value ?? 1,\n        });\n        // Check if unit is different from previous line\n        if (typesLib.gt(this._receiptUnit.length, 1) && this._unitIsSame) {\n            if (typesLib.strictNe(page.receiptUnitCode.value, this._receiptUnit[typesLib.sub(this._receiptUnit.length, 2)].code)) {\n                this._unitIsSame = false;\n            }\n        }\n        const detailLine = {\n            packingUnit: page.isPackingUnit ? (page.receiptUnitCode.value ?? '') : product.stockUnit.code,\n            quantityInPackingUnit: page.isPackingUnit\n                ? (page.quantityToReceive.value ?? 0)\n                : quantityReceivedInStockUnit,\n            packingUnitToStockUnitConversionFactor: page.isPackingUnit\n                ? (page.packingUnitToStockUnitConversionFactor.value ?? 1)\n                : 1,\n            lot: page.lot.value ?? undefined, // using undefined, omits the property entirely from JSON when stringified\n            sublot: page.sublot.value ?? undefined,\n            supplierLot: page.supplierLot.value ?? undefined,\n            potency: page.potency.value ?? undefined,\n            location: page.location.value?.code,\n            serialNumber: page.serialNumber.value ?? undefined,\n            status: page.status.value ?? undefined, // this is always required\n            majorVersion: page.majorVersion.value?.code,\n            minorVersion: page.minorVersion.value?.minorVersion,\n            licensePlateNumber: page.licensePlateNumber.value?.code,\n            expirationDate: (page.expirationDate.isDisabled ? page.calculatedExpirationDate.value : page.expirationDate.value) ??\n                undefined,\n            useByDate: page.useByDate.value ?? undefined,\n            lotCustomField1: page.lotCustomField1.value ?? undefined,\n            lotCustomField2: page.lotCustomField2.value ?? undefined,\n            lotCustomField3: page.lotCustomField3.value ?? undefined,\n            lotCustomField4: page.lotCustomField4.value ?? undefined,\n            identifier1: page.identifier1.value ?? undefined,\n            identifier2: page.identifier2.value ?? undefined,\n        };\n        this._stockDetails.push(detailLine);\n        // Initialize detail page for next detail line.  Most field values will default to previous detail line values.\n        page.location.isDisabled = false;\n        page.licensePlateNumber.value = { code: '' };\n        page.sublot.value = '';\n        page.serialNumber.value = '';\n        if (!this._purchaseSession || !this._purchaseSession.purchaseReceipt.lines)\n            return;\n        const currLine = this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)];\n        if (!currLine.purchaseOrder) {\n            // Set remaining quantity to 0 for direct receipts\n            page.quantityToReceive.value = 0;\n        }\n        else {\n            // Calculate remaining quantity for PO receipt lines (not direct receipt)\n            // remainingQuantity and quantityToReceive will always be the same unit and that unit will be the default\n            // for the next detail line.  Value can never be negative\n            page.remainingQuantityInStockUnit.value = typesLib.sub((page.remainingQuantityInStockUnit.value ?? 0), typesLib.mul((page.quantityToReceive.value ?? 0), (page.packingUnitToStockUnitConversionFactor.value ?? 1)));\n            if (typesLib.strictNe(page.packingUnitToStockUnitConversionFactor.value, 0))\n                page.remainingQuantityInPackingUnit.value = typesLib.div(page.remainingQuantityInStockUnit.value, (page.packingUnitToStockUnitConversionFactor.value ?? 1));\n            page.quantityToReceive.value = typesLib.max(0, page.remainingQuantityInPackingUnit.value ?? 0);\n            page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n        }\n    }\n}\nexports.PurchaseReceiptDetailsRecordManager = PurchaseReceiptDetailsRecordManager;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9saWIvY2xpZW50LWZ1bmN0aW9ucy9wdXJjaGFzZS1yZWNlaXB0LWRldGFpbHMtY29udHJvbC50cyIsIm1hcHBpbmdzIjoiOzs7O0FBT0EsMkZBQWtEO0FBRWxELHVFQUFxQztBQUNyQywrRUFBNEQ7QUFPckQsS0FBSyxVQUFVLFFBQVEsQ0FBQyxJQUFVO0lBQ3JDLDJIQUEySDtJQUMzSCxNQUFNLE1BQU0sR0FBRyxNQUFNLElBQUksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQzVDLHNCQUFJLE1BQU0sQ0FBQyxNQUFNLEVBQUssQ0FBQyxHQUFFLENBQUM7UUFDdEIsT0FBTyxJQUFJLENBQUM7SUFDaEIsQ0FBQztJQUVELElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsdUJBQVEsRUFBQyx3Q0FBd0MsRUFBRSxPQUFPLENBQUMsS0FBSyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtRQUM3RixJQUFJLEVBQUUsT0FBTztRQUNiLE9BQU8sRUFBRSxLQUFLO0tBQ2pCLENBQUMsQ0FBQztJQUVILE9BQU8sS0FBSyxDQUFDO0FBQ2pCLENBQUM7QUFiRCw0QkFhQztBQUNNLEtBQUssVUFBVSxpQkFBaUIsQ0FDbkMsWUFBa0IsRUFDbEIsR0FBVyxFQUNYLE9BQWUsRUFDZixTQUFpQixFQUNqQixJQUFZO0lBRVosSUFBSSxDQUFDLEdBQUcsSUFBSSxDQUFDLE9BQU8sSUFBSSxDQUFDLFNBQVM7UUFBRSxNQUFNLElBQUksS0FBSyxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDekUsSUFBSSxrQkFBa0IsR0FBRztRQUNyQixTQUFTLEVBQUUsSUFBSTtRQUNmLFlBQVksRUFBRSxTQUFTO1FBQ3ZCLE9BQU8sRUFBRSxFQUFFLElBQUksRUFBRSxPQUFPLEVBQUU7UUFDMUIsU0FBUyxFQUFFLElBQUk7UUFDZixHQUFHLEVBQUUsR0FBRztLQUNYLENBQUM7SUFFRixNQUFNLFFBQVEsR0FBRywrQkFBWSxFQUN6QixNQUFNLFlBQVksQ0FBQyxDQUFDLENBQUMsS0FBSztTQUNyQixJQUFJLENBQUMsa0NBQWtDLENBQUM7U0FDeEMsS0FBSyxDQUNGLHFCQUFVLENBQUMsYUFBYSxDQUNwQjtRQUNJLEdBQUcsRUFBRSxJQUFJO1FBQ1QsTUFBTSxFQUFFLElBQUk7S0FDZixFQUNEO1FBQ0ksTUFBTSxFQUFFLGtCQUFrQjtLQUM3QixDQUNKLENBQ0o7U0FDQSxPQUFPLEVBQUUsQ0FDakIsQ0FBQztJQUVGLGdCQUFJLFFBQVEsQ0FBQyxNQUFNLEVBQUcsQ0FBQyxHQUFFLENBQUM7UUFDdEIsWUFBWSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQ3BCLHVCQUFRLEVBQ0osb0RBQW9ELEVBQ3BELDBEQUEwRCxFQUMxRCxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FDZixFQUNELEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxDQUNwQixDQUFDO1FBQ0YsT0FBTyxLQUFLLENBQUM7SUFDakIsQ0FBQztJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2hCLENBQUM7QUE3Q0QsOENBNkNDO0FBRUQsSUFBSyxTQUdKO0FBSEQsV0FBSyxTQUFTO0lBQ1YscUNBQU07SUFDTix1Q0FBTztBQUNYLENBQUMsRUFISSxTQUFTLEtBQVQsU0FBUyxRQUdiO0FBU0QsTUFBYSxtQ0FBbUM7SUFDNUMsWUFDWSxJQUFvQixFQUM1Qiw2QkFBNkIsR0FBRyxLQUFLO1FBRDdCLFNBQUksR0FBSixJQUFJLENBQWdCO1FBV3hCLGtCQUFhLEdBQWlDLEVBQUUsQ0FBQztRQUNqRCxpQkFBWSxHQUFrQixFQUFFLENBQUM7UUFDakMsZ0JBQVcsR0FBWSxJQUFJLENBQUM7UUFWaEMsaUlBQWlJO1FBQ2pJLElBQUksNkJBQTZCO1lBQUUsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO0lBQzlELENBQUM7YUFFdUIseUJBQW9CLEdBQVcsaUJBQWlCLENBQUM7SUFRekUsSUFBVyxlQUFlO1FBQ3RCLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7WUFDeEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7UUFDakMsQ0FBQztRQUVELE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQ3pDLG1DQUFtQyxDQUFDLG9CQUFvQixDQUNqRCxDQUFDO1FBQ1osSUFBSSxhQUFhLEVBQUUsQ0FBQztZQUNoQixNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBMkIsQ0FBQztZQUMxRSxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLEVBQUUsQ0FBQztnQkFDcEMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGFBQWEsQ0FBQztZQUMxQyxDQUFDO2lCQUFNLENBQUM7Z0JBQ0osaUVBQWlFO2dCQUNqRSxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDeEIsQ0FBQztRQUNMLENBQUM7UUFDRCxPQUFPLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztJQUNqQyxDQUFDO0lBRUQsSUFBVyxlQUFlLENBQUMsZUFBdUM7UUFDOUQsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO1lBQ25CLE9BQU87UUFDWCxDQUFDO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsZUFBZSxDQUFDLEVBQUUsQ0FBQztZQUN2QyxNQUFNLElBQUksS0FBSyxDQUFDLGtDQUFrQyxDQUFDLENBQUM7UUFDeEQsQ0FBQztRQUVELElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQ25CLG1DQUFtQyxDQUFDLG9CQUFvQixFQUN4RCxJQUFJLENBQUMsU0FBUyxDQUFDLGVBQWUsQ0FBQyxDQUNsQyxDQUFDO1FBQ0YsSUFBSSxDQUFDLGdCQUFnQixHQUFHLGVBQWUsQ0FBQztJQUM1QyxDQUFDO0lBRU8sYUFBYSxDQUFDLFdBQW1DO1FBQ3JELDJHQUEyRztRQUMzRyxJQUNJLENBQUMsV0FBVztZQUNaLENBQUMsV0FBVyxDQUFDLHdCQUF3QixDQUFDLElBQUk7WUFDMUMsQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLFdBQVc7WUFDeEMsQ0FBQyxXQUFXLENBQUMsZUFBZSxDQUFDLEtBQUssc0JBQ2xDLFdBQVcsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBSyxDQUFDO1lBQzlDLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxXQUFXO1lBQ3hDLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxRQUFRLEVBQ3ZDLENBQUM7WUFDQyxPQUFPLEtBQUssQ0FBQztRQUNqQixDQUFDO1FBRUQsT0FBTyxDQUFDLFdBQVcsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLElBQThCLEVBQUUsRUFBRTtZQUM5RSx1RUFBdUU7WUFDdkUsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztnQkFDckIsT0FBTyxLQUFLLENBQUM7WUFDakIsQ0FBQztZQUVELCtEQUErRDtZQUMvRCxJQUNJLENBQUMsSUFBSSxDQUFDLFdBQVcsc0JBQ2pCLElBQUksQ0FBQyw2QkFBNkIsRUFBSyxJQUFJLHVCQUMzQyxJQUFJLENBQUMsNkJBQTZCLEVBQUssU0FBUyxHQUNsRCxDQUFDO2dCQUNDLE9BQU8sSUFBSSxDQUFDO1lBQ2hCLENBQUM7WUFFRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBeUIsRUFBRSxFQUFFO2dCQUN4RCxvRkFBb0Y7Z0JBQ3BGLE9BQU8sQ0FDSCxDQUFDLE1BQU0sQ0FBQyxXQUFXLHNCQUNuQixNQUFNLENBQUMscUJBQXFCLEVBQUssSUFBSSx1QkFDckMsTUFBTSxDQUFDLHFCQUFxQixFQUFLLFNBQVMsRUFDN0MsQ0FBQztZQUNOLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQyxDQUFDLENBQUM7SUFDUCxDQUFDO0lBRU8sZUFBZTtRQUNuQixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxDQUFDLDhCQUE4QjtRQUM1RSxJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixJQUFJLENBQUMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLO1lBQUUsT0FBTztRQUVuRixpRkFBaUY7UUFDakYsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxDQUFDO1FBQzFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FDNUYsQ0FBQyxJQUE4QixFQUFFLEVBQUU7WUFDL0IsSUFDSSxDQUFDLElBQUksQ0FBQyxXQUFXLHNCQUNqQixJQUFJLENBQUMsNkJBQTZCLEVBQUssSUFBSSx1QkFDM0MsSUFBSSxDQUFDLDZCQUE2QixFQUFLLFNBQVM7Z0JBQ2hELENBQUMsSUFBSSxDQUFDLFlBQVksRUFDcEIsQ0FBQztnQkFDQyxPQUFPLEtBQUssQ0FBQztZQUNqQixDQUFDO1lBRUQsT0FBTyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBeUIsRUFBRSxFQUFFO2dCQUN6RCxvRkFBb0Y7Z0JBQ3BGLE9BQU8sQ0FDSCxDQUFDLE1BQU0sQ0FBQyxXQUFXLHNCQUNuQixNQUFNLENBQUMscUJBQXFCLEVBQUssSUFBSSx1QkFDckMsTUFBTSxDQUFDLHFCQUFxQixFQUFLLFNBQVMsRUFDN0MsQ0FBQztZQUNOLENBQUMsQ0FBQyxDQUFDO1FBQ1AsQ0FBQyxDQUNKLENBQUM7UUFFRixvREFBb0Q7UUFDcEQsc0JBQUksSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFLLENBQUMsR0FBRSxDQUFDO1lBQzVELElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztRQUN4QixDQUFDO2FBQU0sc0JBQUksYUFBYSxFQUFLLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRSxDQUFDO1lBQzlFLDJEQUEyRDtZQUMzRCxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztRQUNqRCxDQUFDO0lBQ0wsQ0FBQztJQUVNLFlBQVk7UUFDZixJQUFJLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLG1DQUFtQyxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDckYsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQztJQUNqQyxDQUFDO0lBRU0sVUFBVSxDQUNiLElBVUMsRUFDRCxPQUtDO1FBRUQsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSztZQUFFLE9BQU87UUFDbkYsTUFBTSxpQkFBaUIsZ0JBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWUsQ0FBQyxLQUFLLENBQUMsTUFBTSxFQUFHLENBQUMsRUFBQztRQUNqRixNQUFNLFdBQVcsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQ25GLFdBQVcsQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUU5QyxzR0FBc0c7UUFDdEcsK0JBQStCO1FBQy9CLElBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ25CLFdBQVcsQ0FBQyw2QkFBNkIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBVSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRTtnQkFDN0Ysb0JBQU8sUUFBUSxFQUFHLElBQUksQ0FBQyxxQkFBcUIsRUFBQztZQUNqRCxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDTixXQUFXLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1lBQ3BELFdBQVcsQ0FBQyxzQ0FBc0MsR0FBRyxNQUFNLENBQ3ZELElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLENBQ3BELENBQUM7UUFDTixDQUFDO2FBQU0sQ0FBQztZQUNKLFdBQVcsQ0FBQyw2QkFBNkIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBVSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUUsRUFBRTtnQkFDN0Ysb0JBQU8sUUFBUSxlQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsRUFBRyxNQUFNLENBQUMsSUFBSSxDQUFDLHlCQUF5QixDQUFDLEdBQUM7WUFDbEcsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1lBQ04sV0FBVyxDQUFDLFdBQVcsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQztZQUNqRCxXQUFXLENBQUMsc0NBQXNDLEdBQUcsTUFBTSxDQUN2RCxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxDQUNwRCxDQUFDO1FBQ04sQ0FBQztRQUVELHlCQUF5QjtRQUN6QixXQUFXLENBQUMsVUFBVSxnQkFBRyxjQUFDLGlCQUFpQixFQUFHLENBQUMsRUFBQyxFQUFHLElBQUksRUFBQztRQUV4RDs7Ozs7Ozs2REFPcUQ7UUFDckQsV0FBVyxDQUFDLE9BQU8sR0FBRyxDQUNsQixzQkFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUssRUFBRSxDQUFDLFFBQVEsQ0FBQyx5QkFBeUIsRUFBRSxLQUFLLENBQUMsRUFBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FDMUcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUNiLFdBQVcsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLElBQUksU0FBUyxDQUFDO1FBQzFELFdBQVcsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDO1FBQ3BELElBQUksQ0FBQyxlQUFlLEdBQUc7WUFDbkIsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLHdCQUF3QjtZQUN4RSxlQUFlLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLGVBQWU7WUFDdEQsdUNBQXVDLEVBQUUsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssSUFBSSxDQUFDO1NBQ2xHLENBQUM7SUFDTixDQUFDO0lBRU0sZ0JBQWdCLENBQ25CLElBNkJDLEVBQ0QsT0FLQztRQUVELE1BQU0sMkJBQTJCLGdCQUM3QixDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEVBQUcsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxJQUFJLENBQUMsQ0FBQyxFQUFDO1FBRW5HLGdIQUFnSDtRQUNoSCxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztZQUNuQixJQUFJLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxLQUFLLElBQUksRUFBRTtZQUN0QyxxQkFBcUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxJQUFJLENBQUM7WUFDeEQseUJBQXlCLEVBQUUsSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssSUFBSSxDQUFDO1NBQ3BGLENBQUMsQ0FBQztRQUVILGdEQUFnRDtRQUNoRCxJQUFJLGdCQUFJLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRyxDQUFDLEtBQUksSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1lBQ25ELHNCQUFJLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFLLElBQUksQ0FBQyxZQUFZLGNBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUcsQ0FBQyxFQUFDLENBQUMsSUFBSSxHQUFFLENBQUM7Z0JBQ3RGLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1lBQzdCLENBQUM7UUFDTCxDQUFDO1FBRUQsTUFBTSxVQUFVLEdBQStCO1lBQzNDLFdBQVcsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUk7WUFDN0YscUJBQXFCLEVBQUUsSUFBSSxDQUFDLGFBQWE7Z0JBQ3JDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDO2dCQUNyQyxDQUFDLENBQUMsMkJBQTJCO1lBQ2pDLHNDQUFzQyxFQUFFLElBQUksQ0FBQyxhQUFhO2dCQUN0RCxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsc0NBQXNDLENBQUMsS0FBSyxJQUFJLENBQUMsQ0FBQztnQkFDMUQsQ0FBQyxDQUFDLENBQUM7WUFDUCxHQUFHLEVBQUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLElBQUksU0FBUyxFQUFFLDBFQUEwRTtZQUM1RyxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLElBQUksU0FBUztZQUN0QyxXQUFXLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxLQUFLLElBQUksU0FBUztZQUNoRCxPQUFPLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxLQUFLLElBQUksU0FBUztZQUN4QyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsSUFBSTtZQUNuQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLElBQUksU0FBUztZQUNsRCxNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLElBQUksU0FBUyxFQUFFLDBCQUEwQjtZQUNsRSxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsSUFBSTtZQUMzQyxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsWUFBWTtZQUNuRCxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLElBQUk7WUFDdkQsY0FBYyxFQUNWLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsS0FBSyxDQUFDO2dCQUNsRyxTQUFTO1lBQ2IsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDNUMsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsZUFBZSxFQUFFLElBQUksQ0FBQyxlQUFlLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDeEQsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxJQUFJLFNBQVM7WUFDaEQsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsS0FBSyxJQUFJLFNBQVM7U0FDbkQsQ0FBQztRQUVGLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBRXBDLCtHQUErRztRQUMvRyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7UUFDakMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLEtBQUssR0FBRyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQztRQUM3QyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssR0FBRyxFQUFFLENBQUM7UUFDdkIsSUFBSSxDQUFDLFlBQVksQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO1FBRTdCLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLElBQUksQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLEtBQUs7WUFBRSxPQUFPO1FBRW5GLE1BQU0sUUFBUSxHQUNWLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxjQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sRUFBRyxDQUFDLEVBQUMsQ0FBQztRQUV4RyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRSxDQUFDO1lBQzFCLGtEQUFrRDtZQUNsRCxJQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQztRQUNyQyxDQUFDO2FBQU0sQ0FBQztZQUNKLHlFQUF5RTtZQUN6RSx5R0FBeUc7WUFDekcseURBQXlEO1lBRXpELElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxLQUFLLGdCQUNuQyxDQUFDLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLGVBQzlDLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssSUFBSSxDQUFDLENBQUMsRUFBRyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEdBQUM7WUFDbkcsc0JBQUksSUFBSSxDQUFDLHNDQUFzQyxDQUFDLEtBQUssRUFBSyxDQUFDO2dCQUN2RCxJQUFJLENBQUMsOEJBQThCLENBQUMsS0FBSyxnQkFDckMsSUFBSSxDQUFDLDRCQUE0QixDQUFDLEtBQUssRUFBRyxDQUFDLElBQUksQ0FBQyxzQ0FBc0MsQ0FBQyxLQUFLLElBQUksQ0FBQyxDQUFDLEVBQUM7WUFDM0csSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssR0FBRyxTQUFLLEdBQUcsQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLDhCQUE4QixDQUFDLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQztZQUMzRixJQUFJLENBQUMsMEJBQTBCLEdBQUcsSUFBSSxDQUFDLGlCQUFpQixDQUFDLEtBQUssQ0FBQztRQUNuRSxDQUFDO0lBQ0wsQ0FBQzs7QUE3VEwsa0ZBOFRDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uL2xpYi9jbGllbnQtZnVuY3Rpb25zL3B1cmNoYXNlLXJlY2VpcHQtZGV0YWlscy1jb250cm9sLnRzPzA2NzEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHtcbiAgICBHcmFwaEFwaSxcbiAgICBQdXJjaGFzZUVudHJ5VHJhbnNhY3Rpb25JbnB1dCxcbiAgICBQdXJjaGFzZVJlY2VpcHRJbnB1dCxcbiAgICBQdXJjaGFzZVJlY2VpcHRMaW5lSW5wdXQsXG59IGZyb20gJ0BzYWdlL3gzLXB1cmNoYXNpbmctYXBpJztcbmltcG9ydCB7IFN0b2NrSm91cm5hbElucHV0LCBTdG9ja01hbmFnZW1lbnRSdWxlcyB9IGZyb20gJ0BzYWdlL3gzLXN0b2NrLWRhdGEtYXBpJztcbmltcG9ydCB7IGV4dHJhY3RFZGdlcyB9IGZyb20gJ0BzYWdlL3h0cmVtLWNsaWVudCc7XG5pbXBvcnQgeyBkZWNpbWFsIH0gZnJvbSAnQHNhZ2UveHRyZW0tc2hhcmVkJztcbmltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcbmltcG9ydCB7IFBhZ2UsIGxvY2FsaXplLCBxdWVyeVV0aWxzIH0gZnJvbSAnQHNhZ2UveHRyZW0tdWknO1xuaW50ZXJmYWNlIHJlY2VpcHRVbml0IHtcbiAgICBjb2RlOiBzdHJpbmc7XG4gICAgcXVhbnRpdHlJblJlY2VpcHRVbml0OiBudW1iZXI7XG4gICAgc3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogbnVtYmVyO1xufVxuXG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gdmFsaWRhdGUocGFnZTogUGFnZSk6IFByb21pc2U8Ym9vbGVhbj4ge1xuICAgIC8vIChYMy0yMDEwNDYsIFgzLTIwMzg4NSkgVE9ETyBJc3N1ZTogSGF2ZSBiZXR0ZXIgdmFsaWRhdGlvbiBlcnJvciBtZXNzYWdlcyB0aGF0IHNwZWNpZmljYWxseSB0ZWxsIHdoaWNoIGZpZWxkcyBoYXZlIGlzc3Vlc1xuICAgIGNvbnN0IGVycm9ycyA9IGF3YWl0IHBhZ2UuJC5wYWdlLnZhbGlkYXRlKCk7XG4gICAgaWYgKGVycm9ycy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgcmV0dXJuIHRydWU7XG4gICAgfVxuXG4gICAgcGFnZS4kLnNob3dUb2FzdChgJHtsb2NhbGl6ZSgnQHNhZ2UveDMtcHVyY2hhc2luZy9kaWFsb2ctZXJyb3ItdGl0bGUnLCAnRXJyb3InKX06ICR7ZXJyb3JzWzBdfWAsIHtcbiAgICAgICAgdHlwZTogJ2Vycm9yJyxcbiAgICAgICAgdGltZW91dDogMzAwMDAsXG4gICAgfSk7XG5cbiAgICByZXR1cm4gZmFsc2U7XG59XG5leHBvcnQgYXN5bmMgZnVuY3Rpb24gY29udHJvbExvdFJlY2VpcHQoXG4gICAgcGFnZUluc3RhbmNlOiBQYWdlLFxuICAgIGxvdDogc3RyaW5nLFxuICAgIHByb2R1Y3Q6IHN0cmluZyxcbiAgICBlbnRyeVR5cGU6IHN0cmluZyxcbiAgICBzaXRlOiBzdHJpbmcsXG4pOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICBpZiAoIWxvdCB8fCAhcHJvZHVjdCB8fCAhZW50cnlUeXBlKSB0aHJvdyBuZXcgRXJyb3IoJ0ludmFsaWQgYXJndW1lbnRzJyk7XG4gICAgbGV0IHN0b2NrSm91cm5hbEZpbHRlciA9IHtcbiAgICAgICAgc3RvY2tTaXRlOiBzaXRlLFxuICAgICAgICBkb2N1bWVudFR5cGU6IGVudHJ5VHlwZSxcbiAgICAgICAgcHJvZHVjdDogeyBjb2RlOiBwcm9kdWN0IH0sXG4gICAgICAgIGlzVXBkYXRlZDogdHJ1ZSxcbiAgICAgICAgbG90OiBsb3QsXG4gICAgfTtcblxuICAgIGNvbnN0IHJlc3BvbnNlID0gZXh0cmFjdEVkZ2VzKFxuICAgICAgICBhd2FpdCBwYWdlSW5zdGFuY2UuJC5ncmFwaFxuICAgICAgICAgICAgLm5vZGUoJ0BzYWdlL3gzLXN0b2NrLWRhdGEvU3RvY2tKb3VybmFsJylcbiAgICAgICAgICAgIC5xdWVyeShcbiAgICAgICAgICAgICAgICBxdWVyeVV0aWxzLmVkZ2VzU2VsZWN0b3IoXG4gICAgICAgICAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgIHN1YmxvdDogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICAgICAgICAgZmlsdGVyOiBzdG9ja0pvdXJuYWxGaWx0ZXIsXG4gICAgICAgICAgICAgICAgICAgIH0sXG4gICAgICAgICAgICAgICAgKSxcbiAgICAgICAgICAgIClcbiAgICAgICAgICAgIC5leGVjdXRlKCksXG4gICAgKTtcblxuICAgIGlmIChyZXNwb25zZS5sZW5ndGggPiAwKSB7XG4gICAgICAgIHBhZ2VJbnN0YW5jZS4kLnNob3dUb2FzdChcbiAgICAgICAgICAgIGxvY2FsaXplKFxuICAgICAgICAgICAgICAgICdAc2FnZS94My1wdXJjaGFzaW5nL25vdGlmaWNhdGlvbi1lcnJvci1yZWNlaXB0LWxvdCcsXG4gICAgICAgICAgICAgICAgJ3RoZSBsb3QgbnVtYmVyIHt7IGxvdCB9fSBhbHJlYWR5IGV4aXN0cyBmb3IgdGhpcyBwcm9kdWN0JyxcbiAgICAgICAgICAgICAgICB7IGxvdDogbG90IH0sXG4gICAgICAgICAgICApLFxuICAgICAgICAgICAgeyB0eXBlOiAnZXJyb3InIH0sXG4gICAgICAgICk7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgcmV0dXJuIHRydWU7XG59XG5cbmVudW0gWWVzTm9FbnVtIHtcbiAgICBubyA9IDEsXG4gICAgeWVzID0gMixcbn1cblxuZXhwb3J0IHR5cGUgUHVyY2hhc2VSZWNlaXB0U2Vzc2lvbiA9IHtcbiAgICBwdXJjaGFzZVJlY2VpcHQ6IFB1cmNoYXNlUmVjZWlwdElucHV0O1xuICAgIHB1cmNoYXNlRW50cnlUcmFuc2FjdGlvbjogUHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uSW5wdXQ7XG4gICAgcHVyY2hhc2VTdG9ja01hbmFnZW1lbnRSdWxlcz86IFN0b2NrTWFuYWdlbWVudFJ1bGVzO1xuICAgIG9yZGVyVW5pdFRvUHVyY2hhc2VVbml0Q29udmVyc2lvbkZhY3RvcjogbnVtYmVyO1xufSB8IG51bGw7XG5cbmV4cG9ydCBjbGFzcyBQdXJjaGFzZVJlY2VpcHREZXRhaWxzUmVjb3JkTWFuYWdlciB7XG4gICAgY29uc3RydWN0b3IoXG4gICAgICAgIHByaXZhdGUgcGFnZTogUGFnZTxHcmFwaEFwaT4sXG4gICAgICAgIGNsZWFudXBJbmNvbXBsZXRlU2Vzc2lvbkxpbmVzID0gZmFsc2UsXG4gICAgKSB7XG4gICAgICAgIC8vIEFuIGluY29tcGxldGUgcHVyY2hhc2UgcmVjZWlwdCBsaW5lIGNhbiBiZSBhZGRlZCB0byB0aGUgc2Vzc2lvbiB3aGVuIHVzZXIgaXMgdHJhbnNpdGlvbmluZyBmcm9tIG1haW4gcGFnZSB0byBlbnRlciBkZXRhaWwgcGFnZVxuICAgICAgICBpZiAoY2xlYW51cEluY29tcGxldGVTZXNzaW9uTGluZXMpIHRoaXMuX2NsZWFudXBTZXNzaW9uKCk7XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBzdGF0aWMgcmVhZG9ubHkgUFVSQ0hBU0VfUkVDRUlQVF9LRVk6IHN0cmluZyA9ICdwdXJjaGFzZVJlY2VpcHQnO1xuXG4gICAgcHJpdmF0ZSBfcHVyY2hhc2VTZXNzaW9uOiBQdXJjaGFzZVJlY2VpcHRTZXNzaW9uO1xuXG4gICAgcHJpdmF0ZSBfc3RvY2tEZXRhaWxzOiBQYXJ0aWFsPFN0b2NrSm91cm5hbElucHV0PltdID0gW107XG4gICAgcHJpdmF0ZSBfcmVjZWlwdFVuaXQ6IHJlY2VpcHRVbml0W10gPSBbXTtcbiAgICBwcml2YXRlIF91bml0SXNTYW1lOiBib29sZWFuID0gdHJ1ZTtcblxuICAgIHB1YmxpYyBnZXQgcHVyY2hhc2VTZXNzaW9uKCk6IFB1cmNoYXNlUmVjZWlwdFNlc3Npb24ge1xuICAgICAgICBpZiAodGhpcy5fcHVyY2hhc2VTZXNzaW9uKSB7XG4gICAgICAgICAgICByZXR1cm4gdGhpcy5fcHVyY2hhc2VTZXNzaW9uO1xuICAgICAgICB9XG5cbiAgICAgICAgY29uc3Qgc3RvcmVkU2Vzc2lvbiA9IHRoaXMucGFnZS4kLnN0b3JhZ2UuZ2V0KFxuICAgICAgICAgICAgUHVyY2hhc2VSZWNlaXB0RGV0YWlsc1JlY29yZE1hbmFnZXIuUFVSQ0hBU0VfUkVDRUlQVF9LRVksXG4gICAgICAgICkgYXMgc3RyaW5nO1xuICAgICAgICBpZiAoc3RvcmVkU2Vzc2lvbikge1xuICAgICAgICAgICAgY29uc3QgcGFyc2VkU2Vzc2lvbiA9IEpTT04ucGFyc2Uoc3RvcmVkU2Vzc2lvbikgYXMgUHVyY2hhc2VSZWNlaXB0U2Vzc2lvbjtcbiAgICAgICAgICAgIGlmICh0aGlzLl9jaGVja1N0b3JhZ2UocGFyc2VkU2Vzc2lvbikpIHtcbiAgICAgICAgICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24gPSBwYXJzZWRTZXNzaW9uO1xuICAgICAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgICAgICAvLyBwdXJjaGFzZSByZWNlaXB0IGluIHRoZSBzZXNzaW9uIHN0b3JhZ2UgaXMgY29ycnVwdGVkL21hbGZvcm1lZFxuICAgICAgICAgICAgICAgIHRoaXMuY2xlYXJTZXNzaW9uKCk7XG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHRoaXMuX3B1cmNoYXNlU2Vzc2lvbjtcbiAgICB9XG5cbiAgICBwdWJsaWMgc2V0IHB1cmNoYXNlU2Vzc2lvbihwdXJjaGFzZVNlc3Npb246IFB1cmNoYXNlUmVjZWlwdFNlc3Npb24pIHtcbiAgICAgICAgaWYgKCFwdXJjaGFzZVNlc3Npb24pIHtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuXG4gICAgICAgIGlmICghdGhpcy5fY2hlY2tTdG9yYWdlKHB1cmNoYXNlU2Vzc2lvbikpIHtcbiAgICAgICAgICAgIHRocm93IG5ldyBFcnJvcignSW52YWxpZCBQdXJjaGFzZSBSZWNlaXB0IHNlc3Npb24nKTtcbiAgICAgICAgfVxuXG4gICAgICAgIHRoaXMucGFnZS4kLnN0b3JhZ2Uuc2V0KFxuICAgICAgICAgICAgUHVyY2hhc2VSZWNlaXB0RGV0YWlsc1JlY29yZE1hbmFnZXIuUFVSQ0hBU0VfUkVDRUlQVF9LRVksXG4gICAgICAgICAgICBKU09OLnN0cmluZ2lmeShwdXJjaGFzZVNlc3Npb24pLFxuICAgICAgICApO1xuICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24gPSBwdXJjaGFzZVNlc3Npb247XG4gICAgfVxuXG4gICAgcHJpdmF0ZSBfY2hlY2tTdG9yYWdlKHNlc3Npb25EYXRhOiBQdXJjaGFzZVJlY2VpcHRTZXNzaW9uKTogYm9vbGVhbiB7XG4gICAgICAgIC8vIGNoZWNrIGlmIHNlc3Npb25EYXRhIGNvbnRhaW5zIGF0IGxlYXN0IG9uZSBwdXJjaGFzZSByZWNlaXB0IGxpbmUgdGhhdCBoYXMgYXQgbGVhc3Qgb25lIHN0b2NrIGRldGFpbCBsaW5lXG4gICAgICAgIGlmIChcbiAgICAgICAgICAgICFzZXNzaW9uRGF0YSB8fFxuICAgICAgICAgICAgIXNlc3Npb25EYXRhLnB1cmNoYXNlRW50cnlUcmFuc2FjdGlvbi5jb2RlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnJlY2VpcHREYXRlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LmxpbmVzIHx8XG4gICAgICAgICAgICBzZXNzaW9uRGF0YS5wdXJjaGFzZVJlY2VpcHQubGluZXMubGVuZ3RoID09PSAwIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnJlY2VpcHRTaXRlIHx8XG4gICAgICAgICAgICAhc2Vzc2lvbkRhdGEucHVyY2hhc2VSZWNlaXB0LnN1cHBsaWVyXG4gICAgICAgICkge1xuICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuICFzZXNzaW9uRGF0YS5wdXJjaGFzZVJlY2VpcHQubGluZXMuc29tZSgobGluZTogUHVyY2hhc2VSZWNlaXB0TGluZUlucHV0KSA9PiB7XG4gICAgICAgICAgICAvLyBza2lwIG1vc3QgcmVjZW50IGxpbmUgdGhhdCBpcyBwZW5kaW5nIHRvIGJlIGNvbXBsZXRlZCBpbiBkZXRhaWwgcGFnZVxuICAgICAgICAgICAgaWYgKCFsaW5lLnN0b2NrRGV0YWlscykge1xuICAgICAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgLy8gY2hlY2sgZm9yIGVhY2ggbGluZSwgdGhlIHJlY2VpcHQgdW5pdCAmIHF1YW50aXR5IGFyZSBkZWZpbmVkXG4gICAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAgICAgIWxpbmUucmVjZWlwdFVuaXQgfHxcbiAgICAgICAgICAgICAgICBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdFJlY2VpdmVkID09PSBudWxsIHx8XG4gICAgICAgICAgICAgICAgbGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdHJ1ZTtcbiAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgcmV0dXJuIGxpbmUuc3RvY2tEZXRhaWxzLnNvbWUoKGRldGFpbDogU3RvY2tKb3VybmFsSW5wdXQpID0+IHtcbiAgICAgICAgICAgICAgICAvLyBjaGVjayBmb3IgZWFjaCBzdG9jayBkZXRhaWwgb24gdGhpcyBsaW5lLCB0aGUgcGFja2luZyB1bml0ICYgcXVhbnRpdHkgYXJlIGRlZmluZWRcbiAgICAgICAgICAgICAgICByZXR1cm4gKFxuICAgICAgICAgICAgICAgICAgICAhZGV0YWlsLnBhY2tpbmdVbml0IHx8XG4gICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IG51bGwgfHxcbiAgICAgICAgICAgICAgICAgICAgZGV0YWlsLnF1YW50aXR5SW5QYWNraW5nVW5pdCA9PT0gdW5kZWZpbmVkXG4gICAgICAgICAgICAgICAgKTtcbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9KTtcbiAgICB9XG5cbiAgICBwcml2YXRlIF9jbGVhbnVwU2Vzc2lvbigpIHtcbiAgICAgICAgdGhpcy5fcHVyY2hhc2VTZXNzaW9uID0gdGhpcy5wdXJjaGFzZVNlc3Npb247IC8vIGdldCB0aGUgbGF0ZXN0IGZyb20gc2Vzc2lvblxuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuXG4gICAgICAgIC8vIHJlbW92ZSBhbnkgaW5jb21wbGV0ZSBwdXJjaGFzZSByZWNlaXB0IGxpbmVzIChleC4gYSBsaW5lIHdpdGhvdXQgc3RvY2tEZXRhaWxzKVxuICAgICAgICBjb25zdCBwcmV2TGluZUNvdW50ID0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcz8ubGVuZ3RoO1xuICAgICAgICB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzID0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5maWx0ZXIoXG4gICAgICAgICAgICAobGluZTogUHVyY2hhc2VSZWNlaXB0TGluZUlucHV0KSA9PiB7XG4gICAgICAgICAgICAgICAgaWYgKFxuICAgICAgICAgICAgICAgICAgICAhbGluZS5yZWNlaXB0VW5pdCB8fFxuICAgICAgICAgICAgICAgICAgICBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdFJlY2VpdmVkID09PSBudWxsIHx8XG4gICAgICAgICAgICAgICAgICAgIGxpbmUucXVhbnRpdHlJblJlY2VpcHRVbml0UmVjZWl2ZWQgPT09IHVuZGVmaW5lZCB8fFxuICAgICAgICAgICAgICAgICAgICAhbGluZS5zdG9ja0RldGFpbHNcbiAgICAgICAgICAgICAgICApIHtcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgICAgICAgICAgIH1cblxuICAgICAgICAgICAgICAgIHJldHVybiAhbGluZS5zdG9ja0RldGFpbHMuc29tZSgoZGV0YWlsOiBTdG9ja0pvdXJuYWxJbnB1dCkgPT4ge1xuICAgICAgICAgICAgICAgICAgICAvLyBjaGVjayBmb3IgZWFjaCBzdG9jayBkZXRhaWwgb24gdGhpcyBsaW5lLCB0aGUgcGFja2luZyB1bml0ICYgcXVhbnRpdHkgYXJlIGRlZmluZWRcbiAgICAgICAgICAgICAgICAgICAgcmV0dXJuIChcbiAgICAgICAgICAgICAgICAgICAgICAgICFkZXRhaWwucGFja2luZ1VuaXQgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IG51bGwgfHxcbiAgICAgICAgICAgICAgICAgICAgICAgIGRldGFpbC5xdWFudGl0eUluUGFja2luZ1VuaXQgPT09IHVuZGVmaW5lZFxuICAgICAgICAgICAgICAgICAgICApO1xuICAgICAgICAgICAgICAgIH0pO1xuICAgICAgICAgICAgfSxcbiAgICAgICAgKTtcblxuICAgICAgICAvLyBpZiBhbGwgbGluZXMgaGF2ZSBiZWVuIHJlbW92ZWQsIGNsZWFyIHRoZSBzZXNzaW9uXG4gICAgICAgIGlmICh0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzPy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgICAgIHRoaXMuY2xlYXJTZXNzaW9uKCk7XG4gICAgICAgIH0gZWxzZSBpZiAocHJldkxpbmVDb3VudCAhPT0gdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5sZW5ndGgpIHtcbiAgICAgICAgICAgIC8vIG90aGVyd2lzZSBpZiBhbnkgbGluZSBnb3QgcmVtb3ZlZCwgb3ZlcndyaXRlIHRoZSBzZXNzaW9uXG4gICAgICAgICAgICB0aGlzLnB1cmNoYXNlU2Vzc2lvbiA9IHRoaXMuX3B1cmNoYXNlU2Vzc2lvbjtcbiAgICAgICAgfVxuICAgIH1cblxuICAgIHB1YmxpYyBjbGVhclNlc3Npb24oKTogdm9pZCB7XG4gICAgICAgIHRoaXMucGFnZS4kLnN0b3JhZ2UucmVtb3ZlKFB1cmNoYXNlUmVjZWlwdERldGFpbHNSZWNvcmRNYW5hZ2VyLlBVUkNIQVNFX1JFQ0VJUFRfS0VZKTtcbiAgICAgICAgdGhpcy5fcHVyY2hhc2VTZXNzaW9uID0gbnVsbDtcbiAgICB9XG5cbiAgICBwdWJsaWMgY3JlYXRlTGluZShcbiAgICAgICAgcGFnZToge1xuICAgICAgICAgICAgY2xvc2VQb0xpbmU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGw7IG9wdGlvbnM/OiBzdHJpbmdbXSB9O1xuICAgICAgICAgICAgZGVzY3JpcHRpb246IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHNpdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHN1cHBsaWVyOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBwdXJjaGFzZU9yZGVyTnVtYmVyOiBzdHJpbmc7XG4gICAgICAgICAgICBwdXJjaGFzZU9yZGVyTGluZU51bWJlcjogc3RyaW5nIHwgbnVtYmVyIHwgYm9vbGVhbjtcbiAgICAgICAgICAgIHdhcmVob3VzZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgY29udGFpbmVyOiB7IHZhbHVlOiB7IGNvZGU/OiBzdHJpbmcgfSB8IG51bGwgfTtcbiAgICAgICAgICAgIHBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yOiB7IHZhbHVlOiBudW1iZXIgfCBudWxsIH07XG4gICAgICAgIH0sXG4gICAgICAgIHByb2R1Y3Q6IHtcbiAgICAgICAgICAgIHN0b2NrVW5pdDoge1xuICAgICAgICAgICAgICAgIGNvZGU6IHN0cmluZztcbiAgICAgICAgICAgIH07XG4gICAgICAgICAgICBjb2RlOiBzdHJpbmc7ICAgICAgICAgICBcbiAgICAgICAgfVxuICAgICkge1xuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuICAgICAgICBjb25zdCBjdXJyZW50TGluZU51bWJlciA9IHRoaXMuX3B1cmNoYXNlU2Vzc2lvbi5wdXJjaGFzZVJlY2VpcHQubGluZXMubGVuZ3RoIC0gMTtcbiAgICAgICAgY29uc3QgY3VycmVudExpbmUgPSB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LmxpbmVzW2N1cnJlbnRMaW5lTnVtYmVyXTtcbiAgICAgICAgY3VycmVudExpbmUuc3RvY2tEZXRhaWxzID0gdGhpcy5fc3RvY2tEZXRhaWxzO1xuXG4gICAgICAgIC8vIElmIGFsbCByZWNlaXB0IHVuaXRzIGFyZSB0aGUgc2FtZSwgdXNlIHRoYXQgdW5pdCBmb3IgdGhlIGxpbmUuIElmIHRoZXJlIGFyZSBtdWx0aXBsZSByZWNlaXB0IHVuaXRzLFxuICAgICAgICAvLyB1c2Ugc3RvY2sgdW5pdCBmb3IgdGhlIGxpbmUuXG4gICAgICAgIGlmICh0aGlzLl91bml0SXNTYW1lKSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9IHRoaXMuX3JlY2VpcHRVbml0LnJlZHVjZTxkZWNpbWFsPigodG90YWxRdHksIGxpbmUpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdG90YWxRdHkgKyBsaW5lLnF1YW50aXR5SW5SZWNlaXB0VW5pdDtcbiAgICAgICAgICAgIH0sIDApO1xuICAgICAgICAgICAgY3VycmVudExpbmUucmVjZWlwdFVuaXQgPSB0aGlzLl9yZWNlaXB0VW5pdFswXS5jb2RlO1xuICAgICAgICAgICAgY3VycmVudExpbmUucmVjZWlwdFVuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IgPSBOdW1iZXIoXG4gICAgICAgICAgICAgICAgcGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSxcbiAgICAgICAgICAgICk7XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXRSZWNlaXZlZCA9IHRoaXMuX3JlY2VpcHRVbml0LnJlZHVjZTxkZWNpbWFsPigodG90YWxRdHksIGxpbmUpID0+IHtcbiAgICAgICAgICAgICAgICByZXR1cm4gdG90YWxRdHkgKyBOdW1iZXIobGluZS5xdWFudGl0eUluUmVjZWlwdFVuaXQpICogTnVtYmVyKGxpbmUuc3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvcik7XG4gICAgICAgICAgICB9LCAwKTtcbiAgICAgICAgICAgIGN1cnJlbnRMaW5lLnJlY2VpcHRVbml0ID0gcHJvZHVjdC5zdG9ja1VuaXQuY29kZTtcbiAgICAgICAgICAgIGN1cnJlbnRMaW5lLnJlY2VpcHRVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yID0gTnVtYmVyKFxuICAgICAgICAgICAgICAgIHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUsXG4gICAgICAgICAgICApO1xuICAgICAgICB9XG5cbiAgICAgICAgLy9TZXQgcmVjZWlwdCBsaW5lIG51bWJlclxuICAgICAgICBjdXJyZW50TGluZS5saW5lTnVtYmVyID0gKGN1cnJlbnRMaW5lTnVtYmVyICsgMSkgKiAxMDAwO1xuXG4gICAgICAgIC8qICBpZiAoXG4gICAgICAgICAgICBjdXJyZW50TGluZS5wdXJjaGFzZU9yZGVyTnVtYmVyICYmXG4gICAgICAgICAgICBjdXJyZW50TGluZS5wdXJjaGFzZU9yZGVyTGluZU51bWJlciAmJlxuICAgICAgICAgICAgY3VycmVudExpbmUucHVyY2hhc2VPcmRlckxpbmVcbiAgICAgICAgKSB7XG4gICAgICAgICAgICBjdXJyZW50TGluZS5fZm9yTXV0YXRpb25Pbmx5RG9DbG9zZVB1cmNoYXNlT3JkZXJMaW5lID1cbiAgICAgICAgICAgICAgICBwYWdlLmNsb3NlUG9MaW5lLm9wdGlvbnMuaW5kZXhPZihwYWdlLmNsb3NlUG9MaW5lLnZhbHVlKSA9PT0gMCA/IFllc05vRW51bS55ZXMgOiBZZXNOb0VudW0ubm87XG4gICAgICAgIH0gX2Zvck11dGF0aW9uT25seURvQ2xvc2VQdXJjaGFzZU9yZGVyTGluZSBtaXNzaW5nICovXG4gICAgICAgIGN1cnJlbnRMaW5lLmJhbGFuY2UgPSAoXG4gICAgICAgICAgICBwYWdlLmNsb3NlUG9MaW5lLnZhbHVlID09PSB1aS5sb2NhbGl6ZSgnQHNhZ2UveDMtcHVyY2hhc2luZy9ZZXMnLCAnWWVzJykgPyBZZXNOb0VudW0ueWVzIDogWWVzTm9FbnVtLm5vXG4gICAgICAgICkudG9TdHJpbmcoKTtcbiAgICAgICAgY3VycmVudExpbmUud2FyZWhvdXNlID0gcGFnZS53YXJlaG91c2UudmFsdWUgPz8gdW5kZWZpbmVkO1xuICAgICAgICBjdXJyZW50TGluZS5jb250YWluZXIgPSBwYWdlLmNvbnRhaW5lcj8udmFsdWU/LmNvZGU7XG4gICAgICAgIHRoaXMucHVyY2hhc2VTZXNzaW9uID0ge1xuICAgICAgICAgICAgcHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uOiB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VFbnRyeVRyYW5zYWN0aW9uLFxuICAgICAgICAgICAgcHVyY2hhc2VSZWNlaXB0OiB0aGlzLl9wdXJjaGFzZVNlc3Npb24ucHVyY2hhc2VSZWNlaXB0LFxuICAgICAgICAgICAgb3JkZXJVbml0VG9QdXJjaGFzZVVuaXRDb252ZXJzaW9uRmFjdG9yOiBwYWdlLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlID8/IDAsXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHVibGljIGxvYWRTdG9ja0RldGFpbHMoXG4gICAgICAgIHBhZ2U6IHtcbiAgICAgICAgICAgIHJlY2VpcHRVbml0OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICByZWNlaXB0VW5pdENvZGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHF1YW50aXR5VG9SZWNlaXZlOiB7IHZhbHVlOiBudW1iZXIgfCBudWxsIH07XG4gICAgICAgICAgICBxdWFudGl0eVRvUmVjZWl2ZU5vUm91bmRlZDogbnVtYmVyO1xuICAgICAgICAgICAgaXNQYWNraW5nVW5pdDogYm9vbGVhbjtcbiAgICAgICAgICAgIHJlbWFpbmluZ1F1YW50aXR5SW5QYWNraW5nVW5pdDogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgcmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdDogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgcGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHsgdmFsdWU6IG51bWJlciB8IG51bGwgfTtcbiAgICAgICAgICAgIHdhcmVob3VzZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgc3RhdHVzOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsaWNlbnNlUGxhdGVOdW1iZXI6IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbG9jYXRpb246IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbDsgaXNEaXNhYmxlZD86IGJvb2xlYW4gfTtcbiAgICAgICAgICAgIHN1cHBsaWVyTG90OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsb3Q6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHN1YmxvdDogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgcG90ZW5jeTogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgZXhwaXJhdGlvbkRhdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGw7IGlzRGlzYWJsZWQ/OiBib29sZWFuIH07XG4gICAgICAgICAgICBjYWxjdWxhdGVkRXhwaXJhdGlvbkRhdGU6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIHVzZUJ5RGF0ZTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgc2VyaWFsTnVtYmVyOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBtYWpvclZlcnNpb246IHsgdmFsdWU6IHsgY29kZT86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbWlub3JWZXJzaW9uOiB7IHZhbHVlOiB7IG1pbm9yVmVyc2lvbj86IHN0cmluZyB9IHwgbnVsbCB9O1xuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQxOiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBsb3RDdXN0b21GaWVsZDI6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgICAgIGxvdEN1c3RvbUZpZWxkMzogeyB2YWx1ZTogbnVtYmVyIHwgbnVsbCB9O1xuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQ0OiB7IHZhbHVlOiBzdHJpbmcgfCBudWxsIH07XG4gICAgICAgICAgICBpZGVudGlmaWVyMTogeyB2YWx1ZTogc3RyaW5nIHwgbnVsbCB9O1xuICAgICAgICAgICAgaWRlbnRpZmllcjI6IHsgdmFsdWU6IHN0cmluZyB8IG51bGwgfTtcbiAgICAgICAgfSxcbiAgICAgICAgcHJvZHVjdDoge1xuICAgICAgICAgICAgc3RvY2tVbml0OiB7XG4gICAgICAgICAgICAgICAgY29kZTogc3RyaW5nO1xuICAgICAgICAgICAgfTtcbiAgICAgICAgICAgIGNvZGU6IHN0cmluZztcbiAgICAgICAgfVxuICAgICkge1xuICAgICAgICBjb25zdCBxdWFudGl0eVJlY2VpdmVkSW5TdG9ja1VuaXQgPVxuICAgICAgICAgICAgKHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCkgKiAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKTtcblxuICAgICAgICAvLyBTYXZpbmcgcmVjZWlwdCB1bml0cyBpcyBzZXBhcmF0ZSBhcnJheSBiZWNhdXNlIG9ubHkgc3RvY2sgYW5kIHBhY2tpbmcgdW5pdHMgYXJlIHNhdmVkIGF0IHN0b2NrIGRldGFpbHMgbGV2ZWwuXG4gICAgICAgIHRoaXMuX3JlY2VpcHRVbml0LnB1c2goe1xuICAgICAgICAgICAgY29kZTogcGFnZS5yZWNlaXB0VW5pdENvZGUudmFsdWUgPz8gJycsXG4gICAgICAgICAgICBxdWFudGl0eUluUmVjZWlwdFVuaXQ6IHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCxcbiAgICAgICAgICAgIHN0b2NrVW5pdENvbnZlcnNpb25GYWN0b3I6IHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPz8gMSxcbiAgICAgICAgfSk7XG5cbiAgICAgICAgLy8gQ2hlY2sgaWYgdW5pdCBpcyBkaWZmZXJlbnQgZnJvbSBwcmV2aW91cyBsaW5lXG4gICAgICAgIGlmICh0aGlzLl9yZWNlaXB0VW5pdC5sZW5ndGggPiAxICYmIHRoaXMuX3VuaXRJc1NhbWUpIHtcbiAgICAgICAgICAgIGlmIChwYWdlLnJlY2VpcHRVbml0Q29kZS52YWx1ZSAhPT0gdGhpcy5fcmVjZWlwdFVuaXRbdGhpcy5fcmVjZWlwdFVuaXQubGVuZ3RoIC0gMl0uY29kZSkge1xuICAgICAgICAgICAgICAgIHRoaXMuX3VuaXRJc1NhbWUgPSBmYWxzZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IGRldGFpbExpbmU6IFBhcnRpYWw8U3RvY2tKb3VybmFsSW5wdXQ+ID0ge1xuICAgICAgICAgICAgcGFja2luZ1VuaXQ6IHBhZ2UuaXNQYWNraW5nVW5pdCA/IChwYWdlLnJlY2VpcHRVbml0Q29kZS52YWx1ZSA/PyAnJykgOiBwcm9kdWN0LnN0b2NrVW5pdC5jb2RlLFxuICAgICAgICAgICAgcXVhbnRpdHlJblBhY2tpbmdVbml0OiBwYWdlLmlzUGFja2luZ1VuaXRcbiAgICAgICAgICAgICAgICA/IChwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID8/IDApXG4gICAgICAgICAgICAgICAgOiBxdWFudGl0eVJlY2VpdmVkSW5TdG9ja1VuaXQsXG4gICAgICAgICAgICBwYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3RvcjogcGFnZS5pc1BhY2tpbmdVbml0XG4gICAgICAgICAgICAgICAgPyAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKVxuICAgICAgICAgICAgICAgIDogMSxcbiAgICAgICAgICAgIGxvdDogcGFnZS5sb3QudmFsdWUgPz8gdW5kZWZpbmVkLCAvLyB1c2luZyB1bmRlZmluZWQsIG9taXRzIHRoZSBwcm9wZXJ0eSBlbnRpcmVseSBmcm9tIEpTT04gd2hlbiBzdHJpbmdpZmllZFxuICAgICAgICAgICAgc3VibG90OiBwYWdlLnN1YmxvdC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBzdXBwbGllckxvdDogcGFnZS5zdXBwbGllckxvdC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBwb3RlbmN5OiBwYWdlLnBvdGVuY3kudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG9jYXRpb246IHBhZ2UubG9jYXRpb24udmFsdWU/LmNvZGUsXG4gICAgICAgICAgICBzZXJpYWxOdW1iZXI6IHBhZ2Uuc2VyaWFsTnVtYmVyLnZhbHVlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHN0YXR1czogcGFnZS5zdGF0dXMudmFsdWUgPz8gdW5kZWZpbmVkLCAvLyB0aGlzIGlzIGFsd2F5cyByZXF1aXJlZFxuICAgICAgICAgICAgbWFqb3JWZXJzaW9uOiBwYWdlLm1ham9yVmVyc2lvbi52YWx1ZT8uY29kZSxcbiAgICAgICAgICAgIG1pbm9yVmVyc2lvbjogcGFnZS5taW5vclZlcnNpb24udmFsdWU/Lm1pbm9yVmVyc2lvbixcbiAgICAgICAgICAgIGxpY2Vuc2VQbGF0ZU51bWJlcjogcGFnZS5saWNlbnNlUGxhdGVOdW1iZXIudmFsdWU/LmNvZGUsXG4gICAgICAgICAgICBleHBpcmF0aW9uRGF0ZTpcbiAgICAgICAgICAgICAgICAocGFnZS5leHBpcmF0aW9uRGF0ZS5pc0Rpc2FibGVkID8gcGFnZS5jYWxjdWxhdGVkRXhwaXJhdGlvbkRhdGUudmFsdWUgOiBwYWdlLmV4cGlyYXRpb25EYXRlLnZhbHVlKSA/P1xuICAgICAgICAgICAgICAgIHVuZGVmaW5lZCxcbiAgICAgICAgICAgIHVzZUJ5RGF0ZTogcGFnZS51c2VCeURhdGUudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQxOiBwYWdlLmxvdEN1c3RvbUZpZWxkMS52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBsb3RDdXN0b21GaWVsZDI6IHBhZ2UubG90Q3VzdG9tRmllbGQyLnZhbHVlID8/IHVuZGVmaW5lZCxcbiAgICAgICAgICAgIGxvdEN1c3RvbUZpZWxkMzogcGFnZS5sb3RDdXN0b21GaWVsZDMudmFsdWUgPz8gdW5kZWZpbmVkLFxuICAgICAgICAgICAgbG90Q3VzdG9tRmllbGQ0OiBwYWdlLmxvdEN1c3RvbUZpZWxkNC52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBpZGVudGlmaWVyMTogcGFnZS5pZGVudGlmaWVyMS52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgICAgICBpZGVudGlmaWVyMjogcGFnZS5pZGVudGlmaWVyMi52YWx1ZSA/PyB1bmRlZmluZWQsXG4gICAgICAgIH07XG5cbiAgICAgICAgdGhpcy5fc3RvY2tEZXRhaWxzLnB1c2goZGV0YWlsTGluZSk7XG5cbiAgICAgICAgLy8gSW5pdGlhbGl6ZSBkZXRhaWwgcGFnZSBmb3IgbmV4dCBkZXRhaWwgbGluZS4gIE1vc3QgZmllbGQgdmFsdWVzIHdpbGwgZGVmYXVsdCB0byBwcmV2aW91cyBkZXRhaWwgbGluZSB2YWx1ZXMuXG4gICAgICAgIHBhZ2UubG9jYXRpb24uaXNEaXNhYmxlZCA9IGZhbHNlO1xuICAgICAgICBwYWdlLmxpY2Vuc2VQbGF0ZU51bWJlci52YWx1ZSA9IHsgY29kZTogJycgfTtcbiAgICAgICAgcGFnZS5zdWJsb3QudmFsdWUgPSAnJztcbiAgICAgICAgcGFnZS5zZXJpYWxOdW1iZXIudmFsdWUgPSAnJztcblxuICAgICAgICBpZiAoIXRoaXMuX3B1cmNoYXNlU2Vzc2lvbiB8fCAhdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcykgcmV0dXJuO1xuXG4gICAgICAgIGNvbnN0IGN1cnJMaW5lID1cbiAgICAgICAgICAgIHRoaXMuX3B1cmNoYXNlU2Vzc2lvbi5wdXJjaGFzZVJlY2VpcHQubGluZXNbdGhpcy5fcHVyY2hhc2VTZXNzaW9uLnB1cmNoYXNlUmVjZWlwdC5saW5lcy5sZW5ndGggLSAxXTtcblxuICAgICAgICBpZiAoIWN1cnJMaW5lLnB1cmNoYXNlT3JkZXIpIHtcbiAgICAgICAgICAgIC8vIFNldCByZW1haW5pbmcgcXVhbnRpdHkgdG8gMCBmb3IgZGlyZWN0IHJlY2VpcHRzXG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID0gMDtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIC8vIENhbGN1bGF0ZSByZW1haW5pbmcgcXVhbnRpdHkgZm9yIFBPIHJlY2VpcHQgbGluZXMgKG5vdCBkaXJlY3QgcmVjZWlwdClcbiAgICAgICAgICAgIC8vIHJlbWFpbmluZ1F1YW50aXR5IGFuZCBxdWFudGl0eVRvUmVjZWl2ZSB3aWxsIGFsd2F5cyBiZSB0aGUgc2FtZSB1bml0IGFuZCB0aGF0IHVuaXQgd2lsbCBiZSB0aGUgZGVmYXVsdFxuICAgICAgICAgICAgLy8gZm9yIHRoZSBuZXh0IGRldGFpbCBsaW5lLiAgVmFsdWUgY2FuIG5ldmVyIGJlIG5lZ2F0aXZlXG5cbiAgICAgICAgICAgIHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA9XG4gICAgICAgICAgICAgICAgKHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblN0b2NrVW5pdC52YWx1ZSA/PyAwKSAtXG4gICAgICAgICAgICAgICAgKHBhZ2UucXVhbnRpdHlUb1JlY2VpdmUudmFsdWUgPz8gMCkgKiAocGFnZS5wYWNraW5nVW5pdFRvU3RvY2tVbml0Q29udmVyc2lvbkZhY3Rvci52YWx1ZSA/PyAxKTtcbiAgICAgICAgICAgIGlmIChwYWdlLnBhY2tpbmdVbml0VG9TdG9ja1VuaXRDb252ZXJzaW9uRmFjdG9yLnZhbHVlICE9PSAwKVxuICAgICAgICAgICAgICAgIHBhZ2UucmVtYWluaW5nUXVhbnRpdHlJblBhY2tpbmdVbml0LnZhbHVlID1cbiAgICAgICAgICAgICAgICAgICAgcGFnZS5yZW1haW5pbmdRdWFudGl0eUluU3RvY2tVbml0LnZhbHVlIC8gKHBhZ2UucGFja2luZ1VuaXRUb1N0b2NrVW5pdENvbnZlcnNpb25GYWN0b3IudmFsdWUgPz8gMSk7XG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlLnZhbHVlID0gTWF0aC5tYXgoMCwgcGFnZS5yZW1haW5pbmdRdWFudGl0eUluUGFja2luZ1VuaXQudmFsdWUgPz8gMCk7XG4gICAgICAgICAgICBwYWdlLnF1YW50aXR5VG9SZWNlaXZlTm9Sb3VuZGVkID0gcGFnZS5xdWFudGl0eVRvUmVjZWl2ZS52YWx1ZTtcbiAgICAgICAgfVxuICAgIH1cbn1cbiJdLCJuYW1lcyI6W10sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./lib/client-functions/purchase-receipt-details-control.ts\n");

/***/ }),

/***/ "./lib/client-functions/purchase-receipt-details-initializer.ts":
/*!**********************************************************************!*\
  !*** ./lib/client-functions/purchase-receipt-details-initializer.ts ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.PurchaseReceiptDetailsInitializer = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst defaultValue_1 = __webpack_require__(/*! ./defaultValue */ \"./lib/client-functions/defaultValue.ts\");\nconst product_site_data_1 = __webpack_require__(/*! ./product-site-data */ \"./lib/client-functions/product-site-data.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ./stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\n/*\n * Initializer helper class for the Purchase Receipts Detail page.\n */\nclass PurchaseReceiptDetailsInitializer {\n    static { this.QTY_DECIMAL_PLACES = 8; } // this precision is based on how classic Sage X3 4GL calculates remaining quantity in ENVADC.src\n    static { this.CONVERSION_RATE_DECIMAL_PLACES = 6; } //Display and precision length is defined by the X3 datatype which we do not have access to currently.  Setting to 6 decimal places for now as this is the precisions of the conversion rate data type.\n    static async initializePage(page, closePoLineOptions) {\n        // Checking for required parameters\n        var errMsg;\n        if (!page.purchaseSession) {\n            return false;\n        }\n        // Some local variables to reduce code verbosity\n        const currReceipt = page.purchaseSession.purchaseReceipt;\n        if (!currReceipt || !currReceipt.lines) {\n            return false;\n        }\n        const currLine = currReceipt.lines[typesLib.sub(currReceipt.lines.length, 1)]; // get the latest line user wants to add\n        const transactionEntry = page.purchaseSession.purchaseEntryTransaction;\n        if (!currReceipt.receiptSite) {\n            errMsg = ui.localize('@sage/x3-purchasing/notification-error-missing-site', 'Stock site not defined');\n        }\n        else if (!currReceipt.supplier) {\n            errMsg = ui.localize('@sage/x3-purchasing/notification-error-missing-supplier', 'Supplier not defined');\n        }\n        else if (!currLine.product) {\n            errMsg = ui.localize('@sage/x3-purchasing/notification-error-purchase-receipt-details-invalid-product-site', `The product could not be retreived for the {{ siteCode }} site.`, { siteCode: currReceipt.receiptSite });\n        }\n        if (errMsg) {\n            page.$.showToast(errMsg, { type: 'error', timeout: 5000 });\n            return false;\n        }\n        page.site.value = currReceipt.receiptSite ?? '';\n        page.supplier.value = currReceipt.supplier ?? '';\n        if (!currLine.product || !page.site.value) {\n            return false;\n        }\n        const productSiteData = new product_site_data_1.ProductSiteData(currLine.product, page.site.value, page);\n        const productPromise = await productSiteData.product;\n        const productSitePromise = typesLib.strictNe(productPromise?.stockManagementMode, 'notManaged') ? await productSiteData.productSite : undefined;\n        let purchaseOrderLine;\n        purchaseOrderLine = null;\n        let supplierProductUnits;\n        let statuses;\n        let shipmentLine;\n        shipmentLine = null;\n        // if this receipt line to create is based on a PO line, additionally retrieve information for calculating remaining quantity & setting default unit of measure\n        if (currLine.purchaseOrder && currLine.purchaseOrderLineNumber && currLine.purchaseOrderLine) {\n            page.purchaseOrderNumber = currLine.purchaseOrder;\n            page.purchaseOrderLineNumber = currLine.purchaseOrderLineNumber;\n            page.purchaseShipment = currLine.purchaseShipment;\n            page.purchaseShipmentLine = Number(currLine.purchaseShipmentLine);\n            try {\n                purchaseOrderLine = await page.$.graph\n                    .node('@sage/x3-purchasing/PurchaseOrderLine')\n                    .read({\n                    orderUnit: {\n                        code: true,\n                    },\n                    purchaseUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    quantityInStockUnitOrdered: true,\n                    quantityInStockUnitReceived: true,\n                    quantityInOrderUnitOrdered: true,\n                    quantityInPurchaseUnitOrdered: true,\n                    quantityInPurchaseUnitReceived: true,\n                    orderUnitToPurchaseUnitConversionFactor: true,\n                    majorProductVersion: { code: true },\n                    minorProductVersion: true,\n                }, \n                // TODO: find a better way if possible (instead of having to pass PO seq number, pass in _id)\n                `${page.purchaseOrderNumber}|${page.purchaseOrderLineNumber}|${currLine.purchaseOrderLine}`)\n                    .execute();\n            }\n            catch (e) {\n                await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing/error-loading-purchase-order', 'Error loading purchase order'), String(e)); // (X3-218179) TODO Issue: Better error handling: String(e) calculates to \"Error: testing\"\n                return false;\n            }\n            try {\n                const shipmentLineReponse = await page.$.graph\n                    .node('@sage/x3-purchasing/PurchaseShipmentLine')\n                    .query(ui.queryUtils.edgesSelector({\n                    purchaseShipment: { id: true },\n                    lineNumber: true,\n                    product: { code: true },\n                    quantityInPurchaseUnitExpected: true,\n                    quantityInOrderUnitShipped: true,\n                    quantityInPurchaseUnitShipped: true,\n                    quantityInStockUnitShipped: true,\n                    orderUnitToPurchaseUnitConversionFactor: true,\n                    orderUnit: { code: true },\n                    stockUnit: { code: true },\n                }, {\n                    filter: {\n                        purchaseShipment: {\n                            id: page.purchaseShipment,\n                        },\n                        lineNumber: page.purchaseShipmentLine,\n                    },\n                }))\n                    .execute();\n                if (typesLib.strictEq(shipmentLineReponse.edges.length, 1)) {\n                    shipmentLine = shipmentLineReponse.edges[0].node;\n                }\n            }\n            catch (e) {\n                await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing/error-loading-purchase-shipment-line', 'Error loading purchase shipment line'), String(e));\n                return false;\n            }\n        }\n        //Add supplier product units\n        try {\n            supplierProductUnits = (await page.$.graph\n                .node('@sage/x3-master-data/SupplierProduct')\n                .read({\n                purchaseUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                purchaseUnitToStockUnitConversionFactor: true,\n                packingUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnitToPurchaseUnitConversionFactor: true,\n            }, \n            // TODO: Better way to specify id for a Sage X3 record?\n            `${currLine.product}|${currReceipt.supplier}`)\n                .execute());\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing/error-loading-supplier-product', 'Error loading supplier product'), String(e)); // (X3-218179) TODO Issue: Better error handling: String(e) calculates to \"Error: testing\"\n            return false;\n        }\n        const productSite = await productSitePromise;\n        const product = await productPromise;\n        //read stock rules management\n        if (!product) {\n            return false;\n        }\n        page.product.value = product.code;\n        page.purchaseSession.purchaseStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(page.site.value, product.productCategory.code, '3', transactionEntry.stockMovementCode ?? null, page);\n        //Add available statuses\n        if (!page.purchaseSession.purchaseStockManagementRules) {\n            return false;\n        }\n        const selectedStatus = [];\n        page.purchaseSession.purchaseStockManagementRules.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        try {\n            statuses = (0, xtrem_client_1.extractEdges)(await page.$.graph\n                .node('@sage/x3-stock-data/StockStatus')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: {\n                    code: { _or: selectedStatus },\n                },\n            }))\n                .execute()).map(status => status.code);\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing/error-loading-stock-statuses', 'Error loading stock statuses'), String(e)); // (X3-218179) TODO Issue: Better error handling: String(e) calculates to \"Error: testing\"\n            return false;\n        }\n        //default status\n        const defaultStatus = page.purchaseSession.purchaseStockManagementRules.defaultStatus;\n        const lotManagementRule = page.purchaseSession.purchaseStockManagementRules.lotEntry;\n        const lotByDefault = page.purchaseSession.purchaseStockManagementRules.lotByDefault;\n        const lpnManagementRule = page.purchaseSession.purchaseStockManagementRules?.licensePlateNumberEntry;\n        //PurchaseReceiptDetailsInitializer.initReceiptLines(page, !!productSite); // TODO Implement or removed\n        PurchaseReceiptDetailsInitializer.initLotFields(page, product, transactionEntry, lotManagementRule, lotByDefault);\n        PurchaseReceiptDetailsInitializer.initReceiptUnitFields(page, product, supplierProductUnits); // TODO remove 'as any' - published ProductSite.product doesn't have packingUnits at the moment.\n        PurchaseReceiptDetailsInitializer.initMiscellaneousFields(page, product, productSite, statuses, defaultStatus, transactionEntry, lpnManagementRule);\n        //add suggested location\n        if (productSite && !page.suggestedLocation.isHidden) {\n            const suggestedLocation = await (0, stock_management_rules_1.findDefaultLocation)(productSite, page.purchaseSession.purchaseStockManagementRules, page);\n            if (!suggestedLocation)\n                page.suggestedLocation.isHidden = true;\n            else\n                page.suggestedLocation.value = suggestedLocation;\n            if (typesLib.strictEq(page.isLocationPreloaded, true) && suggestedLocation) {\n                const _location = await (0, stock_management_rules_1.getLocationPreloaded)(page.site.value, suggestedLocation, page);\n                if (_location) {\n                    page.location.value = _location;\n                }\n            }\n        }\n        PurchaseReceiptDetailsInitializer.initPoCloseLineSelect(page, closePoLineOptions);\n        // Set receiptUnit select field to default unit based on selected PO Line's orderUnit or selected Supplier->Product's purchaseUnit\n        let defaultReceiptUnit;\n        let defaultReceiptUnitCode;\n        let orderUnitToStockUnitConversionFactor;\n        if (purchaseOrderLine) {\n            page.purchaseSession.orderUnitToPurchaseUnitConversionFactor = Number(purchaseOrderLine.orderUnitToPurchaseUnitConversionFactor);\n            orderUnitToStockUnitConversionFactor = Number.parseFloat((typesLib.div(Number(purchaseOrderLine.quantityInStockUnitOrdered), Number(purchaseOrderLine.quantityInOrderUnitOrdered))).toFixed(PurchaseReceiptDetailsInitializer.CONVERSION_RATE_DECIMAL_PLACES)).toString();\n            if (typesLib.strictEq(purchaseOrderLine.orderUnit.code, product.stockUnit.code) && typesLib.strictEq(orderUnitToStockUnitConversionFactor, '1')) {\n                defaultReceiptUnit = purchaseOrderLine.orderUnit.code;\n                defaultReceiptUnitCode = purchaseOrderLine.orderUnit.code;\n            }\n            else {\n                defaultReceiptUnitCode = purchaseOrderLine.orderUnit.code;\n                defaultReceiptUnit = formatUnitForDisplay(purchaseOrderLine.orderUnit.code, orderUnitToStockUnitConversionFactor, product.stockUnit.code);\n            }\n            // Add order unit calculated from supplier purchase unit when used on PO\n            const findUnit = page.receiptUnits.find(packingUnit => typesLib.strictEq(packingUnit.node.packingUnit.code, defaultReceiptUnitCode)); // TODO Issue: Rounding issue on orderUnitToStockUnitConversionFactor can cause an existing match to not be found and thus, create a 'duplicate' option in receiptUnit\n            if (!findUnit) {\n                page.receiptUnits.push({\n                    node: {\n                        packingUnit: {\n                            code: purchaseOrderLine.orderUnit.code,\n                            numberOfDecimals: page.receiptUnits.find(packingUnit => typesLib.strictEq(packingUnit.node.packingUnit.code, purchaseOrderLine?.orderUnit.code))?.node.packingUnit.numberOfDecimals ?? 0,\n                            name: defaultReceiptUnit,\n                        },\n                        packingUnitToStockUnitConversionFactor: orderUnitToStockUnitConversionFactor.toString(),\n                        isPackingFactorEntryAllowed: false,\n                        isPackingUnit: true,\n                    },\n                });\n                //Update available units\n                page.receiptUnit.options?.push(defaultReceiptUnit);\n            }\n        }\n        else {\n            //If supplier product purchase unit exists, use it as default.  Otherwise use the product's purchase unit.\n            let defaultOrderUnit;\n            if (supplierProductUnits?.purchaseUnit?.code) {\n                defaultOrderUnit = supplierProductUnits.purchaseUnit.code;\n                orderUnitToStockUnitConversionFactor = Number.parseFloat(supplierProductUnits.purchaseUnitToStockUnitConversionFactor).toString();\n            }\n            else {\n                defaultOrderUnit = product.purchaseUnit.code;\n                orderUnitToStockUnitConversionFactor = Number.parseFloat(product.purchaseUnitToStockUnitConversionFactor).toString();\n            }\n            if (typesLib.strictEq(defaultOrderUnit, product.stockUnit.code) && typesLib.strictEq(orderUnitToStockUnitConversionFactor, '1')) {\n                defaultReceiptUnit = defaultOrderUnit;\n                defaultReceiptUnitCode = defaultOrderUnit;\n            }\n            else {\n                defaultReceiptUnitCode = defaultOrderUnit;\n                defaultReceiptUnit = formatUnitForDisplay(defaultOrderUnit, orderUnitToStockUnitConversionFactor, product.stockUnit.code);\n            }\n        }\n        const selectedUnit = page.receiptUnits.find(packingUnit => typesLib.strictEq(packingUnit.node.packingUnit.code, defaultReceiptUnitCode));\n        if (!selectedUnit)\n            return false;\n        page.packingUnitToStockUnitConversionFactor.value = Number(orderUnitToStockUnitConversionFactor);\n        page.isPackingUnit = selectedUnit.node.isPackingUnit;\n        page.quantityToReceive.scale = selectedUnit.node.packingUnit.numberOfDecimals; // set # of decimal places restriction based on selected unit of measure\n        if (typesLib.strictNe(selectedUnit.node.packingUnit.code, product.stockUnit.code) && typesLib.strictNe(orderUnitToStockUnitConversionFactor, '1')) {\n            page.receiptUnit.value = formatUnitForDisplay(selectedUnit.node.packingUnit.code, selectedUnit.node.packingUnitToStockUnitConversionFactor, product.stockUnit.code);\n        }\n        else\n            page.receiptUnit.value = defaultReceiptUnit;\n        page.receiptUnitCode.value = selectedUnit.node.packingUnit.code;\n        page.previousReceiptUnit.value = page.receiptUnit.value;\n        page.packingUnitToStockUnitConversionFactor.isDisabled = !selectedUnit.node.isPackingFactorEntryAllowed;\n        // Calculating remaining quantity only applicable for PO Line workflow\n        if (purchaseOrderLine) {\n            PurchaseReceiptDetailsInitializer.initVersionFields(page, product, purchaseOrderLine);\n            const remainingQuantity = [0, 0, 0];\n            PurchaseReceiptDetailsInitializer.calculateRemainingQuantity(page, purchaseOrderLine, currReceipt.lines.slice(0, typesLib.sub(currReceipt.lines.length, 1)), // do not include most recently added line as part of the equation, because that is the current line being edited\n            shipmentLine, remainingQuantity);\n            page.remainingQuantityInStockUnit.value = remainingQuantity[0];\n            //the packing unit is the order unit, so I can put remainingQuantityInOrderUnit in the remainingQuantityInPackingUnit field\n            page.remainingQuantityInPackingUnit.value = remainingQuantity[1];\n            //if (selectedUnit?.node.unit.numberOfDecimals && selectedUnit?.node.packingUnit.numberOfDecimals !== 0) {\n            const tmp = typesLib.pow(10, selectedUnit?.node.packingUnit.numberOfDecimals);\n            if (typesLib.strictNe(tmp, 0)) {\n                page.remainingQuantityInStockUnit.value = typesLib.div(typesLib.round(typesLib.mul(page.remainingQuantityInStockUnit.value, tmp)), tmp);\n            }\n            //}\n            page.quantityToReceive.value = page.remainingQuantityInPackingUnit.value; // should auto-round value appropriately based on scale property that was set for this field\n            page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n            page.quantityToReceiveRounded = page.quantityToReceive.value;\n            page.remainingQuantityNoRounded = page.remainingQuantityInPackingUnit.value;\n            page.remainingQuantityRounded = page.remainingQuantityInPackingUnit.value;\n            page.closePoLine.value = closePoLineOptions[0]; //Yes\n            page.remainingQuantityInitialInStockUnit = shipmentLine\n                ? Number(shipmentLine.quantityInStockUnitShipped)\n                : Number(purchaseOrderLine.quantityInStockUnitOrdered);\n            page.remainingQuantityInitialInOrderUnit = shipmentLine\n                ? Number(shipmentLine.quantityInOrderUnitShipped)\n                : Number(purchaseOrderLine.quantityInOrderUnitOrdered);\n            page.orderUnit = shipmentLine ? shipmentLine.orderUnit : purchaseOrderLine.orderUnit;\n        }\n        else {\n            PurchaseReceiptDetailsInitializer.initVersionFields(page, product);\n            //Quantity values not used for direct receipts\n            page.remainingQuantityInPackingUnit.value = 0;\n            page.remainingQuantityInPackingUnit.isHidden = true;\n            page.closePoLine.isHidden = true;\n            page.remainingQuantityInitialInStockUnit = 0;\n            page.remainingQuantityInitialInOrderUnit = 0;\n        }\n        page.productSite = productSite;\n        page.productNode = product;\n        PurchaseReceiptDetailsInitializer.initHeader(page, product, purchaseOrderLine, currReceipt.lines.slice(0, typesLib.sub(currReceipt.lines.length, 1)), shipmentLine);\n        return true;\n    }\n    static calculateRemainingQuantity(page, purchaseOrderLine, lines = [], shipmentLine, remainingQuantity) {\n        // calculate the conversion rate from stock unit to order unit\n        // TODO: Unfortunately there appears to be cases in which toFixed() doesn't round correctly\n        // TODO: Verify if there is a better way of calculating conversion rate. This is based on 4GL ENVADC.src\n        let conversionRatePurchaseUnitToStockUnit = 0;\n        let conversionRateOrderUnitToStockUnit = 0;\n        let pendingQuantityInStockUnitReceived = 0;\n        let quantityInStockUnitExpected = 0;\n        let remainingQuantityInStockUnit = 0;\n        let remainingQuantityInOrderUnit = 0;\n        let remainingQuantityInPurchaseUnit = 0;\n        if (shipmentLine) {\n            conversionRatePurchaseUnitToStockUnit = Number.parseFloat((typesLib.div(Number(shipmentLine.quantityInStockUnitShipped), Number(shipmentLine.quantityInPurchaseUnitShipped))).toFixed(PurchaseReceiptDetailsInitializer.QTY_DECIMAL_PLACES));\n            conversionRateOrderUnitToStockUnit = Number.parseFloat((typesLib.div(Number(purchaseOrderLine.quantityInStockUnitOrdered), Number(purchaseOrderLine.quantityInOrderUnitOrdered))).toFixed(PurchaseReceiptDetailsInitializer.QTY_DECIMAL_PLACES)); // using Number.parseFloat() to remove any trailing decimal zeros due to toFixed()\n        }\n        else {\n            conversionRateOrderUnitToStockUnit = Number.parseFloat((typesLib.div(Number(purchaseOrderLine.quantityInStockUnitOrdered), Number(purchaseOrderLine.quantityInOrderUnitOrdered))).toFixed(PurchaseReceiptDetailsInitializer.QTY_DECIMAL_PLACES)); // using Number.parseFloat() to remove any trailing decimal zeros due to toFixed()\n            conversionRatePurchaseUnitToStockUnit = Number.parseFloat((typesLib.div(Number(purchaseOrderLine.quantityInStockUnitOrdered), Number(purchaseOrderLine.quantityInPurchaseUnitOrdered))).toFixed(PurchaseReceiptDetailsInitializer.QTY_DECIMAL_PLACES)); // using Number.parseFloat() to remove any trailing decimal zeros due to toFixed()\n        }\n        try {\n            if (typesLib.gt(lines?.length, 0)) {\n                // iterate through receipt lines user has added so far for the same PO Line & product as this selected PO line\n                if (shipmentLine?.purchaseShipment) {\n                    pendingQuantityInStockUnitReceived = calculCurrentQuantityInStockUnitReceived(lines, shipmentLine);\n                }\n                else {\n                    lines\n                        .filter((line) => typesLib.strictEq(line.purchaseOrder, page.purchaseOrderNumber) && typesLib.strictEq(line.purchaseOrderLineNumber, page.purchaseOrderLineNumber) && typesLib.strictEq(line.product, page.product.value))\n                        .map((line) => (pendingQuantityInStockUnitReceived = typesLib.add(pendingQuantityInStockUnitReceived, typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor)))));\n                }\n            }\n        }\n        catch (error) {\n            ui.console.warn(`Error loading saved purchase receipt session data: ${error}`);\n        }\n        // quantity is initially calculated based on remaining stock quantity and then converted to order unit\n        if (shipmentLine) {\n            quantityInStockUnitExpected = typesLib.mul(Number(shipmentLine?.quantityInPurchaseUnitExpected), conversionRatePurchaseUnitToStockUnit);\n            remainingQuantityInStockUnit = typesLib.max(0, typesLib.sub(Number(quantityInStockUnitExpected), pendingQuantityInStockUnitReceived));\n            if (typesLib.strictNe(conversionRateOrderUnitToStockUnit, 0)) {\n                remainingQuantityInOrderUnit = typesLib.div(remainingQuantityInStockUnit, conversionRateOrderUnitToStockUnit);\n            }\n            if (typesLib.strictNe(conversionRatePurchaseUnitToStockUnit, 0)) {\n                const tmp = typesLib.pow(10, purchaseOrderLine.purchaseUnit.numberOfDecimals);\n                if (typesLib.strictNe(tmp, 0)) {\n                    remainingQuantityInPurchaseUnit = typesLib.div(typesLib.round(typesLib.mul((typesLib.div(remainingQuantityInStockUnit, conversionRatePurchaseUnitToStockUnit)), tmp)), tmp);\n                }\n                else {\n                    remainingQuantityInPurchaseUnit = typesLib.div(remainingQuantityInStockUnit, conversionRatePurchaseUnitToStockUnit);\n                }\n            }\n        }\n        else {\n            remainingQuantityInStockUnit = typesLib.max(0, typesLib.sub(typesLib.sub(Number(purchaseOrderLine.quantityInStockUnitOrdered), Number(purchaseOrderLine.quantityInStockUnitReceived)), pendingQuantityInStockUnitReceived));\n            if (typesLib.strictNe(conversionRateOrderUnitToStockUnit, 0)) {\n                remainingQuantityInOrderUnit = typesLib.div(remainingQuantityInStockUnit, conversionRateOrderUnitToStockUnit);\n            }\n            if (typesLib.strictNe(conversionRatePurchaseUnitToStockUnit, 0)) {\n                const tmp = typesLib.pow(10, purchaseOrderLine.purchaseUnit.numberOfDecimals);\n                if (typesLib.strictNe(tmp, 0)) {\n                    remainingQuantityInPurchaseUnit = typesLib.div(typesLib.round(typesLib.mul((typesLib.div(remainingQuantityInStockUnit, conversionRatePurchaseUnitToStockUnit)), tmp)), tmp);\n                }\n                else {\n                    remainingQuantityInPurchaseUnit = typesLib.div(remainingQuantityInStockUnit, conversionRatePurchaseUnitToStockUnit);\n                }\n            }\n        }\n        remainingQuantity[0] = remainingQuantityInStockUnit;\n        remainingQuantity[1] = remainingQuantityInOrderUnit;\n        remainingQuantity[2] = remainingQuantityInPurchaseUnit;\n    }\n    static initReceiptLines(page, newDetail = false) {\n        // TODO: fill in line management later\n    }\n    static initHeader(page, productNode, purchaseOrderLine, lines, shipmentLine) {\n        page.product.value = productNode.code;\n        page.description.value = productNode.localizedDescription1;\n        if (purchaseOrderLine && page.purchaseOrderNumber && page.purchaseOrderLineNumber) {\n            page.headerTitleLeft.value = page.purchaseOrderNumber;\n            page.headerTitleRight.value = page.purchaseOrderLineNumber.toString();\n            page.headerTitleRight.prefix = ui.localize('@sage/x3-purchasing/pages__adc_purchase_receipt_header_detail__line_no', 'Line No.');\n            page.headerLine2Left.value = page.product.value;\n            page.headerLine2Right.value = page.description.value;\n            page.headerLine3Left.value = ui.localize('@sage/x3-purchasing/pages__adc_purchase_receipt_header_detail__expected_quantity', 'Expected quantity:');\n            const remainingQuantity = [0, 0, 0];\n            PurchaseReceiptDetailsInitializer.calculateRemainingQuantity(page, purchaseOrderLine, lines, shipmentLine, remainingQuantity);\n            page.headerLine3Right.value = `${Number(remainingQuantity[2]).toFixed(purchaseOrderLine.purchaseUnit.numberOfDecimals)} ${purchaseOrderLine.purchaseUnit.code}`;\n        }\n        else {\n            page.headerTitleLeft.value = page.product.value;\n            page.headerTitleRight.value = '';\n            page.headerLine2Left.value = page.description.value;\n            page.headerLine2Right.value = '';\n            page.headerLine3Left.value = page.supplier.value;\n            page.headerLine3Right.value = '';\n        }\n    }\n    static initVersionFields(page, productNode, purchaseOrderLineNode) {\n        const versionManagementMode = productNode.stockVersionMode;\n        page.majorVersion.isHidden = !['major', 'majorAndMinor'].includes(versionManagementMode);\n        page.minorVersion.isHidden = typesLib.strictNe(versionManagementMode, 'majorAndMinor');\n        page.minorVersion.isDisabled = true;\n        // if workflow is PO Line, display version from the PO Line if provided\n        if (purchaseOrderLineNode &&\n            !page.majorVersion.isHidden &&\n            purchaseOrderLineNode.majorProductVersion &&\n            purchaseOrderLineNode.majorProductVersion.code) {\n            page.majorVersion.value = { code: purchaseOrderLineNode.majorProductVersion.code };\n            // check for minor version\n            if (!page.minorVersion.isHidden && purchaseOrderLineNode.minorProductVersion) {\n                page.minorVersion.value = { minorVersion: purchaseOrderLineNode.minorProductVersion };\n                page.minorVersion.isDisabled = false;\n            }\n        }\n        // no need to check at this point if only minor version is hidden. Cannot have minor without major\n    }\n    static initLotFields(page, productNode, transactionEntry, lotManagementRule, lotByDefault) {\n        const lotManagement = productNode.lotManagementMode;\n        const lotNotManaged = typesLib.strictEq(lotManagement, 'notManaged');\n        page.lot.isHidden = lotNotManaged;\n        page.supplierLot.isHidden = lotNotManaged;\n        page.sublot.isHidden = typesLib.strictNe(lotManagement, 'lotAndSublot');\n        page.sublot.isMandatory = !page.sublot.isHidden;\n        if (!page.lot.isHidden) {\n            if (typesLib.strictEq(lotManagementRule, 'no')) {\n                page.lot.isDisabled = true;\n                if (typesLib.strictEq(page.sublot.isHidden, false)) {\n                    page.sublot.value = '00001';\n                    page.sublot.isDisabled = true;\n                }\n            }\n            else if (typesLib.strictEq(lotManagementRule, 'newLot')) {\n                if (typesLib.strictEq(page.sublot.isHidden, false))\n                    page.sublot.value = '00001';\n            }\n            else if (typesLib.strictEq(lotManagementRule, 'free') && typesLib.strictEq(lotByDefault, 'documentNumber')) {\n                if (typesLib.strictEq(page.sublot.isHidden, false))\n                    page.sublot.value = '00001';\n            }\n        }\n        page.lotCustomField1.isHidden = !transactionEntry.isLotCustomField1Allowed || lotNotManaged;\n        page.lotCustomField2.isHidden = !transactionEntry.isLotCustomField2Allowed || lotNotManaged;\n        page.lotCustomField3.isHidden = !transactionEntry.isLotCustomField3Allowed || lotNotManaged;\n        page.lotCustomField4.isHidden = !transactionEntry.isLotCustomField4Allowed || lotNotManaged;\n        page.lot.isMandatory =\n            !page.lot.isHidden &&\n                !productNode.lotSequenceNumber && typesLib.strictNe(lotManagement, 'optionalLot') && typesLib.strictNe(lotByDefault, 'documentNumber');\n    }\n    static initReceiptUnitFields(page, productNode, supplierProduct) {\n        const packingUnitList = productNode.packingUnits;\n        page.receiptUnit.options = [];\n        page.receiptUnits = [];\n        const unitCodeOptions = [];\n        const stockUnit = productNode.stockUnit.code;\n        // Add stock unit\n        page.receiptUnits.push({\n            node: {\n                packingUnit: {\n                    code: stockUnit,\n                    numberOfDecimals: productNode.stockUnit.numberOfDecimals,\n                    name: stockUnit,\n                },\n                packingUnitToStockUnitConversionFactor: '1',\n                isPackingFactorEntryAllowed: false,\n                isPackingUnit: false,\n            },\n        });\n        unitCodeOptions.push(productNode.stockUnit.code);\n        let currentUnitDisplay;\n        currentUnitDisplay = '';\n        // Add purchase unit if different from stock unit\n        if (typesLib.strictNe(productNode.stockUnit.code, productNode.purchaseUnit.code)) {\n            currentUnitDisplay = formatUnitForDisplay(productNode.purchaseUnit.code, productNode.purchaseUnitToStockUnitConversionFactor, stockUnit);\n            page.receiptUnits.push({\n                node: {\n                    packingUnit: {\n                        code: productNode.purchaseUnit.code,\n                        name: currentUnitDisplay,\n                        numberOfDecimals: productNode.purchaseUnit.numberOfDecimals,\n                    },\n                    packingUnitToStockUnitConversionFactor: productNode.purchaseUnitToStockUnitConversionFactor.toString(),\n                    isPackingFactorEntryAllowed: false,\n                    isPackingUnit: false,\n                },\n            });\n            unitCodeOptions.push(currentUnitDisplay);\n        }\n        // Add all units from packingUnitList.  Packing unit cannot be a stock unit.\n        let duplicateUnit = false;\n        if (typesLib.gt(packingUnitList.query?.edges?.length, 0)) {\n            for (const packUnit of packingUnitList.query.edges) {\n                duplicateUnit = false;\n                for (const receiptUnit of page.receiptUnits) {\n                    currentUnitDisplay = formatUnitForDisplay(\n                    // TODO Issue: This logic only needs to be done one per packing unit. Should be moved outside of this for loop\n                    packUnit.node.packingUnit.code, packUnit.node.packingUnitToStockUnitConversionFactor, stockUnit);\n                    if (typesLib.strictEq(packUnit.node.packingUnit.code, receiptUnit.node.packingUnit.code) && typesLib.strictEq(packUnit.node.packingUnitToStockUnitConversionFactor, receiptUnit.node.packingUnitToStockUnitConversionFactor)) {\n                        duplicateUnit = true;\n                        //If a packing unit matches the product's purchase unit, convert is to a packing unit\n                        receiptUnit.node.isPackingUnit = true;\n                        break;\n                    }\n                }\n                if (!duplicateUnit) {\n                    page.receiptUnits.push({\n                        node: {\n                            packingUnit: {\n                                code: packUnit.node.packingUnit.code,\n                                name: currentUnitDisplay,\n                                numberOfDecimals: packUnit.node.packingUnit.numberOfDecimals,\n                            },\n                            packingUnitToStockUnitConversionFactor: packUnit.node.packingUnitToStockUnitConversionFactor,\n                            isPackingFactorEntryAllowed: packUnit.node.isPackingFactorEntryAllowed,\n                            isPackingUnit: true,\n                        },\n                    });\n                    unitCodeOptions.push(currentUnitDisplay);\n                }\n            }\n        }\n        // Add supplier-product units\n        duplicateUnit = false;\n        if (supplierProduct?.purchaseUnit?.code) {\n            for (const receiptUnit of page.receiptUnits) {\n                currentUnitDisplay = formatUnitForDisplay(\n                // TODO Issue: This logic only needs to be done one per packing unit. Should be moved outside of this for loop\n                supplierProduct.purchaseUnit.code, supplierProduct.purchaseUnitToStockUnitConversionFactor, stockUnit);\n                if (typesLib.strictEq(supplierProduct.purchaseUnit.code, receiptUnit.node.packingUnit.code) && typesLib.strictEq(supplierProduct.purchaseUnitToStockUnitConversionFactor, receiptUnit.node.packingUnitToStockUnitConversionFactor)) {\n                    duplicateUnit = true;\n                    break;\n                }\n            }\n            if (!duplicateUnit) {\n                page.receiptUnits.push({\n                    node: {\n                        packingUnit: {\n                            code: supplierProduct.purchaseUnit.code,\n                            name: currentUnitDisplay,\n                            numberOfDecimals: supplierProduct.purchaseUnit.numberOfDecimals,\n                        },\n                        packingUnitToStockUnitConversionFactor: supplierProduct.purchaseUnitToStockUnitConversionFactor,\n                        isPackingFactorEntryAllowed: false,\n                        isPackingUnit: false,\n                    },\n                });\n                unitCodeOptions.push(currentUnitDisplay);\n            }\n        }\n        duplicateUnit = false;\n        if (supplierProduct?.packingUnit?.code) {\n            const unitConversion = Number.parseFloat((typesLib.mul(Number(supplierProduct.packingUnitToPurchaseUnitConversionFactor), Number(supplierProduct.purchaseUnitToStockUnitConversionFactor))).toFixed(PurchaseReceiptDetailsInitializer.CONVERSION_RATE_DECIMAL_PLACES)).toString();\n            for (const receiptUnit of page.receiptUnits) {\n                currentUnitDisplay = formatUnitForDisplay(supplierProduct.packingUnit.code, unitConversion, stockUnit); // TODO Issue: This logic does not need to be repeated. Should be moved outside of this for loop\n                //Comparison of conversion rates required converting both to string.  unitConversion is a number and\n                //packingUnitToStockUnitConversionFactor is defined as a number.  However, packingUnitToStockUnitConversionFactor\n                //is retrieved with quotes around it so the validation always returns false which can result in duplicate\n                //units displayed.  If I convert just unitConversion to a string, I receive a compile error that I am\n                //comparing a number to string.\n                if (typesLib.strictEq(supplierProduct.packingUnit.code, receiptUnit.node.packingUnit.code) && typesLib.strictEq(unitConversion.toString(), receiptUnit.node.packingUnitToStockUnitConversionFactor.toString())) {\n                    duplicateUnit = true;\n                    break;\n                }\n            }\n            if (!duplicateUnit) {\n                page.receiptUnits.push({\n                    node: {\n                        packingUnit: {\n                            code: supplierProduct.packingUnit.code,\n                            name: currentUnitDisplay,\n                            numberOfDecimals: supplierProduct.packingUnit.numberOfDecimals,\n                        },\n                        packingUnitToStockUnitConversionFactor: unitConversion,\n                        isPackingFactorEntryAllowed: false,\n                        isPackingUnit: false,\n                    },\n                });\n                unitCodeOptions.push(currentUnitDisplay);\n            }\n        }\n        page.receiptUnit.options = unitCodeOptions;\n        page.receiptUnit.isReadOnly = typesLib.lte(page.receiptUnit.options.length, 1);\n        page.receiptUnit.isDisabled = false;\n    }\n    static initMiscellaneousFields(page, productNode, productSiteNode, statuses, defaultStatus, transactionEntry, lpnManagementRule) {\n        //TODO: Retrieve default status value from StockManagementRules node.  This node will not be published in\n        //time for 2020 R3 release.\n        page.status.options = statuses;\n        //page.status.value = 'A'; // TODO Verify: hard-code status?\n        page.status.value = defaultStatus;\n        // Potency management\n        const potencyManagement = productNode.stockManagementMode;\n        page.potency.isHidden =\n            typesLib.strictNe(potencyManagement, 'potencyManaged') || !transactionEntry.isLotPotencyAllowed || page.lot.isHidden;\n        if (!page.potency.isHidden) {\n            page.potency.value = Number(productNode.defaultPotencyInPercentage);\n        }\n        const serialNumberManagement = productNode.serialNumberManagementMode;\n        page.serialNumber.isHidden = typesLib.strictEq(serialNumberManagement, 'notManaged') || typesLib.strictEq(serialNumberManagement, 'issued');\n        page.serialNumber.isMandatory = !page.serialNumber.isHidden && !productNode.serialSequenceNumber;\n        page.licensePlateNumber.isHidden = !productSiteNode || !productSiteNode.isLicensePlateNumberManaged;\n        page.location.isHidden = !productSiteNode || !productSiteNode.isLocationManaged;\n        page.location.isMandatory = !page.location.isHidden;\n        page.suggestedLocation.isHidden = page.location.isHidden;\n        const expirationManagement = productNode.expirationManagementMode;\n        page.isExpirationManaged = typesLib.strictNe(expirationManagement, 'notManaged');\n        page.expirationDate.isHidden = page.useByDate.isHidden = !page.isExpirationManaged;\n        if (page.isExpirationManaged) {\n            page.expirationDate.isDisabled = page.useByDate.isDisabled = false;\n            if (transactionEntry.isLotExpirationDateAllowed) {\n                page.useByDate.isDisabled =\n                    typesLib.strictEq(expirationManagement, 'roundingBeginningMonth1') || typesLib.strictEq(expirationManagement, 'roundingMonthEnd');\n            }\n            else {\n                page.expirationDate.isDisabled = page.useByDate.isDisabled =\n                    typesLib.strictEq(expirationManagement, 'roundingBeginningMonth1') || typesLib.strictEq(expirationManagement, 'roundingMonthEnd') || typesLib.strictEq(expirationManagement, 'withoutRounding');\n            }\n        }\n        const effectiveDate = xtrem_date_time_1.DateValue.today().toString();\n        if (!page.expirationDate.isHidden && typesLib.strictNe(expirationManagement, 'manualEntry')) {\n            page.expirationDate.value =\n                (0, defaultValue_1.expirationDateDefaultValue)(productNode.expirationManagementMode, productNode.expirationLeadTime, productNode.expirationTimeUnit, effectiveDate) ?? '';\n            page.useByDate.value =\n                (0, defaultValue_1.useByDateDefaultValue)(page.expirationDate.value, effectiveDate, productNode.expirationManagementMode, Number(productNode.useByDateCoefficient)) ?? '';\n            page.useByDate.maxDate = page.expirationDate.value;\n        }\n        switch (transactionEntry.identifier1Detail) {\n            case 'entered': {\n                page.identifier1.isHidden = false;\n                page.identifier1.isDisabled = false;\n                break;\n            }\n            case 'displayed': {\n                page.identifier1.isHidden = false;\n                page.identifier1.isDisabled = true;\n                break;\n            }\n            default: {\n                page.identifier1.isHidden = true;\n            }\n        }\n        switch (transactionEntry.identifier2Detail) {\n            case 'entered': {\n                page.identifier2.isHidden = false;\n                page.identifier2.isDisabled = false;\n                break;\n            }\n            case 'displayed': {\n                page.identifier2.isHidden = false;\n                page.identifier2.isDisabled = true;\n                break;\n            }\n            default: {\n                page.identifier2.isHidden = true;\n            }\n        }\n        page.container.isHidden = typesLib.strictNe(lpnManagementRule, 'mandatory') || !productSiteNode || !productSiteNode.isLicensePlateNumberManaged;\n        if (productSiteNode && !page.container.isHidden)\n            page.container.value = productSiteNode.defaultInternalContainer;\n    }\n    static initPoCloseLineSelect(page, closePoLineOptions) {\n        page.closePoLine.options = closePoLineOptions;\n    }\n}\nexports.PurchaseReceiptDetailsInitializer = PurchaseReceiptDetailsInitializer;\nfunction formatUnitForDisplay(code, conversionRate, stockUnit) {\n    return `${code} ${'='} ${conversionRate} ${stockUnit}`;\n}\nfunction calculCurrentQuantityInStockUnitReceived(lines = [], shipmentLine) {\n    let currentQuantityInStockUnitReceived = 0;\n    lines\n        ?.filter((line) => typesLib.strictEq(line?.purchaseShipment, shipmentLine.purchaseShipment.id) && typesLib.strictEq(Number(line?.purchaseShipmentLine), Number(shipmentLine.lineNumber)))\n        .map((line) => (currentQuantityInStockUnitReceived = typesLib.add(currentQuantityInStockUnitReceived, typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor)))));\n    return currentQuantityInStockUnitReceived;\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/purchase-receipt-details-initializer.ts\n");

/***/ }),

/***/ "./lib/client-functions/read-parameter.ts":
/*!************************************************!*\
  !*** ./lib/client-functions/read-parameter.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readParameterValue = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function readParameterValue(parameter, user, stockSite, pageInstance) {\n    try {\n        let resp;\n        const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-system/GeneralParameter')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            definitionLevel: true,\n            folderValue: true,\n            valueType: true,\n        }, {\n            filter: {\n                code: parameter,\n            },\n        }))\n            .execute());\n        // Call appropriate function depending on parameter level\n        if (typesLib.strictEq(response[0].definitionLevel, 'user') && typesLib.strictEq(response[0].folderValue, false)) {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n        }\n        else {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            return '';\n        }\n    }\n    catch (e) {\n        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/utils-error-reading-parameter-value', 'Error reading parameter value: {{ param }}', { param: parameter }));\n        return '';\n    }\n}\nexports.readParameterValue = readParameterValue;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/read-parameter.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getLocationPreloaded = exports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(null, productCategory, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(null, null, transactionType, null, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-purchasing/utils__stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: true,\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg?.node?.defaultLocation &&\n            !defaultLocationCateg?.node?.defaultLocation?.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\nasync function getLocationPreloaded(site, suggestedLocation, pageInstance) {\n    try {\n        return await pageInstance.$.graph\n            .node('@sage/x3-stock-data/Location')\n            .read({\n            code: true,\n            type: true,\n            stockSite: {\n                code: true,\n            },\n            warehouse: {\n                code: true,\n            },\n        }, `${site}|${suggestedLocation}`)\n            .execute();\n    }\n    catch (e) {\n        return null;\n    }\n}\nexports.getLocationPreloaded = getLocationPreloaded;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-purchase-receipt-enter-receipt-detail.ts":
/*!*******************************************************************!*\
  !*** ./lib/pages/mobile-purchase-receipt-enter-receipt-detail.ts ***!
  \*******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePurchaseReceiptEnterReceiptDetail = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst support_service_management_gs_1_page_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/support-service-management-gs-1-page */ \"../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts\");\nconst parsed_element_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/parsed-element */ \"../../shared/x3-system/lib/shared-functions/parsed-element.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst defaultValue_1 = __webpack_require__(/*! ../client-functions/defaultValue */ \"./lib/client-functions/defaultValue.ts\");\nconst purchase_receipt_details_control_1 = __webpack_require__(/*! ../client-functions/purchase-receipt-details-control */ \"./lib/client-functions/purchase-receipt-details-control.ts\");\nconst purchase_receipt_details_initializer_1 = __webpack_require__(/*! ../client-functions/purchase-receipt-details-initializer */ \"./lib/client-functions/purchase-receipt-details-initializer.ts\");\nconst read_parameter_1 = __webpack_require__(/*! ../client-functions/read-parameter */ \"./lib/client-functions/read-parameter.ts\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\nconst mobile_purchase_receipt_1 = __webpack_require__(/*! ./mobile-purchase-receipt */ \"./lib/pages/mobile-purchase-receipt.ts\");\nconst closePoLineOptions = [\n    ui.localize('@sage/x3-purchasing/Yes', 'Yes'),\n    ui.localize('@sage/x3-purchasing/No', 'No'),\n];\nfunction getPackingUnitFromName(name, packingUnits) {\n    return packingUnits.findIndex(packingUnit => typesLib.strictEq(packingUnit.node.packingUnit.name, name));\n}\nlet MobilePurchaseReceiptEnterReceiptDetail = class MobilePurchaseReceiptEnterReceiptDetail extends support_service_management_gs_1_page_1.SupportServiceManagementGs1Page {\n    constructor() {\n        /**\n         *\n         * Technical composite data properties\n         *\n         */\n        super(...arguments);\n        /** This value is initialized only by main page\n         * and used only for control composite data block\n         */\n        /* @internal */\n        this._globalTradeItemNumber = null;\n        /**\n         * This value is initialized only when dispatching\n         * and reset when user change lot or expiration date.\n         */\n        /* @internal */\n        this._batchLot = null;\n        /**\n         * This value is initialized only when dispatching\n         * and reset when user change lot or expiration date.\n         */\n        /* @internal */\n        this._expiryDate = null;\n        this._effectiveDate = xtrem_date_time_1.DateValue.today().toString();\n        this.receiptUnits = [];\n        this.isAddQuantity = false;\n        /**\n         * This asynchronous readonly function check if current composite data is valid or not\n         * @param dictionaryDataComposite : dictionary of composite data block.\n         * @returns false when data must be discarded\n         */\n        /** @internal */\n        this._checkCompositeDataAllowed = async (dictionaryDataComposite) => {\n            const product = dictionaryDataComposite[parsed_element_1.DataTitle.gtin];\n            if (!!this.product?.value &&\n                ((!product && typesLib.strictNe(Object.keys(dictionaryDataComposite).length, 0)) ||\n                    (product && typesLib.strictNe((this._globalTradeItemNumber ?? ''), product.data)))) {\n                await this.$.sound.error();\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/dialog-error-gs-1-data-is-not-related-to-product', 'GS1 data is not related to product {{ product }}.', { product: this.product?.value }), {\n                    fullScreen: false,\n                });\n                return false;\n            }\n            return true;\n        };\n        /**\n         *\n         * Private methods\n         *\n         */\n        /**\n         * OnChange readonly process\n         *\n         * Used both decorator and bar code manager.\n         * @returns Promise<void>\n         */\n        /** @internal */\n        this._onChange_serialNumber = async () => { };\n        /** @internal */\n        this._onChange_lot = async () => {\n            this.lot.value ? (this.lot.value = this.lot.value.toUpperCase()) : '';\n            if (this.lot.value && typesLib.strictEq(this.purchaseSession?.purchaseStockManagementRules?.lotEntry, 'newLot')) {\n                if (!(await (0, purchase_receipt_details_control_1.controlLotReceipt)(this, this.lot.value, this.productNode.code, '6', this.site.value ?? ''))) {\n                    this.lot.value = null;\n                    this.lot.focus();\n                }\n            }\n            /**\n             * This bloc initialize current batch / lot during scanning,\n             * any change after invalidate the entire control data block\n             * */\n            if (this.controlManagerGs1.isDispatchInProgress) {\n                this._batchLot = this.lot.value;\n            }\n            else if (typesLib.strictNe(this._batchLot, this.lot.value)) {\n                this._resetCompositeDataControl();\n            }\n            this.sublot.value && !this.sublot.isHidden && typesLib.strictNe(this.svgLot.value, this.lot.value)\n                ? (this.sublot.value = null)\n                : null;\n            await this._getLotValues();\n            this.svgLot.value = this.lot.value;\n            if (this.lot.value) {\n                this._getNextField(this.lot)?.focus();\n            }\n        };\n        /** @internal */\n        this._onChange_expirationDate = async () => {\n            /**\n             * This bloc initialize current batch / lot during scanning,\n             * any change after invalidate the entire control data block\n             * */\n            if (this.controlManagerGs1.isDispatchInProgress) {\n                this._expiryDate = this.expirationDate.value;\n            }\n            else if (typesLib.strictNe(this._expiryDate, this.expirationDate.value)) {\n                this._resetCompositeDataControl();\n            }\n            this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value ?? '', this._effectiveDate, this.productNode.expirationManagementMode, Number(this.productNode.useByDateCoefficient));\n            this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n        };\n        /*\n         *\n         *  record management functions\n         *\n         */\n        // (X3-218180) TODO: Implement: To be migrated\n        // private createDetail() {\n        //     const manager = new PurchaseReceiptDetailsRecordManager();\n        //     manager.createLine(this.$, this, this.productSite);\n        // }\n    }\n    /**\n     *\n     * Technical composite data methods\n     *\n     */\n    /**\n     * Initialize ControlManagerGs1\n     * @returns true when ControlManagerGs1 has usable\n     */\n    async _initControlManagerGs1(site) {\n        this._resetCompositeDataControl();\n        return await this.createAndInitServiceGs1(site, mobile_purchase_receipt_1.mobileApplicationGs1Key, {\n            [parsed_element_1.DataTitle.serial]: {\n                mainField: this.serialNumber,\n                onChangeMainField: this._onChange_serialNumber,\n            },\n            [parsed_element_1.DataTitle.batchLot]: {\n                mainField: this.lot,\n                onChangeMainField: this._onChange_lot,\n            },\n            [parsed_element_1.DataTitle.expiryDate]: {\n                mainField: this.expirationDate,\n                onChangeMainField: this._onChange_expirationDate,\n            },\n        }, undefined, this._checkCompositeDataAllowed);\n    }\n    /**\n     * Reinitialize all control data block\n     */\n    /** @internal */\n    _resetCompositeDataControl() {\n        this._batchLot = null;\n        this._expiryDate = null;\n    }\n    _getNextField(field) {\n        let _nextField = field.getNextField(true);\n        if (typesLib.strictNe(this.productNode.expirationManagementMode, 'manualEntry')) {\n            while (typesLib.strictEq(_nextField, this.expirationDate) || typesLib.strictEq(_nextField, this.useByDate)) {\n                _nextField = _nextField.getNextField(true);\n            }\n        }\n        return _nextField;\n    }\n    async _getLotValues() {\n        if (this.lot.value && (this.sublot.isHidden || this.sublot.value)) {\n            try {\n                const result = (0, xtrem_client_1.extractEdges)(await this.$.graph\n                    .node('@sage/x3-stock-data/Lot')\n                    .query(ui.queryUtils.edgesSelector({\n                    code: true,\n                    product: {\n                        code: true,\n                    },\n                    sublot: true,\n                    supplierLot: true,\n                    expirationDate: true,\n                    lotCustomField1: true,\n                    lotCustomField2: true,\n                    lotCustomField3: true,\n                    lotCustomField4: true,\n                    majorVersion: {\n                        code: true,\n                    },\n                    minorVersion: true,\n                    potency: true,\n                    useByDate: true,\n                }, {\n                    filter: {\n                        product: this.product.value,\n                        code: this.lot.value,\n                        sublot: typesLib.strictEq(this.sublot.value, null) ? '' : this.sublot.value,\n                    },\n                }))\n                    .execute());\n                if (typesLib.strictNe(result.length, 0)) {\n                    await this._setLotValues(result);\n                    // this.$.commitValueAndPropertyChanges();\n                }\n                else {\n                    await this._initLotValues();\n                }\n            }\n            catch (e) {\n                await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), typesLib.add(ui.localize('@sage/x3-purchasing/dialog-error-set-expdate', 'Error while reading the lot information'), String(e)));\n                return;\n            }\n        }\n        else {\n            await this._initLotValues();\n        }\n    }\n    async _setLotValues(lotValues) {\n        if (this.isExpirationManaged) {\n            this.expirationDate.value = lotValues[0].expirationDate;\n        }\n        this.useByDate.value = lotValues[0].useByDate;\n        this.supplierLot.value = lotValues[0].supplierLot;\n        this.lotCustomField1.value = lotValues[0].lotCustomField1;\n        this.lotCustomField2.value = lotValues[0].lotCustomField2;\n        this.lotCustomField3.value = Number(lotValues[0].lotCustomField3);\n        this.lotCustomField4.value = lotValues[0].lotCustomField4;\n        this.majorVersion.value = null;\n        this.minorVersion.value = null;\n        this.$.commitValueAndPropertyChanges();\n        this.majorVersion.value = { code: lotValues[0].majorVersion ? lotValues[0].majorVersion.code : undefined };\n        this.minorVersion.value = {\n            minorVersion: lotValues[0].minorVersion,\n        };\n        this.potency.value = Number(lotValues[0].potency);\n        this.supplierLot.isDisabled = true;\n        this.lotCustomField1.isDisabled = true;\n        this.lotCustomField2.isDisabled = true;\n        this.lotCustomField3.isDisabled = true;\n        this.lotCustomField4.isDisabled = true;\n        this.majorVersion.isDisabled = true;\n        this.minorVersion.isDisabled = true;\n        this.potency.isDisabled = true;\n        this.expirationDate.isDisabled = true;\n        this.useByDate.isDisabled = true;\n    }\n    async _initLotValues() {\n        const expirationManagement = this.productNode.expirationManagementMode;\n        if (this.isExpirationManaged) {\n            this.expirationDate.value = this.useByDate.value = null;\n        }\n        /**\n         * When dispatching has finished, lot and expiry date must have data :\n         * in this case, our may using saved date.\n         * Otherwise, user have make some change OR composite information have missing,\n         * and all controls data must be cleared before to continue with standard value.\n         */\n        if (!this.controlManagerGs1.isDispatchInProgress) {\n            if (typesLib.strictNe(this._batchLot, null) && typesLib.strictNe(this._expiryDate, null)) {\n                this.expirationDate.value = this._expiryDate;\n            }\n            else {\n                this._resetCompositeDataControl();\n            }\n        }\n        // Initialize only expiration date when is not received before\n        if (!this.expirationDate.value) {\n            this.expirationDate.value = (0, defaultValue_1.expirationDateDefaultValue)(this.productNode.expirationManagementMode, this.productNode.expirationLeadTime, this.productNode.expirationTimeUnit, this._effectiveDate);\n        }\n        this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, this._effectiveDate, this.productNode.expirationManagementMode, Number(this.productNode.useByDateCoefficient));\n        this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n        //disable expirationDate field\n        this.expirationDate.isDisabled = false;\n        //disable useByDate field\n        this.useByDate.isDisabled = ['roundingBeginningMonth1', 'roundingMonthEnd'].includes(expirationManagement);\n        this.lotCustomField1.value = null;\n        this.lotCustomField2.value = null;\n        this.lotCustomField3.value = null;\n        this.lotCustomField4.value = null;\n        this.potency.value = Number(this.productNode.defaultPotencyInPercentage);\n        this.supplierLot.isDisabled = false;\n        this.lotCustomField1.isDisabled = false;\n        this.lotCustomField2.isDisabled = false;\n        this.lotCustomField3.isDisabled = false;\n        this.lotCustomField4.isDisabled = false;\n        this.majorVersion.isDisabled = false;\n        this.minorVersion.isDisabled = !this.majorVersion.value;\n        this.potency.isDisabled = false;\n    }\n    async _resetValues() {\n        // Reinitialize all control composite data before to continue\n        this._resetCompositeDataControl();\n        if (!this.purchaseSession?.purchaseStockManagementRules) {\n            return;\n        }\n        //location and suggested location\n        this.location.value = null;\n        if (this.productSite && !this.suggestedLocation.isHidden) {\n            const suggestedLocation = await (0, stock_management_rules_1.findDefaultLocation)(this.productSite, this.purchaseSession.purchaseStockManagementRules, this);\n            if (!suggestedLocation)\n                this.suggestedLocation.isHidden = true;\n            else {\n                this.suggestedLocation.value = suggestedLocation;\n                if (this.isLocationPreloaded && this.site.value) {\n                    this.location.value = await (0, stock_management_rules_1.getLocationPreloaded)(this.site.value, suggestedLocation, this);\n                }\n            }\n        }\n        //lot and sublot\n        const lotManagementRule = this.purchaseSession.purchaseStockManagementRules.lotEntry;\n        const lotByDefault = this.purchaseSession.purchaseStockManagementRules.lotByDefault;\n        this.lot.value = null;\n        if (!this.lot.isHidden) {\n            if (typesLib.strictEq(lotManagementRule, 'no')) {\n                if (typesLib.strictEq(this.sublot.isHidden, false)) {\n                    this.sublot.value = '00001';\n                }\n            }\n            else if (typesLib.strictEq(lotManagementRule, 'newLot')) {\n                if (typesLib.strictEq(this.sublot.isHidden, false))\n                    this.sublot.value = '00001';\n            }\n            else if (typesLib.strictEq(lotManagementRule, 'free') && typesLib.strictEq(lotByDefault, 'documentNumber')) {\n                if (typesLib.strictEq(this.sublot.isHidden, false))\n                    this.sublot.value = '00001';\n            }\n            else {\n                if (typesLib.strictEq(this.sublot.isHidden, false))\n                    this.sublot.value = null;\n            }\n        }\n        //expiration date and use by date\n        const expirationManagement = this.productNode.expirationManagementMode;\n        const effectiveDate = xtrem_date_time_1.DateValue.today().toString();\n        if (!this.expirationDate.isHidden && typesLib.strictNe(expirationManagement, 'manualEntry')) {\n            this.expirationDate.value = (0, defaultValue_1.expirationDateDefaultValue)(this.productNode.expirationManagementMode, this.productNode.expirationLeadTime, this.productNode.expirationTimeUnit, effectiveDate);\n            this.useByDate.value = (0, defaultValue_1.useByDateDefaultValue)(this.expirationDate.value, effectiveDate, this.productNode.expirationManagementMode, Number(this.productNode.useByDateCoefficient));\n            this.useByDate.maxDate = this.expirationDate.value ?? undefined;\n        }\n        else {\n            this.expirationDate.value = null;\n            this.useByDate.value = null;\n        }\n        this.supplierLot.value = null;\n        this.lotCustomField1.value = null;\n        this.lotCustomField2.value = null;\n        this.lotCustomField3.value = null;\n        this.lotCustomField4.value = null;\n        this.majorVersion.value = null;\n        this.minorVersion.value = null;\n        this.status.value = this.purchaseSession.purchaseStockManagementRules.defaultStatus;\n        if (!this.potency.isHidden) {\n            this.potency.value = Number(this.productNode.defaultPotencyInPercentage);\n        }\n        this.identifier1.value = null;\n        this.identifier2.value = null;\n        //if (!this.container.isHidden) this.container.value = this.productSite.defaultInternalContainer;\n    }\n    // (X3-226769) TODO: Issue: Need better more dynamic way to know which next field to focus, rather than hard-coding every possible scenario\n    async _focusToNextField(field) {\n        switch (field?.id) {\n            default:\n                if (!this.quantityToReceive.isHidden &&\n                    !this.quantityToReceive.isDisabled &&\n                    !this.quantityToReceive.isReadOnly) {\n                    this.quantityToReceive.focus();\n                    break;\n                }\n            case this.receiptUnit.id:\n                if (!this.quantityToReceive.isHidden &&\n                    !this.quantityToReceive.isDisabled &&\n                    !this.quantityToReceive.isReadOnly) {\n                    this.quantityToReceive.focus();\n                    break;\n                }\n            case this.quantityToReceive.id:\n                if (!this.status.isHidden && !this.status.isDisabled && !this.status.isReadOnly) {\n                    this.status.focus();\n                    break;\n                }\n            case this.status.id:\n                if (!this.container.isHidden && !this.container.isDisabled && !this.container.isReadOnly) {\n                    this.container.focus();\n                    break;\n                }\n            case this.container.id:\n                if (!this.licensePlateNumber.isHidden &&\n                    !this.licensePlateNumber.isDisabled &&\n                    !this.licensePlateNumber.isReadOnly) {\n                    this.licensePlateNumber.focus();\n                    break;\n                }\n            case this.licensePlateNumber.id:\n                if (!this.location.isHidden && !this.location.isDisabled && !this.location.isReadOnly) {\n                    this.location.focus();\n                    break;\n                }\n            case this.location.id:\n                if (!this.serialNumber.isHidden && !this.serialNumber.isDisabled && !this.serialNumber.isReadOnly) {\n                    this.serialNumber.focus();\n                    break;\n                }\n            case this.serialNumber.id:\n                if (!this.supplierLot.isHidden && !this.supplierLot.isDisabled && !this.supplierLot.isReadOnly) {\n                    this.supplierLot.focus();\n                    break;\n                }\n            case this.supplierLot.id:\n                if (!this.lot.isHidden && !this.lot.isDisabled && !this.lot.isReadOnly) {\n                    this.lot.focus();\n                    break;\n                }\n            case this.lot.id:\n                if (!this.sublot.isHidden && !this.sublot.isDisabled && !this.sublot.isReadOnly) {\n                    this.sublot.focus();\n                    break;\n                }\n            case this.sublot.id:\n                if (!this.majorVersion.isHidden && !this.majorVersion.isDisabled && !this.majorVersion.isReadOnly) {\n                    this.majorVersion.focus();\n                    break;\n                }\n            case this.majorVersion.id:\n                if (!this.minorVersion.isHidden && !this.minorVersion.isDisabled && !this.minorVersion.isReadOnly) {\n                    this.minorVersion.focus();\n                    break;\n                }\n            case this.minorVersion.id:\n                if (!this.potency.isHidden && !this.potency.isDisabled && !this.potency.isReadOnly) {\n                    this.potency.focus();\n                    break;\n                }\n            case this.potency.id:\n                if (!this.expirationDate.isHidden &&\n                    !this.expirationDate.isDisabled &&\n                    !this.expirationDate.isReadOnly) {\n                    this.expirationDate.focus();\n                    break;\n                }\n            case this.expirationDate.id:\n                if (!this.useByDate.isHidden && !this.useByDate.isDisabled && !this.useByDate.isReadOnly) {\n                    this.useByDate.focus();\n                    break;\n                }\n            case this.useByDate.id:\n                if (!this.calculatedExpirationDate.isHidden &&\n                    !this.calculatedExpirationDate.isDisabled &&\n                    !this.calculatedExpirationDate.isReadOnly) {\n                    this.calculatedExpirationDate.focus();\n                    break;\n                }\n            case this.calculatedExpirationDate.id:\n                if (!this.lotCustomField1.isHidden &&\n                    !this.lotCustomField1.isDisabled &&\n                    !this.lotCustomField1.isReadOnly) {\n                    this.lotCustomField1.focus();\n                    break;\n                }\n            case this.lotCustomField1.id:\n                if (!this.lotCustomField2.isHidden &&\n                    !this.lotCustomField2.isDisabled &&\n                    !this.lotCustomField2.isReadOnly) {\n                    this.lotCustomField2.focus();\n                    break;\n                }\n            case this.lotCustomField2.id:\n                if (!this.lotCustomField3.isHidden &&\n                    !this.lotCustomField3.isDisabled &&\n                    !this.lotCustomField3.isReadOnly) {\n                    this.lotCustomField3.focus();\n                    break;\n                }\n            case this.lotCustomField3.id:\n                if (!this.lotCustomField4.isHidden &&\n                    !this.lotCustomField4.isDisabled &&\n                    !this.lotCustomField4.isReadOnly) {\n                    this.lotCustomField4.focus();\n                    break;\n                }\n            case this.lotCustomField4.id:\n                if (!this.identifier1.isHidden && !this.identifier1.isDisabled && !this.identifier1.isReadOnly) {\n                    this.identifier1.focus();\n                    break;\n                }\n            case this.identifier1.id:\n                if (!this.identifier2.isHidden && !this.identifier2.isDisabled && !this.identifier2.isReadOnly) {\n                    this.identifier2.focus();\n                    break;\n                }\n            case this.identifier2.id:\n                if (!this.closePoLine.isHidden && !this.closePoLine.isDisabled && !this.closePoLine.isReadOnly) {\n                    this.closePoLine.focus();\n                    break;\n                }\n            case this.closePoLine.id: // do nothing, cannot focus on a button in xtreem\n        }\n    }\n    // (X3-201046, X3-203885) TODO: Obsolete: Hard-coded way to create a comprehensive validation error message for this page\n    async _validate() {\n        const fieldErrors = new Array();\n        if (await this._isFieldInvalid(this.receiptUnit))\n            fieldErrors.push(this.receiptUnit.title ?? '');\n        if (await this._isFieldInvalid(this.quantityToReceive))\n            fieldErrors.push(this.quantityToReceive.title ?? '');\n        if (await this._isFieldInvalid(this.status))\n            fieldErrors.push(this.status.title ?? '');\n        if (await this._isFieldInvalid(this.licensePlateNumber))\n            fieldErrors.push(this.licensePlateNumber.title ?? '');\n        if (await this._isFieldInvalid(this.location))\n            fieldErrors.push(this.location.title ?? '');\n        if (await this._isFieldInvalid(this.serialNumber))\n            fieldErrors.push(this.serialNumber.title ?? '');\n        if (await this._isFieldInvalid(this.supplierLot))\n            fieldErrors.push(this.supplierLot.title ?? '');\n        if (await this._isFieldInvalid(this.lot))\n            fieldErrors.push(this.lot.title ?? '');\n        if (await this._isFieldInvalid(this.sublot))\n            fieldErrors.push(this.sublot.title ?? '');\n        if (await this._isFieldInvalid(this.majorVersion))\n            fieldErrors.push(this.majorVersion.title ?? '');\n        if (await this._isFieldInvalid(this.minorVersion))\n            fieldErrors.push(this.minorVersion.title ?? '');\n        if (await this._isFieldInvalid(this.potency))\n            fieldErrors.push(this.potency.title ?? '');\n        if (await this._isFieldInvalid(this.expirationDate))\n            fieldErrors.push(this.expirationDate.title ?? '');\n        if (await this._isFieldInvalid(this.useByDate))\n            fieldErrors.push(this.useByDate.title ?? '');\n        if (await this._isFieldInvalid(this.calculatedExpirationDate))\n            fieldErrors.push(this.calculatedExpirationDate.title ?? '');\n        if (await this._isFieldInvalid(this.lotCustomField1))\n            fieldErrors.push(this.lotCustomField1.title ?? '');\n        if (await this._isFieldInvalid(this.lotCustomField2))\n            fieldErrors.push(this.lotCustomField2.title ?? '');\n        if (await this._isFieldInvalid(this.lotCustomField3))\n            fieldErrors.push(this.lotCustomField3.title ?? '');\n        if (await this._isFieldInvalid(this.lotCustomField4))\n            fieldErrors.push(this.lotCustomField4.title ?? '');\n        if (await this._isFieldInvalid(this.identifier1))\n            fieldErrors.push(this.identifier1.title ?? '');\n        if (await this._isFieldInvalid(this.identifier2))\n            fieldErrors.push(this.identifier2.title ?? '');\n        if (await this._isFieldInvalid(this.closePoLine))\n            fieldErrors.push(this.closePoLine.title ?? '');\n        if (await this._isFieldInvalid(this.container))\n            fieldErrors.push(this.container.title ?? '');\n        if (typesLib.gt(fieldErrors.length, 0)) {\n            this.$.removeToasts();\n            this.$.showToast(ui.localize('@sage/x3-purchasing/pages__utils__notification__invalid_entry_error', `Please check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fieldErrors }), { type: 'error', timeout: 5000 });\n            await this.$.page.validate(); // (X3-201046, X3-203885) TODO: Obsolete: To trigger highlighting problematic fields with red borders\n        }\n        return typesLib.strictEq(fieldErrors.length, 0);\n    }\n    // (X3-201046, X3-203885) TODO: Obsolete: Hard-coded way to create a comprehensive validation error message for this page\n    async _isFieldInvalid(field) {\n        return !field.isHidden && ((field.isMandatory && !field.value) || !!(await field.validate()));\n    }\n    async _getMinorVersions(majorVersion) {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-master-data/ProductVersion')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            minorVersion: true,\n        }, {\n            filter: {\n                product: this.product.value,\n                majorVersion: majorVersion,\n                type: { _eq: 'stock' },\n                useStatus: { _eq: 'availableToUse' },\n            },\n            orderBy: {\n                minorVersion: 1,\n            },\n        }))\n            .execute());\n    }\n    _initDirty() {\n        // Ignore empty new row / current row\n        if (typesLib.gt((this.purchaseSession?.purchaseReceipt.lines ?? []).length, 1)) {\n            this.product.isDirty = true;\n        }\n    }\n    async _isEmptyLpnAndContainerValues() {\n        if (!this.container.isHidden &&\n            !this.licensePlateNumber.isHidden &&\n            (!this.container.value || typesLib.strictEq(this.container.value?.code, '')) &&\n            (!this.licensePlateNumber.value || typesLib.strictEq(this.licensePlateNumber.value?.code, ''))) {\n            await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/pages__adc_purchase_receipt_enter_detail_container_license_plate_number_mandatory_error', 'Container or license plate number is mandatory'));\n            return true;\n        }\n        else {\n            return false;\n        }\n    }\n};\nexports.MobilePurchaseReceiptEnterReceiptDetail = MobilePurchaseReceiptEnterReceiptDetail;\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerTitleLeft\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerTitleRight\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerLine2Left\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerLine2Right\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerLine3Left\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"headerLine3Right\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__product____title\", \"Product\"),\n        isReadOnly: true,\n        size: 'large',\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__description____title\", \"Description\"),\n        isReadOnly: true,\n        size: 'small',\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"description\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__site____title\", \"Site\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__supplier____title\", \"Supplier\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"supplier\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__addDetails____title\", \"Add quantity\"),\n        buttonType: 'secondary',\n        shortcut: ['f7'],\n        async onClick() {\n            if (await this._isEmptyLpnAndContainerValues()) {\n                return;\n            }\n            if (await this._validate()) {\n                const haveLicensePlateNumber = !!this.licensePlateNumber.value?.code;\n                this._purchaseReceiptRecordManager.loadStockDetails(this, this.productNode);\n                this.closePoLine.value = closePoLineOptions[0]; //Yes\n                const containerValue = this.container.value ?? undefined;\n                if (!this.container.isHidden) {\n                    if (containerValue) {\n                        this.container.value = containerValue;\n                        this.container.isDisabled = true;\n                        if (!haveLicensePlateNumber) {\n                            this.licensePlateNumber.isDisabled = true;\n                            this.licensePlateNumber.value = null;\n                        }\n                    }\n                    else if (this.licensePlateNumber.value) {\n                        this.container.isDisabled = true;\n                    }\n                    else {\n                        if (this.productSite?.defaultInternalContainer) {\n                            this.container.value = this.productSite?.defaultInternalContainer;\n                        }\n                        else {\n                            this.container.value = null;\n                        }\n                        this.container.isDisabled = true;\n                    }\n                }\n                this.isAddQuantity = true;\n                this.previousPackingUnitToStockUnitConversionFactor =\n                    this.packingUnitToStockUnitConversionFactor.value ?? 0;\n                this.$.showToast(ui.localize('@sage/x3-purchasing/dialog-notification-purchase-receipt-details-quantity-added', 'Quantity added'), { type: 'success', timeout: 3000 });\n                this.$.setPageClean();\n                this._resetValues();\n                this._initDirty();\n                await this._focusToNextField(this.receiptUnit);\n            }\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"addDetails\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__addProduct____title\", \"Next\"),\n        buttonType: 'primary',\n        shortcut: ['f3'],\n        async onClick() {\n            if (await this._isEmptyLpnAndContainerValues()) {\n                return;\n            }\n            this.addProduct.isDisabled = true;\n            if (typesLib.strictEq(this.remainingQuantityInStockUnit.value, 0) && typesLib.strictEq(this.quantityToReceive.value, 0)) {\n                this._purchaseReceiptRecordManager.createLine(this, this.productNode);\n                this.$.setPageClean();\n                this.addProduct.isDisabled = false;\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceipt');\n            }\n            else if (await this._validate()) {\n                this._purchaseReceiptRecordManager.loadStockDetails(this, this.productNode);\n                this._purchaseReceiptRecordManager.createLine(this, this.productNode);\n                this.$.setPageClean();\n                this.addProduct.isDisabled = false;\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceipt');\n            }\n            else {\n                this.addProduct.isDisabled = false;\n            }\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"addProduct\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.sectionHeader;\n        },\n        isTitleHidden: false,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"blockProduct\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.sectionHeader;\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"blockClosePoLine\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__receiptUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__receiptUnit____placeholder\", \"Enter...\"),\n        options: ['UN'],\n        isMandatory: true,\n        // (X3-198508) TODO: Issue: Does not get triggered when value is changed to 1st option via manual typing\n        onChange() {\n            let packingUnitIndex;\n            if (\n            // To handle scenario of user manually inputting a non-existent value or clearing out value\n            !this.receiptUnit.value || typesLib.strictEq((packingUnitIndex = getPackingUnitFromName(this.receiptUnit.value, this.receiptUnits)), -1)) {\n                // revert back to previous value that is saved in a hidden label\n                this.receiptUnit.value = this.previousReceiptUnit.value;\n                return;\n            }\n            const selectedUnit = this.receiptUnits[packingUnitIndex].node;\n            const previousUnit = this.receiptUnits[getPackingUnitFromName(this.previousReceiptUnit.value ?? '', this.receiptUnits)].node;\n            //if purchase order: calcul the conversion factor with the purchase order quantities\n            if (this.purchaseOrderNumber && this.purchaseOrderLineNumber) {\n                if (this.remainingQuantityInitialInStockUnit) {\n                    // calcul packUnitTostockUnittoStockUnitConveriosnFactor : QTYSTU/QTYUOM\n                    if (this.remainingQuantityInitialInOrderUnit) {\n                        this.packingUnitToStockUnitConversionFactor.value = typesLib.div(this.remainingQuantityInitialInStockUnit, this.remainingQuantityInitialInOrderUnit);\n                        if (typesLib.strictEq(selectedUnit.packingUnit.code, this.orderUnit.code))\n                            selectedUnit.packingUnitToStockUnitConversionFactor =\n                                this.packingUnitToStockUnitConversionFactor.value.toString();\n                        if (typesLib.strictEq(previousUnit.packingUnit.code, this.orderUnit.code))\n                            previousUnit.packingUnitToStockUnitConversionFactor =\n                                this.packingUnitToStockUnitConversionFactor.value.toString();\n                    }\n                }\n            }\n            let selectedUnitConversionFactor;\n            if (typesLib.strictNe(Number(selectedUnit.packingUnitToStockUnitConversionFactor), 0)) {\n                selectedUnitConversionFactor = (typesLib.div(Number(previousUnit.packingUnitToStockUnitConversionFactor), Number(selectedUnit.packingUnitToStockUnitConversionFactor))).toString();\n            }\n            else {\n                selectedUnitConversionFactor = Number(previousUnit.packingUnitToStockUnitConversionFactor).toString();\n            }\n            const tmp = typesLib.pow(10, selectedUnit?.packingUnit.numberOfDecimals);\n            if (this.quantityToReceive.value) {\n                this.quantityToReceiveNoRounded = typesLib.mul(this.quantityToReceiveNoRounded, Number(selectedUnitConversionFactor));\n                if (typesLib.strictNe(tmp, 0)) {\n                    this.quantityToReceiveRounded = typesLib.div(typesLib.round(typesLib.mul(this.quantityToReceiveNoRounded, tmp)), tmp);\n                }\n                this.quantityToReceive.value = this.quantityToReceiveRounded;\n            }\n            if (this.purchaseOrderNumber && this.purchaseOrderLineNumber) {\n                if (this.remainingQuantityInitialInStockUnit && typesLib.strictNe(this.packingUnitToStockUnitConversionFactor.value, 0))\n                    this.remainingQuantityNoRoundedInPackingUnit = Number(typesLib.div(this.remainingQuantityInitialInStockUnit, Number(this.packingUnitToStockUnitConversionFactor.value)));\n                if (typesLib.strictNe(tmp, 0)) {\n                    this.remainingQuantityRoundedInPackingUnit = typesLib.div(typesLib.round(typesLib.mul(this.remainingQuantityNoRoundedInPackingUnit, tmp)), tmp);\n                }\n                else {\n                    this.remainingQuantityNoRoundedInPackingUnit = typesLib.mul(this.remainingQuantityNoRoundedInPackingUnit, Number(this.packingUnitToStockUnitConversionFactor.value));\n                    if (typesLib.strictNe(tmp, 0)) {\n                        this.remainingQuantityRoundedInPackingUnit = typesLib.div(typesLib.round(typesLib.mul(this.quantityToReceiveNoRounded, tmp)), tmp);\n                    }\n                }\n                this.remainingQuantityInPackingUnit.value = this.remainingQuantityRoundedInPackingUnit;\n            }\n            this.quantityToReceive.focus(); // this moves cursor to quantityToReceive and auto-round & update # of decimal places allowed in its current value\n            this.previousReceiptUnit.value = this.receiptUnit.value;\n            this.receiptUnitCode.value = selectedUnit.packingUnit.code;\n            this.packingUnitToStockUnitConversionFactor.value = Number(selectedUnit.packingUnitToStockUnitConversionFactor);\n            this.packingUnitToStockUnitConversionFactor.isDisabled = !selectedUnit.isPackingFactorEntryAllowed; // TODO: Obsolete isPackingFactorEntryAllowed because packingUnitToStockUnitConversionFactor is now a hidden field\n            this.isPackingUnit = selectedUnit.isPackingUnit;\n            this.quantityToReceive.scale = selectedUnit.packingUnit.numberOfDecimals;\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"receiptUnit\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isHidden: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"receiptUnitCode\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isHidden: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"previousReceiptUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__quantityToReceive____title\", \"Quantity\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__quantityToReceive____placeholder\", \"Enter...\"),\n        isMandatory: true,\n        validation(value) {\n            const regex = /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/; // reg ex for any positive numbers (integers or decimals) excluding 0\n            if (typesLib.strictEq((value.toString().match(regex)?.length ?? 0), 0)) {\n                return ui.localize('@sage/x3-purchasing/validate-error-invalid-value', 'invalid value');\n            }\n            if (this.purchaseOrderNumber &&\n                this.purchaseOrderLineNumber && typesLib.gt((typesLib.mul((this.quantityToReceive.value ?? 0), (this.packingUnitToStockUnitConversionFactor.value ?? 0)) ?? 0), (this.remainingQuantityInStockUnit.value ?? 0)) &&\n                !this._isOverReceiptAllowed) {\n                return ui.localize('@sage/x3-purchasing/validation-error-purchase-receipt-details-quantity-received-is-greater-than-the-ordered-quantity', 'The quantity received is greater than the ordered quantity.');\n            }\n            return undefined;\n        },\n        min: 0,\n        async onChange() {\n            if (this.purchaseOrderNumber && this.purchaseOrderLineNumber) {\n                const tmp = typesLib.pow(10, this.quantityToReceive.scale ?? 1);\n                if (typesLib.gt(typesLib.round(typesLib.div((typesLib.mul((typesLib.mul((this.quantityToReceive.value ?? 0), (this.packingUnitToStockUnitConversionFactor.value ?? 0)) ?? 0), tmp)), tmp)), (this.remainingQuantityInStockUnit.value ?? 0))) {\n                    if (!this._isOverReceiptAllowed) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/dialog-error-purchase-receipt-details-quantity-received-is-greater-than-the-ordered-quantity', `The quantity received is greater than the ordered quantity.`), {\n                            fullScreen: false,\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-purchasing/button-accept-ok', 'OK'),\n                            },\n                        });\n                        this.quantityToReceive.focus();\n                        return;\n                    }\n                    else {\n                        if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing/dialog-warn-purchase-receipt-details-quantity-message', 'Quantity larger than expected. Validate ?'), {\n                            fullScreen: false,\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-purchasing/button-accept-yes', 'Yes'),\n                            },\n                            cancelButton: {\n                                text: ui.localize('@sage/x3-purchasing/button-cancel-no', 'No'),\n                            },\n                        }))) {\n                            this.quantityToReceive.value = 0;\n                            await this.$.commitValueAndPropertyChanges();\n                            this.quantityToReceive.focus();\n                        }\n                    }\n                }\n                if (typesLib.strictEq((typesLib.mul((this.quantityToReceive.value ?? 0), (this.packingUnitToStockUnitConversionFactor.value ?? 0)) ??\n                    0), this.remainingQuantityInStockUnit.value)) {\n                    this.closePoLine.value = closePoLineOptions[0]; //Yes\n                }\n                else if (typesLib.lt((typesLib.mul((this.quantityToReceive.value ?? 0), (this.packingUnitToStockUnitConversionFactor.value ?? 0)) ??\n                    0), (this.remainingQuantityInStockUnit.value ?? 0))) {\n                    this.closePoLine.value = closePoLineOptions[1]; //No\n                }\n            }\n            if (!this.quantityToReceive.value) {\n                this.quantityToReceive.value = 0;\n            }\n            if (typesLib.strictNe(this.quantityToReceive.value, this.quantityToReceiveRounded)) {\n                this.quantityToReceiveNoRounded = this.quantityToReceive.value;\n            }\n            this.quantityToReceiveRounded = this.quantityToReceive.value;\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"quantityToReceive\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        // parent() {\n        //     return this.blockQuantity;\n        // },\n        // title: 'Remaining quantity',\n        // placeholder: 'Qty',\n        isReadOnly: true,\n        isHidden: true, // (X3-184844) TODO: Temporarily hidden until further discussion\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"remainingQuantityInPackingUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        // parent() {\n        //     return this.blockQuantity;\n        // },\n        // title: 'Remaining quantity',\n        // placeholder: 'Qty',\n        isReadOnly: true,\n        isHidden: true, // (X3-184844) TODO: Temporarily hidden until further discussion\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"remainingQuantityInStockUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        isDisabled: true,\n        isHidden: false,\n        scale: 6,\n        onChange() {\n            if (this.isAddQuantity && typesLib.strictNe(this.packingUnitToStockUnitConversionFactor.value, this.previousPackingUnitToStockUnitConversionFactor)) {\n                this.packingUnitToStockUnitConversionFactor.value = this.previousPackingUnitToStockUnitConversionFactor;\n                this.packingUnitToStockUnitConversionFactor.focus();\n                this.$.showToast(`${ui.localize('@sage/x3-purchasing/notification-The-conversion-factor-can-t-be-different-as-the-one-entered-previously-on-the-same-stock-line', \"The conversion factor can't be different as the one entered previously on the same stock line.\")}`, { type: 'error', timeout: 5000 });\n                this.packingUnitToStockUnitConversionFactor.value = this.previousPackingUnitToStockUnitConversionFactor;\n                this.packingUnitToStockUnitConversionFactor.focus();\n            }\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__status____placeholder\", \"Scan or select...\"),\n        isMandatory: true,\n        onChange() {\n            this.status.getNextField(true)?.focus();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__container____title\", \"Container\"),\n        node: '@sage/x3-master-data/Container',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__container____placeholder\", \"Scan or select...\"),\n        width: 'large',\n        isTransient: true,\n        canFilter: false,\n        filter() {\n            return {\n                isInternal: { _eq: true },\n                isActive: { _eq: true },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__container____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'containerType',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__container____columns__title__containerType\", \"Type\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'description',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__container____columns__title__description\", \"Description\"),\n            }),\n        ],\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"container\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____title\", \"License plate number\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isFullWidth: true,\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            // TODO: Issue: Depending on the selected site, it can be LPN managed but contains no LPN results to select from (for ex. FR022)\n            let licensePlateNumberFilter = {\n                stockSite: { code: this.site.value ?? undefined },\n                isActive: { _eq: true },\n                _or: [\n                    {\n                        isSingleProduct: { _eq: true },\n                        stock: { _atLeast: 1, product: { product: { code: this.product.value ?? undefined } } },\n                    },\n                    { isSingleProduct: { _eq: true }, stock: { _none: true } },\n                    { isSingleProduct: { _eq: false } },\n                ],\n            };\n            // TODO: LPN must also be associated with container (not available yet) if populated\n            if (this.location.value?.code) {\n                licensePlateNumberFilter._or = [\n                    {\n                        location: { code: this.location.value.code },\n                    },\n                    {\n                        // to also include entries without location that have 'free' status\n                        _and: [{ location: { code: undefined } }, { status: 'free' }],\n                    },\n                ];\n            }\n            if (this.container.value) {\n                licensePlateNumberFilter = {\n                    ...licensePlateNumberFilter,\n                    container: { code: this.container.value?.code },\n                };\n            }\n            return licensePlateNumberFilter;\n        },\n        async onChange() {\n            if (!this.licensePlateNumber.value) {\n                this.location.isDisabled = false;\n                this.location.value = null;\n                this.container.isDisabled = this.isAddQuantity;\n                await this.$.commitValueAndPropertyChanges(); // without this, when you clear out LPN and then, without tabbing out, click Location's lookup button directly, nothing will happen\n                return;\n            }\n            // LPN can be associated with or without a location\n            // if location is NOT popualted manually by the user\n            if (!!this.licensePlateNumber.value.location?.code) {\n                this.location.isDisabled = true;\n                this.location.value = this.licensePlateNumber.value.location;\n                if (this.licensePlateNumber.value.container) {\n                    this.container.value = this.licensePlateNumber.value.container;\n                    this.container.isDisabled = true;\n                }\n                else {\n                    this.container.isDisabled = false;\n                }\n            }\n            else {\n                if (this.location.isDisabled) {\n                    this.location.value = null;\n                    this.location.isDisabled = false;\n                }\n                this.container.isDisabled = this.isAddQuantity;\n            }\n            await this.$.commitValueAndPropertyChanges();\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        isTransient: true,\n        isMandatory: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____columns__title__code\", \"License Plate Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____columns__title__location__code\", \"Location\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____columns__title__container__code\", \"Container\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__licensePlateNumber____columns__title__status\", \"Status\"),\n                map(value, rowData) {\n                    switch (value) {\n                        case 'free':\n                            return 'Free';\n                        case 'inStock':\n                            return 'In Stock';\n                        default:\n                            return '';\n                    }\n                },\n                borderColor: ui.tokens.colorsYang100,\n                optionType: '@sage/x3-stock-data/ContainerStatus',\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__suggestedLocation____title\", \"Suggested Location\"),\n        //node: '@sage/xtrem-x3-stock/Location',\n        //valueField: 'code',\n        isReadOnly: true,\n        width: 'large',\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"suggestedLocation\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__location____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__location____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.site.value ?? undefined },\n            };\n        },\n        onChange() {\n            if (this.location.value)\n                this.location.getNextField(true)?.focus();\n            this.warehouse.value = !this.location.value?.warehouse ? '' : this.location.value.warehouse.code;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Warehouse',\n                bind: 'warehouse',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n        minLookupCharacters: 1,\n        isFullWidth: true,\n        isMandatory: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"warehouse\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__serialNumber____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isMandatory: false,\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.serialNumber, rawData);\n        },\n        async onChange() {\n            await this._onChange_serialNumber();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__supplierLot____title\", \"Supplier lot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__supplierLot____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isMandatory: false,\n        async onChange() {\n            const supplierLot = this.supplierLot.value?.replace(/\\s/g, '')?.toUpperCase() ?? '';\n            if (typesLib.strictNe(supplierLot, this.supplierLot.value)) {\n                this.supplierLot.value = supplierLot;\n                await this.$.commitValueAndPropertyChanges();\n            }\n            if (this.supplierLot.value && this.purchaseSession?.purchaseStockManagementRules) {\n                if (typesLib.strictEq(this.purchaseSession.purchaseStockManagementRules.lotByDefault, 'supplierLot')) {\n                    if (typesLib.strictEq(this.purchaseSession.purchaseStockManagementRules.lotEntry, 'newLot')) {\n                        if (typesLib.strictEq((await (0, purchase_receipt_details_control_1.controlLotReceipt)(this, this.supplierLot.value, this.productNode.code, '6', this.site.value ?? '')), false)) {\n                            this.supplierLot.value = null;\n                            this.supplierLot.focus();\n                        }\n                    }\n                    /**\n                     *  Only when previous lot value has not same and has editable :\n                     * - Assign new lot value.\n                     * - If composite control block become invalid, reset it.\n                     * - Commit page change.\n                     * - If lot has editable, perform explicit lot change event (no _getLotValues) and stay in this field\n                     * - Overwise next focus to next field focusable\n                     */\n                    if (this.supplierLot.value && typesLib.ne(this.supplierLot.value, this.lot.value)) {\n                        this.lot.value = this.supplierLot.value;\n                        if (this._batchLot && typesLib.strictNe(this.lot.value, this._batchLot)) {\n                            // this._resetCompositeDataControl();\n                        }\n                        await this.$.commitValueAndPropertyChanges();\n                        if (!this.lot.isHidden && !this.lot.isDisabled && !this.lot.isReadOnly) {\n                            // await this._getLotValues();\n                            await this._onChange_lot();\n                            this.lot.focus();\n                        }\n                        else {\n                            this.lot.getNextField(true)?.focus();\n                        }\n                    }\n                    else {\n                        await this.$.commitValueAndPropertyChanges();\n                    }\n                }\n            }\n        },\n        // node: '@sage/x3-stockData/Stock',\n        // valueField: 'supplierLot',\n        // filter() {\n        //     return {\n        //         stockSite: { $eq: this.site.value },\n        //         product: { $eq: this.product.value },\n        //         //supplierLot: { $ne: null },\n        //     };\n        // },\n        // isTransient: true,\n        // isMandatory: false,\n        // columns: [\n        //     ui.nestedFields.text({\n        //         bind: 'supplierLot',\n        //         title: 'Supplier lot',\n        //         isReadOnly: true,\n        //     }),\n        // ],\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"supplierLot\", void 0);\n__decorate([\n    ui.decorators.filterSelectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lot____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/LotsSites',\n        valueField: 'lot',\n        validation: /^$|^[^|]+$/,\n        isMandatory: false,\n        isTransient: true,\n        isNewEnabled: true,\n        minLookupCharacters: 1,\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value ?? undefined },\n                storageSite: { code: this.site.value ?? undefined },\n                stock: { _atLeast: 1 },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'lot',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lot____columns__title__lot\", \"Lot\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sublot',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lot____columns__title__sublot\", \"Sublot\"),\n                isReadOnly: true,\n            }),\n        ],\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.lot, rawData);\n        },\n        async onChange() {\n            await this._onChange_lot();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        isHidden: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"svgLot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__sublot____placeholder\", \"Scan...\"),\n        isMandatory: true,\n        validation: /^$|^[^|]+$/,\n        async onInputValueChange(rawData) {\n            this.expirationDate.isDisabled = true;\n            this.useByDate.isDisabled = true;\n        },\n        async onChange() {\n            this.sublot.value ? (this.sublot.value = this.sublot.value.toUpperCase()) : '';\n            await this._getLotValues();\n            this._getNextField(this.sublot)?.focus();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__majorVersion____title\", \"Major version\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__majorVersion____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/MajorVersionStatus',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            const filter = {\n                product: { code: this.product.value ?? '' },\n                // (X3-227355) TODO: Issue: Cannot use the less verbose _in operator instead of individual _or filter criterion\n                _or: [{ status: 'prototypeVersion' }, { status: 'activeVersion' }, { status: 'stoppedVersion' }],\n            };\n            // if majorAndMinor managed, filter down further for major version with available minor versions\n            if (!this.minorVersion.isHidden) {\n                filter.minorVersions = {\n                    _atLeast: 1,\n                    type: { _eq: 'stock' },\n                    useStatus: { _eq: 'availableToUse' },\n                };\n            }\n            return filter;\n        },\n        async onChange() {\n            // if not major & minor version managed\n            if (this.minorVersion.isHidden) {\n                if (this.majorVersion.value) {\n                    this.majorVersion.getNextField(true)?.focus();\n                }\n            }\n            // if major version is cleared out, clear out minor version if any as well\n            else if ((this.minorVersion.isDisabled = !this.majorVersion.value)) {\n                this.minorVersion.value = null;\n            }\n            else {\n                // Auto-populate minor version based on the last minor version available\n                const minorVersions = await this._getMinorVersions(this.majorVersion.value.code);\n                this.minorVersion.value = minorVersions[typesLib.sub(minorVersions.length, 1)];\n                this._getNextField(this.majorVersion)?.focus();\n            }\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__majorVersion____columns__title__code\", \"Major version\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__majorVersion____columns__title__status\", \"Status\"),\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Product',\n                bind: 'product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n        isMandatory: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"majorVersion\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__minorVersion____title\", \"Minor version\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__minorVersion____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-master-data/ProductVersion',\n        isAutoSelectEnabled: true,\n        valueField: 'minorVersion',\n        canFilter: false,\n        filter() {\n            return {\n                product: { code: this.product.value ?? '' },\n                majorVersion: this.majorVersion.value?.code,\n                type: 'stock',\n                useStatus: 'availableToUse',\n            };\n        },\n        onChange() {\n            if (this.minorVersion.value)\n                this._getNextField(this.minorVersion)?.focus();\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'minorVersion',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__minorVersion____columns__title__minorVersion\", \"Minor version\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.reference({\n                bind: 'product',\n                node: '@sage/x3-master-data/Product',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'majorVersion',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'useStatus',\n                isHidden: true,\n            }),\n        ],\n        isMandatory: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"minorVersion\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__potency____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__potency____title\", \"Potency %\"),\n        isMandatory: true,\n        scale: 4,\n        validation: /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/, // reg ex for any positive numbers (integers or decimals) excluding 0\n        min: 0,\n        max: 100,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"potency\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__expirationDate____title\", \"Expiration date\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__expirationDate____placeholder\", \"Enter...\"),\n        isMandatory: true,\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.expirationDate, rawData);\n        },\n        async onChange() {\n            await this._onChange_expirationDate();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__useByDate____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__useByDate____title\", \"Use-by date\"),\n        isMandatory: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"useByDate\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__calculatedExpirationDate____title\", \"Expiration date\"),\n        isDisabled: true,\n        isHidden: true,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"calculatedExpirationDate\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField1____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField1____title\", \"Lot custom field 1\"),\n        isMandatory: false,\n        validation: /^$|^[^|]+$/,\n        maxLength: 20,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"lotCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField2____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField2____title\", \"Lot custom field 2\"),\n        isMandatory: false,\n        validation: /^$|^[^|]+$/,\n        maxLength: 10,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"lotCustomField2\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField3____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField3____title\", \"Lot custom field 3\"),\n        isMandatory: false,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"lotCustomField3\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField4____placeholder\", \"Enter...\"),\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__lotCustomField4____title\", \"Lot custom field 4\"),\n        isMandatory: false,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"lotCustomField4\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__identifier1____placeholder\", \"Scan...\"),\n        isMandatory: false,\n        validation: /^$|^[^|]+$/,\n        maxLength: 10,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isMandatory: false,\n        maxLength: 10,\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"identifier2\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__closePoLine____title\", \"Close PO line\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail__closePoLine____placeholder\", \"Select...\"),\n        isFullWidth: true,\n        // options: ['Yes', 'No'],\n    })\n], MobilePurchaseReceiptEnterReceiptDetail.prototype, \"closePoLine\", void 0);\nexports.MobilePurchaseReceiptEnterReceiptDetail = MobilePurchaseReceiptEnterReceiptDetail = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail____title\", \"Purchase receipt\"),\n        subtitle: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt_enter_receipt_detail____subtitle\", \"Enter details\"),\n        module: 'x3-purchasing',\n        mode: 'default',\n        isTransient: true,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.headerTitleLeft,\n                titleRight: this.headerTitleRight,\n                line2: this.headerLine2Left,\n                line2Right: this.headerLine2Right,\n                line3: this.headerLine3Left,\n                line3Right: this.headerLine3Right,\n            };\n        },\n        businessActions() {\n            return [this.addDetails, this.addProduct];\n        },\n        async onLoad() {\n            this.isLocationPreloaded = typesLib.strictEq(this.$.queryParameters?.isLocationPreloaded, '1');\n            this._purchaseReceiptRecordManager = new purchase_receipt_details_control_1.PurchaseReceiptDetailsRecordManager(this);\n            this.purchaseSession = this._purchaseReceiptRecordManager.purchaseSession;\n            if (!this.purchaseSession) {\n                this.addDetails.isHidden = true;\n                this.addProduct.isHidden = true;\n                this.blockProduct.isHidden = true;\n                return;\n            }\n            if (!(await purchase_receipt_details_initializer_1.PurchaseReceiptDetailsInitializer.initializePage(this, closePoLineOptions))) {\n                this.clearAllCompositeDataAndStorage(mobile_purchase_receipt_1.mobileApplicationGs1Key);\n                // TODO: Return a non-developer error message to user about invalid session/routing?\n                (0, on_goto_1.onGoto)(this, '@sage/x3-purchasing/MobilePurchaseReceipt');\n                return;\n            }\n            // Retrieve current product globalTradeItemNumber from the main page\n            this._globalTradeItemNumber = this.$.queryParameters?.globalTradeItemNumber ?? '';\n            // Allow reception greater than the order based on RCPORD setting. Storing value in local storage so only need to read once.\n            this._isOverReceiptAllowed = typesLib.strictEq((await (0, read_parameter_1.readParameterValue)('RCPORD', this.$.userCode ?? '', this.site.value ?? '', this)), 2);\n            this._initDirty();\n            await this._focusToNextField(this.receiptUnit);\n            if (!(await this._initControlManagerGs1(this.site.value ?? ''))) {\n                this.clearAllCompositeDataAndStorage(mobile_purchase_receipt_1.mobileApplicationGs1Key);\n                // TODO: What action should be taken in the event of a fatal error ?\n                (0, on_goto_1.onGoto)(this, '@sage/x3-purchasing/MobilePurchaseReceipt');\n                return;\n            }\n            // Composite data having been dispatched during the initialization phase, can now be deleted from the service\n            // because we don't need it anymore.\n            this.clearCompositeData();\n        },\n    })\n], MobilePurchaseReceiptEnterReceiptDetail);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-purchase-receipt-enter-receipt-detail.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-purchase-receipt.ts":
/*!**********************************************!*\
  !*** ./lib/pages/mobile-purchase-receipt.ts ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobilePurchaseReceipt = exports.mobileApplicationGs1Key = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst get_selected_stock_site_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/get-selected-stock-site */ \"../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\");\nconst on_goto_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/on-goto */ \"../../shared/x3-master-data/lib/client-functions/on-goto.ts\");\nconst receipt_1 = __webpack_require__(/*! @sage/x3-stock-data/build/lib/menu-items/receipt */ \"../../shared/x3-stock-data/build/lib/menu-items/receipt.js\");\nconst support_service_management_gs_1_page_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/support-service-management-gs-1-page */ \"../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts\");\nconst parsed_element_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/parsed-element */ \"../../shared/x3-system/lib/shared-functions/parsed-element.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst purchase_receipt_details_control_1 = __webpack_require__(/*! ../client-functions/purchase-receipt-details-control */ \"./lib/client-functions/purchase-receipt-details-control.ts\");\nconst read_parameter_1 = __webpack_require__(/*! ../client-functions/read-parameter */ \"./lib/client-functions/read-parameter.ts\");\n// Key to use with Composite Data Gs1 for this application\nexports.mobileApplicationGs1Key = 'MobilePurchaseReceiptGs1Key';\nconst QTY_DECIMAL_PLACES = 8;\nconst CONVERSION_RATE_DECIMAL_PLACES = 6;\nlet MobilePurchaseReceipt = class MobilePurchaseReceipt extends support_service_management_gs_1_page_1.SupportServiceManagementGs1Page {\n    constructor() {\n        super(...arguments);\n        this._shipmentLines = [];\n        this._purchaseShipmentIds = [];\n        /* @internal */\n        this._globalTradeItemNumber = null;\n        /** @internal */\n        this._postDoneDetailPage = () => {\n            this.$.removeToasts();\n            this.$.setPageClean();\n            if (typesLib.gt(this._purchaseShipmentIds?.length, 1)) {\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceiptSelectAShipment', {\n                    purchaseOrderId: `${this.purchaseOrder?.value?.id}`,\n                    purchaseOrderLineNumber: `${this.purchaseOrderLinesSupplier?.value?.lineNumber}`,\n                    globalTradeItemNumber: `${this._globalTradeItemNumber ?? ''}`,\n                    shipmentToLoad: `${JSON.stringify(this._purchaseShipmentIds)}`,\n                    isLocationPreloaded: `${this._isLocationPreloaded ? '1' : '0'}`,\n                });\n            }\n            else {\n                this.$.router.goTo('@sage/x3-purchasing/MobilePurchaseReceiptEnterReceiptDetail', {\n                    globalTradeItemNumber: `${this._globalTradeItemNumber ?? ''}`,\n                    isLocationPreloaded: `${this._isLocationPreloaded ? '1' : '0'}`,\n                });\n            }\n        };\n        /**\n         * OnChange readonly process\n         *\n         * Used both decorator and bar code manager.\n         * @returns Promise<void>\n         */\n        /** @internal */\n        this._onChange_productSupplier = async () => {\n            this._globalTradeItemNumber = null;\n            if (!this.productSupplier.value)\n                return; // if user closes the lookup instead of selecting a record\n            if (!(await (0, purchase_receipt_details_control_1.validate)(this))) {\n                this.productSupplier.value = null;\n                return;\n            }\n            this._purchaseShipment = undefined;\n            this._purchaseShipmentLine = undefined;\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isBeingCounted: true,\n            }, {\n                filter: {\n                    product: {\n                        code: this.productSupplier?.value?.product,\n                    },\n                    stockSite: {\n                        code: this.stockSite.value ?? undefined,\n                    },\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0) && typesLib.strictEq(response.edges[0].node.isBeingCounted, true)) {\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel-no', 'No'),\n                    },\n                }))) {\n                    //cancel button clicked - promise rejected\n                    this.productSupplier.value = null;\n                    this.productSupplier.focus();\n                    return;\n                }\n            }\n            this.goToDetailsPage({ product: this.productSupplier?.value?.product }, this.productSupplier?.value?.globalTradeItemNumber ?? null);\n        };\n        /** @internal */\n        this._onChange_purchaseOrderLinesSupplier = async () => {\n            this._globalTradeItemNumber = null;\n            this._purchaseShipment = undefined;\n            this._purchaseShipmentLine = undefined;\n            // if user closes the lookup instead of selecting a record\n            if (!this.purchaseOrderLinesSupplier.value)\n                return;\n            if (!(await (0, purchase_receipt_details_control_1.validate)(this))) {\n                this.purchaseOrderLinesSupplier.value = null;\n                return;\n            }\n            this._shipmentLines = await this._readShipmentLines();\n            this._cleanShipmentLines();\n            if (typesLib.strictEq(this._shipmentLines?.length, 1)) {\n                this._purchaseShipment = this._shipmentLines[0].purchaseShipment?.id;\n                this._purchaseShipmentLine = this._shipmentLines[0].lineNumber?.toString();\n            }\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isBeingCounted: true,\n            }, {\n                filter: {\n                    product: {\n                        code: this.purchaseOrderLinesSupplier.value.product,\n                    },\n                    stockSite: {\n                        code: this.stockSite.value ?? undefined,\n                    },\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0) && typesLib.strictEq(response.edges[0].node.isBeingCounted, true)) {\n                if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing/product-blocked-by-count-continue', 'Product blocked by count. Do you want to continue?'), {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-yes', 'Yes'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel-no', 'No'),\n                    },\n                }))) {\n                    //cancel button clicked - promise rejected\n                    this.purchaseOrderLinesSupplier.value = null;\n                    this.purchaseOrderLinesSupplier.focus();\n                    return;\n                }\n            }\n            this.goToDetailsPage({\n                product: this.purchaseOrderLinesSupplier?.value?.product,\n                purchaseOrder: this.purchaseOrder?.value?.id,\n                purchaseOrderLineNumber: this.purchaseOrderLinesSupplier?.value?.lineNumber,\n                purchaseOrderLine: this.purchaseOrderLinesSupplier?.value?.sequenceNumber,\n            }, this.purchaseOrderLinesSupplier?.value?.globalTradeItemNumber ?? null);\n        };\n    }\n    /**\n     *\n     * Methods section\n     *\n     *\n     */\n    _showWorkflowLayout(isPOWorkflow = true) {\n        this.purchaseOrderLinesSupplier.isHidden = !isPOWorkflow;\n        this.purchaseOrderLinesSupplier.isDisabled = !isPOWorkflow || !this.purchaseOrder.value;\n        this.productSupplier.isHidden = isPOWorkflow;\n        this.productSupplier.isDisabled =\n            isPOWorkflow || !this.supplier.value || !this._purchaseSession?.purchaseReceipt?.supplier;\n        this.supplier.isReadOnly = isPOWorkflow;\n        // product is to be disabled, if it is hidden or supplier field is empty\n        // Logic for whether supplier field should be readonly or not. If it becomes readonly, then auto-populate it based on selected PO\n        if (!this._purchaseSession?.purchaseReceipt?.supplier) {\n            // supplier field is only modifiable when there is no purchase receipt session yet\n            this.supplier.isReadOnly = isPOWorkflow;\n            if (this.supplier.isReadOnly) {\n                // this.supplier.value = this.purchaseOrder.value.orderFromSupplier._id;\n                this.supplier.value = this.purchaseOrder.value?.orderFromSupplier;\n            }\n            //Supplier will be disabled if current user is not authorized to process direct receipts.\n            //So clear supplier value when clearing the PO value.\n            if (!isPOWorkflow)\n                this.supplier.value = null;\n        }\n        if (this.supplier.isDisabled && !isPOWorkflow)\n            this.productSupplier.isDisabled = true;\n        if (isPOWorkflow)\n            this.purchaseOrderLinesSupplier.focus();\n        this.supplierPackingSlip.isHidden = true;\n        // this.$.commitValueAndPropertyChanges();\n    }\n    /**\n     * Initialize the page\n     * @returns false when page must be disabled\n     */\n    /** @internal */\n    async _init() {\n        //Populate the receipt so far if provided in the session data\n        this._purchaseReceiptRecordManager = new purchase_receipt_details_control_1.PurchaseReceiptDetailsRecordManager(this, true);\n        this._purchaseSession = this._purchaseReceiptRecordManager.purchaseSession;\n        const purchaseOrderId = this.$.queryParameters.purchaseOrderId;\n        const supplierCode = this.$.queryParameters.supplierCode;\n        let fromInquiries = false;\n        // if this is the first time user is on the main page of Purchase Receipt\n        if (!this._purchaseSession) {\n            // Initialize Receipt Date to the current date\n            this.receiptDate.value = xtrem_date_time_1.DateValue.today().toString();\n            try {\n                // Populate Default Site & Legal company & Entry Transaction fields\n                this.stockSite.value = await (0, get_selected_stock_site_1.getSelectedStockSite)(this, ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing/dialog-error-location-inquiry-set-site', 'Define a default stock site on the user function profile.'));\n                if (!this.stockSite.value) {\n                    return false;\n                }\n                await this._getProductSearch();\n                await this._initTransaction();\n            }\n            catch (error) {\n                this.$.showToast(error.message, { type: 'error' });\n                return false;\n            }\n            // Preloading purchaseOrderId and supplierCode into the purchaseOrder and supplier code fields\n            if (purchaseOrderId && supplierCode) {\n                fromInquiries = true;\n                this.purchaseOrder.value = {\n                    id: purchaseOrderId,\n                    orderFromSupplier: {\n                        code: { code: supplierCode },\n                    },\n                };\n                this._showWorkflowLayout(true);\n                await this.$.commitValueAndPropertyChanges();\n            }\n        }\n        else {\n            // else display user's selected entry transaction & date (both as disabled) & selected products to add stored from session storage\n            const purchaseReceipt = this._purchaseSession.purchaseReceipt;\n            // Populate Default Site\n            this.stockSite.value = purchaseReceipt.receiptSite ?? null; // TODO: Issue: User can change site via sticker. This can a runtime error because Enter Detail page always use the site from the sticker. (To reproduce error, add a PO line from site FR022 and then change site to NA021, refresh the main page, and notice the site is still set to FR022. When selecting a product from FR022, a runtime error during loading Enter Detail page will occur because it is using the wrong site NA021 from the sticker to retrieve a product that is from FR022)\n            await this._getProductSearch();\n            // Populate Entry Transaction, Receipt Date, Receipt lines to create, and Supplier fields based on session storage\n            try {\n                await this._initTransaction();\n            }\n            catch (e) {\n                ui.console.error(e);\n            }\n            this.transaction.options = [this._purchaseSession?.purchaseEntryTransaction?.code ?? ''];\n            this.transaction.value = this._purchaseSession.purchaseEntryTransaction.code ?? null;\n            // not allowed to be changed unless user creates successfully or remove all receipt lines\n            this.receiptDate.value = purchaseReceipt.receiptDate ?? null;\n            this.supplierPackingSlip.value = purchaseReceipt.supplierPackingSlip ?? null;\n            if (this.supplierPackingSlip.value) {\n                this.supplierPackingSlip.isHidden = false;\n                this.supplierPackingSlipLink.isHidden = true;\n            }\n            this.receiptToCreate.value = await this._mapPurchaseReceipt(purchaseReceipt.lines ?? []);\n            this.receiptBlock.isHidden = false;\n            this.supplier.value = { code: { code: purchaseReceipt.supplier } };\n            this.supplier.isReadOnly = true;\n            this.productSupplier.isDisabled = false; // because supplier is now poulated & cannot be changed til the entire session is cleared out\n            // auto-populate PO lookup with most recently selected PO or empty if most recently is a direct receipt line (i.e. Supplier->product workflow)\n            if (purchaseReceipt.lines && purchaseReceipt.lines[typesLib.sub(purchaseReceipt.lines.length, 1)].purchaseOrder) {\n                this.purchaseOrder.value = {\n                    id: purchaseReceipt.lines[typesLib.sub(purchaseReceipt.lines.length, 1)].purchaseOrder,\n                }; // TODO: Verify: Is this bad practice of auto-populating reference field\n                this.purchaseOrderLinesSupplier.isDisabled = this.purchaseOrderLinesSupplier.isHidden = false;\n                this.productSupplier.isDisabled = this.productSupplier.isHidden = true;\n                this.purchaseOrderLinesSupplier.focus();\n            }\n            this.createButton.isDisabled = false;\n        }\n        // required for Purchase Order lookup (TODO: Verify if legalCompany can be stored in session to avoid a GraphQL call)\n        this.legalCompany.value = await this._getLegalCompany(this.stockSite.value ?? '');\n        // Disallow direct receipts based on PTHDIR setting. Storing value in local storage so only need to read once.\n        const valPTHDIR = await (0, read_parameter_1.readParameterValue)('PTHDIR', this.$.userCode ?? '', this.stockSite.value ?? '', this);\n        this.supplier.isDisabled = typesLib.strictNe(valPTHDIR, 2);\n        if (fromInquiries) {\n            this.purchaseOrder.focus();\n            this.purchaseOrderLinesSupplier.focus();\n        }\n        // perform screen initialization for current workFlow enabled\n        if (!(await this._initControlManagerGs1(this.stockSite.value ?? ''))) {\n            return false;\n        }\n        return true;\n    }\n    /**\n     * Initialize ControlManagerGs1\n     * @returns true when ControlManagerGs1 has usable\n     */\n    async _initControlManagerGs1(site) {\n        const isPOWorkflow = !!this.purchaseOrder.value;\n        return await this.createAndInitServiceGs1(site, exports.mobileApplicationGs1Key, {\n            [parsed_element_1.DataTitle.gtin]: {\n                mainField: isPOWorkflow ? this.purchaseOrderLinesSupplier : this.productSupplier,\n                onChangeMainField: isPOWorkflow\n                    ? this._onChange_purchaseOrderLinesSupplier\n                    : this._onChange_productSupplier,\n            },\n        });\n    }\n    /**\n     * Update fields mappings\n     * @returns true when ControlManagerGs1 has usable\n     */\n    /** @internal */\n    async _updateControlManagerGs1() {\n        const isPOWorkflow = !!this.purchaseOrder.value;\n        return await this.setScreenFieldSupported({\n            [parsed_element_1.DataTitle.gtin]: {\n                mainField: isPOWorkflow ? this.purchaseOrderLinesSupplier : this.productSupplier,\n                onChangeMainField: isPOWorkflow\n                    ? this._onChange_purchaseOrderLinesSupplier\n                    : this._onChange_productSupplier,\n            },\n        });\n    }\n    goToDetailsPage(line, globalTradeItemNumber) {\n        const purchaseReceiptLine = {\n            receiptSite: this.stockSite.value ?? undefined,\n            ...line,\n        };\n        // Store globalTradeItemNumber for postDone action\n        this._globalTradeItemNumber = globalTradeItemNumber;\n        if (!this._purchaseSession) {\n            // if no session, create a new session object\n            const selectedEntryTransaction = this._entryTransactionMap.get(this.transaction.value ?? '');\n            this._purchaseReceiptRecordManager.purchaseSession = {\n                purchaseReceipt: {\n                    receiptSite: this.stockSite.value ?? undefined,\n                    receiptDate: this.receiptDate.value ?? undefined,\n                    supplier: this.supplier.value?.code.code,\n                    stockAutomaticJournal: selectedEntryTransaction?.stockAutomaticJournal,\n                    stockMovementCode: selectedEntryTransaction?.stockMovementCode ?? '',\n                    transaction: selectedEntryTransaction?.code,\n                    destination: this.$.storage.get('mobile-label-destination')?.toString() ?? '',\n                    document: this.$.storage.get('mobile-document-destination')?.toString() ?? '',\n                    supplierPackingSlip: this.supplierPackingSlip.value ?? undefined,\n                    supplierPackingSlipDate: xtrem_date_time_1.DateValue.today().toString(),\n                    lines: [\n                        {\n                            ...purchaseReceiptLine,\n                            stockMovementGroup: selectedEntryTransaction?.defaultStockMovementGroup ?? '',\n                            purchaseShipment: this._purchaseShipment,\n                            purchaseShipmentLine: this._purchaseShipmentLine,\n                        },\n                    ],\n                },\n                purchaseEntryTransaction: {\n                    code: this.transaction.value ?? undefined,\n                    isLotCustomField1Allowed: selectedEntryTransaction?.isLotCustomField1Allowed,\n                    isLotCustomField2Allowed: selectedEntryTransaction?.isLotCustomField2Allowed,\n                    isLotCustomField3Allowed: selectedEntryTransaction?.isLotCustomField3Allowed,\n                    isLotCustomField4Allowed: selectedEntryTransaction?.isLotCustomField4Allowed,\n                    identifier1Entry: selectedEntryTransaction?.identifier1Entry,\n                    identifier1Detail: selectedEntryTransaction?.identifier1Detail,\n                    identifier2Entry: selectedEntryTransaction?.identifier2Entry,\n                    identifier2Detail: selectedEntryTransaction?.identifier2Detail,\n                    isLotPotencyAllowed: selectedEntryTransaction?.isLotPotencyAllowed,\n                    isLotExpirationDateAllowed: selectedEntryTransaction?.isLotExpirationDateAllowed,\n                    stockMovementCode: selectedEntryTransaction?.stockMovementCode,\n                },\n                orderUnitToPurchaseUnitConversionFactor: 1,\n            };\n        }\n        else {\n            this._purchaseSession.purchaseReceipt.lines?.push({\n                ...purchaseReceiptLine,\n                stockMovementGroup: this._purchaseSession.purchaseReceipt.lines[typesLib.sub(this._purchaseSession.purchaseReceipt.lines.length, 1)]\n                    .stockMovementGroup, // copy stockMovementGroup from the previous most line\n                purchaseShipment: this._purchaseShipment,\n                purchaseShipmentLine: this._purchaseShipmentLine,\n            });\n            this._purchaseReceiptRecordManager.purchaseSession = {\n                purchaseReceipt: this._purchaseSession.purchaseReceipt,\n                purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n                orderUnitToPurchaseUnitConversionFactor: 1,\n            };\n        }\n        // saving data and aborting dispatch is not enough :\n        // the page has changed before dispatching has aborted !\n        this.saveCompositeData();\n        // If we are in the process of dispatching, we must delay the change of page\n        if (this.controlManagerGs1.isDispatchInProgress) {\n            this.controlManagerGs1.abortDispatch(this._postDoneDetailPage);\n        }\n        else if (!this.controlManagerGs1.isInitializationInProgress) {\n            this._postDoneDetailPage();\n        }\n    }\n    async _getLegalCompany(defaultSite) {\n        const response = await this.$.graph\n            .node('@sage/x3-system/Site')\n            .read({\n            _id: true, // TODO: Remove unneeded property\n            legalCompany: { code: true },\n        }, defaultSite)\n            .execute();\n        if (!response) {\n            // This should never occur as long as the user function profile has a valid site set up\n            throw new Error(ui.localize('@sage/x3-purchasing/error-purchase-receipt-no-legal-company', 'The invalid site {{site}} has no legal company.', {\n                site: defaultSite,\n            }));\n        }\n        return response.legalCompany.code;\n    }\n    async _getEntryTransactionOptions() {\n        const response = (0, xtrem_client_1.extractEdges)(await this.$.graph\n            // with 'provides' property defined in accessCode of this node, should automatically return only transactions that are accessible for the current user\n            .node('@sage/x3-purchasing/PurchaseEntryTransaction')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            code: true,\n            stockMovementCode: {\n                code: true,\n            },\n            defaultStockMovementGroup: {\n                code: true,\n            },\n            stockAutomaticJournal: {\n                code: true,\n            },\n            isLotCustomField1Allowed: true,\n            isLotCustomField2Allowed: true,\n            isLotCustomField3Allowed: true,\n            isLotCustomField4Allowed: true,\n            identifier1Entry: true,\n            identifier1Detail: true,\n            identifier2Entry: true,\n            identifier2Detail: true,\n            isLotPotencyAllowed: true,\n            isLotExpirationDateAllowed: true,\n        }, {\n            filter: {\n                entryTransactionType: 'receipt',\n                isActive: true,\n            },\n        }))\n            .execute());\n        this._entryTransactionMap = new Map(); // TODO: Put this in a better place\n        // transform Entry Transaction response into a string array\n        return response.map((entryTransaction) => {\n            this._entryTransactionMap.set(entryTransaction.code, {\n                code: entryTransaction.code,\n                _id: entryTransaction._id,\n                stockAutomaticJournal: entryTransaction.stockAutomaticJournal?.code,\n                stockMovementCode: entryTransaction.stockMovementCode?.code,\n                defaultStockMovementGroup: entryTransaction.defaultStockMovementGroup?.code,\n                isLotCustomField1Allowed: entryTransaction.isLotCustomField1Allowed,\n                isLotCustomField2Allowed: entryTransaction.isLotCustomField2Allowed,\n                isLotCustomField3Allowed: entryTransaction.isLotCustomField3Allowed,\n                isLotCustomField4Allowed: entryTransaction.isLotCustomField4Allowed,\n                identifier1Entry: entryTransaction.identifier1Entry,\n                identifier1Detail: entryTransaction.identifier1Detail,\n                identifier2Entry: entryTransaction.identifier2Entry,\n                identifier2Detail: entryTransaction.identifier2Detail,\n                isLotPotencyAllowed: entryTransaction.isLotPotencyAllowed,\n                isLotExpirationDateAllowed: entryTransaction.isLotExpirationDateAllowed,\n            });\n            return entryTransaction.code;\n        });\n    }\n    async _callCreationAPI() {\n        const _purchaseReceiptArgs = this._purchaseSession?.purchaseReceipt ?? {};\n        let result;\n        try {\n            result = await this.$.graph\n                .node('@sage/x3-purchasing/PurchaseReceipt')\n                .create({\n                id: true,\n            }, {\n                data: _purchaseReceiptArgs,\n            })\n                .execute();\n            if (!result) {\n                throw new xtrem_shared_1.BusinessRuleError(ui.localize('@sage/x3-purchasing/dialog-error-purchase-receipt-no-create-results', 'No results for the created purchase receipt'));\n            }\n        }\n        catch (error) {\n            return error;\n        }\n        return result;\n    }\n    async _getReceiptUnits(units) {\n        const response = await this.$.graph\n            .node('@sage/x3-master-data/UnitOfMeasure')\n            .query(ui.queryUtils.edgesSelector({\n            code: true,\n            numberOfDecimals: true,\n        }, {\n            filter: {\n                code: { _in: units },\n            },\n        }))\n            .execute();\n        return response.edges.map(edge => {\n            return {\n                code: edge.node.code,\n                numberOfDecimals: edge.node.numberOfDecimals,\n            };\n        });\n    }\n    async _mapPurchaseReceipt(receipt) {\n        let rowCount = 0;\n        const receiptUnits = await this._getReceiptUnits(receipt.map((line) => line.receiptUnit));\n        return receipt.map((line) => {\n            var _v;\n            return {\n                _id: String((_v = rowCount, rowCount = typesLib.add(rowCount, 1), _v)), // this defines the rowId parameter in dropdownActions onClick() event\n                purchaseOrderLineNumber: line.purchaseOrder && line.purchaseOrderLineNumber\n                    ? `${line.purchaseOrder} ${line.purchaseOrderLineNumber}`\n                    : '',\n                product: line.product,\n                quantityAndStockUnit: `${Number(line.quantityInReceiptUnitReceived).toFixed(receiptUnits.find(unit => typesLib.strictEq(unit.code, line.receiptUnit))?.numberOfDecimals ?? 0)} ${line.receiptUnit}`,\n                purchaseShipment: line.purchaseShipment && line.purchaseShipmentLine\n                    ? `${line.purchaseShipment} ${line.purchaseShipmentLine}`\n                    : '',\n            };\n        });\n    }\n    _disablePage() {\n        this.purchaseOrder.isDisabled = true;\n        this.supplier.isDisabled = true;\n        this.receiptDate.isDisabled = true;\n        this.transaction.isDisabled = true;\n        this.supplierPackingSlip.isDisabled = true;\n    }\n    async _getProductSearch() {\n        const responseSite = await this.$.graph\n            .node('@sage/x3-master-data/MobileAutomationSetup')\n            .query(ui.queryUtils.edgesSelector({\n            criteria1: true,\n            criteria2: true,\n            isLocationPreloaded: true,\n        }, {\n            filter: {\n                site: { code: this.stockSite.value },\n            },\n        }))\n            .execute();\n        if (typesLib.strictNe(responseSite.edges.length, 0)) {\n            responseSite.edges.some(edge => {\n                this._productSearchCriteria1 = edge.node.criteria1;\n                this._productSearchCriteria2 = edge.node.criteria2;\n                this._isLocationPreloaded = edge.node.isLocationPreloaded;\n            });\n        }\n        else {\n            const response = await this.$.graph\n                .node('@sage/x3-master-data/MobileAutomationSetup')\n                .query(ui.queryUtils.edgesSelector({\n                criteria1: true,\n                criteria2: true,\n                isLocationPreloaded: true,\n            }, {\n                filter: {\n                    site: null,\n                },\n            }))\n                .execute();\n            if (typesLib.strictNe(response.edges.length, 0)) {\n                response.edges.some(edge => {\n                    this._productSearchCriteria1 = edge.node.criteria1;\n                    this._productSearchCriteria2 = edge.node.criteria2;\n                    this._isLocationPreloaded = edge.node.isLocationPreloaded;\n                });\n            }\n            else {\n                this._productSearchCriteria1 = 'none';\n                this._productSearchCriteria2 = 'none';\n                this._isLocationPreloaded = true;\n            }\n        }\n    }\n    async _initTransaction() {\n        this.transaction.options = await this._getEntryTransactionOptions();\n        switch (this.transaction.options.length) {\n            case 0:\n                this._disablePage();\n                throw new Error('No transaction, cannot continue');\n            case 1:\n                this.transaction.value = this.transaction.options[0];\n                this.transaction.isHidden = true;\n                break;\n            default:\n                this.transaction.value = this.transaction.options[0];\n                if (this._purchaseSession) {\n                    this.transaction.isDisabled = true;\n                }\n                break;\n        }\n    }\n    async _readShipmentLines() {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-purchasing/PurchaseShipmentLine')\n            .query(ui.queryUtils.edgesSelector({\n            purchaseShipment: { id: true },\n            lineNumber: true,\n            product: { code: true },\n            purchaseOrderNumber: { id: true },\n            purchaseOrderLineNumber: true,\n            quantityInPurchaseUnitShipped: true,\n            quantityInPurchaseUnitReceived: true,\n            quantityInPurchaseUnitPreReceived: true,\n            quantityInOrderUnitShipped: true,\n            quantityInStockUnitShipped: true,\n            isClosed: true,\n            isPreReceived: true,\n        }, {\n            filter: {\n                purchaseOrderNumber: { id: this.purchaseOrder.value?.id },\n                purchaseOrderLineNumber: this.purchaseOrderLinesSupplier?.value?.lineNumber,\n                purchaseShipment: {\n                    shipmentStatus: {\n                        _nin: ['received', 'closed'],\n                    },\n                },\n                isClosed: { _eq: false },\n            },\n        }))\n            .execute());\n    }\n    _cleanShipmentLines() {\n        this._shipmentLines.forEach((element) => {\n            if ((element.isPreReceived && typesLib.gt(Number(element.quantityInPurchaseUnitPreReceived), Number(element.quantityInPurchaseUnitReceived))) ||\n                (!element.isPreReceived && typesLib.gt(Number(element.quantityInPurchaseUnitShipped), Number(element.quantityInPurchaseUnitReceived)))) {\n                this._purchaseShipmentIds.push(element?.purchaseShipment?.id);\n            }\n            else {\n                const resultIndex = this._shipmentLines.indexOf(element);\n                this._shipmentLines.splice(resultIndex, 1);\n            }\n        });\n        if (this._purchaseSession?.purchaseReceipt?.lines) {\n            this._shipmentLines.forEach(lineShip => {\n                if (typesLib.strictEq(lineShip.purchaseOrderNumber, this.purchaseOrder.value?.id) && typesLib.strictEq(lineShip.purchaseOrderLineNumber, this.purchaseOrderLinesSupplier?.value?.lineNumber)) {\n                    let QuantityInStockUnitReceived = 0;\n                    let quantityInStockUnitExpected = Number(lineShip.quantityInStockUnitShipped);\n                    this._purchaseSession?.purchaseReceipt?.lines?.forEach(line => {\n                        if (line.purchaseShipment) {\n                            if (typesLib.strictEq(line.purchaseShipment, lineShip.purchaseShipment?.id) && typesLib.strictEq(Number(line.purchaseShipmentLine), Number(lineShip.lineNumber))) {\n                                QuantityInStockUnitReceived = typesLib.add(QuantityInStockUnitReceived, typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor)));\n                            }\n                        }\n                    });\n                    if (typesLib.lte(typesLib.sub(Number(quantityInStockUnitExpected), Number(QuantityInStockUnitReceived)), 0)) {\n                        let resultIndex = this._purchaseShipmentIds.indexOf(lineShip.purchaseShipment?.id);\n                        this._purchaseShipmentIds.splice(resultIndex, 1);\n                        resultIndex = this._shipmentLines.indexOf(lineShip);\n                        this._shipmentLines.splice(resultIndex, 1);\n                    }\n                }\n            });\n        }\n    }\n};\nexports.MobilePurchaseReceipt = MobilePurchaseReceipt;\n__decorate([\n    ui.decorators.textField({\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"stockSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__createButton____title\", \"Create\"),\n        buttonType: 'primary',\n        shortcut: ['f2'],\n        isDisabled: true,\n        async onClick() {\n            // Check if the purchase receipt to create contains at least one valid line\n            if (!this._purchaseSession) {\n                this.$.showToast(ui.localize('@sage/x3-purchasing/notification-error-purchase-receipt-no-products', `Enter at least one product.`), { type: 'error', timeout: 5000 });\n                return;\n            }\n            // Only validate receipt date is populated\n            const validateError = (await this.receiptDate.validate()) || (await this.supplierPackingSlip.validate());\n            if (validateError) {\n                this.$.removeToasts();\n                this.$.showToast(`${ui.localize('@sage/x3-purchasing/notification-error-purchase-receipt-error', 'Error')}: ${validateError}`, { type: 'error', timeout: 30000 });\n                return;\n            }\n            this.createButton.isDisabled = true; // to prevent extreme case of duplicate receipts by rapidly clicking on create button multiple times\n            this.$.loader.isHidden = false;\n            const result = await this._callCreationAPI();\n            this.$.loader.isHidden = true;\n            // Special case unable to connect check type of error\n            this.supplierPackingSlip.isDirty = false;\n            if (!result || result instanceof Error) {\n                this.$.loader.isHidden = true;\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-goback', 'Go back'),\n                    },\n                    cancelButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-cancel', 'Cancel'),\n                    },\n                    size: 'small',\n                    mdContent: true,\n                };\n                let message = '';\n                if (!result?.message) {\n                    message = `${ui.localize('@sage/x3-purchasing/pages_creation_error_connexion_webservice_contact_administrator', 'An error has occurred (connection or webservice error). Please contact your administrator.')}`;\n                }\n                else {\n                    const _messages = [];\n                    const _results = result;\n                    let _diagnoses = _results?.diagnoses;\n                    if (typesLib.gt(_diagnoses?.length, 1)) {\n                        _diagnoses = _diagnoses.splice(0, typesLib.sub(_diagnoses.length, 1));\n                    }\n                    ((_results?.errors\n                        ? _results.errors[0]?.extensions?.diagnoses\n                        : (_results?.innerError?.errors[0]?.extensions?.diagnoses ??\n                            _results.extensions?.diagnoses ??\n                            _diagnoses)) ?? [])\n                        .filter((d) => typesLib.gt(d.severity, 2) && d.message)\n                        .forEach((d) => {\n                        const _message = d.message.split(`\\n`);\n                        _messages.push(..._message);\n                    });\n                    const _result = _messages.length ? _messages : result.message.split(`\\n`);\n                    message = `**${ui.localize('@sage/x3-purchasing/dialog-error-purchase-receipt-creation', 'An error has occurred')}**\\n\\n`;\n                    if (typesLib.strictEq(_result.length, 1)) {\n                        message = typesLib.add(message, `${_result[0]}`);\n                    }\n                    else {\n                        message = typesLib.add(message, _result.map(item => `* ${item}`).join('\\n'));\n                    }\n                }\n                await this.$.sound.error();\n                if (await (0, dialogs_1.dialogConfirmation)(this, 'error', ui.localize('@sage/x3-purchasing/dialog-error-title', 'Error'), message, options)) {\n                    await this.$.router.refresh();\n                }\n                else {\n                    this._purchaseReceiptRecordManager.clearSession();\n                    await this.$.router.emptyPage();\n                }\n            }\n            else {\n                this._purchaseReceiptRecordManager.clearSession();\n                const options = {\n                    acceptButton: {\n                        text: ui.localize('@sage/x3-purchasing/button-accept-ok', 'OK'),\n                    },\n                    fullScreen: true,\n                };\n                await this.$.sound.success();\n                await (0, dialogs_1.dialogMessage)(this, 'success', ui.localize('@sage/x3-purchasing/dialog-success-title', 'Success'), ui.localize('@sage/x3-purchasing/dialog-success-purchase-receipt-creation', 'Document no. {{receiptId}} created.', { receiptId: result.id }), options);\n                await this.$.router.emptyPage();\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"createButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"mainSection\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        isTitleHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"productBlock\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.mainSection;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptBlock____title\", \"Receipt to create\"),\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"receiptBlock\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptDate____title\", \"Receipt date\"),\n        isTransient: true,\n        isMandatory: true,\n        maxDate: xtrem_date_time_1.DateValue.today().toString(), // restricts to current date or earlier\n        onChange() {\n            if (this._purchaseSession && this.receiptDate.value) {\n                this._purchaseSession.purchaseReceipt.receiptDate = this.receiptDate.value;\n                this._purchaseReceiptRecordManager.purchaseSession = this._purchaseSession; // trigger session manager's setter to save receipt date into session\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"receiptDate\", void 0);\n__decorate([\n    ui.decorators.dropdownListField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__transaction____title\", \"Transaction\"),\n        isMandatory: true,\n        isTransient: true,\n    })\n], MobilePurchaseReceipt.prototype, \"transaction\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isTransient: true,\n        isHidden: true,\n    })\n], MobilePurchaseReceipt.prototype, \"legalCompany\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____title\", \"Purchase order\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/PurchaseOrder',\n        valueField: 'id',\n        helperTextField: { orderFromSupplier: { code: { code: true } } },\n        isHelperTextHidden: true,\n        canFilter: false,\n        filter() {\n            const filter = {\n                isClosed: { _eq: false },\n                isIntersite: { _eq: false },\n                // (X3-227355) TODO: Issue: Cannot use the less verbose _in operator instead of individual _or filter criterion\n                _and: [\n                    {\n                        _or: [\n                            {\n                                signatureStatus: 'inFull',\n                            },\n                            {\n                                signatureStatus: 'notManaged',\n                            },\n                            {\n                                signatureStatus: 'automatic',\n                            },\n                        ],\n                    },\n                    {\n                        _or: [\n                            {\n                                receiptStatus: 'no',\n                            },\n                            {\n                                receiptStatus: 'inPart',\n                            },\n                        ],\n                    },\n                ],\n                // (X3-227172) TODO: Issue: Using _id instead of code in order to properly filter for 'null' values, however removed because this will break lookup Search bar\n                // receiptSite: { _id: { _in: [this.stockSite.value, null] } },\n                purchaseSite: { legalCompany: { code: this.legalCompany.value ?? undefined } },\n                // filtering on PO's lines to exclude PO that have nothing to receive\n                purchaseOrderLines: {\n                    _atLeast: 1,\n                    //(X3-191778) TODO: Issue: Not possible to filter on a collection's reference property\n                    // product: {\n                    //     productStatus: { _eq: 'active' },\n                    //     isReceived: true as any,\n                    // },\n                    // _or: [\n                    //     { purchaseOrder: { isIntersite: { _eq: true as any } } },\n                    //     {\n                    //         purchaseOrder: { isIntersite: { _eq: false as any } },\n                    //         product: {\n                    //             _or: [{ isManufactured: false as any }, { isPhantom: false as any }],\n                    //         },\n                    //     },\n                    // ],\n                    isClosed: { _eq: false },\n                    receiptSite: { code: this.stockSite.value ?? undefined },\n                    sourceRequest: { _ne: 'directOrder' },\n                    productType: { _ne: 'subcontract' },\n                    lineType: { _eq: 'normal' },\n                },\n            };\n            if (this.supplier.value) {\n                filter.orderFromSupplier = { code: this.supplier.value.code };\n            }\n            return filter;\n        },\n        async onChange() {\n            this._showWorkflowLayout(!!this.purchaseOrder.value);\n            // perform another screen initialization for current workFlow enabled\n            // TODO: This operation deletes the composite data, see if you want to transfer them here\n            if (!(await this._updateControlManagerGs1())) {\n                // TODO: What action should be taken in the event of a fatal error ?\n            }\n            this.supplierPackingSlipLink.isHidden = false;\n        },\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'id',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__id\", \"Order no.\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'purchaseSite',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__purchaseSite__code\", \"Order site\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Supplier',\n                bind: 'orderFromSupplier',\n                valueField: { code: { code: true } },\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__orderFromSupplier__code__code\", \"Supplier\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'internalOrderReference',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrder____columns__title__internalOrderReference\", \"Internal or order reference\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.checkbox({\n                bind: 'isClosed',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'signatureStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'receiptStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'receiptSite',\n                valueField: '_id',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'purchaseSite',\n                valueField: { legalCompany: { code: true } },\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"purchaseOrder\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____title\", \"Supplier\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-master-data/Supplier',\n        valueField: { code: { code: true } },\n        canFilter: false,\n        filter: {\n            isActive: { _eq: true },\n        },\n        onChange() {\n            this.productSupplier.isDisabled = !this.supplier.value;\n            if (this.supplier.value) {\n                this.productSupplier.focus();\n            }\n        },\n        isTransient: true,\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.reference({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__code__code\", \"Supplier\"),\n                isReadOnly: true,\n                node: '@sage/x3-master-data/BusinessPartner',\n                valueField: 'code',\n            }),\n            ui.nestedFields.text({\n                bind: 'shortCompanyName',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__shortCompanyName\", \"Short Description\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'companyName1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplier____columns__title__companyName1\", \"Company name\"),\n                isReadOnly: true,\n            }),\n            // (X3-227347) TODO: Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"supplier\", void 0);\n__decorate([\n    ui.decorators.linkField({\n        parent() {\n            return this.productBlock;\n        },\n        isTransient: true,\n        isTitleHidden: true,\n        size: 'small',\n        isFullWidth: true,\n        width: 'small',\n        map() {\n            return ui.localize('@sage/x3-purchasing/select-supplier-packing-slip', 'Add a supplier packing slip');\n        },\n        async onClick() {\n            this.supplierPackingSlip.isHidden = false;\n            this.supplierPackingSlipLink.isHidden = true;\n            this.supplierPackingSlip.focus();\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"supplierPackingSlipLink\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplierPackingSlip____title\", \"Supplier packing slip\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__supplierPackingSlip____placeholder\", \"Scan or enter...\"),\n        isTransient: true,\n        isMandatory: false,\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        maxLength: 20,\n        isHidden: true,\n        onChange() {\n            if (this.supplierPackingSlip.value)\n                this.supplierPackingSlip.getNextField(true)?.focus();\n            if (this._purchaseSession) {\n                this._purchaseSession.purchaseReceipt.supplierPackingSlip = this.supplierPackingSlip.value ?? undefined;\n                this._purchaseReceiptRecordManager.purchaseSession = this._purchaseSession;\n            }\n        },\n    })\n], MobilePurchaseReceipt.prototype, \"supplierPackingSlip\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/ProductSupplierView',\n        valueField: { product: true },\n        helperTextField: 'upc',\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: this.stockSite.value ?? undefined,\n                supplier: this.supplier.value?.code.code ?? undefined,\n                productStatus: 'active',\n                isReceived: { _eq: true },\n                _or: [\n                    { isPurchased: { _eq: true } },\n                    { isSubcontracted: { _eq: true } },\n                    { isService: { _eq: true } },\n                    { isPhantom: { _eq: true } },\n                    { isDeliverable: { _eq: true } },\n                    { isSold: { _eq: true } },\n                ],\n            };\n        },\n        onError(error, originScreenId, originElementId) {\n            ui.console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.productSupplier, rawData);\n        },\n        async onChange() {\n            await this._onChange_productSupplier();\n        },\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isDisabled: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__upc\", \"UPC\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'globalTradeItemNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__globalTradeItemNumber\", \"GTIN\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierUpc\", \"Supplier UPC\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierProduct\", \"Supplier product\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProductDescription',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__supplierProductDescription\", \"Supplier product description\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productCategory',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__productSupplier____columns__title__productCategory\", \"Product category\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isReceived',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPurchased',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSubcontracted',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isService',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPhantom',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isDeliverable',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSold',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"productSupplier\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.productBlock;\n        },\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____title\", \"Product\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-purchasing/PurchaseOrderQuantityLinesSupplierView',\n        valueField: { product: true },\n        helperTextField: { upc: true },\n        canFilter: false,\n        filter() {\n            return {\n                productStatus: 'active',\n                isReceived: { _eq: true },\n                _or: [\n                    { isIntersite: { _eq: true } },\n                    { isIntersite: { _eq: false }, isManufactured: { _eq: false } },\n                    { isIntersite: { _eq: false }, isPhantom: { _eq: false } },\n                ],\n                isClosed: { _eq: false },\n                sourceRequest: { _ne: 'directOrder' },\n                productType: { _ne: 'subcontract' },\n                lineType: 'normal',\n                receiptSite: this.stockSite.value ?? undefined,\n                purchaseOrder: this.purchaseOrder.value?.id,\n            };\n        },\n        onError(error, originScreenId, originElementId) {\n            console.warn(`Error on ${originScreenId} ${originElementId}: ${error.message || error}`);\n        },\n        async onInputValueChange(rawData) {\n            await this.scanBarCode(this.purchaseOrderLinesSupplier, rawData);\n        },\n        async onChange() {\n            await this._onChange_purchaseOrderLinesSupplier();\n        },\n        isTransient: true,\n        isMandatory: true,\n        isFullWidth: true,\n        isHidden: true,\n        isDisabled: true,\n        isAutoSelectEnabled: true,\n        shouldSuggestionsIncludeColumns: true,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lineNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__lineNumber\", \"Order line\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix__lineNumber\", \"Line no.\"),\n                isReadOnly: true,\n                isHidden: false,\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierUpc\", \"Supplier upc\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'supplierUpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierProduct\", \"Supplier product\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'supplierProductCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__upc\", \"UPC\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'x3UpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'globalTradeItemNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__globalTradeItemNumber\", \"GTIN\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__description1\", \"Description\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria1, 'x3ProductDescription');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierUpc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierUpc__2\", \"Supplier upc\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'supplierUpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'supplierProduct',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__supplierProduct__2\", \"Supplier product\"),\n                isReadOnly: true,\n                canFilter: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'supplierProductCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'upc',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__upc__2\", \"UPC\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'x3UpcCode');\n                },\n            }),\n            ui.nestedFields.text({\n                bind: 'description1',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__description1__2\", \"Description\"),\n                isReadOnly: true,\n                isHidden() {\n                    return typesLib.strictNe(this._productSearchCriteria2, 'x3ProductDescription');\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'purchaseUnitToStockUnitConversionFactor',\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPurchaseUnitOrdered',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__quantityInPurchaseUnitOrdered\", \"Ordered qty\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.numeric({\n                bind: 'quantityInPurchaseUnitReceived',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title__quantityInPurchaseUnitReceived\", \"Received qty\"),\n                isReadOnly: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.label({\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title___id\", \"Ordered\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix___id\", \"Ordered\"),\n                isFullWidth: false,\n                postfix(value, rowData) {\n                    return rowData?.purchaseUnit;\n                },\n                isTitleHidden: false,\n                isTransient: true,\n                bind: '_id',\n                map(value, rowData) {\n                    return rowData.quantityInPurchaseUnitOrdered.toString();\n                },\n            }),\n            ui.nestedFields.label({\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__title___id__2\", \"Expected\"),\n                prefix: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__purchaseOrderLinesSupplier____columns__prefix___id__2\", \"Expected\"),\n                isFullWidth: false,\n                postfix(value, rowData) {\n                    return rowData?.purchaseUnit;\n                },\n                isTitleHidden: false,\n                isTransient: true,\n                bind: '_id',\n                isHidden: false,\n                map(value, rowData) {\n                    let quantityInPurchaseUnitReceived = 0;\n                    let quantityInPurchaseUnitToReceive = typesLib.max(typesLib.sub(Number(rowData.quantityInPurchaseUnitOrdered), Number(rowData.quantityInPurchaseUnitReceived)), 0);\n                    if (this._purchaseSession?.purchaseReceipt?.lines) {\n                        this._purchaseSession?.purchaseReceipt?.lines\n                            .filter((line) => typesLib.strictEq(line.purchaseOrder, rowData.purchaseOrder) && typesLib.strictEq(Number(line.purchaseOrderLineNumber), Number(rowData.lineNumber)) && typesLib.strictEq(line.product, rowData.product))\n                            .map((line) => (quantityInPurchaseUnitReceived = typesLib.add(quantityInPurchaseUnitReceived, typesLib.div((typesLib.mul(Number(line.quantityInReceiptUnitReceived), Number(line.receiptUnitToStockUnitConversionFactor))), rowData.purchaseUnitToStockUnitConversionFactor))));\n                        if (typesLib.gt(quantityInPurchaseUnitReceived, 0)) {\n                            quantityInPurchaseUnitToReceive = typesLib.max(typesLib.sub(typesLib.sub(Number(rowData.quantityInPurchaseUnitOrdered), Number(rowData.quantityInPurchaseUnitReceived)), Number(quantityInPurchaseUnitReceived)), 0);\n                        }\n                    }\n                    return Number.isInteger(Number(quantityInPurchaseUnitToReceive))\n                        ? quantityInPurchaseUnitToReceive.toString()\n                        : quantityInPurchaseUnitToReceive.toFixed(QTY_DECIMAL_PLACES);\n                },\n            }),\n            ui.nestedFields.numeric({\n                bind: 'sequenceNumber',\n                isTitleHidden: true,\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseUnit',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isReceived',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isIntersite',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isManufactured',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isPhantom',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isClosed',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'sourceRequest',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'workInProgressStatus',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'productType',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'lineType',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'receiptSite',\n                isHidden: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseOrder',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"purchaseOrderLinesSupplier\", void 0);\n__decorate([\n    ui.decorators.tableField({\n        parent() {\n            return this.receiptBlock;\n        },\n        //title: 'Product(s)',\n        isTitleHidden: true,\n        isTransient: true,\n        canSelect: false,\n        canFilter: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'product',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__product\", \"Product\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'quantityAndStockUnit',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__quantityAndStockUnit\", \"Quantity\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseOrderLineNumber',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__purchaseOrderLineNumber\", \"Line No.\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'purchaseShipment',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____columns__title__purchaseShipment\", \"Shipment\"),\n                isReadOnly: true,\n            }),\n        ],\n        dropdownActions: [\n            {\n                icon: 'delete',\n                title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt__receiptToCreate____dropdownActions__title\", \"Delete\"),\n                async onClick(rowId, data) {\n                    this._purchaseSession?.purchaseReceipt?.lines?.splice(rowId, 1);\n                    if (!this._purchaseSession?.purchaseReceipt?.lines?.length) {\n                        this._purchaseReceiptRecordManager.clearSession();\n                        this.createButton.isDisabled = true;\n                        (0, on_goto_1.onGoto)(this, `@sage/x3-purchasing/${this.$.page.id}`);\n                    }\n                    else {\n                        this.receiptToCreate.value = await this._mapPurchaseReceipt(this._purchaseSession.purchaseReceipt.lines ?? []);\n                        // don't forget to update session storage or deleted lines will reappear if user refreshes the page\n                        this._purchaseReceiptRecordManager.purchaseSession = {\n                            purchaseEntryTransaction: this._purchaseSession.purchaseEntryTransaction,\n                            purchaseReceipt: this._purchaseSession.purchaseReceipt,\n                            orderUnitToPurchaseUnitConversionFactor: 1,\n                        };\n                    }\n                },\n            },\n        ],\n    })\n], MobilePurchaseReceipt.prototype, \"receiptToCreate\", void 0);\nexports.MobilePurchaseReceipt = MobilePurchaseReceipt = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-purchasing/pages__mobile_purchase_receipt____title\", \"Purchase receipt\"),\n        module: 'x3-purchasing',\n        mode: 'default',\n        menuItem: receipt_1.receipt,\n        priority: 100,\n        isTransient: true,\n        isTitleHidden: true,\n        authorizationCode: 'CWSPTH',\n        access: { node: '@sage/x3-purchasing/PurchaseReceipt' },\n        async onLoad() {\n            if (!(await this._init())) {\n                this._disablePage();\n            }\n        },\n        businessActions() {\n            return [this.createButton];\n        },\n    })\n], MobilePurchaseReceipt);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-purchase-receipt.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts":
/*!***********************************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getSelectedStockSite = void 0;\nconst dialogs_1 = __webpack_require__(/*! ./dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\n/**\n * Return selected stock site for current application\n * @param pageInstance Current page instance\n * @param errorTitle error title when no default site exist\n * @param errorMessage error message when no default site exist\n * @returns default site or null\n */\nasync function getSelectedStockSite(pageInstance, errorTitle, errorMessage) {\n    const selectedSite = pageInstance.$.storage.get('mobile-selected-stock-site');\n    if (!selectedSite) {\n        // Please note that there asynchronous processing is not prefixed by an await on purpose\n        // so that it can be processed in parallel and not block the main process.\n        // Be careful not to leave the current page before the user has closed this dialog box.\n        pageInstance.$.sound.error();\n        (0, dialogs_1.dialogMessage)(pageInstance, 'error', errorTitle, errorMessage);\n        return null;\n    }\n    else {\n        return selectedSite.toString();\n    }\n}\nexports.getSelectedStockSite = getSelectedStockSite;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/get-selected-stock-site.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/on-goto.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/on-goto.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.onGoto = void 0;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\n/**\n * This allow to change page delayed\n * @param pageInstance current page instance\n * @param address page url\n * @param parameters optional parameters\n *\n */\n/** @internal */\nfunction onGoto(pageInstance, address, parameters) {\n    setTimeout(() => {\n        try {\n            pageInstance.$.removeToasts();\n            pageInstance.$.setPageClean();\n            pageInstance.$.router.goTo(address, parameters);\n        }\n        catch (error) {\n            ui.console.error(`Router goto failure :\\n${JSON.stringify(error) ?? ''}`);\n        }\n    }, 100);\n}\nexports.onGoto = onGoto;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4vLi4vc2hhcmVkL3gzLW1hc3Rlci1kYXRhL2xpYi9jbGllbnQtZnVuY3Rpb25zL29uLWdvdG8udHMiLCJtYXBwaW5ncyI6Ijs7O0FBQUEsdUVBQXFDO0FBRXJDOzs7Ozs7R0FNRztBQUNILGdCQUFnQjtBQUNoQixTQUFnQixNQUFNLENBQUMsWUFBcUIsRUFBRSxPQUFlLEVBQUUsVUFBZ0I7SUFDM0UsVUFBVSxDQUFDLEdBQUcsRUFBRTtRQUNaLElBQUksQ0FBQztZQUNELFlBQVksQ0FBQyxDQUFDLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDOUIsWUFBWSxDQUFDLENBQUMsQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUM5QixZQUFZLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLEtBQUssRUFBRSxDQUFDO1lBQ2IsRUFBRSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsMEJBQTBCLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM5RSxDQUFDO0lBQ0wsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxDQUFDO0FBQ1osQ0FBQztBQVZELHdCQVVDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8veHRyZW1BcnRpZmFjdC8uLi8uLi9zaGFyZWQveDMtbWFzdGVyLWRhdGEvbGliL2NsaWVudC1mdW5jdGlvbnMvb24tZ290by50cz8zYzdmIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHVpIGZyb20gJ0BzYWdlL3h0cmVtLXVpJztcblxuLyoqXG4gKiBUaGlzIGFsbG93IHRvIGNoYW5nZSBwYWdlIGRlbGF5ZWRcbiAqIEBwYXJhbSBwYWdlSW5zdGFuY2UgY3VycmVudCBwYWdlIGluc3RhbmNlXG4gKiBAcGFyYW0gYWRkcmVzcyBwYWdlIHVybFxuICogQHBhcmFtIHBhcmFtZXRlcnMgb3B0aW9uYWwgcGFyYW1ldGVyc1xuICpcbiAqL1xuLyoqIEBpbnRlcm5hbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIG9uR290byhwYWdlSW5zdGFuY2U6IHVpLlBhZ2UsIGFkZHJlc3M6IHN0cmluZywgcGFyYW1ldGVycz86IGFueSk6IHZvaWQge1xuICAgIHNldFRpbWVvdXQoKCkgPT4ge1xuICAgICAgICB0cnkge1xuICAgICAgICAgICAgcGFnZUluc3RhbmNlLiQucmVtb3ZlVG9hc3RzKCk7XG4gICAgICAgICAgICBwYWdlSW5zdGFuY2UuJC5zZXRQYWdlQ2xlYW4oKTtcbiAgICAgICAgICAgIHBhZ2VJbnN0YW5jZS4kLnJvdXRlci5nb1RvKGFkZHJlc3MsIHBhcmFtZXRlcnMpO1xuICAgICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgICAgdWkuY29uc29sZS5lcnJvcihgUm91dGVyIGdvdG8gZmFpbHVyZSA6XFxuJHtKU09OLnN0cmluZ2lmeShlcnJvcikgPz8gJyd9YCk7XG4gICAgICAgIH1cbiAgICB9LCAxMDApO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/on-goto.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/management-service-gs-1.ts":
/*!******************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/management-service-gs-1.ts ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.ManagementServiceGs1 = exports.errorMessageError = exports.errorMessageCheckYourEntry = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst barcode_parser_1 = __webpack_require__(/*! ../shared-functions/barcode-parser */ \"../../shared/x3-system/lib/shared-functions/barcode-parser.ts\");\nconst screen_management_gs_1_1 = __webpack_require__(/*! ./screen-management-gs-1 */ \"../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\");\nexports.errorMessageCheckYourEntry = `Check your entry for {{#each fieldNames}}\\n - {{this}}{{/each}}`;\nexports.errorMessageError = 'Error';\nclass ManagementServiceGs1 {\n    /**\n     * Initialize permanent data for page\n     * @param _storageKey       : storage key used for this page\n     */\n    constructor(_storageKey) {\n        this._storageKey = _storageKey;\n        // Private data area\n        /**\n         *  Store all codes GS 1 supported by access code (for speedup decoding)\n         */\n        /** @internal */\n        this._screenFieldsSupported = [];\n        /** @internal */\n        this._dictionarySegment = {};\n        /** @internal */\n        this._screenFieldsMapped = [];\n        /** @internal */\n        this._dictionaryDataComposites = {};\n        /** @internal */\n        this._abortDispatch = false;\n        /** @internal */\n        this._dispatchInProgress = false;\n        /** @internal */\n        this._initializationInProgress = false;\n        this._parseBarCode = new barcode_parser_1.ParseBarCode();\n    }\n    /**\n     * This Method build instance with retrieving all data\n     * @param pageInstance : current page\n     * @param dictionaryFieldSupported : page fields supported\n     * @param dictionaryDataComposites : extracted composite data, may be send to storage\n     * @param checkCompositeDataAllowed? : optional client callback to check composite data code before to dispatch them\n     */\n    async initialize(pageInstance, dictionaryFieldSupported = {}, dictionaryDataComposites = {}, checkCompositeDataAllowed) {\n        if (!pageInstance || !this._storageKey) {\n            throw new xtrem_shared_1.SystemError('Invalid arguments');\n        }\n        try {\n            this._dispatchInProgress = false;\n            this._initializationInProgress = true;\n            this._checkCompositeDataAllowed = checkCompositeDataAllowed;\n            // ui.console.warn(`Field(s) supported :\\n${JSON.stringify(dictionaryFieldSupported)}`);\n            // ui.console.warn(`Composite data :\\n${JSON.stringify(dictionaryDataComposites)}`);\n            // Process composite data before to continue\n            if (typesLib.gt(Object.keys(dictionaryDataComposites ?? {}).length, 0)) {\n                this.clearCompositeData();\n                // Erase storage\n                this._removeCompositeDataStorage(pageInstance);\n                this._dictionaryDataComposites = dictionaryDataComposites ?? {};\n            }\n            else {\n                this.loadCompositeData(pageInstance);\n            }\n            if (typesLib.gt(Object.keys(dictionaryFieldSupported ?? {}).length, 0)) {\n                await this.setScreenFieldSupported(pageInstance, dictionaryFieldSupported ?? {});\n                // mapped data has not deleted after dispatching\n                if (this.isExistsDataComposite && this.isExistsFieldsMapped) {\n                    if (this._beginDispatching()) {\n                        try {\n                            // use existing first segment field, temporary ignoring result\n                            const results = (await this._dispatchDataToFields(pageInstance, this._screenFieldsMapped[0].mainField, false).catch(() => false));\n                        }\n                        catch (error) {\n                            ui.console.error(`Error dispatching initial data :\\n${error}`);\n                        }\n                        finally {\n                            this._endingDispatching();\n                        }\n                    }\n                }\n            }\n        }\n        catch (error) {\n            ui.console.error(`Unexpected initialization error :\\n${error}`);\n        }\n        finally {\n            this._initializationInProgress = false;\n        }\n        return true;\n    }\n    /**\n     * Return if dispatch session is in progress\n     */\n    get isDispatchInProgress() {\n        return this._dispatchInProgress;\n    }\n    /**\n     * Return if initialization is in progress\n     */\n    get isInitializationInProgress() {\n        return this._initializationInProgress;\n    }\n    /**\n     * This function start dispatching\n     * @returns true when a new session has started, false when already in progress\n     */\n    /** @internal */\n    _beginDispatching() {\n        const oldDispatchInProgress = this._dispatchInProgress;\n        this._dispatchInProgress = true;\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        return !oldDispatchInProgress;\n    }\n    /**\n     * Terminate current dispatch session\n     * @returns true when session has been terminated, false when non session exist\n     */\n    /** @internal */\n    _endingDispatching() {\n        const oldDispatchInProgress = this._dispatchInProgress;\n        this._dispatchInProgress = false;\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        return oldDispatchInProgress;\n    }\n    /**\n     * Request to abort dispatch without error (end of scan) :\n     * This is used only when onChange() has performed some operations,\n     * ie : switching page... except when initialization is in progress\n     * @param {function}    optional callback to be executed approx. 100ms after end of dispatching.\n     * @returns {boolean}   true when request has be set\n     */\n    abortDispatch(postActionAbortDispatch) {\n        this._abortDispatch = false;\n        this._postActionAbortDispatch = undefined;\n        if (this._dispatchInProgress) {\n            this._abortDispatch = true;\n            if (!this.isInitializationInProgress) {\n                this._postActionAbortDispatch = postActionAbortDispatch;\n            }\n        }\n        return this.isAbortDispatchInProgress;\n    }\n    /**\n     * Return if abort dispatch session is requested\n     */\n    get isAbortDispatchInProgress() {\n        return this._abortDispatch;\n    }\n    /**\n     * Called when field update is in progress\n     * @param pageInstance current page\n     * @param currentField reference of field to updating\n     * @param rawData received raw data\n     * @param appendCompositeData true when is necessary to appending current date to previous set\n     * @return true when is not necessary to continue and affect a value : composite value has been processed\n     */\n    async scan(pageInstance, currentField, rawData, appendCompositeData = false) {\n        if (this._beginDispatching()) {\n            try {\n                let result = true;\n                // when is not a composite data, is not necessary to process\n                if (!rawData || typesLib.strictNe(typeof rawData, 'string') || typesLib.lt(rawData.length, 4) ||\n                    !Number(rawData.match(screen_management_gs_1_1.compositeCodePrefix)?.length) ||\n                    !(await this._decodeCompositeData(rawData, appendCompositeData))) {\n                    this._endingDispatching();\n                    return false;\n                }\n                // When composite data have skipped, nothing to do, report no errors\n                if (this.isExistsDataComposite) {\n                    let _postActionToDo;\n                    const _soundOriginalValue = await this._setSoundField(pageInstance, currentField, true);\n                    try {\n                        result = (await this._dispatchDataToFields(pageInstance, currentField).catch(() => false));\n                        // Special action to do after exiting a function\n                        if (result && this.isAbortDispatchInProgress && this._postActionAbortDispatch) {\n                            _postActionToDo = this._postActionAbortDispatch;\n                        }\n                    }\n                    finally {\n                        setTimeout(async () => {\n                            try {\n                                await this._setSoundField(pageInstance, currentField, _soundOriginalValue);\n                                if (_postActionToDo)\n                                    await _postActionToDo();\n                            }\n                            catch (error) {\n                                ui.console.error(`Dispatching post done action error :\\n${error}`);\n                            }\n                        }, 100);\n                    }\n                }\n                else {\n                    await this._clearField(pageInstance, currentField);\n                }\n                return result;\n            }\n            catch (error) {\n                ui.console.error(`Dispatching error :${error}`);\n            }\n            finally {\n                this._endingDispatching();\n            }\n        }\n        ui.console.error(`Dispatching not available`);\n        return false;\n    }\n    /**\n     * returns if the field support sound management\n     * @param originalField\n     * @returns\n     */\n    /** @internal */\n    _getIsSupportedSoundField(currentField) {\n        return currentField instanceof ui.fields.Reference || currentField instanceof ui.fields.FilterSelect;\n    }\n    /**\n     * When possible, changes the sound mode activation state and returns the old value\n     * @param currentField current field or undefined\n     * @param disableSound true for disable sound for this field\n     * @returns old value\n     */\n    /** @internal */\n    async _setSoundField(pageInstance, currentField, disableSound, refreshField = true) {\n        const originalIsSoundDisabled = currentField?.isSoundDisabled ?? false;\n        if (currentField && typesLib.strictNe(disableSound, originalIsSoundDisabled) && this._getIsSupportedSoundField(currentField)) {\n            currentField.isSoundDisabled = disableSound;\n            if (refreshField) {\n                await pageInstance.$.commitValueAndPropertyChanges();\n            }\n        }\n        return originalIsSoundDisabled;\n    }\n    /**\n     * Clear current UI field with null value and update page.\n     * @param pageInstance current page\n     * @param currentField current field to clear\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     */\n    /** @internal */\n    async _clearField(pageInstance, currentField, setFocus = true) {\n        currentField.value = null;\n        // Request all changes to page (optional field and unit) before any action\n        await pageInstance.$.commitValueAndPropertyChanges();\n        if (setFocus) {\n            currentField.focus();\n        }\n        // Force validation\n        await currentField.validate().catch(() => false);\n    }\n    /**\n     * Decode raw data to one or more data fields\n     * @param rawData raw composite data before decoding\n     * @param appendCompositeData may apply only when valid received data must be replace or append\n     * @returns true when data has valid and operation fully performed\n     */\n    /** @internal */\n    async _decodeCompositeData(rawData, appendCompositeData = false) {\n        const extractedComposite = {};\n        ui.console.debug(`initial data raw : ${JSON.stringify(rawData)}, size : ${rawData.length}`);\n        let parsedBarcode;\n        try {\n            parsedBarcode = this._parseBarCode.parseBarcode(rawData);\n            ui.console.debug(`RawData :\\n${rawData}\\nParsed code(s) :\\n${JSON.stringify(parsedBarcode)}`);\n        }\n        catch (error) {\n            ui.console.debug(`ERROR in parseBarcode :\\n${error}`);\n            return false;\n        }\n        /**\n         * When the block does not include a prefix or when it is not recognized by the parser,\n         * the GS1 composite code block requires in this case more than one AI code to be considered,\n         * as a single value could be incorrectly considered composite.\n         */\n        if (!parsedBarcode.parsedCodeItems.length ||\n            (typesLib.lt(parsedBarcode.parsedCodeItems.length, 2) && typesLib.strictEq(parsedBarcode.codeName, ''))) {\n            return false;\n        }\n        // Store data into composite data storage\n        for (const parsedCodeItem of parsedBarcode.parsedCodeItems) {\n            // Add a new data entry\n            extractedComposite[parsedCodeItem.elementDataTitle] = {\n                DataTitle: parsedCodeItem.elementDataTitle,\n                data: parsedCodeItem.data,\n                unit: parsedCodeItem.unit,\n            };\n        }\n        // ui.console.warn(`composite data existing : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // ui.console.warn(`composite data loaded : ${JSON.stringify(extractedComposite)}`);\n        // Dictionary update\n        if (!appendCompositeData) {\n            this.clearCompositeData();\n            this._dictionaryDataComposites = extractedComposite;\n        }\n        else {\n            for (const [key, value] of Object.entries(extractedComposite)) {\n                this._dictionaryDataComposites[key] = value;\n            }\n        }\n        // ui.console.debug(`composite data updated : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // before to map, check if allowed\n        if (!(await this._isDataCompositeAllowed())) {\n            this.clearCompositeData();\n            return true;\n        }\n        // mapping composite data to dataField without checking error condition\n        this._mappingFields();\n        // Sometimes no data is stored due to inactive code, this is not an error\n        return true;\n    }\n    /**\n     * Check if exists some fields loaded into service\n     */\n    get isExistsFieldsSupported() {\n        return typesLib.gt(Object.keys(this._screenFieldsSupported).length, 0);\n    }\n    /**\n     * Check if exists some fields mapped into service,\n     * ready to dispatch\n     */\n    get isExistsFieldsMapped() {\n        return typesLib.gt(this._screenFieldsMapped.length, 0);\n    }\n    /**\n     *\n     * @returns true when some composite data have been stored.\n     */\n    get isExistsDataComposite() {\n        return typesLib.gt(Object.keys(this._dictionaryDataComposites).length, 0);\n    }\n    /**\n     *\n     * @param field check current field is available\n     * @returns true if not available\n     */\n    /** @internal */\n    _isFieldNotAvailable(field) {\n        return (field?.isHidden || field?.isDisabled || field?.isReadOnly) ?? true;\n    }\n    /**\n     * @returns cloned dictionary data composite (must be empty)\n     */\n    /** @internal */\n    _cloneDictionaryDataComposite() {\n        const dictionaryDataComposite = {};\n        for (const [key, value] of Object.entries(this._dictionaryDataComposites)) {\n            dictionaryDataComposite[key] = value;\n        }\n        return dictionaryDataComposite;\n    }\n    /**\n     * Process client callback when exists to check data\n     * @returns Checks if the composite dataset can be processed\n     */\n    /** @internal */\n    async _isDataCompositeAllowed() {\n        // If any error occurs, the composite data block will be processed\n        try {\n            if (this._checkCompositeDataAllowed &&\n                this.isExistsDataComposite &&\n                !(await this._checkCompositeDataAllowed(this._cloneDictionaryDataComposite()))) {\n                return false;\n            }\n        }\n        catch (error) {\n            ui.console.error(`Error when evaluating data composite condition is allowed :\\n${error}`);\n        }\n        return true;\n    }\n    /**\n     * Update screen fields supported.\n     * field mapping was done after\n     * @param pageInstance current page\n     * @param dictionaryFieldSupported dictionary of page fields submitted\n     * @returns true when done, false when no any field to process with data\n     */\n    async setScreenFieldSupported(pageInstance, dictionaryFieldSupported) {\n        // Get only fields matching with active parameters\n        let index = 0;\n        const lastInitializationInProgress = this.isInitializationInProgress;\n        try {\n            this._initializationInProgress = true;\n            this._screenFieldsSupported =\n                this._existingFields(pageInstance, dictionaryFieldSupported).map(field => {\n                    const segmentsSupported = [];\n                    // Create segments allowed\n                    field.segments.forEach(segment => {\n                        const currentField = segment.currentField;\n                        segmentsSupported.push({\n                            currentField: currentField,\n                            onChange: segment.onChange,\n                        });\n                    });\n                    return {\n                        DataTitle: field.DataTitle,\n                        sequence: (index = typesLib.add(index, 1)),\n                        segments: segmentsSupported,\n                    };\n                }) ?? [];\n            // ui.console.debug(`Fields supported into page : ${JSON.stringify(this._screenFieldsSupported)}`);\n            // Map fields with existing composite data\n            return this._mappingFields();\n        }\n        catch (error) {\n            ui.console.error(`Error in setScreenFieldSupported :\\n${error}`);\n            return false;\n        }\n        finally {\n            this._initializationInProgress = lastInitializationInProgress;\n        }\n    }\n    /**\n     * This function map current fields with set of data\n     * @returns true when exists some fields with data mapped\n     */\n    /** @internal */\n    _mappingFields() {\n        // ui.console.debug(`Starting mapping, composite data : ${JSON.stringify(this._dictionaryDataComposites)}`);\n        // ui.console.debug(`Screen field(s) supported : ${JSON.stringify(this._screenFieldsSupported)}`);\n        // Extract active field\n        this._screenFieldsMapped = [];\n        let index = 0;\n        const mappingFields = [];\n        // No process only hidden fields\n        this._screenFieldsSupported\n            .filter(field => this._dictionaryDataComposites[field.DataTitle] &&\n            !field.segments.some(segment => segment.currentField.isHidden))\n            .sort((field1, field2) => typesLib.sub(field1.sequence, field2.sequence))\n            .forEach(item => {\n            const dataFieldMapped = {\n                DataTitle: item.DataTitle,\n                sequence: (index = typesLib.add(index, 1)),\n                mainField: item.segments[0].currentField,\n                onChangeMainField: item.segments[0].onChange,\n                data: this._dictionaryDataComposites[item.DataTitle]?.data,\n            };\n            // Add optional part\n            if (typesLib.gt(item.segments.length, 1) && item.segments[1]?.currentField) {\n                dataFieldMapped.unitField = item.segments[1].currentField;\n                dataFieldMapped.onChangeUnitField = item.segments[1].onChange;\n                dataFieldMapped.unit = this._dictionaryDataComposites[item.DataTitle]?.unit;\n            }\n            mappingFields.push(dataFieldMapped);\n        });\n        this._screenFieldsMapped = mappingFields;\n        // ui.console.debug(`Field(s) Mapped : ${JSON.stringify(this._screenFieldsMapped)}`);\n        return typesLib.gt(this._screenFieldsMapped.length, 0);\n    }\n    /**\n     * Remove fields definition\n     * @param removeCompositeData  : optionally remove composite data too\n     */\n    clearScreenFields(removeCompositeData = false) {\n        this._screenFieldsSupported = [];\n        this._screenFieldsMapped = [];\n        if (removeCompositeData) {\n            this.clearCompositeData();\n        }\n    }\n    /**\n     * Remove composite data\n     */\n    clearCompositeData() {\n        this._dictionaryDataComposites = {};\n    }\n    /**\n     * Remove composite data from storage\n     * @param pageInstance current page\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    clearCompositeDataStorage(pageInstance, storageKey) {\n        this._removeCompositeDataStorage(pageInstance, storageKey);\n    }\n    /**\n     * Remove all composite and storage data\n     * @param pageInstance current page\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    clearAllCompositeDataAndStorage(pageInstance, storageKey) {\n        this.clearCompositeData();\n        this.clearCompositeDataStorage(pageInstance, storageKey);\n    }\n    /**\n     * Load composite data from storage and then delete it there.\n     * @returns true when some data has been loaded\n     */\n    loadCompositeData(pageInstance) {\n        this.clearCompositeData();\n        try {\n            const dictionaryDataComposites = JSON.parse((pageInstance.$.storage.get(this._storageKey) ?? '{}'));\n            // ui.console.warn(`Composite data loaded :\\n${JSON.stringify(dictionaryDataComposites)}`);\n            // Erase storage\n            this._removeCompositeDataStorage(pageInstance);\n            if (typesLib.gt(Object.keys(dictionaryDataComposites).length, 0)) {\n                this._dictionaryDataComposites = dictionaryDataComposites;\n                // ui.console.warn(`Assigned :\\n${JSON.stringify(this._dictionaryDataComposites)}`);\n                return true;\n            }\n        }\n        catch (error) {\n            this.clearCompositeData();\n            this._removeCompositeDataStorage(pageInstance);\n            ui.console.error(`Error loading composite data from storage :\\n${error}`);\n        }\n        // ui.console.error(`No composite data`);\n        return this.isExistsDataComposite;\n    }\n    /**\n     * Save composite data, zero elements allowed\n     * @param pageInstance current page\n     * @returns true when operation has performed\n     */\n    saveCompositeData(pageInstance) {\n        if (pageInstance && this._storageKey && this.isExistsDataComposite) {\n            const dictionaryDataComposites = this._dictionaryDataComposites;\n            pageInstance.$.storage.set(this._storageKey, JSON.stringify(dictionaryDataComposites));\n            return true;\n        }\n        if (pageInstance) {\n            this._removeCompositeDataStorage(pageInstance);\n        }\n        return false;\n    }\n    /**\n     * Remove data from the storage\n     * @param pageInstance current page\n     */\n    /** @internal */\n    _removeCompositeDataStorage(pageInstance, storageKey) {\n        const isDataStorage = !!pageInstance && (!!this._storageKey || !!storageKey);\n        if (isDataStorage) {\n            pageInstance.$.storage.remove(storageKey ?? this._storageKey);\n        }\n        return isDataStorage;\n    }\n    /**\n     * assign date to page fields when existing and available\n     * @param pageInstance current page\n     * @param originalField original field (reserved)\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @returns false when dispatching failure occurs\n     */\n    /** @internal */\n    async _dispatchDataToFields(pageInstance, originalField, setFocus = false) {\n        const $items = pageInstance?._pageMetadata.layout.$items ?? [];\n        let isFailure = false;\n        let isOneFieldProcessed = false;\n        // ui.console.debug('Starting dispatching all fields');\n        if (typesLib.gt($items?.length, 0) && this.isExistsDataComposite) {\n            for (const field of this._screenFieldsMapped) {\n                if (field?.data) {\n                    if ((isFailure = !(await this._processField(pageInstance, field, setFocus).catch(() => false)))) {\n                        // ui.console.error(`Dispatching error, composite data has cleared`);\n                        this.clearCompositeData();\n                        break;\n                    }\n                    else {\n                        isOneFieldProcessed = true;\n                    }\n                }\n            }\n        }\n        // If no composite data could be assigned, it is an error\n        if (!isFailure && !isOneFieldProcessed) {\n            isFailure = true;\n            this.clearCompositeData();\n            this._clearField(pageInstance, originalField, setFocus);\n            ui.console.error(`Composite data was removed because none could be assigned, and field ${originalField?.id} was reset`);\n        }\n        // ui.console.debug(`Ending dispatching all fields : ${!isFailure}`);\n        return !isFailure;\n    }\n    /**\n     *\n     * @param pageInstance current page\n     * @param field current field already evaluated\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @returns true when item has found, but updated only when available\n     */\n    /** @internal */\n    async _processField(pageInstance, field, setFocus = false) {\n        const fieldsToRevalidate = [];\n        const onChangeCallbacks = [];\n        const mainField = field?.mainField;\n        const mainFieldId = mainField?.id ?? '';\n        const unitField = field?.unitField;\n        const unitFieldId = unitField?.id ?? '';\n        let validation = true;\n        let mainSoundOriginalValue = false;\n        let unitSoundOriginalValue = undefined;\n        try {\n            // process all subFields (segments) requested (main and optional unit)\n            // ui.console.debug(`_ProcessField (mapped fields) :\\n${JSON.stringify(field)}`);\n            // current field not currently available : don't process this field\n            if (!mainField || this._isFieldNotAvailable(mainField)) {\n                // ui.console.error(`Field ${mainFieldId} has unavailable`);\n                return true;\n            }\n            if (field?.data) {\n                if (unitField && field?.unit && this._isFieldNotAvailable(unitField)) {\n                    // ui.console.error(`Unit field ${unitFieldId} has unavailable`);\n                    return true;\n                }\n                mainSoundOriginalValue = await this._setSoundField(pageInstance, mainField, true);\n                // If not possible to change a value, composite block is invalid\n                switch (await this._setFieldValue(pageInstance, mainField, field?.data, setFocus)) {\n                    case null:\n                        // ui.console.warn(`Field ${mainFieldId} has no data available`);\n                        return false;\n                    case true:\n                        fieldsToRevalidate.push(mainField);\n                        if (field?.onChangeMainField) {\n                            onChangeCallbacks.push([mainFieldId, field.onChangeMainField]);\n                        }\n                        break;\n                }\n                // Process optional unit available with data\n                if (unitField && field?.unit && !this._isFieldNotAvailable(unitField)) {\n                    unitSoundOriginalValue = await this._setSoundField(pageInstance, unitField, true);\n                    switch (await this._setFieldValue(pageInstance, unitField, field.unit)) {\n                        case null:\n                            // ui.console.warn(`Unit field ${unitFieldId} has no data available`);\n                            return false;\n                        case true:\n                            fieldsToRevalidate.push(unitField);\n                            if (field?.onChangeUnitField) {\n                                onChangeCallbacks.push([unitFieldId, field.onChangeUnitField]);\n                            }\n                            break;\n                    }\n                }\n                // Request all changes to page (optional field and unit) before any action\n                await pageInstance.$.commitValueAndPropertyChanges();\n                // We only process with the case of modified fields\n                if (fieldsToRevalidate.length) {\n                    // Now process change / validation field segments\n                    for (const onChangeCallback of onChangeCallbacks) {\n                        const fieldId = onChangeCallback[0];\n                        const onChange = onChangeCallback[1];\n                        try {\n                            await onChange();\n                        }\n                        catch (error) {\n                            throw new xtrem_shared_1.SystemError(`onChange failure on field ${fieldId} :\\n${JSON.stringify(error)}`, error);\n                        }\n                        if (this.isAbortDispatchInProgress) {\n                            // ui.console.warn(`Aborting dispatching in progress for field ${fieldId}`);\n                            break;\n                        }\n                    }\n                    // CAUTION: when aborting is in progress, context may be invalid :\n                    // This behavior is taken into account by the possibility of abandoning dispatching,\n                    // and possibly executing a postDone action at the end. If possible, this action should\n                    // avoid being asynchronous for this reason.\n                    if (!this.isAbortDispatchInProgress) {\n                        // If we have performed at least one change action, we redo a commit of the page\n                        if (onChangeCallbacks.length) {\n                            await pageInstance.$.commitValueAndPropertyChanges();\n                        }\n                        // ui.console.debug(`Starting Validation`);\n                        for (const fieldToValidate of fieldsToRevalidate) {\n                            validation &&= (await fieldToValidate\n                                .validate()\n                                .then(data => typesLib.strictEq(data, undefined))\n                                .catch(() => false));\n                            if (!validation) {\n                                ui.console.warn(`Validation failure on field : ${fieldToValidate.id}`);\n                                break;\n                            }\n                        }\n                    }\n                }\n            }\n        }\n        catch (error) {\n            ui.console.error(`Error dispatching ${mainFieldId} :\\n${error?.message}`);\n            return false;\n        }\n        finally {\n            let isChanged = typesLib.strictNe((await this._setSoundField(pageInstance, mainField, mainSoundOriginalValue, false)), mainSoundOriginalValue);\n            if (typesLib.strictNe(unitSoundOriginalValue, undefined)) {\n                isChanged ||= typesLib.strictNe((await this._setSoundField(pageInstance, unitField, unitSoundOriginalValue, false)), unitSoundOriginalValue);\n            }\n            if (isChanged) {\n                await pageInstance.$.commitValueAndPropertyChanges();\n            }\n        }\n        return validation;\n    }\n    /**\n     * Assign value to field\n     * @param field current field\n     * @param value value to assign in the field\n     * @param setFocus optional value must be true when focus must be performed in reInitializing\n     * @return false if field has reinitialized, null when no change has performed (to more results)\n     */\n    /** @internal */\n    async _setFieldValue(pageInstance, field, value, setFocus = true) {\n        const originalValue = field.value;\n        let newValue;\n        if (field instanceof ui.fields.Reference) {\n            const result = await field.fetchSuggestions(value);\n            // We only update if there is a result otherwise the value will remain unchanged\n            if (!result.length) {\n                await pageInstance.$.sound.error();\n                await this._clearField(pageInstance, field, setFocus);\n                return false;\n            }\n            else {\n                newValue = result[0];\n                await pageInstance.$.sound.success();\n                if (typesLib.strictEq(result.length, 1)) {\n                    await pageInstance.$.sound.success();\n                }\n                else {\n                    /* Duplicate not supported, keep first result */\n                    await pageInstance.$.sound.success();\n                }\n            }\n        }\n        else if (field instanceof ui.fields.FilterSelect) {\n            newValue = value;\n        }\n        else if (field instanceof ui.fields.Text) {\n            newValue = String(value);\n        }\n        else if (field instanceof ui.fields.Numeric) {\n            newValue = Number(value);\n        }\n        else if (field instanceof ui.fields.Date) {\n            newValue = value instanceof xtrem_date_time_1.DateValue ? value.toString() : value;\n        }\n        else {\n            newValue = value;\n        }\n        field.value = newValue;\n        const isChanged = typesLib.strictNe(originalValue, newValue);\n        if (isChanged && !field.isDirty) {\n            field.isDirty = true;\n        }\n        return isChanged;\n    }\n    /**\n     * Convert a user field submitted by full segment reference before evaluation.\n     * @param dictionaryFieldsToPrepare fields to check to put in dictionary\n     * @returns Screen fields supported for internal use\n     */\n    /** @internal */\n    _prepareSegment(dictionaryFieldsToPrepare) {\n        // Reset internal dictionary\n        this._dictionarySegment = {};\n        const screenFieldsSupported = [];\n        for (const [key, field] of Object.entries(dictionaryFieldsToPrepare)) {\n            if (field) {\n                const screenFieldSupported = {\n                    DataTitle: key,\n                    sequence: -1,\n                    segments: [],\n                };\n                const mainField = field.mainField;\n                // Create directory entry now\n                screenFieldSupported.segments.push((this._dictionarySegment[mainField.id] = {\n                    currentField: mainField,\n                    onChange: field.onChangeMainField,\n                    sequence: -2,\n                }));\n                // Add unit too\n                const unitField = field.unitField;\n                if (unitField) {\n                    screenFieldSupported.segments.push((this._dictionarySegment[unitField.id] = {\n                        currentField: unitField,\n                        onChange: field.onChangeUnitField,\n                        sequence: -3,\n                    }));\n                }\n                screenFieldsSupported.push(screenFieldSupported);\n            }\n        }\n        return screenFieldsSupported;\n    }\n    /**\n     *  Analyze all fields existing\n     * @param pageInstance current page\n     * @param dictionaryFieldToCheck\n     * @returns\n     */\n    /** @internal */\n    _existingFields(pageInstance, dictionaryFieldToCheck) {\n        const $items = pageInstance?._pageMetadata.layout.$items ?? [];\n        const preparedFields = this._prepareSegment(dictionaryFieldToCheck);\n        const selectedFields = [];\n        const dictionarySegment = this._dictionarySegment;\n        let sequence = 0;\n        // ui.console.warn(`Dictionary prepared :\\n${JSON.stringify(dictionarySegment)}`);\n        // ui.console.warn(`Field prepared :\\n${JSON.stringify(preparedFields)}`);\n        // For now, the check does not test if the current field is available or not\n        if (typesLib.gt($items.length, 0) && typesLib.gt(preparedFields.length, 0)) {\n            // Start analysis\n            this._existFields(pageInstance, $items, dictionarySegment, (segments, field) => true, (segments, field) => {\n                field.sequence = (sequence = typesLib.add(sequence, 1));\n                return !Object.entries(segments).some(([key, value]) => typesLib.lte(value.sequence, 0));\n            });\n            // Remove invalid dictionary entries : Each field must be have all segments available\n            for (const [key, value] of Object.entries(dictionarySegment)) {\n                if (typesLib.lte(value.sequence, 0)) {\n                    delete dictionarySegment[key];\n                }\n            }\n        }\n        // Update internal dictionary now\n        this._dictionarySegment = dictionarySegment;\n        // Retain entry only with full segments\n        for (const key in preparedFields) {\n            const fields = preparedFields[key];\n            if (fields.segments.every(thisSegment => typesLib.strictEq(dictionarySegment[thisSegment.currentField.id]?.currentField.id, thisSegment.currentField.id))) {\n                selectedFields.push(fields);\n            }\n            else {\n                // Remove partial entries\n                for (const segment of fields.segments) {\n                    delete this._dictionarySegment[segment.currentField.id];\n                }\n            }\n        }\n        // ui.console.debug(`Dictionary updated :\\n${JSON.stringify(this._dictionarySegment)}`);\n        // ui.console.debug(`Prepared fields :\\n${JSON.stringify(preparedFields)}`);\n        // ui.console.debug(`Selected fields :\\n${JSON.stringify(selectedFields)}`);\n        return selectedFields;\n    }\n    /**\n     * Analyze list of fields submitted (recursive)\n     * @param pageInstance current page\n     * @param $items\n     * @param segments current segments list for field\n     * @param check verify is possible to use the field for action\n     * @param action perform action\n     * @returns\n     */\n    /** @internal */\n    _existFields(pageInstance, $items, segments, check, action) {\n        // Index from array\n        for (let i in $items) {\n            let $bind = undefined;\n            let pageField = undefined;\n            let field = undefined;\n            if (($bind = $items[i].$bind) && (pageField = pageInstance[$bind]) && (field = segments[pageField?.id])) {\n                // ui.console.debug(`Bind field : ${JSON.stringify($bind)}`);\n                if (check(segments, field) && action(segments, field)) {\n                    return true;\n                }\n                continue;\n            }\n            else {\n                // ui.console.debug(`Skipping binded field : ${JSON.stringify($bind)}`);\n                const $items2 = $items[i].$layout?.$items ?? [];\n                // recursively search for 'binded' components inside the layout's containers like section & blocks\n                if (typesLib.gt($items2.length, 0) && this._existFields(pageInstance, $items2, segments, check, action)) {\n                    return true;\n                }\n            }\n        }\n        return false;\n    }\n    /**\n     * Section page validation\n     * */\n    /**\n     * Perform validation of all segments managed\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageCheckYourEntry\n     * @returns\n     */\n    async validate(pageInstance, errorMessage = exports.errorMessageCheckYourEntry) {\n        const fieldErrors = new Array();\n        const isPageValid = await pageInstance.$.page.isValid;\n        let areAllFieldsValid = true;\n        for (const field of this._screenFieldsSupported) {\n            for (const segment of field.segments) {\n                if (!(await this._validateField(segment.currentField))) {\n                    areAllFieldsValid = false;\n                    fieldErrors.push(segment.currentField.id);\n                }\n            }\n        }\n        if (typesLib.gt(fieldErrors.length, 0)) {\n            this._notifyFieldNotValid(pageInstance, fieldErrors, errorMessage);\n        }\n        return isPageValid && areAllFieldsValid;\n    }\n    /**\n     * Perform field validation\n     * @param field current field\n     * @returns true when field is validated\n     */\n    /** @internal */\n    async _validateField(field) {\n        return !(await field.validate());\n    }\n    /**\n     * Notify all fields invalids\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageCheckYourEntry\n     * @param fields\n     */\n    /** @internal */\n    async _notifyFieldNotValid(pageInstance, fields, errorMessage = exports.errorMessageCheckYourEntry) {\n        pageInstance.$.removeToasts();\n        pageInstance.$.showToast((0, xtrem_shared_1.format)(errorMessage, 'base', {\n            fieldNames: fields.map(field => pageInstance[field]?.title),\n        }), { type: 'error', timeout: 5000 });\n    }\n    /**\n     * Validate current page\n     * @param pageInstance current page\n     * @param errorMessage translated message error errorMessageError\n     * @returns false when error occur\n     */\n    async validatePage(pageInstance, errorMessage = exports.errorMessageError) {\n        const errors = await pageInstance.$.page.validate();\n        if (!errors.length) {\n            return true;\n        }\n        const zz = pageInstance.$.removeToasts();\n        pageInstance.$.showToast(`${(0, xtrem_shared_1.format)(errorMessage, 'base')}: ${errors[0]}`, {\n            type: 'error',\n            timeout: 30000,\n        });\n        return false;\n    }\n    /**\n     * perform fields validation with detailed errors lists.\n     * @param pageInstance current page\n     * @param errorMessage errorMessageCheckYourEntry\n     * @returns false when error occur\n     */\n    async validateWithDetails(pageInstance, errorMessage = exports.errorMessageCheckYourEntry) {\n        // Request change to page\n        // to handle such edgy cases as user clearing an input from a field and then directly clicking on a button without blurring that field\n        await pageInstance.$.commitValueAndPropertyChanges();\n        const errors = await pageInstance.$.page.validateWithDetails();\n        if (!errors.length) {\n            return true;\n        }\n        pageInstance.$.removeToasts();\n        pageInstance.$.showToast((0, xtrem_shared_1.format)(errorMessage, 'base', {\n            fieldNames: errors.map((error) => `${pageInstance[error.elementId]?.title ?? error.elementId}`),\n        }), { type: 'error', timeout: 5000 });\n        return false;\n    }\n}\nexports.ManagementServiceGs1 = ManagementServiceGs1;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/management-service-gs-1.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts":
/*!*****************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\n/** Interfaces and types for management code GS 1 */\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.compositeCodePrefix = void 0;\nexports.compositeCodePrefix = /^(\\d{2,4}|\\][A-Za-z]\\d{3,5}|\\x1d\\d{2,4})/;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts":
/*!*******************************************************************************************!*\
  !*** ../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.SupportServiceManagementGs1Page = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst screen_management_gs_1_1 = __webpack_require__(/*! ./screen-management-gs-1 */ \"../../shared/x3-system/lib/client-functions/screen-management-gs-1.ts\");\nconst management_service_gs_1_1 = __webpack_require__(/*! ./management-service-gs-1 */ \"../../shared/x3-system/lib/client-functions/management-service-gs-1.ts\");\nconst defaultManagementServiceKey = 'DEFAULT_MOBILE_COMPOSITE_GS_1_DATA_KEY';\nclass SupportServiceManagementGs1Page extends ui.Page {\n    /**\n     * Internal only\n     */\n    constructor() {\n        super();\n        /**\n         * Used only for disable scan operation (service must stay active)\n         */\n        /** @internal */\n        this._disableServiceGs1 = false;\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);\n    }\n    /**\n     * Initialize ControlManagerGs1\n     *\n     * @param site current site\n     * @param compositePageKey key for storage operation\n     * @param dictionaryFieldSupported fields screen to manage and control\n     * @param dictionaryDataComposites? optional composite data\n     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them\n     * @returns true when ControlManagerGs1 has usable\n     */\n    /** @internal */\n    async _createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(compositePageKey);\n        // Including erroneous field misspelled dateTestFake instead dateTest\n        if (site && compositePageKey) {\n            if ((await this._controlManagerGs1\n                .initialize(this, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed)\n                .catch(() => false))) {\n                return true;\n            }\n            else {\n                // Error detected, abort controller\n                ui.console.error(`Service initialization failure for site ${site}`);\n            }\n        }\n        // Initialization failure : reset to default instance\n        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);\n        return false;\n    }\n    /**\n     * Protected only\n     */\n    /**\n     * Return current state of service\n     */\n    /** @protected */\n    get isServiceGs1Disabled() {\n        return this._disableServiceGs1;\n    }\n    /**\n     * Disable or enable service (default : enable) :\n     * Disabling clearing all composite data\n     */\n    /** @protected */\n    set disableServiceGs1(disableServiceGs1) {\n        this._disableServiceGs1 = disableServiceGs1;\n        if (this._disableServiceGs1) {\n            this._controlManagerGs1.clearCompositeData();\n        }\n    }\n    /**\n     * Get current control manager instance\n     */\n    /** @protected */\n    get controlManagerGs1() {\n        return this._controlManagerGs1;\n    }\n    /**\n     * Remove composite data\n     */\n    /** @protected */\n    clearCompositeData() {\n        this._controlManagerGs1.clearCompositeData();\n    }\n    /**\n     * Remove composite data from storage\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    /** @protected */\n    clearCompositeDataStorage(storageKey) {\n        this._controlManagerGs1.clearCompositeDataStorage(this, storageKey);\n    }\n    /**\n     * Remove all composite and storage data\n     * @param storageKey optional, for overriding current service key (use with caution)\n     */\n    /** @protected */\n    clearAllCompositeDataAndStorage(storageKey) {\n        this._controlManagerGs1.clearAllCompositeDataAndStorage(this, storageKey);\n    }\n    /**\n     * Create and initialize manager for a given service :\n     * manager stay available only when site has defined and initialization is done.\n     *\n     * @param site current site\n     * @param compositePageKey key for storage operation\n     * @param dictionaryFieldSupported fields screen to manage and control\n     * @param dictionaryDataComposites? optional composite data\n     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them\n     * @return false when service has not properly initialized (unavailable)\n     */\n    /** @protected */\n    async createAndInitServiceGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {\n        if (!site ||\n            !(await this._createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed))) {\n            ui.console.error(`Unable to initialize service control manager Gs 1 for site ${site}`);\n            return false;\n        }\n        return true;\n    }\n    /**\n     * Load composite data from storage and erase them\n     * @returns true when some data has been loaded\n     */\n    /** @protected */\n    loadCompositeData() {\n        return this._controlManagerGs1.loadCompositeData(this);\n    }\n    /**\n     * Save composite data, zero elements allowed\n     * @returns true when operation has performed\n     */\n    /** @protected */\n    saveCompositeData() {\n        return this._controlManagerGs1.saveCompositeData(this);\n    }\n    /**\n     * call scan evaluator only when manager available and rawData has minimum requirement\n     * @param mainField current screen field reference\n     * @param rawData data to parse\n     * @return false when is not a bar code composite\n     */\n    /** @protected */\n    async scanBarCode(mainField, rawData) {\n        // class must be created, initialized and not busy, data must be started by a numeric value,\n        // minimum size 2 to 4 numerics or prefix ]<alphabetic><numeric>\n        if (!(this._disableServiceGs1 ?? false) && typesLib.gt(rawData.length, 4) &&\n            Number(rawData.match(screen_management_gs_1_1.compositeCodePrefix)?.length)) {\n            return (await this._controlManagerGs1\n                .scan(this, mainField, rawData)\n                .catch(() => false));\n        }\n        return false;\n    }\n    /**\n     * Update screen fields supported (only when exists Gs1 parameters).\n     * mapping field has been performed after\n     * @param dictionaryFieldSupported dictionary of page fields submitted\n     * @returns true when done, false when no any field to process with data\n     */\n    async setScreenFieldSupported(dictionaryFieldSupported) {\n        return await this._controlManagerGs1.setScreenFieldSupported(this, dictionaryFieldSupported);\n    }\n}\nexports.SupportServiceManagementGs1Page = SupportServiceManagementGs1Page;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/client-functions/support-service-management-gs-1-page.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/barcode-parser.ts":
/*!*********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/barcode-parser.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.parseBarcode = exports.ParseBarCode = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\n/**\n * P. Brockfeld, 2014-02-05\n *\n * JavaScript for parsing GS1 barCodes, see\n *\n * https://github.com/hprange/BarcodeParser (active fork)\n *\n * https://github.com/PeterBrockfeld/BarcodeParser (original repo)\n *\n * for details.\n */\nconst xtrem_date_time_1 = __webpack_require__(/*! @sage/xtrem-date-time */ \"@sage/xtrem-date-time\");\nconst xtrem_shared_1 = __webpack_require__(/*! @sage/xtrem-shared */ \"@sage/xtrem-shared\");\nconst parsed_element_1 = __webpack_require__(/*! ./parsed-element */ \"../../shared/x3-system/lib/shared-functions/parsed-element.ts\");\n/**\n * This section store internal errors\n */\nvar ErrorMessages;\n(function (ErrorMessages) {\n    ErrorMessages[\"invalidAIAfter0\"] = \"invalid AI after '0'\";\n    ErrorMessages[\"invalidAIAfter1\"] = \"invalid AI after '1'\";\n    ErrorMessages[\"invalidAIAfter24\"] = \"invalid AI after '24'\";\n    ErrorMessages[\"invalidAIAfter25\"] = \"invalid AI after '25'\";\n    ErrorMessages[\"invalidAIAfter2\"] = \"invalid AI after '2'\";\n    ErrorMessages[\"invalidAIAfter31\"] = \"invalid AI after '31'\";\n    ErrorMessages[\"invalidAIAfter32\"] = \"invalid AI after '32'\";\n    ErrorMessages[\"invalidAIAfter33\"] = \"invalid AI after '33'\";\n    ErrorMessages[\"invalidAIAfter34\"] = \"invalid AI after '34'\";\n    ErrorMessages[\"invalidAIAfter35\"] = \"invalid AI after '35'\";\n    ErrorMessages[\"invalidAIAfter36\"] = \"invalid AI after '36'\";\n    ErrorMessages[\"invalidAIAfter39\"] = \"invalid AI after '39'\";\n    ErrorMessages[\"invalidAIAfter3\"] = \"invalid AI after '3'\";\n    ErrorMessages[\"invalidAIAfter40\"] = \"invalid AI after '40'\";\n    ErrorMessages[\"invalidAIAfter41\"] = \"invalid AI after '41'\";\n    ErrorMessages[\"invalidAIAfter42\"] = \"invalid AI after '42'\";\n    ErrorMessages[\"invalidAIAfter4\"] = \"invalid AI after '4'\";\n    ErrorMessages[\"invalidAIAfter700\"] = \"invalid AI after '700'\";\n    ErrorMessages[\"invalidAIAfter70\"] = \"invalid AI after '70'\";\n    ErrorMessages[\"invalidAIAfter71\"] = \"invalid AI after '71'\";\n    ErrorMessages[\"invalidAIAfter7\"] = \"invalid AI after '7'\";\n    ErrorMessages[\"invalidAIAfter800\"] = \"invalid AI after '800'\";\n    ErrorMessages[\"invalidAIAfter801\"] = \"invalid AI after '801'\";\n    ErrorMessages[\"invalidAIAfter802\"] = \"invalid AI after '802'\";\n    ErrorMessages[\"invalidAIAfter80\"] = \"invalid AI after '80'\";\n    ErrorMessages[\"invalidAIAfter810\"] = \"invalid AI after '810'\";\n    ErrorMessages[\"invalidAIAfter811\"] = \"invalid AI after '811'\";\n    ErrorMessages[\"invalidAIAfter81\"] = \"invalid AI after '81'\";\n    ErrorMessages[\"invalidAIAfter82\"] = \"invalid AI after '82'\";\n    ErrorMessages[\"invalidAIAfter8\"] = \"invalid AI after '8'\";\n    ErrorMessages[\"invalidAIAfter9\"] = \"invalid AI after '9'\";\n    ErrorMessages[\"noValidAI\"] = \"no valid AI\";\n    ErrorMessages[\"invalidNumber\"] = \"invalid number\";\n    ErrorMessages[\"invalidFixedSizeInParse\"] = \"invalid fixed size in parse\";\n    ErrorMessages[\"invalidVariableSizeInParse\"] = \"invalid variable size in parse\";\n    ErrorMessages[\"invalidFixedSizeMeasureInParse\"] = \"invalid fixed size measure in parse\";\n    ErrorMessages[\"invalidVariableSizeMeasureInParse\"] = \"invalid variable size measure in parse\";\n    ErrorMessages[\"invalidVariableSizeWithISONumbersInParse\"] = \"invalid variable size with ISO numbers in parse\";\n    ErrorMessages[\"invalidVariableSizeWithISOCharsInParse\"] = \"invalid variable size with ISO chars in parse\";\n    ErrorMessages[\"invalidDateSizeInParse\"] = \"invalid date size in parse\";\n})(ErrorMessages || (ErrorMessages = {}));\nclass ParseBarCode {\n    constructor(codeString = '') {\n        // Main function\n        /* @internal */\n        this._codeString = '';\n        /* @internal */\n        this._codeStringLength = this.codeString.length;\n        this._codeString = codeString;\n        this._fncChar = String.fromCharCode(29); // the ASCII \"group separator\"\n    }\n    /**\n     * Special separator of variable record\n     */\n    get fncChar() {\n        return this._fncChar;\n    }\n    /**\n     * String before change\n     */\n    get codeString() {\n        return this._codeString;\n    }\n    set codeString(codeString) {\n        this._codeString = codeString;\n        this._codeStringLength = codeString.length;\n    }\n    /**\n     * String length before change\n     */\n    get codeStringLength() {\n        return this._codeStringLength;\n    }\n    /** Evaluate barcode received */\n    parseBarcode(barcode) {\n        const barCodeLength = barcode.length;\n        const answer = {}; // the object to return\n        let restOfBarcode = ''; // the rest of the barcode, when first\n        // elements are spliced away\n        const symbologyIdentifier = barcode.slice(0, 3);\n        let firstElement = {};\n        /**\n         * =========== BEGIN of main routine ===================\n         */\n        /**\n         *\n         * ==== First step: ====\n         *\n         * IF there is any symbology identifier\n         *   chop it off;\n         *   put as \"codeName\" into the answer;\n         *   fill restOfBarcode with the rest\n         *   after the symbology identifier;\n         * ELSE\n         *   leave \"codeName\" empty;\n         *   put the whole barcode into restOfBarcode;\n         */\n        if (barcode.startsWith(this.fncChar)) {\n            answer.codeName = 'GS1-128';\n            restOfBarcode = barcode.slice(1, barCodeLength);\n        }\n        else {\n            switch (symbologyIdentifier) {\n                case ']C1':\n                    answer.codeName = 'GS1-128';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']e0':\n                    answer.codeName = 'GS1 DataBar';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']e1':\n                case ']e2':\n                    answer.codeName = 'GS1 Composite';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']d2':\n                    answer.codeName = 'GS1 DataMatrix';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                case ']Q3':\n                    answer.codeName = 'GS1 QR Code';\n                    restOfBarcode = barcode.slice(3, barCodeLength);\n                    break;\n                default:\n                    answer.codeName = '';\n                    restOfBarcode = barcode;\n                    break;\n            }\n        }\n        /**\n         * we have chopped off any symbology identifier. Now we can\n         * try to parse the rest. It should give us an array of\n         * ParsedElements.\n         */\n        /**\n         * ===== Second step: ====\n         *\n         * Parse \"barcode\" data element by data element using\n         * identifyAI.\n         *\n         */\n        answer.parsedCodeItems = [];\n        /**\n         * The following part calls \"identifyAI\" in a loop, until\n         * the whole barcode is parsed (or an error occurs).\n         *\n         * It uses the following strategy:\n         *\n         *   try to parse the part after the symbology identifier:\n         *   - identify the first AI;\n         *   - make a parsed element from the part after the AI;\n         *   - append the parsed element to answer;\n         *   - chop off the parsed part;\n         *  do so while there is left something to parse;\n         */\n        while (typesLib.gt(restOfBarcode.length, 0)) {\n            try {\n                firstElement = this._identifyAI(restOfBarcode);\n                restOfBarcode = firstElement.codeString;\n                answer.parsedCodeItems.push(firstElement.element);\n            }\n            catch (e) {\n                throw new xtrem_shared_1.SystemError(e.message, e);\n            }\n        }\n        /**\n         * ==== Third and last step: =====\n         *\n         */\n        return answer;\n    }\n    // auxillary functions\n    /**\n     * \"ParsedElement\" is the\n     *\n     * @constructor for ParsedElements, the components of the array returned by parseBarcode\n     * @param {String} elementAI        the AI of the recognized element\n     * @param {String} elementDataTitle the title of the element, i.e. its short description\n     * @param {String} elementType      a one-letter string describing the type of the element.\n     *                                  allowed values are\n     *                                  \"string\" for strings,\n     *                                  \"numeric\" for numbers and\n     *                                  \"date\" for dates\n     */\n    /**\n     *\n     * ================== BEGIN of identifyAI =======================\n     *\n     * does the main work:\n     *   what AI is in the beginning of the restOfBarcode?\n     *     If identified:\n     *       which function to call with\n     *       which parameters to parse the element?[Description]]\n     * @param   {String} codeString a string; the function tries to\n     *                   identify an AI in the beginning of this string\n     * @returns {Object} if it succeeds in identifying an AI the\n     *                   ParsedElement is returned with, together with the\n     *                   still unparsed rest of codeString.\n     */\n    _identifyAI(codeString) {\n        // find first identifier. AIs have a minimum length of 2\n        // digits, some have 3, some even 4.\n        const firstNumber = codeString.slice(0, 1);\n        const secondNumber = codeString.slice(1, 2);\n        let parsedElementAndCode;\n        this.codeString = codeString;\n        /**\n         *\n         * ======= BEGIN of the big switch =======================\n         *\n         * and now a very big \"switch\", which tries to find a valid\n         * AI within the first digits of the codeString.\n         *\n         * See the documentation for an explanation why it is made\n         * this way (and not by some configuration file).\n         */\n        switch (firstNumber) {\n            case '0':\n                parsedElementAndCode = this._evaluateCodeStartWith0(secondNumber);\n                break;\n            case '1':\n                parsedElementAndCode = this._evaluateCodeStartWith1(secondNumber);\n                break;\n            case '2':\n                parsedElementAndCode = this._evaluateCodeStartWith2(secondNumber);\n                break;\n            case '3':\n                parsedElementAndCode = this._evaluateCodeStartWith3(secondNumber);\n                break;\n            case '4':\n                parsedElementAndCode = this._evaluateCodeStartWith4(secondNumber);\n                break;\n            // first digits 5 and 6 are not used\n            case '7':\n                parsedElementAndCode = this._evaluateCodeStartWith7(secondNumber);\n                break;\n            case '8':\n                parsedElementAndCode = this._evaluateCodeStartWith8(secondNumber);\n                break;\n            case '9':\n                parsedElementAndCode = this._evaluateCodeStartWith9(secondNumber);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.noValidAI);\n        }\n        /**\n         *\n         * ======= END of the big switch =======================\n         *\n         * now identifyAI has just to return the new\n         * ParsedElement (create by one of the parsing\n         * functions) and the (cleaned) rest of codeString.\n         */\n        return {\n            element: parsedElementAndCode.element,\n            codeString: this._cleanCodeString(parsedElementAndCode.codeString),\n        };\n    }\n    _evaluateCodeStartWith0(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // SSCC (Serial Shipping Container Code)\n                parsedElementAndCode = this._parseFixedLength('00', parsed_element_1.DataTitle.sscc, 18);\n                break;\n            case '1':\n                // Global Trade Item Number (GTIN)\n                parsedElementAndCode = this._parseFixedLength('01', parsed_element_1.DataTitle.gtin, 14);\n                break;\n            case '2':\n                // GTIN of Contained Trade Items\n                parsedElementAndCode = this._parseFixedLength('02', parsed_element_1.DataTitle.content, 14);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter0);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith1(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Batch or Lot Number\n                parsedElementAndCode = this._parseVariableLength('10', parsed_element_1.DataTitle.batchLot, 20);\n                break;\n            case '1':\n                // Production Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('11', parsed_element_1.DataTitle.prodDate);\n                break;\n            case '2':\n                // Due Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('12', parsed_element_1.DataTitle.dueDate);\n                break;\n            case '3':\n                // Packaging Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('13', parsed_element_1.DataTitle.packDate);\n                break;\n            // AI \"14\" isn't defined\n            case '5':\n                // Best Before Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('15', parsed_element_1.DataTitle.bestBefore);\n                break;\n            case '6':\n                // Sell By Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('16', parsed_element_1.DataTitle.sellBy);\n                break;\n            case '7':\n                // Expiration Date (YYMMDD)\n                parsedElementAndCode = this._parseDate('17', parsed_element_1.DataTitle.expiryDate);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter1);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith2(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Variant Number\n                parsedElementAndCode = this._parseFixedLength('20', parsed_element_1.DataTitle.variant, 2);\n                break;\n            case '1':\n                // Serial Number\n                parsedElementAndCode = this._parseVariableLength('21', parsed_element_1.DataTitle.serial, 20);\n                break;\n            case '2':\n                // Consumer product variant\n                parsedElementAndCode = this._parseVariableLength('22', parsed_element_1.DataTitle.cpv, 20);\n                break;\n            // AI 23 is not defined\n            case '4':\n                // from now, the third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith24(this.codeString.slice(2, 3));\n                break;\n            case '5':\n                // from now, the third number matters:\n                parsedElementAndCode = this._evaluateCodeStartWith25(this.codeString.slice(2, 3));\n                break;\n            // AI \"26\" to \"29\" aren't defined\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter2);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith24(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Additional Item Identification\n                parsedElementAndCode = this._parseVariableLength('240', parsed_element_1.DataTitle.additionalId, 30);\n                break;\n            case '1':\n                // Customer Part Number\n                parsedElementAndCode = this._parseVariableLength('241', parsed_element_1.DataTitle.customPartNumber, 30);\n                break;\n            case '2':\n                // Made-to-Order Variation Number\n                parsedElementAndCode = this._parseVariableLength('242', parsed_element_1.DataTitle.mtoVariant, 6);\n                break;\n            case '3':\n                // Packaging Component Number\n                parsedElementAndCode = this._parseVariableLength('243', parsed_element_1.DataTitle.pcn, 20);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter24);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith25(thirdNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Secondary Serial Number\n                parsedElementAndCode = this._parseVariableLength('250', 'SECONDARY SERIAL', 30);\n                break;\n            case '1':\n                // Reference to Source Entity\n                parsedElementAndCode = this._parseVariableLength('251', 'REF. TO SOURCE', 30);\n                break;\n            // AI \"252\" isn't defined\n            case '3':\n                // Global Document Type Identifier (GDTI)\n                parsedElementAndCode = this._parseVariableLength('253', 'GDTI', typesLib.add(13, 17));\n                break;\n            case '4':\n                // GLN Extension Component\n                parsedElementAndCode = this._parseVariableLength('254', 'GLN EXTENSION COMPONENT', 20);\n                break;\n            case '5':\n                // Global Coupon Number (GCN)\n                parsedElementAndCode = this._parseVariableLength('255', 'GCN', typesLib.add(13, 12));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter25);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith3(secondNumber) {\n        let parsedElementAndCode;\n        switch (secondNumber) {\n            case '0':\n                // Count of Items (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseVariableLength('30', parsed_element_1.DataTitle.varCount, 8);\n                break;\n            case '1':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith31(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '2':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith32(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '3':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith33(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '4':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith34(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '5':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith35(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '6':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith36(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            case '7':\n                // Count of Trade Items\n                parsedElementAndCode = this._parseVariableLength('37', 'COUNT', 8);\n                break;\n            // AI \"38\" isn't defined\n            case '9':\n                // third and fourth numbers matter:\n                parsedElementAndCode = this._evaluateCodeStartWith39(this.codeString.slice(2, 3), this.codeString.slice(3, 4));\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter3);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith31(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net weight, kilograms (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('310', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.KILOGRAM);\n                break;\n            case '1':\n            // 1 - Length or first dimension, metres (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '2':\n            // 2 - Width, diameter, or second dimension, metres (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '3':\n                // 3 - Depth, thickness, height, or third dimension, metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`31${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '4':\n                // Area, square metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('314', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_METER);\n                break;\n            case '5':\n                // Net volume, litres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('315', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.LITER);\n                break;\n            case '6':\n                // Net volume, cubic metres (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('316', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.CUBIC_METER);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter31);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith32(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net weight, pounds (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('320', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.POUND);\n                break;\n            case '1':\n            // 1 - Length or first dimension, inches (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '4':\n            // 4 - Width, diameter, or second dimension, inches (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '7':\n                // 7 - Depth, thickness, height, or third dimension, inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.width, parsed_element_1.UnitOfMeasure.INCH);\n                break;\n            case '2':\n            // 2 - Length or first dimension, feet (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '5':\n            // 5 - Width, diameter, or second dimension, feet (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '8':\n                // 8 - Depth, thickness, height, or third dimension, feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.FOOT);\n                break;\n            case '3':\n            // 3 - Length or first dimension, yards (Variable Measure Trade Item)\n            // eslint-disable-next-line no-fallthrough\n            case '6':\n            // 6 - Width, diameter, or second dimension, yards (Variable Measure Trade Item\n            // eslint-disable-next-line no-fallthrough\n            case '9':\n                // 9 - Depth, thickness, height, or third dimension, yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure(`32${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter32);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith33(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Logistic weight, kilograms\n                parsedElementAndCode = this._parseFixedLengthMeasure('330', fourthNumber, parsed_element_1.DataTitle.grossWeight, parsed_element_1.UnitOfMeasure.KILOGRAM);\n                break;\n            case '1':\n                // Length or first dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('331', fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '2':\n                // Width, diameter, or second dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('332', fourthNumber, parsed_element_1.DataTitle.width, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '3':\n                // Depth, thickness, height, or third dimension, metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('333', fourthNumber, parsed_element_1.DataTitle.height, parsed_element_1.UnitOfMeasure.METER);\n                break;\n            case '4':\n                // Area, square metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('334', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_METER);\n                break;\n            case '5':\n                // Logistic volume, litres\n                parsedElementAndCode = this._parseFixedLengthMeasure('335', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.LITER);\n                break;\n            case '6':\n                // Logistic volume, cubic metres\n                parsedElementAndCode = this._parseFixedLengthMeasure('336', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_METER);\n                break;\n            case '7':\n                // Kilograms per square metre, yes, the ISO code for this _is_ \"28\".\n                parsedElementAndCode = this._parseFixedLengthMeasure('337', fourthNumber, parsed_element_1.DataTitle.kgPerSquareMeter, parsed_element_1.UnitOfMeasure._28);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter33);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith34(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // 340 - Logistic weight, pounds\n                parsedElementAndCode = this._parseFixedLengthMeasure('340', fourthNumber, parsed_element_1.DataTitle.grossWeight, parsed_element_1.UnitOfMeasure.POUND);\n                break;\n            case '1':\n            // 341 - Length or first dimension, inches\n            // eslint-disable-next-line no-fallthrough\n            case '4':\n            // 344 - Width, diameter, or second dimension, inches\n            // eslint-disable-next-line no-fallthrough\n            case '7':\n                // 347 - Depth, thickness, height, or third dimension, inches\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.INCH);\n                break;\n            case '2':\n            // 342 - Length or first dimension, feet\n            // eslint-disable-next-line no-fallthrough\n            case '5':\n            // 345 - Width, diameter, or second dimension, feet\n            // eslint-disable-next-line no-fallthrough\n            case '8':\n                // 348 - Depth, thickness, height, or third dimension, feet\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.FOOT);\n                break;\n            case '3':\n            // 343 - Length or first dimension, yards\n            // eslint-disable-next-line no-fallthrough\n            case '6':\n            // 346 - Width, diameter, or second dimension, yard\n            // eslint-disable-next-line no-fallthrough\n            case '9':\n                // 349 - Depth, thickness, height, or third dimension, yards\n                parsedElementAndCode = this._parseFixedLengthMeasure(`34${thirdNumber}`, fourthNumber, parsed_element_1.DataTitle.length, parsed_element_1.UnitOfMeasure.YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter34);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith35(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Area, square inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('350', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_INCH);\n                break;\n            case '1':\n                // Area, square feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('351', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_FOOT);\n                break;\n            case '2':\n                // Area, square yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('352', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_YARD);\n                break;\n            case '3':\n                // Area, square inches\n                parsedElementAndCode = this._parseFixedLengthMeasure('353', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_INCH);\n                break;\n            case '4':\n                // Area, square feet\n                parsedElementAndCode = this._parseFixedLengthMeasure('354', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_FOOT);\n                break;\n            case '5':\n                // Area, square yards\n                parsedElementAndCode = this._parseFixedLengthMeasure('355', fourthNumber, parsed_element_1.DataTitle.area, parsed_element_1.UnitOfMeasure.SQUARE_YARD);\n                break;\n            case '6':\n                // Net weight, troy ounces (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('356', fourthNumber, parsed_element_1.DataTitle.netWeight, parsed_element_1.UnitOfMeasure.TROY_OUNCES);\n                break;\n            case '7':\n                // Net weight (or volume), ounces (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('357', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.OUNCE);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter35);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith36(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Net volume, quarts (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('360', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.QUART);\n                break;\n            case '1':\n                // Net volume, gallons U.S. (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('361', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.GALLON);\n                break;\n            case '2':\n                // Logistic volume, quarts\n                parsedElementAndCode = this._parseFixedLengthMeasure('362', fourthNumber, parsed_element_1.DataTitle.netVolume, parsed_element_1.UnitOfMeasure.QUART);\n                break;\n            case '3':\n                // Logistic volume, gallons U.S.\n                parsedElementAndCode = this._parseFixedLengthMeasure('363', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.GALLON);\n                break;\n            case '4':\n                // Net volume, cubic inches (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('364', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_INCH);\n                break;\n            case '5':\n                // Net volume, cubic feet (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('365', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_FOOT);\n                break;\n            case '6':\n                // Net volume, cubic yards (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseFixedLengthMeasure('366', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_YARD);\n                break;\n            case '7':\n                // Logistic volume, cubic inches\n                parsedElementAndCode = this._parseFixedLengthMeasure('367', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_INCH);\n                break;\n            case '8':\n                // Logistic volume, cubic feet\n                parsedElementAndCode = this._parseFixedLengthMeasure('368', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_FOOT);\n                break;\n            case '9':\n                // Logistic volume, cubic yards\n                parsedElementAndCode = this._parseFixedLengthMeasure('369', fourthNumber, parsed_element_1.DataTitle.volume, parsed_element_1.UnitOfMeasure.CUBIC_YARD);\n                break;\n            default:\n                throw new xtrem_shared_1.SystemError(ErrorMessages.invalidAIAfter36);\n        }\n        return parsedElementAndCode;\n    }\n    _evaluateCodeStartWith39(thirdNumber, fourthNumber) {\n        let parsedElementAndCode;\n        switch (thirdNumber) {\n            case '0':\n                // Applicable Amount Payable, local currency\n                parsedElementAndCode = this._parseVariableLengthMeasure('390', fourthNumber, parsed_element_1.DataTitle.amount, 15);\n                break;\n            case '1':\n                // Applicable Amount Payable with ISO Currency Code\n                parsedElementAndCode = this._parseVariableLengthWithISONumbers('391', fourthNumber, parsed_element_1.DataTitle.amount, 15);\n                break;\n            case '2':\n                // Applicable Amount Payable, single monetary area (Variable Measure Trade Item)\n                parsedElementAndCode = this._parseVariableLengthMeasure('392', fourthNumber, parsed_element_1.DataTitle.price, 15);\n                break;\n            case '3':\n                // Applicable Amount Payable with ISO Currency Code (Variable Measure Trade Item)\n                parsedElementAndC