import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, date, Reference, integer, decimal } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseShipment extends Node {
    readonly id: Promise<string>;
    readonly shipmentId: Promise<string>;
    readonly shipDate: Promise<date | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly site: Reference<sageX3System.nodes.Site | null>;
    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
    readonly destinationCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly transportNumber: Reference<sageX3Purchasing.nodes.Transport | null>;
    readonly shipmentRecordType: Promise<sageX3PurchasingData.enums.ShipmentRecordType>;
    readonly expectedArrivalDate: Promise<date | null>;
    readonly transitStart: Reference<sageX3MasterData.nodes.TransitArea | null>;
    readonly transitArrival: Reference<sageX3MasterData.nodes.TransitArea | null>;
    readonly departureDate: Promise<date | null>;
    readonly arrivalDate: Promise<date | null>;
    readonly transportMode: Promise<sageX3PurchasingData.enums.TransportMode | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly company: Reference<sageX3System.nodes.Company | null>;
    readonly dateShift: Promise<integer | null>;
    readonly shipmentManagement: Promise<sageX3PurchasingData.enums.ShipmentManagement | null>;
    readonly container: Reference<sageX3MasterData.nodes.Container | null>;
    readonly quantityOfContainers: Promise<integer | null>;
    readonly maximumWeight: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly maximumVolume: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly shipmentTotalWeight: Promise<decimal | null>;
    readonly shipmentTotalVolume: Promise<decimal | null>;
    readonly availableWeight: Promise<decimal | null>;
    readonly availableVolume: Promise<decimal | null>;
    readonly shipmentStatus: Promise<sageX3PurchasingData.enums.ShipmentStatus | null>;
    readonly isShipped: Promise<boolean>;
}
//# sourceMappingURL=purchase-shipment.d.ts.map