"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseShipmentLine = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseShipment: {
            id: 'purchaseShipment',
        },
        purchaseOrderNumber: {
            id: 'purchaseOrderNumber',
        },
        purchaseOrderSequenceNumber: {
            purchaseOrder: 'purchaseOrderNumber',
            lineNumber: 'purchaseOrderLineNumber',
            sequenceNumber: 'purchaseOrderSequenceNumber',
        },
        product: {
            code: 'product',
        },
        orderUnit: {
            code: 'orderUnit',
        },
        purchaseUnit: {
            code: 'purchaseUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
    },
};
let PurchaseShipmentLine = class PurchaseShipmentLine extends xtrem_core_1.Node {
};
exports.PurchaseShipmentLine = PurchaseShipmentLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SHIPNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseShipment,
    })
], PurchaseShipmentLine.prototype, "purchaseShipment", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIPLIN',
    })
], PurchaseShipmentLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseOrder,
    })
], PurchaseShipmentLine.prototype, "purchaseOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPLIN',
    })
], PurchaseShipmentLine.prototype, "purchaseOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POQSEQ',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLine,
    })
], PurchaseShipmentLine.prototype, "purchaseOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseShipmentLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "quantityInOrderUnitShipped", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "quantityInPurchaseUnitShipped", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "quantityInStockUnitShipped", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "quantityInPurchaseUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCPQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "quantityInPurchaseUnitPreReceived", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseShipmentLine.prototype, "orderUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PUU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseShipmentLine.prototype, "purchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseShipmentLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMPUUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseShipmentLine.prototype, "orderUnitToPurchaseUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLEFLG',
    })
], PurchaseShipmentLine.prototype, "isClosed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCPFLG',
    })
], PurchaseShipmentLine.prototype, "isPreReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isNullable: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        computeValue() {
            return sageX3Purchasing.nodeFunctions.getQuantityInPurchaseUnitExpected(this);
        },
    })
], PurchaseShipmentLine.prototype, "quantityInPurchaseUnitExpected", void 0);
exports.PurchaseShipmentLine = PurchaseShipmentLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SHIPMENTD',
        keyPropertyNames: ['purchaseShipment', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseShipment: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseShipmentLine);
//# sourceMappingURL=purchase-shipment-line.js.map