"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseReturnLineTaxes = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const denormalized = { maxRepeat: 3 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            purchaseReturn: 'purchaseReturn',
            lineNumber: 'lineNumber',
        },
        tax: {
            code: 'tax',
            async legislation() {
                return (await (await (await (await (await this._denormalizedParent).purchaseReturn)?.returnSite)?.legalCompany)?.legislation)?.code;
            },
        },
    },
};
let PurchaseReturnLineTaxes = class PurchaseReturnLineTaxes extends xtrem_core_1.Node {
};
exports.PurchaseReturnLineTaxes = PurchaseReturnLineTaxes;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], PurchaseReturnLineTaxes.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PNHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReturnLineTaxes.prototype, "purchaseReturn", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PNDLIN',
    })
], PurchaseReturnLineTaxes.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReturnLine,
    })
], PurchaseReturnLineTaxes.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VAT',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
    })
], PurchaseReturnLineTaxes.prototype, "tax", void 0);
exports.PurchaseReturnLineTaxes = PurchaseReturnLineTaxes = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRETURND',
        keyPropertyNames: ['denormalizedIndex', 'purchaseReturn', 'lineNumber'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], PurchaseReturnLineTaxes);
//# sourceMappingURL=purchase-return-line-taxes.js.map