"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseReceipt = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3PhysicalFlowsData = require("@sage/x3-physical-flows-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        receiptSite: {
            code: 'receiptSite',
        },
        supplier: {
            code: 'supplier',
        },
        address: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'supplier',
            code: 'address',
        },
        shipFromAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'supplier',
            code: 'shipFromAddress',
        },
        shipFromCountry: {
            code: 'shipFromCountry',
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        billBySupplierAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'billBySupplier',
            code: 'billBySupplierAddress',
        },
        payToBusinessPartner: {
            code: 'payToBusinessPartner',
        },
        payToBusinessPartnerAddress: {
            entityType() {
                return 'businessPartner';
            },
            businessPartner: 'payToBusinessPartner',
            code: 'payToBusinessPartnerAddress',
        },
        carrier: {
            code: 'carrier',
        },
        forwardingAgent: {
            code: 'forwardingAgent',
        },
        forwardingAgentAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'forwardingAgent',
            code: 'forwardingAgentAddress',
        },
        currency: {
            code: 'currency',
        },
        taxRule: {
            code: 'taxRule',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        earlyDiscountOrLateCharge: {
            code: 'earlyDiscountOrLateCharge',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        deliveryMode: {
            code: 'deliveryMode',
        },
        intrastatTransactionNature: {
            code: 'intrastatTransactionNature',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        intrastatStatiscalRule: {
            code: 'intrastatStatiscalRule',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        incoterm: {
            code: 'incoterm',
        },
        project: {
            id: 'project',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        volumeUnit: {
            code: 'volumeUnit',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
        stockAutomaticJournal: {
            code: 'stockAutomaticJournal',
        },
        weightUnitForDistributionOnLines: {
            code: 'weightUnitForDistributionOnLines',
        },
        volumeUnitForDistributionOnLines: {
            code: 'volumeUnitForDistributionOnLines',
        },
        warehouse: {
            code: 'warehouse',
        },
        receiptHeaderTextRef: {
            code: 'receiptHeaderTextKey',
        },
        receiptFooterTextRef: {
            code: 'receiptFooterTextKey',
        },
    },
    collectionJoins: {
        lines: {
            purchaseReceipt: 'id',
        },
    },
};
const compositeReferences = {
    receiptFooterTextRef: {
        receiptFooterText: 'text',
    },
    receiptHeaderTextRef: {
        receiptHeaderText: 'text',
    },
};
let PurchaseReceipt = class PurchaseReceipt extends xtrem_core_1.Node {
};
exports.PurchaseReceipt = PurchaseReceipt;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PTHNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseReceipt.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseReceipt.prototype, "receiptSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNDE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "supplierPackingSlip", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NDEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceipt.prototype, "supplierPackingSlipDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceipt.prototype, "receiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseReceipt.prototype, "supplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseReceipt.prototype, "address", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPOADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseReceipt.prototype, "shipFromAddress", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPOPOSCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "shipFromZipCode", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPOCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "shipFromCity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPOSAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "shipFromState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPOCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseReceipt.prototype, "shipFromCountry", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPOCRYNAM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "shipFromCountryName", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseReceipt.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseReceipt.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPRPAY',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], PurchaseReceipt.prototype, "payToBusinessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAPAY',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.BusinessPartnerAddress,
    })
], PurchaseReceipt.prototype, "payToBusinessPartnerAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPTNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], PurchaseReceipt.prototype, "carrier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Carrier,
    })
], PurchaseReceipt.prototype, "forwardingAgent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FFWADD',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseReceipt.prototype, "forwardingAgentAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseReceipt.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGTYP',
        dataType: () => sageX3System.enums.exchangeRateTypeDatatype,
    })
], PurchaseReceipt.prototype, "rateType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CHGCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "rate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VACBPR',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.TaxRule,
    })
], PurchaseReceipt.prototype, "taxRule", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VACTYP',
    })
], PurchaseReceipt.prototype, "taxRuleType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.EarlyDiscountLateCharge,
    })
], PurchaseReceipt.prototype, "earlyDiscountOrLateCharge", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MDL',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.DeliveryMode,
    })
], PurchaseReceipt.prototype, "deliveryMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNAT',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "intrastatTransactionNature", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECSCH',
        columnType: 'string',
        node: () => sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "intrastatStatiscalRule", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECTRN',
        dataType: () => sageX3MasterData.enums.intrastatTransportModeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "intrastatTransportMode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECICT',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Incoterm,
    })
], PurchaseReceipt.prototype, "incoterm", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ICTCTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "incotermTown", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECLOC',
        dataType: () => sageX3MasterData.enums.countryLocationDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "intrastatTransportLocation", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "europeanUnionIdentification", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECNUMDEB',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceipt.prototype, "intrastatProcessingNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJTH',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PurchaseReceipt.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'GPGCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "groupingCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceipt.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceipt.prototype, "volumeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTGROWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "grossWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTNETWEI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "netWeight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTVOL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINNBR',
    })
], PurchaseReceipt.prototype, "numberOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVLINNBR',
    })
], PurchaseReceipt.prototype, "numberOfLinesFullyInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVLINCTR',
    })
], PurchaseReceipt.prototype, "numberOfInvoicedLines", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PSTLINNBR',
    })
], PurchaseReceipt.prototype, "numberOfPostedLines", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRNFLG',
    })
], PurchaseReceipt.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVFLG',
        dataType: () => sageX3MasterData.enums.noInPartInFullDatatype,
    })
], PurchaseReceipt.prototype, "invoicedStatus", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PSTFLG',
    })
], PurchaseReceipt.prototype, "isPosted", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PSTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceipt.prototype, "reversalDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETFCY',
    })
], PurchaseReceipt.prototype, "isIntersite", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BETCPY',
    })
], PurchaseReceipt.prototype, "isIntercompany", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'TEX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "receiptHeaderTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'TEX2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "receiptFooterTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PurchaseReceipt.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], PurchaseReceipt.prototype, "stockAutomaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceipt.prototype, "weightUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DSPVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceipt.prototype, "volumeUnitForDistributionOnLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "amountOfLinesExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalQuantityOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalWeightOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTLINVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalVolumeOfLines", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTAMTNOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTAMTNOTL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalAmountExcludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTTAXAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTAMTATI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TOTAMTATIL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceipt.prototype, "totalAmountIncludingTaxInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRHE',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], PurchaseReceipt.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LICPLATE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "vehicleLicensePlate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRLLICPLATE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "trailerLicensePlate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DPEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceipt.prototype, "departureDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ARVDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceipt.prototype, "arrivalDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ETD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "departureTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ETA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "arrivalTime", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLine,
        isMutable: true,
        dependsOn: ['id'],
    })
], PurchaseReceipt.prototype, "lines", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseReceipt.prototype, "receiptHeaderTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseReceipt.prototype, "receiptFooterTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseReceipt.prototype, "receiptFooterText", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseReceipt.prototype, "receiptHeaderText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "destination", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "document", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceipt.prototype, "transaction", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptAddressLines,
    })
], PurchaseReceipt.prototype, "addressLines", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptCompanyNames,
    })
], PurchaseReceipt.prototype, "companyNames", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptDimensions,
    })
], PurchaseReceipt.prototype, "dimensions", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineAllocationElements,
    })
], PurchaseReceipt.prototype, "headerInvoiceLineAllocationElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineElements,
    })
], PurchaseReceipt.prototype, "headerInvoiceLineElements", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptStatisticalGroups,
    })
], PurchaseReceipt.prototype, "statisticalGroups", void 0);
exports.PurchaseReceipt = PurchaseReceipt = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRECEIPT',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
    })
], PurchaseReceipt);
//# sourceMappingURL=purchase-receipt.js.map