import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, decimal, integer, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseReceipt extends Node {
    readonly id: Promise<string>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly receiptSite: Reference<sageX3System.nodes.Site>;
    readonly supplierPackingSlip: Promise<string>;
    readonly supplierPackingSlipDate: Promise<date | null>;
    readonly receiptDate: Promise<date | null>;
    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly address: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly shipFromAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly shipFromZipCode: Promise<string>;
    readonly shipFromCity: Promise<string>;
    readonly shipFromState: Promise<string>;
    readonly shipFromCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipFromCountryName: Promise<string>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly carrier: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly rate: Promise<decimal | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule>;
    readonly taxRuleType: Promise<integer | null>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly deliveryMode: Reference<sageX3PurchasingData.nodes.DeliveryMode | null>;
    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatStatiscalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly europeanUnionIdentification: Promise<string>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly groupingCode: Promise<string>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly grossWeight: Promise<decimal | null>;
    readonly netWeight: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfLinesFullyInvoiced: Promise<integer | null>;
    readonly numberOfInvoicedLines: Promise<integer | null>;
    readonly numberOfPostedLines: Promise<integer | null>;
    readonly isPrinted: Promise<boolean>;
    readonly invoicedStatus: Promise<sageX3MasterData.enums.NoInPartInFull | null>;
    readonly isPosted: Promise<boolean>;
    readonly reversalDate: Promise<date | null>;
    readonly isIntersite: Promise<boolean>;
    readonly isIntercompany: Promise<boolean>;
    readonly receiptHeaderTextKey: Promise<string>;
    readonly receiptFooterTextKey: Promise<string>;
    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockAutomaticJournal: Reference<sageX3FinanceData.nodes.AutomaticJournal | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
    readonly totalQuantityOfLines: Promise<decimal | null>;
    readonly totalWeightOfLines: Promise<decimal | null>;
    readonly totalVolumeOfLines: Promise<decimal | null>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalTaxAmount: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly vehicleLicensePlate: Promise<string>;
    readonly trailerLicensePlate: Promise<string>;
    readonly departureDate: Promise<date | null>;
    readonly arrivalDate: Promise<date | null>;
    readonly departureTime: Promise<string>;
    readonly arrivalTime: Promise<string>;
    readonly lines: Collection<sageX3Purchasing.nodes.PurchaseReceiptLine>;
    readonly receiptHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly receiptFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly receiptFooterText: Promise<TextStream>;
    readonly receiptHeaderText: Promise<TextStream>;
    readonly destination: Promise<string>;
    readonly document: Promise<string>;
    readonly transaction: Promise<string>;
    readonly addressLines: Collection<sageX3Purchasing.nodes.PurchaseReceiptAddressLines>;
    readonly companyNames: Collection<sageX3Purchasing.nodes.PurchaseReceiptCompanyNames>;
    readonly dimensions: Collection<sageX3Purchasing.nodes.PurchaseReceiptDimensions>;
    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineAllocationElements>;
    readonly headerInvoiceLineElements: Collection<sageX3Purchasing.nodes.PurchaseReceiptHeaderInvoiceLineElements>;
    readonly statisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseReceiptStatisticalGroups>;
}
//# sourceMappingURL=purchase-receipt.d.ts.map