"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseReceiptLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3Structure = require("@sage/x3-structure");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseReceipt: {
            id: 'purchaseReceipt',
        },
        company: {
            code: 'company',
        },
        receiptSite: {
            code: 'receiptSite',
        },
        purchaseSite: {
            code: 'purchaseSite',
        },
        purchaseOrder: {
            id: 'purchaseOrder',
        },
        purchaseOrderLine: {
            purchaseOrder: 'purchaseOrder',
            lineNumber: 'purchaseOrderLineNumber',
            sequenceNumber: 'purchaseOrderLine',
        },
        supplier: {
            code: 'supplier',
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        billBySupplierAddress: {
            entityType() {
                return 'businessPartner';
            },
            supplier: 'billBySupplier',
            code: 'billBySupplierAddress',
        },
        project: {
            id: 'project',
        },
        product: {
            code: 'product',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountCharge1Reason: {
            code: 'discountCharge1Reason',
        },
        discountCharge2Reason: {
            code: 'discountCharge2Reason',
        },
        discountCharge3Reason: {
            code: 'discountCharge3Reason',
        },
        discountCharge4Reason: {
            code: 'discountCharge4Reason',
        },
        discountCharge5Reason: {
            code: 'discountCharge5Reason',
        },
        discountCharge6Reason: {
            code: 'discountCharge6Reason',
        },
        discountCharge7Reason: {
            code: 'discountCharge7Reason',
        },
        discountCharge8Reason: {
            code: 'discountCharge8Reason',
        },
        discountCharge9Reason: {
            code: 'discountCharge9Reason',
        },
        currency: {
            code: 'currency',
        },
        companyCurrency: {
            code: 'companyCurrency',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        volumeUnit: {
            code: 'volumeUnit',
        },
        receiptUnit: {
            code: 'receiptUnit',
        },
        purchaseUnit: {
            code: 'purchaseUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        countryOfOrigin: {
            code: 'countryOfOrigin',
        },
        shipFromCountry: {
            code: 'shipFromCountry',
        },
        issueState: {
            glossaryId() {
                return 364;
            },
            code: 'issueState',
        },
        stockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'stockMovementGroup',
        },
        receiptTax: {
            code: 'receiptTax',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        issueTax: {
            code: 'issueTax',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        otherTax1: {
            code: 'otherTax1',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        otherTax2: {
            code: 'otherTax2',
            async legislation() {
                return (await (await (await this.receiptSite).legalCompany).legislation)?.code;
            },
        },
        shippingSite: {
            code: 'shippingSite',
        },
        releasedProduct: {
            code: 'releasedProduct',
        },
        warehouse: {
            code: 'warehouse',
        },
        matchingTolerance: {
            code: 'matchingTolerance',
        },
        purchaseShipment: {
            id: 'purchaseShipment',
        },
        purchaseShipmentLine: {
            purchaseShipment: 'purchaseShipment',
            lineNumber: 'purchaseShipmentLine',
        },
        receiptLineTextRef: {
            code: 'receiptLineTextKey',
        },
    },
    collectionJoins: {
        stockDetails: {
            stockSite: 'receiptSite',
            documentType() {
                return 'receipt';
            },
            documentId: 'purchaseReceipt',
            documentLine: 'lineNumber',
        },
    },
};
const compositeReferences = {
    receiptLineTextRef: {
        receiptLineText: 'text',
    },
};
let PurchaseReceiptLine = class PurchaseReceiptLine extends xtrem_core_1.Node {
};
exports.PurchaseReceiptLine = PurchaseReceiptLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReceipt,
    })
], PurchaseReceiptLine.prototype, "purchaseReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTDLIN',
    })
], PurchaseReceiptLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseReceiptLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseReceiptLine.prototype, "receiptSite", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceiptLine.prototype, "receiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POHFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseReceiptLine.prototype, "purchaseSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseOrder,
    })
], PurchaseReceiptLine.prototype, "purchaseOrder", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPLIN',
    })
], PurchaseReceiptLine.prototype, "purchaseOrderLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POQSEQ',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLine,
    })
], PurchaseReceiptLine.prototype, "purchaseOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POHTYP',
        dataType: () => sageX3Purchasing.enums.purchaseOrderTypeDatatype,
    })
], PurchaseReceiptLine.prototype, "orderType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseReceiptLine.prototype, "supplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSINV',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseReceiptLine.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPAINV',
        columnType: 'string',
        filters: {
            lookup: {
                entityType: 'businessPartner',
            },
            control: {
                entityType: 'businessPartner',
            },
        },
        node: () => sageX3MasterData.nodes.SupplierAddress,
    })
], PurchaseReceiptLine.prototype, "billBySupplierAddress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PurchaseReceiptLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseReceiptLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "productDescriptionInSupplierLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
    })
], PurchaseReceiptLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseReceiptLine.prototype, "discountCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRIPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "netPriceInPurchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "lineAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMTCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "lineCostPriceInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "linePurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINATIAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "lineAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement1AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement2AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement3AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement4AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement5AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement6AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement7AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement8AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "distributedInvoicingElement9AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "calculatedTaxableBase7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISBASLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "rebateOnTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "taxableBase1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax2Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax3Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "receiptTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "issueTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax2Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "tax3DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "receiptTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "issueTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "netPriceIncludingInvoicingElementInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "costPriceInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRCLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "theoreticalStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "purchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "landedCostCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "fixedLandedCostPerUnitInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "costStructure", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NETCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseReceiptLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPRCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseReceiptLine.prototype, "companyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "totalPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "totalStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCPRCPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "totalPostedStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYUOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInReceiptUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInPurchaseUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInStockUnitReceived", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceiptLine.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceiptLine.prototype, "volumeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceiptLine.prototype, "receiptUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PUU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceiptLine.prototype, "purchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseReceiptLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMPUUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "receiptUnitToPurchaseUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMSTUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "receiptUnitToStockUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RRRQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInPurchaseUnitRejected", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RRRQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInStockUnitRejected", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTNQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInPurchaseUnitReturned", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RTNQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInStockUnitReturned", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInPurchaseUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVQTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINPRNFLG',
    })
], PurchaseReceiptLine.prototype, "isPrinted", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LININVFLG',
    })
], PurchaseReceiptLine.prototype, "isInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINEECFLG',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceiptLine.prototype, "isExtractedIntrastatLine", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINPSTFLG',
    })
], PurchaseReceiptLine.prototype, "isPosted", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINPSTDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseReceiptLine.prototype, "reversalDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QUAFLG',
        dataType: () => sageX3MasterData.enums.subjectToControlDatatype,
    })
], PurchaseReceiptLine.prototype, "qualityControlManagementMode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QUARTNFLG',
    })
], PurchaseReceiptLine.prototype, "isControlledByQuality", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINPURTYP',
        dataType: () => sageX3InvoicingData.enums.purchaseTypeDatatype,
    })
], PurchaseReceiptLine.prototype, "purchaseType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EECINCRAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseReceiptLine.prototype, "intrastatIncreaseCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORICRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseReceiptLine.prototype, "countryOfOrigin", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPOCRY',
        columnType: 'string',
        node: () => sageX3Structure.nodes.Country,
    })
], PurchaseReceiptLine.prototype, "shipFromCountry", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SATISS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 364,
            },
            control: {
                glossaryId: 364,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "issueState", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAM',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PurchaseReceiptLine.prototype, "stockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXRCP',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "receiptTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXISS',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "issueTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXOTH1',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAXOTH2',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseReceiptLine.prototype, "otherTax2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'LINTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "receiptLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINSTOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseReceiptLine.prototype, "shippingSite", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREFORI',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseReceiptLine.prototype, "releasedProduct", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTYPORI',
        dataType: () => sageX3StockData.enums.entryTypeEnumDatatype,
    })
], PurchaseReceiptLine.prototype, "sourceDocumentType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VCRNUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "sourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRLINORI',
    })
], PurchaseReceiptLine.prototype, "sourceDocumentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRSEQORI',
    })
], PurchaseReceiptLine.prototype, "sourceDocumentSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOMGTCOD',
        dataType: () => sageX3MasterData.enums.stockManagementDatatype,
    })
], PurchaseReceiptLine.prototype, "productStockManagement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VERFLG',
    })
], PurchaseReceiptLine.prototype, "billableIntercompanyStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3PurchasingData.enums.orderLineTypeDatatype,
    })
], PurchaseReceiptLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINCAT',
        dataType: () => sageX3PurchasingData.enums.movementCategoryDatatype,
    })
], PurchaseReceiptLine.prototype, "movementCategory", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTYCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "linkCoefficientForSubcontract", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WRH',
        columnType: 'string',
        node: () => sageX3StockData.nodes.Warehouse,
        serviceOptions: () => [sageX3System.serviceOptions.WrhActivityCode],
    })
], PurchaseReceiptLine.prototype, "warehouse", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MATTOL',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.MatchingTolerance,
    })
], PurchaseReceiptLine.prototype, "matchingTolerance", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SCOCSTCPT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseReceiptLine.prototype, "postedSubcontractCost", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIPNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseShipment,
    })
], PurchaseReceiptLine.prototype, "purchaseShipment", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIPLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseShipmentLine,
    })
], PurchaseReceiptLine.prototype, "purchaseShipmentLine", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMKND',
        dataType: () => sageX3Purchasing.enums.purchasingProductTypeDatatype,
    })
], PurchaseReceiptLine.prototype, "productType", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3StockData.nodes.StockJournal,
        isMutable: true,
        dependsOn: ['receiptSite', 'purchaseReceipt', 'lineNumber'],
    })
], PurchaseReceiptLine.prototype, "stockDetails", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseReceiptLine.prototype, "receiptLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseReceiptLine.prototype, "receiptLineText", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "balance", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isTransientInput: true,
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseReceiptLine.prototype, "container", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLineProductStatisticalGroups,
    })
], PurchaseReceiptLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLineTaxes,
    })
], PurchaseReceiptLine.prototype, "taxes", void 0);
exports.PurchaseReceiptLine = PurchaseReceiptLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PRECEIPTD',
        keyPropertyNames: ['purchaseReceipt', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseReceipt: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseReceiptLine);
//# sourceMappingURL=purchase-receipt-line.js.map