import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseReceiptLine extends Node {
    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt>;
    readonly lineNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly receiptSite: Reference<sageX3System.nodes.Site>;
    readonly receiptDate: Promise<date | null>;
    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder | null>;
    readonly purchaseOrderLineNumber: Promise<integer | null>;
    readonly purchaseOrderLine: Reference<sageX3Purchasing.nodes.PurchaseOrderLine | null>;
    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
    readonly supplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInSupplierLanguage: Promise<string>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge1: Promise<decimal | null>;
    readonly discountCharge2: Promise<decimal | null>;
    readonly discountCharge3: Promise<decimal | null>;
    readonly discountCharge4: Promise<decimal | null>;
    readonly discountCharge5: Promise<decimal | null>;
    readonly discountCharge6: Promise<decimal | null>;
    readonly discountCharge7: Promise<decimal | null>;
    readonly discountCharge8: Promise<decimal | null>;
    readonly discountCharge9: Promise<decimal | null>;
    readonly discountCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly netPriceInPurchaseUnit: Promise<decimal | null>;
    readonly lineAmountExcludingTax: Promise<decimal | null>;
    readonly lineCostPriceInCompanyCurrency: Promise<decimal | null>;
    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly lineAmountIncludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
    readonly calculatedTaxableBase1: Promise<decimal | null>;
    readonly calculatedTaxableBase2: Promise<decimal | null>;
    readonly calculatedTaxableBase3: Promise<decimal | null>;
    readonly calculatedTaxableBase4: Promise<decimal | null>;
    readonly calculatedTaxableBase5: Promise<decimal | null>;
    readonly calculatedTaxableBase6: Promise<decimal | null>;
    readonly calculatedTaxableBase7: Promise<decimal | null>;
    readonly rebateOnTax1Amount: Promise<decimal | null>;
    readonly taxableBase1Amount: Promise<decimal | null>;
    readonly tax1Amount: Promise<decimal | null>;
    readonly tax2Amount: Promise<decimal | null>;
    readonly tax3Amount: Promise<decimal | null>;
    readonly receiptTaxAmount: Promise<decimal | null>;
    readonly issueTaxAmount: Promise<decimal | null>;
    readonly otherTax1Amount: Promise<decimal | null>;
    readonly otherTax2Amount: Promise<decimal | null>;
    readonly tax1DeductibleAmount: Promise<decimal | null>;
    readonly tax2DeductibleAmount: Promise<decimal | null>;
    readonly tax3DeductibleAmount: Promise<decimal | null>;
    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
    readonly netPriceIncludingInvoicingElementInCompanyCurrency: Promise<decimal | null>;
    readonly costPriceInCompanyCurrency: Promise<decimal | null>;
    readonly theoreticalStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
    readonly costStructure: Promise<string>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly totalPostedStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly quantityInReceiptUnitReceived: Promise<decimal | null>;
    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
    readonly quantityInStockUnitReceived: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volume: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly receiptUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly receiptUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
    readonly receiptUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInPurchaseUnitRejected: Promise<decimal | null>;
    readonly quantityInStockUnitRejected: Promise<decimal | null>;
    readonly quantityInPurchaseUnitReturned: Promise<decimal | null>;
    readonly quantityInStockUnitReturned: Promise<decimal | null>;
    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly isPrinted: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly isExtractedIntrastatLine: Promise<boolean>;
    readonly isPosted: Promise<boolean>;
    readonly reversalDate: Promise<date | null>;
    readonly qualityControlManagementMode: Promise<sageX3MasterData.enums.SubjectToControl | null>;
    readonly isControlledByQuality: Promise<boolean>;
    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
    readonly shipFromCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly issueState: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly receiptTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly issueTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly otherTax1: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly otherTax2: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly receiptLineTextKey: Promise<string>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceDocument: Promise<string>;
    readonly sourceDocumentLineNumber: Promise<integer | null>;
    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
    readonly productStockManagement: Promise<sageX3MasterData.enums.StockManagement | null>;
    readonly billableIntercompanyStatus: Promise<integer | null>;
    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
    readonly movementCategory: Promise<sageX3PurchasingData.enums.MovementCategory | null>;
    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
    readonly postedSubcontractCost: Promise<decimal | null>;
    readonly purchaseShipment: Reference<sageX3Purchasing.nodes.PurchaseShipment | null>;
    readonly purchaseShipmentLine: Reference<sageX3Purchasing.nodes.PurchaseShipmentLine | null>;
    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
    readonly stockDetails: Collection<sageX3StockData.nodes.StockJournal>;
    readonly receiptLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly receiptLineText: Promise<TextStream>;
    readonly balance: Promise<string>;
    readonly container: Promise<string>;
    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseReceiptLineProductStatisticalGroups>;
    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseReceiptLineTaxes>;
}
//# sourceMappingURL=purchase-receipt-line.d.ts.map