import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, TextStream, Collection } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseOrderLine extends Node {
    readonly purchaseOrder: Reference<sageX3Purchasing.nodes.PurchaseOrder>;
    readonly lineNumber: Promise<integer | null>;
    readonly sequenceNumber: Promise<integer | null>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly orderType: Promise<sageX3Purchasing.enums.PurchaseOrderType | null>;
    readonly revisionNumber: Promise<integer | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly productDescriptionInUserLanguage: Promise<string>;
    readonly productDescriptionInSupplierLanguage: Promise<string>;
    readonly grossPrice: Promise<decimal | null>;
    readonly priceReason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge1: Promise<decimal | null>;
    readonly discountOrCharge2: Promise<decimal | null>;
    readonly discountOrCharge3: Promise<decimal | null>;
    readonly discountOrCharge4: Promise<decimal | null>;
    readonly discountOrCharge5: Promise<decimal | null>;
    readonly discountOrCharge6: Promise<decimal | null>;
    readonly discountOrCharge7: Promise<decimal | null>;
    readonly discountOrCharge8: Promise<decimal | null>;
    readonly discountOrCharge9: Promise<decimal | null>;
    readonly discountOrCharge1Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge2Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge3Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge4Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge5Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge6Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge7Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge8Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly discountOrCharge9Reason: Reference<sageX3PurchasingData.nodes.PurchasePriceReason | null>;
    readonly netPrice: Promise<decimal | null>;
    readonly buyer: Reference<sageX3System.nodes.User | null>;
    readonly receiptSite: Reference<sageX3System.nodes.Site>;
    readonly receiptAddress: Reference<sageX3MasterData.nodes.SiteAddress | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly intrastatIncreaseCoefficient: Promise<decimal | null>;
    readonly countryOfOrigin: Reference<sageX3Structure.nodes.Country | null>;
    readonly hasQualityControlManagement: Promise<boolean>;
    readonly receiptTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly issueTax: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly otherTax1: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly otherTax2: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly matchingTolerance: Reference<sageX3PurchasingData.nodes.MatchingTolerance | null>;
    readonly purchaseOrderQuantityLine: Reference<sageX3Purchasing.nodes.PurchaseOrderQuantityLine>;
    readonly orderLineTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly acknowledgementDate: Promise<date | null>;
    readonly acknowledgementNumber: Promise<string>;
    readonly acknowledgementUpdate: Promise<integer | null>;
    readonly actualPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly calculatedBasisForTax3: Promise<decimal | null>;
    readonly calculatedTaxBasis1: Promise<decimal | null>;
    readonly calculatedTaxBasis2: Promise<decimal | null>;
    readonly calculationBasisForIssueTax: Promise<decimal | null>;
    readonly calculationBasisForOtherTax1: Promise<decimal | null>;
    readonly calculationBasisForOtherTax2: Promise<decimal | null>;
    readonly calculationBasisForReceiptTax: Promise<decimal | null>;
    readonly commitmentGenerated: Promise<integer | null>;
    readonly commitmentType: Promise<sageX3PurchasingData.enums.CommitmentType | null>;
    readonly companyCurrency: Reference<sageX3MasterData.nodes.Currency>;
    readonly costPriceWithoutLandedCost: Promise<decimal | null>;
    readonly costStructure: Reference<sageX3PurchasingData.nodes.FreightCostStructure | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly distributedInvoicingElement1AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement2AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement3AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement4AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement5AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement6AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement7AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement8AmountExcludingTax: Promise<decimal | null>;
    readonly distributedInvoicingElement9AmountExcludingTax: Promise<decimal | null>;
    readonly expectedReceiptDate: Promise<date | null>;
    readonly fixedLandedCostPerUnitInCompanyCurrency: Promise<decimal | null>;
    readonly interCompanySalesOrderLineNumber: Promise<integer | null>;
    readonly interCompanySalesOrderSequenceNumber: Promise<integer | null>;
    readonly isBudgetOverrun: Promise<boolean>;
    readonly isClosed: Promise<boolean>;
    readonly isClosedByReceipt: Promise<boolean>;
    readonly isInOrderUnit: Promise<boolean>;
    readonly isInvoiced: Promise<boolean>;
    readonly isPrinted: Promise<boolean>;
    readonly issueTaxAmount: Promise<decimal | null>;
    readonly issueTaxDeductibleAmount: Promise<decimal | null>;
    readonly landedCostCoefficient: Promise<decimal | null>;
    readonly lastReceiptDate: Promise<date | null>;
    readonly lastSalesInvoiceDate: Promise<date | null>;
    readonly lineAmountIncludingTax: Promise<decimal | null>;
    readonly lineAndSequenceIndex: Promise<string>;
    readonly lineOrderAmountIncludingTax: Promise<decimal | null>;
    readonly linePurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly lineStatus: Promise<sageX3MasterData.enums.LineStatus | null>;
    readonly lineStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly lineType: Promise<sageX3PurchasingData.enums.OrderLineType | null>;
    readonly linkCoefficientForSubcontract: Promise<decimal | null>;
    readonly locationReference: Promise<string>;
    readonly majorProductVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorProductVersion: Promise<string>;
    readonly numberOfInvoicedReceipts: Promise<integer | null>;
    readonly numberOfInvoices: Promise<integer | null>;
    readonly numberOfReceipts: Promise<integer | null>;
    readonly orderDate: Promise<date | null>;
    readonly orderFromSupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly orderLineText: Promise<TextStream>;
    readonly orderLineTextKey: Promise<string>;
    readonly orderUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly orderUnitToPurchaseUnitConversionFactor: Promise<decimal | null>;
    readonly otherTax1Amount: Promise<decimal | null>;
    readonly otherTax1DeductibleAmount: Promise<decimal | null>;
    readonly otherTax2Amount: Promise<decimal | null>;
    readonly otherTax2DeductibleAmount: Promise<decimal | null>;
    readonly productType: Promise<sageX3Purchasing.enums.PurchasingProductType | null>;
    readonly purchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly purchaseReceipt: Reference<sageX3Purchasing.nodes.PurchaseReceipt | null>;
    readonly purchaseReceiptLine: Reference<sageX3Purchasing.nodes.PurchaseReceiptLine | null>;
    readonly purchaseSite: Reference<sageX3System.nodes.Site>;
    readonly purchaseType: Promise<sageX3InvoicingData.enums.PurchaseType | null>;
    readonly purchaseUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInOrderUnitOrdered: Promise<decimal | null>;
    readonly quantityInPurchaseUnitInvoiced: Promise<decimal | null>;
    readonly quantityInPurchaseUnitOrdered: Promise<decimal | null>;
    readonly quantityInPurchaseUnitReceived: Promise<decimal | null>;
    readonly quantityInPurchaseUnitRequired: Promise<decimal | null>;
    readonly quantityInPurchaseUnitShippedNotReceived: Promise<decimal | null>;
    readonly quantityInStockUnitInvoiced: Promise<decimal | null>;
    readonly quantityInStockUnitOrdered: Promise<decimal | null>;
    readonly quantityInStockUnitReceived: Promise<decimal | null>;
    readonly quantityInStockUnitRequired: Promise<decimal | null>;
    readonly quantityInStockUnitShippedNotReceived: Promise<decimal | null>;
    readonly rebateOnTax1Amount: Promise<decimal | null>;
    readonly receiptTaxAmount: Promise<decimal | null>;
    readonly receiptTaxDeductibleAmount: Promise<decimal | null>;
    readonly releasedProduct: Reference<sageX3MasterData.nodes.Product | null>;
    readonly reorderLeadTime: Promise<decimal | null>;
    readonly requestForQuotation: Promise<string>;
    readonly requestForQuotationResponseLineNumber: Promise<integer | null>;
    readonly requestedDeliveryEndDate: Promise<date | null>;
    readonly requestedDeliveryEndTime: Promise<integer | null>;
    readonly requestedDeliveryStartDate: Promise<date | null>;
    readonly requestedDeliveryStartTime: Promise<integer | null>;
    readonly requirementDate: Promise<date | null>;
    readonly shippingSite: Reference<sageX3System.nodes.Site | null>;
    readonly sourceDocumentLineNumber: Promise<integer | null>;
    readonly sourceDocumentNumber: Promise<string>;
    readonly sourceDocumentSequenceNumber: Promise<integer | null>;
    readonly sourceDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly sourceRequest: Promise<sageX3PurchasingData.enums.RequestSource | null>;
    readonly stockCostInCompanyCurrency: Promise<decimal | null>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly subcontractAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly supplierProduct: Reference<sageX3MasterData.nodes.SupplierProduct | null>;
    readonly tax1BasisAmount: Promise<decimal | null>;
    readonly tax1DeductibleAmount: Promise<decimal | null>;
    readonly tax1amount: Promise<decimal | null>;
    readonly tax2DeductibleAmount: Promise<decimal | null>;
    readonly tax2amount: Promise<decimal | null>;
    readonly tax3DeductibleAmount: Promise<decimal | null>;
    readonly tax3amount: Promise<decimal | null>;
    readonly taxExcludedLineAmount: Promise<decimal | null>;
    readonly totalPurchaseCostInCompanyCurrency: Promise<decimal | null>;
    readonly totalStockCostInCompanyCurrency: Promise<decimal | null>;
    readonly volume: Promise<decimal | null>;
    readonly volumeUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly weight: Promise<decimal | null>;
    readonly weightUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly workInProgressOrderNumber: Promise<string>;
    readonly workOrderInProgressStatus: Promise<sageX3ManufacturingData.enums.StatusInProgress | null>;
    readonly workOrderInProgressType: Promise<sageX3ManufacturingData.enums.WorkOrderType | null>;
    readonly productStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseOrderLineProductStatisticalGroups>;
    readonly taxes: Collection<sageX3Purchasing.nodes.PurchaseOrderLineTaxes>;
}
//# sourceMappingURL=purchase-order-line.d.ts.map