import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3PurchasingData from '@sage/x3-purchasing-data';
import * as sageX3Structure from '@sage/x3-structure';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, Collection, date, TextStream } from '@sage/xtrem-core';
import * as sageX3Purchasing from '..';
export declare class PurchaseInvoice extends Node {
    readonly id: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
    readonly category: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
    readonly invoiceType: Reference<sageX3PurchasingData.nodes.PurchaseInvoiceType | null>;
    readonly purchaseInvoiceCategory: Promise<sageX3MasterData.enums.PurchaseInvoiceCategory | null>;
    readonly billBySupplier: Reference<sageX3MasterData.nodes.Supplier>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly numberOfLines: Promise<integer | null>;
    readonly numberOfLinesWithDifferentQuantity: Promise<integer | null>;
    readonly numberOfLinesWithDifferentPrice: Promise<integer | null>;
    readonly weightUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly volumeUnitForDistributionOnLines: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly totalWeightOfLines: Promise<decimal | null>;
    readonly totalVolumeOfLines: Promise<decimal | null>;
    readonly totalQuantityOfLines: Promise<decimal | null>;
    readonly amountOfLinesExcludingTax: Promise<decimal | null>;
    readonly calculatedLineAmountExcludingTax: Promise<decimal | null>;
    readonly totalTaxAmount: Promise<decimal | null>;
    readonly billBySupplierLanguage: Reference<sageX3System.nodes.Language>;
    readonly companyLanguage: Reference<sageX3System.nodes.Language>;
    readonly company: Reference<sageX3System.nodes.Company>;
    readonly earlyDiscountOrLateCharge: Reference<sageX3InvoicingData.nodes.EarlyDiscountLateCharge | null>;
    readonly invoiceHeaderTextKey: Promise<string>;
    readonly invoiceFooterTextKey: Promise<string>;
    readonly isIntercompany: Promise<boolean>;
    readonly billToCustomer: Reference<sageX3MasterData.nodes.Customer | null>;
    readonly purchaseInvoiceLines: Collection<sageX3Purchasing.nodes.PurchaseInvoiceLine>;
    readonly supplierInvoiceHeader: Reference<sageX3InvoicingData.nodes.SupplierInvoiceHeader>;
    readonly invoiceHeaderTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly invoiceFooterTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
    readonly accountingDate: Promise<date | null>;
    readonly billBySupplierAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly billBySupplierAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierAddressLines>;
    readonly billBySupplierCity: Promise<string>;
    readonly billBySupplierCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderBillBySupplierCompanyNames>;
    readonly billBySupplierCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly billBySupplierCountryName: Promise<string>;
    readonly billBySupplierPostalCode: Promise<string>;
    readonly billBySupplierState: Promise<string>;
    readonly cashVatTaxRule: Promise<boolean>;
    readonly comments: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderComments>;
    readonly control: Promise<string>;
    readonly currencyRates: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderCurrencyRates>;
    readonly debitOrCredit: Promise<integer | null>;
    readonly derCode: Promise<string>;
    readonly dimensions: Collection<sageX3FinanceData.nodes.SupplierInvoiceHeaderDimensions>;
    readonly dueDateCalculationStartDate: Promise<date | null>;
    readonly earlyDiscountOrLateChargeBasis: Promise<decimal | null>;
    readonly earlyDiscountOrLateChargeRate: Promise<decimal | null>;
    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
    readonly europeanUnionIdentification: Promise<string>;
    readonly field40Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly field41Reason: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly fiscalYear: Promise<integer | null>;
    readonly forwardingAgent: Reference<sageX3MasterData.nodes.Carrier | null>;
    readonly forwardingAgentAddress: Reference<sageX3MasterData.nodes.SupplierAddress | null>;
    readonly incoterm: Reference<sageX3MasterData.nodes.Incoterm | null>;
    readonly incotermTown: Promise<string>;
    readonly internalNumber: Promise<integer | null>;
    readonly internalReference: Promise<string>;
    readonly intrastatProcessingNumber: Promise<integer | null>;
    readonly intrastatStatisticalRule: Reference<sageX3PhysicalFlowsData.nodes.IntrastatStatisticalRule | null>;
    readonly intrastatTransactionNature: Reference<sageX3PhysicalFlowsData.nodes.IntrastatTransactionNature | null>;
    readonly intrastatTransportLocation: Promise<sageX3MasterData.enums.CountryLocation | null>;
    readonly intrastatTransportMode: Promise<sageX3MasterData.enums.IntrastatTransportMode | null>;
    readonly invoiceFooterText: Promise<TextStream>;
    readonly invoiceHeaderText: Promise<TextStream>;
    readonly isDas2Submitted: Promise<boolean>;
    readonly isEuropeanUnionInvoice: Promise<boolean>;
    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
    readonly lastServiceAccountedDate: Promise<date | null>;
    readonly matchStatus: Promise<sageX3InvoicingData.enums.MatchStatusEnum | null>;
    readonly numberOfTaxes: Promise<integer | null>;
    readonly originalDocumentNumber: Promise<string>;
    readonly originalInvoiceNumber: Promise<string>;
    readonly payToBusinessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly payToBusinessPartnerAddress: Reference<sageX3MasterData.nodes.BusinessPartnerAddress | null>;
    readonly payToBusinessPartnerAddressLines: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
    readonly payToBusinessPartnerCity: Promise<string>;
    readonly payToBusinessPartnerCompanyNames: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
    readonly payToBusinessPartnerCountry: Reference<sageX3Structure.nodes.Country | null>;
    readonly payToBusinessPartnerCountryName: Promise<string>;
    readonly payToBusinessPartnerPostalCode: Promise<string>;
    readonly payToBusinessPartnerState: Promise<string>;
    readonly paymentApproval: Promise<sageX3MasterData.enums.PaymentApprovalType | null>;
    readonly paymentTerm: Reference<sageX3InvoicingData.nodes.PaymentTerm>;
    readonly period: Promise<integer | null>;
    readonly priceOrAmountType: Promise<sageX3MasterData.enums.PriceAmountTaxTax | null>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly rateDate: Promise<date | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType | null>;
    readonly serviceEndDate: Promise<date | null>;
    readonly serviceStartDate: Promise<date | null>;
    readonly singleCustomsDocumentBusinessPartnerCode: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly singleCustomsDocumentDate: Promise<date | null>;
    readonly singleCustomsDocumentReference: Promise<string>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly sourceDocumentDate: Promise<date | null>;
    readonly sourceModule: Promise<sageX3System.enums.ModuleTable | null>;
    readonly status: Promise<sageX3InvoicingData.enums.PurchasingInvoiceStatus | null>;
    readonly supplierSourceDocument: Promise<string>;
    readonly taxReferenceDate: Promise<date | null>;
    readonly taxRule: Reference<sageX3InvoicingData.nodes.TaxRule | null>;
    readonly taxes: Collection<sageX3InvoicingData.nodes.SupplierInvoiceHeaderTaxes>;
    readonly totalAmountExcludingTax: Promise<decimal | null>;
    readonly totalAmountExcludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly totalAmountIncludingTax: Promise<decimal | null>;
    readonly totalAmountIncludingTaxInCompanyCurrency: Promise<decimal | null>;
    readonly versionControlSystemNumber: Promise<string>;
    readonly headerInvoiceLineAllocationElements: Collection<sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
    readonly headerInvoiceLineElements: Collection<sageX3Purchasing.nodes.PurchaseInvoiceHeaderInvoiceLineElements>;
    readonly supplierStatisticalGroups: Collection<sageX3Purchasing.nodes.PurchaseInvoiceSupplierStatisticalGroups>;
}
//# sourceMappingURL=purchase-invoice.d.ts.map