"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseInvoiceLine = void 0;
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Purchasing = require("..");
const joins = {
    referenceJoins: {
        purchaseInvoice: {
            id: 'purchaseInvoice',
        },
        invoiceType: {
            code: 'invoiceType',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        billBySupplier: {
            code: 'billBySupplier',
        },
        lineSite: {
            code: 'lineSite',
        },
        product: {
            code: 'product',
        },
        invoicingUnit: {
            code: 'invoicingUnit',
        },
        purchaseUnit: {
            code: 'purchaseUnit',
        },
        stockUnit: {
            code: 'stockUnit',
        },
        weightUnit: {
            code: 'weightUnit',
        },
        volumeUnit: {
            code: 'volumeUnit',
        },
        priceReason: {
            code: 'priceReason',
        },
        discountOrCharge1Reason: {
            code: 'discountOrCharge1Reason',
        },
        discountOrCharge2Reason: {
            code: 'discountOrCharge2Reason',
        },
        discountOrCharge3Reason: {
            code: 'discountOrCharge3Reason',
        },
        discountOrCharge4Reason: {
            code: 'discountOrCharge4Reason',
        },
        discountOrCharge5Reason: {
            code: 'discountOrCharge5Reason',
        },
        discountOrCharge6Reason: {
            code: 'discountOrCharge6Reason',
        },
        discountOrCharge7Reason: {
            code: 'discountOrCharge7Reason',
        },
        discountOrCharge8Reason: {
            code: 'discountOrCharge8Reason',
        },
        discountOrCharge9Reason: {
            code: 'discountOrCharge9Reason',
        },
        currency: {
            code: 'currency',
        },
        purchaseOrder: {
            id: 'purchaseOrder',
        },
        purchaseOrderLine: {
            purchaseOrder: 'purchaseOrder',
            lineNumber: 'purchaseOrderLine',
            sequenceNumber: 'purchaseOrderSequenceNumber',
        },
        purchaseReceipt: {
            id: 'purchaseReceipt',
        },
        purchaseReceiptLine: {
            purchaseReceipt: 'purchaseReceipt',
            lineNumber: 'purchaseReceiptLine',
        },
        purchaseReturn: {
            id: 'purchaseReturn',
        },
        purchaseReturnLine: {
            purchaseReturn: 'purchaseReturn',
            lineNumber: 'purchaseReturnLine',
        },
        purchaseShipment: {
            id: 'purchaseShipment',
        },
        purchaseShipmentLine: {
            purchaseShipment: 'purchaseShipment',
            lineNumber: 'purchaseShipmentLine',
        },
        sourcePurchaseInvoice: {
            id: 'sourcePurchaseInvoice',
        },
        sourcePurchaseInvoiceLine: {
            purchaseInvoice: 'sourcePurchaseInvoice',
            lineNumber: 'sourcePurchaseInvoiceLine',
        },
        supplier: {
            code: 'supplier',
        },
        project: {
            id: 'project',
        },
        issueRegion: {
            glossaryId() {
                return 364;
            },
            code: 'issueRegion',
        },
        receiptRegion: {
            glossaryId() {
                return 364;
            },
            code: 'receiptRegion',
        },
        nonFinancialUnit: {
            code: 'nonFinancialUnit',
        },
        companyCurrency: {
            code: 'companyCurrency',
        },
        cost: {
            code: 'cost',
        },
        invoiceLineTextRef: {
            code: 'invoiceLineTextKey',
        },
    },
};
const compositeReferences = {
    invoiceLineTextRef: {
        invoiceLineText: 'text',
    },
};
let PurchaseInvoiceLine = class PurchaseInvoiceLine extends xtrem_core_1.Node {
};
exports.PurchaseInvoiceLine = PurchaseInvoiceLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeader,
    })
], PurchaseInvoiceLine.prototype, "purchaseInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIDLIN',
    })
], PurchaseInvoiceLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVTYP',
        dataType: () => sageX3InvoicingData.enums.invoiceTypeDatatype,
    })
], PurchaseInvoiceLine.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIVTYP',
        columnType: 'string',
        node: () => sageX3PurchasingData.nodes.PurchaseInvoiceType,
    })
], PurchaseInvoiceLine.prototype, "invoiceType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIHTYP',
        dataType: () => sageX3MasterData.enums.purchaseInvoiceCategoryDatatype,
    })
], PurchaseInvoiceLine.prototype, "purchaseInvoiceCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], PurchaseInvoiceLine.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseInvoiceLine.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoiceLine.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseInvoiceLine.prototype, "billBySupplier", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYLIN',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], PurchaseInvoiceLine.prototype, "lineSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TYPORI',
        dataType: () => sageX3Purchasing.enums.purchaseInvoiceSourceDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceLine", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUMORI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceDocument", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINORI',
    })
], PurchaseInvoiceLine.prototype, "sourceDocumentLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SEQORI',
    })
], PurchaseInvoiceLine.prototype, "sourceDocumentSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], PurchaseInvoiceLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoiceLine.prototype, "productDescriptionInUserLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMDES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoiceLine.prototype, "productDescriptionInSupplierLanguage", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "invoicingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PUU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "purchaseUnit", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "stockUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'UOMPUUCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "stockUnitToPurchaseUnitConversionFactor", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYUOM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "quantityInInvoiceUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "quantityInPurchaseUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIQTYPUU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYSTU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "quantityInStockUnitInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "weight", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIQTYWEU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceWeight", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINWEU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "weightUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "volume", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORIQTYVOU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceVolume", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINVOU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "volumeUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GROPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "grossPrice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRIREN',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
    })
], PurchaseInvoiceLine.prototype, "priceReason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGVAL9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN1',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp1ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge1Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN2',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp2ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge2Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN3',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp3ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge3Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN4',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp4ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge4Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN5',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp5ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge5Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN6',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp6ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge6Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN7',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp7ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge7Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN8',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp8ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge8Reason", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGREN9',
        columnType: 'integer',
        node: () => sageX3PurchasingData.nodes.PurchasePriceReason,
        serviceOptions: () => [sageX3System.serviceOptions.Pp9ActivityCode],
    })
], PurchaseInvoiceLine.prototype, "discountOrCharge9Reason", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "netPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORINETPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "sourceNetPrice", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINPURTYP',
        dataType: () => sageX3InvoicingData.enums.purchaseTypeDatatype,
    })
], PurchaseInvoiceLine.prototype, "purchaseType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement1AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement2AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement3AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement4AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement5AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement6AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement7AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement8AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISCRGAMT9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElement9AmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NETCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseInvoiceLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseOrder,
    })
], PurchaseInvoiceLine.prototype, "purchaseOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POPLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseOrderLine,
    })
], PurchaseInvoiceLine.prototype, "purchaseOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POQSEQ',
    })
], PurchaseInvoiceLine.prototype, "purchaseOrderSequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReceipt,
    })
], PurchaseInvoiceLine.prototype, "purchaseReceipt", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTDLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseReceiptLine,
    })
], PurchaseInvoiceLine.prototype, "purchaseReceiptLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PNHNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseReturn,
    })
], PurchaseInvoiceLine.prototype, "purchaseReturn", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PNDLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseReturnLine,
    })
], PurchaseInvoiceLine.prototype, "purchaseReturnLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIPNUM',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.PurchaseShipment,
    })
], PurchaseInvoiceLine.prototype, "purchaseShipment", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHIPLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseShipmentLine,
    })
], PurchaseInvoiceLine.prototype, "purchaseShipmentLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVNUM',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.SupplierInvoiceHeader,
    })
], PurchaseInvoiceLine.prototype, "sourcePurchaseInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'INVLIN',
        columnType: 'integer',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceLine,
    })
], PurchaseInvoiceLine.prototype, "sourcePurchaseInvoiceLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPSNUM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Supplier,
    })
], PurchaseInvoiceLine.prototype, "supplier", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCPDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoiceLine.prototype, "receiptDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PJT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], PurchaseInvoiceLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SATISS',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 364,
            },
            control: {
                glossaryId: 364,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "issueRegion", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SATRCP',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 364,
            },
            control: {
                glossaryId: 364,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "receiptRegion", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "lineAmountExcludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTATILIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "lineAmountIncludingTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTDEPLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "discountAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount4", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount5", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount6", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount7", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount8", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DDTADEP9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "distributedInvoicingElementEarlyDiscountAmount9", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYBUDLIN',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "quantityUncommitted", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTYGLU',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "quantityActualCommitted", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'GLU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], PurchaseInvoiceLine.prototype, "nonFinancialUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "calculatedTaxableBase1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "calculatedTaxableBase2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "calculatedTaxableBase3", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "calculationBasisForReceiptTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "calculationBasisForIssueTax", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "calculationBasisForOtherTax1", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLCAMT7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "calculationBasisForOtherTax2", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DISBASLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "rebateOnTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BASTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "taxableBase1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax1amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax2amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax3amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "receiptTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "issueTaxAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "otherTax1Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "otherTax2Amount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXLIN3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "tax3DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXRCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "receiptTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXISS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "issueTaxDeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "otherTax1DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEDTAXOTH2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PtxActivityCode],
    })
], PurchaseInvoiceLine.prototype, "otherTax2DeductibleAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "landedCostCoefficient", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPRAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "fixedLandedCostPerUnitInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "costPriceInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "purchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINAMTCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "lineStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "linePurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STCNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoiceLine.prototype, "costStructure", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPRCUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], PurchaseInvoiceLine.prototype, "companyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "totalStockCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCSTPUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "totalPurchaseCostInCompanyCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRTFLG',
    })
], PurchaseInvoiceLine.prototype, "isPartiallyInvoiced", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'LINTEX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseInvoiceLine.prototype, "invoiceLineTextKey", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LINEECFLG',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoiceLine.prototype, "isExtractedLineFromIntrastat", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EECFLOPHY',
        serviceOptions: () => [sageX3System.serviceOptions.DebActivityCode],
    })
], PurchaseInvoiceLine.prototype, "isIntrastatPhysicalFlow", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoiceLine.prototype, "serviceStartDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], PurchaseInvoiceLine.prototype, "serviceEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERNBR',
    })
], PurchaseInvoiceLine.prototype, "servicePeriodNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PERTYP',
        dataType: () => sageX3InvoicingData.enums.periodicityTypeDatatype,
    })
], PurchaseInvoiceLine.prototype, "servicePeriodType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LINTYP',
        dataType: () => sageX3PurchasingData.enums.orderLineTypeDatatype,
    })
], PurchaseInvoiceLine.prototype, "lineType", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIKQTYCOE',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "linkQuantityCoefficientForSubcontract", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTNOTLINCAL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], PurchaseInvoiceLine.prototype, "calculatedTaxExcludedLineAmount", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLEECNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.KpoActivityCode],
    })
], PurchaseInvoiceLine.prototype, "vatDeclarationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSTMAJLIN',
    })
], PurchaseInvoiceLine.prototype, "costUpdatedIfAdditionalInvoice", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCSCOD',
        columnType: 'string',
        node: () => sageX3Purchasing.nodes.Cost,
    })
], PurchaseInvoiceLine.prototype, "cost", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STCRFLG',
    })
], PurchaseInvoiceLine.prototype, "isReconciled", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITMKND',
        dataType: () => sageX3Purchasing.enums.purchasingProductTypeDatatype,
    })
], PurchaseInvoiceLine.prototype, "productType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.CommonText,
    })
], PurchaseInvoiceLine.prototype, "invoiceLineTextRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TEXTE',
    })
], PurchaseInvoiceLine.prototype, "invoiceLineText", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceLineProductStatisticalGroups,
    })
], PurchaseInvoiceLine.prototype, "productStatisticalGroups", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Purchasing.nodes.PurchaseInvoiceLineTaxes,
    })
], PurchaseInvoiceLine.prototype, "taxes", void 0);
exports.PurchaseInvoiceLine = PurchaseInvoiceLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PINVOICED',
        keyPropertyNames: ['purchaseInvoice', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    purchaseInvoice: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseInvoiceLine);
//# sourceMappingURL=purchase-invoice-line.js.map