"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PurchaseEntryTransaction = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3PurchasingData = require("@sage/x3-purchasing-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        accessCode: {
            access: 'accessCode',
        },
        defaultStockMovementGroup: {
            glossaryId() {
                return 9;
            },
            code: 'defaultStockMovementGroup',
        },
        stockAutomaticJournal: {
            code: 'stockAutomaticJournal',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
    },
};
let PurchaseEntryTransaction = class PurchaseEntryTransaction extends xtrem_core_1.Node {
};
exports.PurchaseEntryTransaction = PurchaseEntryTransaction;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTRTYP',
        dataType: () => sageX3PurchasingData.enums.purchaseDocumentTypeDatatype,
    })
], PurchaseEntryTransaction.prototype, "entryTransactionType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTRNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], PurchaseEntryTransaction.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        provides: ['accessCode'],
        isNullable: true,
        columnName: 'ACSCOD',
        columnType: 'string',
        node: () => sageX3System.nodes.Access,
    })
], PurchaseEntryTransaction.prototype, "accessCode", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENAFLG',
    })
], PurchaseEntryTransaction.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD01',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], PurchaseEntryTransaction.prototype, "identifier1Entry", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD02',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], PurchaseEntryTransaction.prototype, "identifier2Entry", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD1',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], PurchaseEntryTransaction.prototype, "identifier1Detail", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'IDECOD2',
        dataType: () => sageX3System.enums.entryModeDatatype,
    })
], PurchaseEntryTransaction.prototype, "identifier2Detail", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPERFLG',
    })
], PurchaseEntryTransaction.prototype, "isLotExpirationDateAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPOTFLG',
    })
], PurchaseEntryTransaction.prototype, "isLotPotencyAllowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB1FLG',
    })
], PurchaseEntryTransaction.prototype, "isLotCustomField1Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB2FLG',
    })
], PurchaseEntryTransaction.prototype, "isLotCustomField2Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB3FLG',
    })
], PurchaseEntryTransaction.prototype, "isLotCustomField3Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRUB4FLG',
    })
], PurchaseEntryTransaction.prototype, "isLotCustomField4Allowed", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSFAMDEF',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 9,
            },
            control: {
                glossaryId: 9,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PurchaseEntryTransaction.prototype, "defaultStockMovementGroup", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENTCOD',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.AutomaticJournal,
    })
], PurchaseEntryTransaction.prototype, "stockAutomaticJournal", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], PurchaseEntryTransaction.prototype, "stockMovementCode", void 0);
exports.PurchaseEntryTransaction = PurchaseEntryTransaction = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PURTRS',
        keyPropertyNames: ['entryTransactionType', 'code'],
        indexes: [
            {
                orderBy: {
                    entryTransactionType: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['entryTransactionType', 'code'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], PurchaseEntryTransaction);
//# sourceMappingURL=purchase-entry-transaction.js.map