/// <reference types="@sage/x3-master-data/api" />
import { ExpirationManagement, SerialNumberManagement, StockManagement, SupplierProduct } from '@sage/x3-master-data-api';
import { PurchaseEntryTransactionInput, PurchaseReceiptLineInput, GraphApi as PurchasingGraphApi } from '@sage/x3-purchasing-api';
import { ExpirationLeadTimeUnits, LotManagementMode, StockVersionMode } from '@sage/x3-stock-data-api';
import * as ui from '@sage/xtrem-ui';
import { packingUnit } from '../pages/mobile-purchase-receipt-enter-receipt-detail';
import { PurchaseReceiptSession } from './purchase-receipt-details-control';
interface PageWithStorageAndSite {
    site: {
        value: string;
    };
    purchaseSession: PurchaseReceiptSession;
}
interface PageWithProductSite {
    productSite: {
        product: {
            stockUnit: {
                code: string;
            };
            productCategory: {
                code: string;
            };
            code: string;
            purchaseUnit: {
                code: string;
            };
            purchaseUnitToStockUnitConversionFactor: string;
            useByDateCoefficient: string;
            expirationLeadTime: number;
            expirationTimeUnit: ExpirationLeadTimeUnits;
            lotSequenceNumber: string;
        };
        stockSite: {
            code: string;
        };
    } | undefined;
    productNode: {
        stockUnit: {
            code: string;
        };
        productCategory: {
            code: string;
        };
        code: string;
        purchaseUnit: {
            code: string;
        };
        purchaseUnitToStockUnitConversionFactor: string;
        useByDateCoefficient: string;
        expirationLeadTime: number;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        lotSequenceNumber: string;
    };
}
interface PageWithHeaderFields {
    product: {
        value: string;
    };
    description: {
        value: string;
    };
    purchaseOrderLineNumber: string | number | boolean;
    purchaseOrderNumber: string;
    supplier: {
        value: string;
    };
    headerTitleLeft: {
        value: string;
    };
    headerTitleRight: {
        value: string;
        prefix?: string;
    };
    headerLine2Left: {
        value: string;
    };
    headerLine2Right: {
        value: string;
        prefix?: string;
    };
    headerLine3Left: {
        value: string;
    };
    headerLine3Right: {
        value: string;
        prefix?: string;
    };
}
interface PageWithVersionFields {
    majorVersion: {
        isHidden: boolean;
        isMandatory: boolean;
        isDisabled: boolean;
        value: {
            code?: string;
        };
    };
    minorVersion: {
        isHidden: boolean;
        isMandatory: boolean;
        isDisabled: boolean;
        value: {
            minorVersion?: string;
        };
    };
}
interface PageWithLotFields {
    lot: {
        isHidden: boolean;
        isMandatory: boolean;
        value: string;
        isDisabled: boolean;
    };
    supplierLot: {
        isHidden: boolean;
    };
    sublot: {
        isHidden: boolean;
        isMandatory: boolean;
        value: string;
        isDisabled: boolean;
    };
    lotCustomField1: {
        isHidden: boolean;
    };
    lotCustomField2: {
        isHidden: boolean;
    };
    lotCustomField3: {
        isHidden: boolean;
    };
    lotCustomField4: {
        isHidden: boolean;
    };
    lotSequenceNumber: {
        value: string;
    };
}
interface PageWithPackUnitFields {
    receiptUnit: {
        options?: string[];
        isReadOnly: boolean;
        isDisabled: boolean;
        value: string;
    };
    receiptUnitCode: {
        value: string;
    };
    previousReceiptUnit: {
        value: string;
    };
    receiptUnits: Array<{
        node: {
            packingUnit: {
                code: string;
                numberOfDecimals: number;
                name: string;
            };
            packingUnitToStockUnitConversionFactor: string;
            isPackingFactorEntryAllowed: boolean;
            isPackingUnit: boolean;
        };
    }>;
    packingUnitToStockUnitConversionFactor: {
        value: number;
        isDisabled: boolean;
    };
    isPackingUnit: boolean;
}
interface PageWithPurchaseReceiptMiscProperties {
    status: {
        value: string;
        options?: string[];
    };
    potency: {
        isHidden: boolean;
        value: number;
    };
    serialNumber: {
        isHidden: boolean;
        isMandatory: boolean;
    };
    licensePlateNumber: {
        isHidden: boolean;
    };
    location: {
        isHidden: boolean;
        isMandatory: boolean;
        value: {
            code: string;
            type: string;
            stockSite: {
                code: string;
            };
            warehouse: {
                code: string;
            };
        };
    };
    suggestedLocation: {
        isHidden: boolean;
        value: string;
    };
    expirationDate: {
        isHidden: boolean;
        isDisabled: boolean;
        value: string;
    };
    useByDate: {
        isHidden: boolean;
        isDisabled: boolean;
        isMandatory: boolean;
        value: string;
        maxDate: string;
    };
    remainingQuantityInStockUnit: {
        value: number;
        isHidden: boolean;
    };
    remainingQuantityInPackingUnit: {
        value: number;
        isHidden: boolean;
    };
    quantityToReceive: {
        value: number;
        scale?: number;
    };
    closePoLine: {
        value: string;
        isHidden: boolean;
        options?: string[];
    };
    lot: {
        isHidden: boolean;
        value: string;
    };
    isExpirationManaged: boolean;
    identifier1: {
        isHidden: boolean;
        isDisabled: boolean;
    };
    identifier2: {
        isHidden: boolean;
        isDisabled: boolean;
    };
    container: {
        value: {
            code?: string;
        };
        isHidden: boolean;
    };
    quantityToReceiveNoRounded: number;
    quantityToReceiveRounded: number;
    remainingQuantityNoRounded: number;
    remainingQuantityRounded: number;
    remainingQuantityInitialInStockUnit: number;
    remainingQuantityInitialInOrderUnit: number;
    orderUnit: {
        code: string;
    };
    isLocationPreloaded: boolean;
}
interface PageWithShipmentLine {
    purchaseShipment: string | undefined;
    purchaseShipmentLine: number;
}
export type PurchaseReceiptsDetailPage = ui.Page<PurchasingGraphApi> & PageWithStorageAndSite & PageWithHeaderFields & PageWithVersionFields & PageWithLotFields & PageWithPackUnitFields & PageWithPurchaseReceiptMiscProperties & PageWithProductSite & PageWithShipmentLine;
type PurchaseOrderNodeResponse = {
    orderUnit: {
        code: string;
    };
    purchaseUnit: {
        code: string;
        numberOfDecimals: number;
    };
    quantityInStockUnitOrdered: string;
    quantityInStockUnitReceived: string;
    quantityInOrderUnitOrdered: string;
    quantityInPurchaseUnitOrdered: string;
    quantityInPurchaseUnitReceived: string;
    orderUnitToPurchaseUnitConversionFactor: string;
    majorProductVersion: {
        code: string;
    };
    minorProductVersion: string;
};
type NodeWithUnitData = {
    stockUnit: {
        code: string;
        numberOfDecimals: number;
    };
    purchaseUnit: {
        code: string;
        numberOfDecimals: number;
    };
    packingUnits: {
        query: {
            edges: packingUnit[];
        };
    };
    purchaseUnitToStockUnitConversionFactor: string;
};
type NodeWithMiscellaneousData = {
    product: {
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        stockManagementMode: StockManagement;
        defaultPotencyInPercentage: string;
        serialSequenceNumber: string;
        expirationLeadTime: number;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        useByDateCoefficient: string;
    };
    isLicensePlateNumberManaged: boolean;
    isLocationManaged: boolean;
    defaultInternalContainer: {
        code: string;
    };
};
type NodeProductWithMiscellaneousData = {
    serialNumberManagementMode: SerialNumberManagement;
    expirationManagementMode: ExpirationManagement;
    stockManagementMode: StockManagement;
    defaultPotencyInPercentage: string;
    serialSequenceNumber: string;
    expirationLeadTime: number;
    expirationTimeUnit: ExpirationLeadTimeUnits;
    useByDateCoefficient: string;
};
type shipmentLineNodeResponse = {
    purchaseShipment: {
        id: string;
    };
    lineNumber: number;
    product: {
        code: string;
    };
    quantityInPurchaseUnitExpected: string;
    quantityInOrderUnitShipped: string;
    quantityInPurchaseUnitShipped: string;
    quantityInStockUnitShipped: string;
    orderUnitToPurchaseUnitConversionFactor: string;
    orderUnit: {
        code: string;
    };
    stockUnit: {
        code: string;
    };
};
export declare class PurchaseReceiptDetailsInitializer {
    private static readonly QTY_DECIMAL_PLACES;
    private static readonly CONVERSION_RATE_DECIMAL_PLACES;
    static initializePage(page: PurchaseReceiptsDetailPage, closePoLineOptions: string[]): Promise<boolean>;
    static calculateRemainingQuantity(page: PageWithHeaderFields, purchaseOrderLine: PurchaseOrderNodeResponse, lines: PurchaseReceiptLineInput[], shipmentLine: shipmentLineNodeResponse | null, remainingQuantity: number[]): void;
    static initReceiptLines(page: PurchaseReceiptsDetailPage, newDetail?: boolean): void;
    static initHeader(page: PageWithHeaderFields, productNode: {
        code: string;
        localizedDescription1: string;
    }, purchaseOrderLine: PurchaseOrderNodeResponse | null, lines: PurchaseReceiptLineInput[] | undefined, shipmentLine: shipmentLineNodeResponse | null): void;
    static initVersionFields(page: PageWithVersionFields, productNode: {
        stockVersionMode: StockVersionMode;
    }, purchaseOrderLineNode?: {
        majorProductVersion: {
            code: string;
        };
        minorProductVersion: string;
    }): void;
    static initLotFields(page: PageWithLotFields, productNode: {
        lotManagementMode: LotManagementMode;
        lotSequenceNumber: string;
    }, transactionEntry: PurchaseEntryTransactionInput, lotManagementRule: string, lotByDefault: string): void;
    static initReceiptUnitFields(page: PageWithPackUnitFields & {
        quantityToReceive: {
            scale?: number;
        };
    }, productNode: NodeWithUnitData, supplierProduct: SupplierProduct): void;
    static initMiscellaneousFields(page: PageWithPurchaseReceiptMiscProperties, productNode: NodeProductWithMiscellaneousData, productSiteNode: NodeWithMiscellaneousData | undefined, statuses: string[], defaultStatus: string, transactionEntry: PurchaseEntryTransactionInput, lpnManagementRule: string): void;
    static initPoCloseLineSelect(page: PageWithPurchaseReceiptMiscProperties, closePoLineOptions: string[]): void;
}
export {};
//# sourceMappingURL=purchase-receipt-details-initializer.d.ts.map