import { GraphApi, PurchaseEntryTransactionInput, PurchaseReceiptInput } from '@sage/x3-purchasing-api';
import { StockManagementRules } from '@sage/x3-stock-data-api';
import { Page } from '@sage/xtrem-ui';
export declare function validate(page: Page): Promise<boolean>;
export declare function controlLotReceipt(pageInstance: Page, lot: string, product: string, entryType: string, site: string): Promise<boolean>;
export type PurchaseReceiptSession = {
    purchaseReceipt: PurchaseReceiptInput;
    purchaseEntryTransaction: PurchaseEntryTransactionInput;
    purchaseStockManagementRules?: StockManagementRules;
    orderUnitToPurchaseUnitConversionFactor: number;
} | null;
export declare class PurchaseReceiptDetailsRecordManager {
    private page;
    constructor(page: Page<GraphApi>, cleanupIncompleteSessionLines?: boolean);
    private static readonly PURCHASE_RECEIPT_KEY;
    private _purchaseSession;
    private _stockDetails;
    private _receiptUnit;
    private _unitIsSame;
    get purchaseSession(): PurchaseReceiptSession;
    set purchaseSession(purchaseSession: PurchaseReceiptSession);
    private _checkStorage;
    private _cleanupSession;
    clearSession(): void;
    createLine(page: {
        closePoLine: {
            value: string | null;
            options?: string[];
        };
        description: {
            value: string | null;
        };
        site: {
            value: string | null;
        };
        supplier: {
            value: string | null;
        };
        purchaseOrderNumber: string;
        purchaseOrderLineNumber: string | number | boolean;
        warehouse: {
            value: string | null;
        };
        container: {
            value: {
                code?: string;
            } | null;
        };
        packingUnitToStockUnitConversionFactor: {
            value: number | null;
        };
    }, product: {
        stockUnit: {
            code: string;
        };
        code: string;
    }): void;
    loadStockDetails(page: {
        receiptUnit: {
            value: string | null;
        };
        receiptUnitCode: {
            value: string | null;
        };
        quantityToReceive: {
            value: number | null;
        };
        quantityToReceiveNoRounded: number;
        isPackingUnit: boolean;
        remainingQuantityInPackingUnit: {
            value: number | null;
        };
        remainingQuantityInStockUnit: {
            value: number | null;
        };
        packingUnitToStockUnitConversionFactor: {
            value: number | null;
        };
        warehouse: {
            value: string | null;
        };
        status: {
            value: string | null;
        };
        licensePlateNumber: {
            value: {
                code?: string;
            } | null;
        };
        location: {
            value: {
                code?: string;
            } | null;
            isDisabled?: boolean;
        };
        supplierLot: {
            value: string | null;
        };
        lot: {
            value: string | null;
        };
        sublot: {
            value: string | null;
        };
        potency: {
            value: number | null;
        };
        expirationDate: {
            value: string | null;
            isDisabled?: boolean;
        };
        calculatedExpirationDate: {
            value: string | null;
        };
        useByDate: {
            value: string | null;
        };
        serialNumber: {
            value: string | null;
        };
        majorVersion: {
            value: {
                code?: string;
            } | null;
        };
        minorVersion: {
            value: {
                minorVersion?: string;
            } | null;
        };
        lotCustomField1: {
            value: string | null;
        };
        lotCustomField2: {
            value: string | null;
        };
        lotCustomField3: {
            value: number | null;
        };
        lotCustomField4: {
            value: string | null;
        };
        identifier1: {
            value: string | null;
        };
        identifier2: {
            value: string | null;
        };
    }, product: {
        stockUnit: {
            code: string;
        };
        code: string;
    }): void;
}
//# sourceMappingURL=purchase-receipt-details-control.d.ts.map