"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductSiteData = void 0;
const dialogs_1 = require("@sage/x3-master-data/lib/client-functions/dialogs");
const ui = require("@sage/xtrem-ui");
class ProductSiteData {
    constructor(productCode, site, page) {
        this.productCode = productCode;
        this.site = site;
        this.page = page;
    }
    async _lazyLoadProductSite() {
        if (this._productSite) {
            return this._productSite;
        }
        // read product site record
        try {
            const productSiteToReceive = (await this.page.$.graph
                .node('@sage/x3-master-data/ProductSite')
                .read({
                isLicensePlateNumberManaged: true,
                isLocationManaged: true,
                stockSite: {
                    code: true,
                },
                defaultLocations: {
                    query: {
                        edges: {
                            node: {
                                defaultLocationType: true,
                                locationNumber: true,
                                defaultLocation: true,
                            },
                        },
                    },
                },
                product: {
                    code: true,
                    productCategory: { code: true },
                    serialNumberManagementMode: true,
                    serialSequenceNumber: true,
                    localizedDescription1: true,
                    lotManagementMode: true,
                    lotSequenceNumber: true,
                    stockVersionMode: true,
                    expirationManagementMode: true,
                    stockManagementMode: true,
                    defaultPotencyInPercentage: true,
                    purchaseUnitToStockUnitConversionFactor: true,
                    useByDateCoefficient: true,
                    expirationLeadTime: true,
                    expirationTimeUnit: true,
                    stockUnit: {
                        code: true,
                        numberOfDecimals: true,
                    },
                    purchaseUnit: {
                        code: true,
                        numberOfDecimals: true,
                    },
                    packingUnits: {
                        query: {
                            edges: {
                                node: {
                                    packingUnit: {
                                        code: true,
                                        numberOfDecimals: true,
                                    },
                                    packingUnitToStockUnitConversionFactor: true,
                                    isPackingFactorEntryAllowed: true,
                                },
                            },
                        },
                    },
                },
                defaultInternalContainer: {
                    code: true,
                },
            }, `${this.productCode}|${this.site}`)
                .execute());
            this._productSite = productSiteToReceive;
        }
        catch (e) {
            await (0, dialogs_1.dialogMessage)(this.page, 'error', ui.localize('@sage/x3-purchasing/error-loading-product-site', 'Error loading product-site'), String(e));
            return undefined;
        }
        return this._productSite;
    }
    async _lazyLoadProduct() {
        if (this._product) {
            return this._product;
        }
        // read product site record
        try {
            const productToReceive = (await this.page.$.graph
                .node('@sage/x3-master-data/Product')
                .read({
                code: true,
                productCategory: { code: true },
                serialNumberManagementMode: true,
                serialSequenceNumber: true,
                localizedDescription1: true,
                lotManagementMode: true,
                lotSequenceNumber: true,
                stockVersionMode: true,
                expirationManagementMode: true,
                stockManagementMode: true,
                defaultPotencyInPercentage: true,
                purchaseUnitToStockUnitConversionFactor: true,
                useByDateCoefficient: true,
                expirationLeadTime: true,
                expirationTimeUnit: true,
                stockUnit: {
                    code: true,
                    numberOfDecimals: true,
                },
                purchaseUnit: {
                    code: true,
                    numberOfDecimals: true,
                },
                packingUnits: {
                    query: {
                        edges: {
                            node: {
                                packingUnit: {
                                    code: true,
                                    numberOfDecimals: true,
                                },
                                packingUnitToStockUnitConversionFactor: true,
                                isPackingFactorEntryAllowed: true,
                            },
                        },
                    },
                },
            }, `${this.productCode}`)
                .execute());
            this._product = productToReceive;
        }
        catch (e) {
            await (0, dialogs_1.dialogMessage)(this.page, 'error', ui.localize('@sage/x3-purchasing/error-loading-product', 'Error loading product.'), String(e));
            return undefined;
        }
        return this._product;
    }
    /*
     * The GraphQL query that will be used to get values of the product-site node.
     * This default query can be modified or completely overridden.
     */
    get productSite() {
        return this._lazyLoadProductSite();
    }
    get product() {
        return this._lazyLoadProduct();
    }
}
exports.ProductSiteData = ProductSiteData;
//# sourceMappingURL=product-site-data.js.map