import { dialogMessage } from '@sage/x3-master-data/lib/client-functions/dialogs';
import { GraphApi, PurchaseOrder } from '@sage/x3-purchasing-api';
import { Filter } from '@sage/xtrem-client';
import * as ui from '@sage/xtrem-ui';

/** @internal */
function generateDetailFilter(currentSite: string, expectedDate: string): Filter<PurchaseOrder> {
    const orderFilter: Filter<PurchaseOrder> = {
        signatureStatus: {
            _in: ['inFull', 'notManaged', 'automatic'],
        },
        receiptStatus: {
            _in: ['no', 'inPart'],
        },
        isClosed: {
            _eq: false,
        },
    };

    if (expectedDate !== '') {
        orderFilter.purchaseOrderLines = {
            _atLeast: 1,
            receiptSite: {
                code: currentSite,
            },
            isClosed: false,
            /*    product: {
                productStatus: {
                    _eq: 'active',
                },
            }, very slow timeout */
            expectedReceiptDate: {
                _lte: expectedDate,
            },
        };
    } else {
        orderFilter.purchaseOrderLines = {
            _atLeast: 1,
            receiptSite: {
                code: currentSite,
            },
            isClosed: false,
            /*   product: {
                productStatus: {
                    _eq: 'active',
                },
            }, very slow timeout */
        };
    }

    return orderFilter;
}
@ui.decorators.page<MobileViewPurchaseOrderSelectAPurchaseOrder, PurchaseOrder>({
    module: 'x3-purchasing',
    title: 'Purchase orders',
    subtitle: 'Select a purchase order',
    isTitleHidden: true,
    node: '@sage/x3-purchasing/PurchaseOrder',
    isTransient: false,
    authorizationCode: 'INQPOH',
    skipDirtyCheck: true,
    async onLoad() {
        if (!this.$.storage.get('mobile-selected-stock-site')) {
            await dialogMessage(
                this,
                'error',
                ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error'),
                ui.localize('@sage/x3-purchasing-sales/dialog-error-set-site', 'Stock site not defined'),
            );
        } else {
            this.siteField.value = this.$.storage.get('mobile-selected-stock-site').toString();
        }
        this.receiptDate.value = String(this.$.storage.get('receiptDate'));
    },
    headerCard() {
        return {
            title: this.siteField,
        };
    },
    navigationPanel: {
        canFilter: false,
        isHeaderHidden: true,
        isAutoSelectEnabled: true,
        optionsMenu: [
            {
                title: '',
                graphQLFilter: (storage: any, _queryParameters: any) =>
                    generateDetailFilter(
                        storage.get('mobile-selected-stock-site').toString(),
                        storage.get('receiptDate').toString(),
                    ),
            },
        ],
        listItem: {
            title: ui.nestedFields.text({ bind: 'id' }),
            titleRight: ui.nestedFields.reference({
                bind: 'orderFromSupplier',
                valueField: { code: { code: true } },
                node: '@sage/x3-master-data/BusinessPartner',
            }),
            line2: ui.nestedFields.reference({
                bind: 'orderFromSupplier',
                valueField: { code: { shortCompanyName: true } },
                node: '@sage/x3-master-data/BusinessPartner',
            }),
            line3: ui.nestedFields.text({
                bind: 'isIntersite',
                isHidden: true,
            }),
        },

        onSelect(listItemValue: any) {
            this.$.router.goTo('@sage/x3-purchasing-sales/MobileViewPurchaseOrderSelectAPurchaseOrderLine', {
                purchaseOrder: listItemValue.id,
                orderFromSupplier: listItemValue.orderFromSupplier.code.code,
                site: this.siteField.value,
                receiptDate: this.receiptDate.value,
                isIntersite: listItemValue.isIntersite,
                shortCompanyName: listItemValue.orderFromSupplier.code.shortCompanyName,
            });
            return true;
        },

        orderBy: {
            orderFromSupplier: {
                code: {
                    code: 1,
                },
            },
        },
    },
})
export class MobileViewPurchaseOrderSelectAPurchaseOrder extends ui.Page<GraphApi> {
    @ui.decorators.section<MobileViewPurchaseOrderSelectAPurchaseOrder>({
        isHidden: true,
    })
    mainSection: ui.containers.Section;

    @ui.decorators.block<MobileViewPurchaseOrderSelectAPurchaseOrder>({
        parent() {
            return this.mainSection;
        },
    })
    mainBlock: ui.containers.Block;

    @ui.decorators.textField<MobileViewPurchaseOrderSelectAPurchaseOrder>({
        parent() {
            return this.mainBlock;
        },
        isTransient: true,
        bind: 'purchaseOrder',
    })
    id: ui.fields.Text;

    @ui.decorators.labelField<MobileViewPurchaseOrderSelectAPurchaseOrder>({
        parent() {
            return this.mainBlock;
        },
        isTransient: true,
    })
    siteField: ui.fields.Label;

    @ui.decorators.dateField<MobileViewPurchaseOrderSelectAPurchaseOrder>({
        isTransient: true,
        isReadOnly: true,
    })
    receiptDate: ui.fields.Date;
}
