/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/client-functions/intersite-receipt-details-control.ts":
/*!*******************************************************************!*\
  !*** ./lib/client-functions/intersite-receipt-details-control.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.IntersiteReceiptDetailsRecordManager = exports.controlLotReceipt = exports.validate = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst xtrem_ui_1 = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function validate(page) {\n    // (X3-201046, X3-203885) TODO Issue: Have better validation error messages that specifically tell which fields have issues\n    const errors = await page.$.page.validate();\n    if (typesLib.strictEq(errors.length, 0)) {\n        return true;\n    }\n    page.$.showToast(`${(0, xtrem_ui_1.localize)('@sage/x3-purchasing-sales/dialog-error-title', 'Error')}: ${errors[0]}`, {\n        type: 'error',\n        timeout: 30000,\n    });\n    return false;\n}\nexports.validate = validate;\nasync function controlLotReceipt(pageInstance, lot, product, entryType, site) {\n    if (!lot || !product || !entryType)\n        throw new Error('Invalid arguments');\n    const stockJournalFilter = {\n        stockSite: site,\n        documentType: entryType,\n        product: { code: product },\n        isUpdated: true,\n        lot: lot,\n    };\n    const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n        .node('@sage/x3-stock-data/StockJournal')\n        .query(xtrem_ui_1.queryUtils.edgesSelector({\n        lot: true,\n        sublot: true,\n    }, {\n        filter: stockJournalFilter,\n    }))\n        .execute());\n    if (typesLib.gt(response.length, 0)) {\n        pageInstance.$.showToast((0, xtrem_ui_1.localize)('@sage/x3-purchasing-sales/notification-error-receipt-lot', 'the lot number {{ lot }} already exists for this product', { lot: lot }), { type: 'error' });\n        return false;\n    }\n    return true;\n}\nexports.controlLotReceipt = controlLotReceipt;\nvar YesNoEnum;\n(function (YesNoEnum) {\n    YesNoEnum[YesNoEnum[\"no\"] = 1] = \"no\";\n    YesNoEnum[YesNoEnum[\"yes\"] = 2] = \"yes\";\n})(YesNoEnum || (YesNoEnum = {}));\nclass IntersiteReceiptDetailsRecordManager {\n    constructor(page, cleanupIncompleteSessionLines = false) {\n        this.page = page;\n        if (cleanupIncompleteSessionLines)\n            this._cleanupSession();\n    }\n    static { this.INTERSITE_RECEIPT_KEY = 'IntersiteReceipt'; }\n    get intersiteSession() {\n        if (this._intersiteSession) {\n            return this._intersiteSession;\n        }\n        const storedSession = this.page.$.storage.get(IntersiteReceiptDetailsRecordManager.INTERSITE_RECEIPT_KEY);\n        if (storedSession) {\n            const parsedSession = JSON.parse(storedSession);\n            if (this._checkStorage(parsedSession)) {\n                this._intersiteSession = parsedSession;\n            }\n            else {\n                this.clearSession();\n            }\n        }\n        return this._intersiteSession;\n    }\n    set intersiteSession(intersiteSession) {\n        if (!intersiteSession) {\n            return;\n        }\n        if (!this._checkStorage(intersiteSession)) {\n            throw new Error('Invalid Intersite Receipt session');\n        }\n        this.page.$.storage.set(IntersiteReceiptDetailsRecordManager.INTERSITE_RECEIPT_KEY, JSON.stringify(intersiteSession));\n        this._intersiteSession = intersiteSession;\n    }\n    _checkStorage(sessionData) {\n        if (!sessionData || !sessionData.purchaseEntryTransaction.code || !sessionData.purchaseReceipt.receiptDate) {\n            return false;\n        }\n        return true;\n    }\n    _cleanupSession() {\n        this._intersiteSession = this.intersiteSession; // get the latest from session\n        if (!this._intersiteSession || !this._intersiteSession.purchaseReceipt.lines)\n            return;\n        const prevLineCount = this._intersiteSession.purchaseReceipt.lines.length;\n        this._intersiteSession.purchaseReceipt.lines = this._intersiteSession.purchaseReceipt.lines.filter((line) => {\n            if (!line.receiptUnit || typesLib.strictEq(line.quantityInReceiptUnitReceived, null) || typesLib.strictEq(line.quantityInReceiptUnitReceived, undefined) ||\n                !line.stockDetails) {\n                return false;\n            }\n            return !line.stockDetails.some(detail => {\n                // check for each stock detail on this line, the packing unit & quantity are defined\n                return (!detail.packingUnit || typesLib.strictEq(detail.quantityInPackingUnit, null) || typesLib.strictEq(detail.quantityInPackingUnit, undefined));\n            });\n        });\n        if (typesLib.strictEq(this._intersiteSession.purchaseReceipt.lines.length, 0)) {\n            this.clearSession();\n        }\n        else if (typesLib.strictNe(prevLineCount, this._intersiteSession.purchaseReceipt.lines.length)) {\n            this.intersiteSession = this._intersiteSession;\n        }\n    }\n    clearSession() {\n        this.page.$.storage.remove(IntersiteReceiptDetailsRecordManager.INTERSITE_RECEIPT_KEY);\n        this._intersiteSession = undefined;\n    }\n}\nexports.IntersiteReceiptDetailsRecordManager = IntersiteReceiptDetailsRecordManager;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/intersite-receipt-details-control.ts\n");

/***/ }),

/***/ "./lib/client-functions/intersite-receipt-details-initializer.ts":
/*!***********************************************************************!*\
  !*** ./lib/client-functions/intersite-receipt-details-initializer.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.IntersiteReceiptDetailsInitializer = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst pat_converter_1 = __webpack_require__(/*! @sage/x3-system/lib/shared-functions/pat-converter */ \"../../shared/x3-system/lib/shared-functions/pat-converter.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst stock_management_rules_1 = __webpack_require__(/*! ../client-functions/stock-management-rules */ \"./lib/client-functions/stock-management-rules.ts\");\n/*\n * Initializer helper class for the Purchase Receipts Detail page.\n */\nclass IntersiteReceiptDetailsInitializer {\n    static { this.QTY_DECIMAL_PLACES = 8; } // this precision is based on how classic Sage X3 4GL calculates remaining quantity in ENVADC.src\n    static { this.CONVERSION_RATE_DECIMAL_PLACES = 6; } //Display and precision length is defined by the X3 datatype which we do not have access to currently.  Setting to 6 decimal places for now as this is the precisions of the conversion rate data type.\n    static async initializePage(page) {\n        if (!page.intersiteSession) {\n            return false;\n        }\n        const salesDeliveryLine = await this._getSalesDeveryLine(page);\n        if (!salesDeliveryLine) {\n            return false;\n        }\n        const productSite = await this._getProductSite(page, salesDeliveryLine.product.code, salesDeliveryLine.salesDelivery.receivingSite.code);\n        if (!productSite) {\n            return false;\n        }\n        const productReceivingSite = await this._getProductSite(page, salesDeliveryLine.product.code, salesDeliveryLine.salesDelivery.receivingSite.code);\n        if (!productReceivingSite) {\n            return false;\n        }\n        await this._getStockJournals(page, salesDeliveryLine.product.code, salesDeliveryLine.salesDelivery.salesSite.code);\n        if (typesLib.strictEq(page.stockJournalNodeResponses.length, 0)) {\n            return false;\n        }\n        const transactionEntry = page.intersiteSession.purchaseEntryTransaction;\n        page.site.value = salesDeliveryLine.salesDelivery.receivingSite.code;\n        page.supplier.value =\n            salesDeliveryLine.salesOrderLine?.purchaseOrder?.orderFromSupplier?.code?.code ??\n                salesDeliveryLine.salesDelivery.salesSite.code;\n        let supplierProductUnits;\n        try {\n            supplierProductUnits = (await page.$.graph\n                .node('@sage/x3-master-data/SupplierProduct')\n                .read({\n                purchaseUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                purchaseUnitToStockUnitConversionFactor: true,\n                packingUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                packingUnitToPurchaseUnitConversionFactor: true,\n            }, `${salesDeliveryLine.product.code}|${salesDeliveryLine.salesOrderLine?.purchaseOrder?.orderFromSupplier?.code?.code}`)\n                .execute());\n            if (supplierProductUnits) {\n                const receiptUnitOptions = page.receiptUnit.options;\n                if (supplierProductUnits.purchaseUnit &&\n                    !page.receiptUnits.find(item => typesLib.strictEq(item.node.packingUnit.code, supplierProductUnits.purchaseUnit.code))) {\n                    page.receiptUnits.push({\n                        node: {\n                            packingUnit: {\n                                code: supplierProductUnits.purchaseUnit.code,\n                                numberOfDecimals: supplierProductUnits.purchaseUnit.numberOfDecimals,\n                            },\n                            packingUnitToStockUnitConversionFactor: '1',\n                            isPackingFactorEntryAllowed: false,\n                        },\n                    });\n                    receiptUnitOptions?.push(supplierProductUnits.purchaseUnit.code);\n                }\n                if (supplierProductUnits.packingUnit &&\n                    !page.receiptUnits.find(item => typesLib.strictEq(item.node.packingUnit.code, supplierProductUnits.packingUnit.code))) {\n                    page.receiptUnits.push({\n                        node: {\n                            packingUnit: {\n                                code: supplierProductUnits.packingUnit.code,\n                                numberOfDecimals: supplierProductUnits.packingUnit.numberOfDecimals,\n                            },\n                            packingUnitToStockUnitConversionFactor: '1',\n                            isPackingFactorEntryAllowed: false,\n                        },\n                    });\n                    receiptUnitOptions?.push(supplierProductUnits.packingUnit.code);\n                }\n                page.receiptUnit.options = receiptUnitOptions;\n            }\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-supplier-product', 'Error loading supplier product'), String(e));\n        }\n        page.receiptUnit.value = salesDeliveryLine.salesUnit.code;\n        page.previousReceiptUnit.value = page.receiptUnit.value;\n        page.product.value = salesDeliveryLine.product.code;\n        page.intersiteSession.purchaseStockManagementRules = await (0, stock_management_rules_1.findStockManagementRules)(page.site.value, productSite.product.productCategory.code, '3', transactionEntry?.stockMovementCode, page);\n        page.status.options = await this._getStatuses(page);\n        page.status.value = page.intersiteSession?.purchaseStockManagementRules?.defaultStatus ?? '';\n        const lpnManagementRule = page.intersiteSession.purchaseStockManagementRules?.licensePlateNumberEntry;\n        const lotManagement = productSite.product.lotManagementMode;\n        const lotNotManaged = typesLib.strictEq(lotManagement, 'notManaged');\n        page.lot.isHidden = lotNotManaged;\n        page.supplierLot.isHidden = lotNotManaged;\n        page.sublot.isHidden = typesLib.strictNe(lotManagement, 'lotAndSublot');\n        page.lotCustomField1.isHidden = !transactionEntry.isLotCustomField1Allowed || lotNotManaged;\n        page.lotCustomField2.isHidden = !transactionEntry.isLotCustomField2Allowed || lotNotManaged;\n        page.lotCustomField3.isHidden = !transactionEntry.isLotCustomField3Allowed || lotNotManaged;\n        page.lotCustomField4.isHidden = !transactionEntry.isLotCustomField4Allowed || lotNotManaged;\n        const serialNumberManagement = productSite.product.serialNumberManagementMode;\n        page.serialNumber.isHidden = typesLib.strictEq(serialNumberManagement, 'notManaged') || typesLib.strictEq(serialNumberManagement, 'issued');\n        page.licensePlateNumber.isHidden = !productSite.isLicensePlateNumberManaged;\n        page.location.isHidden = !productSite.isLocationManaged;\n        page.location.isMandatory = !page.location.isHidden;\n        const expirationManagement = productSite.product.expirationManagementMode;\n        page.isExpirationManaged = typesLib.strictNe(expirationManagement, 'notManaged');\n        page.expirationDate.isHidden = page.useByDate.isHidden = !page.isExpirationManaged;\n        switch (transactionEntry.identifier1Detail) {\n            case 'entered':\n            case 'displayed': {\n                page.identifier1.isHidden = false;\n                page.identifier1.isDisabled = true;\n                break;\n            }\n            default: {\n                page.identifier1.isHidden = true;\n            }\n        }\n        switch (transactionEntry.identifier2Detail) {\n            case 'entered':\n            case 'displayed': {\n                page.identifier2.isHidden = false;\n                page.identifier2.isDisabled = true;\n                break;\n            }\n            default: {\n                page.identifier2.isHidden = true;\n            }\n        }\n        page.container.isHidden = typesLib.strictNe(lpnManagementRule, 'mandatory') || !productSite.isLicensePlateNumberManaged;\n        if (!page.container.isHidden)\n            page.container.value = productSite.defaultInternalContainer;\n        const versionManagementMode = productSite.product.stockVersionMode;\n        page.majorVersion.isHidden = !['major', 'majorAndMinor'].includes(versionManagementMode);\n        page.minorVersion.isHidden = typesLib.strictNe(versionManagementMode, 'majorAndMinor');\n        page.quantityToReceive.value = page.remainingQuantity.value; // should auto-round value appropriately based on scale property that was set for this field\n        page.quantityToReceiveNoRounded = page.quantityToReceive.value;\n        page.quantityToReceiveRounded = page.quantityToReceive.value;\n        page.remainingQuantityNoRounded = page.remainingQuantity.value;\n        page.remainingQuantityRounded = page.remainingQuantity.value;\n        page.remainingQuantityInitial = Number(salesDeliveryLine.quantityInStockUnitReceived);\n        page.salesUnitToStockUnitConversionFactor = salesDeliveryLine.salesUnitToStockUnitConversionFactor;\n        page.previousSalesUnitToStockUnitConversionFactor = salesDeliveryLine.salesUnitToStockUnitConversionFactor;\n        const selectedUnit = page.receiptUnits.find(item => typesLib.strictEq(item.node.packingUnit.code, salesDeliveryLine.salesUnit.code));\n        page.packingUnitToStockUnitConversionFactor.isDisabled = selectedUnit\n            ? !selectedUnit.node.isPackingFactorEntryAllowed\n            : true;\n        page.productSite = productSite;\n        if (!page.suggestedLocation.isHidden && page.intersiteSession.purchaseStockManagementRules) {\n            const suggestedLocation = await (0, stock_management_rules_1.findDefaultLocation)(productReceivingSite, page.intersiteSession.purchaseStockManagementRules, page);\n            if (!suggestedLocation)\n                page.suggestedLocation.isHidden = true;\n            else\n                page.suggestedLocation.value = suggestedLocation;\n            if (typesLib.strictEq(page.isLocationPreloaded, true)) {\n                try {\n                    page.location.value = await page.$.graph\n                        .node('@sage/x3-stock-data/Location')\n                        .read({\n                        code: true,\n                        type: true,\n                        stockSite: {\n                            code: true,\n                        },\n                        warehouse: {\n                            code: true,\n                        },\n                    }, `${page.site.value}|${suggestedLocation}`)\n                        .execute();\n                }\n                catch (e) {\n                    await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-location', 'Error loading location'), String(e));\n                    return false;\n                }\n            }\n        }\n        IntersiteReceiptDetailsInitializer.initHeader(page, productSite, salesDeliveryLine);\n        return true;\n    }\n    static async _getSalesDeveryLine(page) {\n        try {\n            return await page.$.graph\n                .node('@sage/x3-sales/SalesDeliveryLine')\n                .read({\n                salesDelivery: {\n                    id: true,\n                    salesSite: {\n                        code: true,\n                    },\n                    receivingSite: {\n                        code: true,\n                    },\n                },\n                product: {\n                    code: true,\n                },\n                stockUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                salesUnit: {\n                    code: true,\n                    numberOfDecimals: true,\n                },\n                salesOrderLine: {\n                    purchaseOrder: {\n                        orderFromSupplier: {\n                            code: {\n                                code: true,\n                            },\n                        },\n                    },\n                },\n                quantityInStockUnitReceived: true,\n                quantityInSalesUnitDelivered: true,\n                salesUnitToStockUnitConversionFactor: true,\n                majorProductVersion: { code: true },\n                minorProductVersion: true,\n            }, `${page.salesDeliveryId}|${page.salesDeliveryLineNumber}`)\n                .execute();\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-sales-delivery', 'Error loading sales delivery'), String(e));\n            return null;\n        }\n    }\n    static async _getProductSite(page, productCode, salesSite) {\n        const receiptUnitOptions = [];\n        try {\n            const _productSites = await page.$.graph\n                .node('@sage/x3-master-data/ProductSite')\n                .query(ui.queryUtils.edgesSelector({\n                isLicensePlateNumberManaged: true,\n                isLocationManaged: true,\n                stockSite: {\n                    code: true,\n                },\n                defaultLocations: {\n                    query: {\n                        edges: {\n                            node: {\n                                defaultLocationType: true,\n                                locationNumber: true,\n                                defaultLocation: true,\n                            },\n                        },\n                    },\n                },\n                product: {\n                    code: true,\n                    productCategory: { code: true },\n                    serialNumberManagementMode: true,\n                    serialSequenceNumber: true,\n                    localizedDescription1: true,\n                    lotManagementMode: true,\n                    lotSequenceNumber: true,\n                    stockVersionMode: true,\n                    expirationManagementMode: true,\n                    stockManagementMode: true,\n                    purchaseUnitToStockUnitConversionFactor: true,\n                    useByDateCoefficient: true,\n                    expirationLeadTime: true,\n                    expirationTimeUnit: true,\n                    stockUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    purchaseUnit: {\n                        code: true,\n                        numberOfDecimals: true,\n                    },\n                    packingUnits: {\n                        query: {\n                            edges: {\n                                node: {\n                                    packingUnit: {\n                                        code: true,\n                                        numberOfDecimals: true,\n                                    },\n                                    packingUnitToStockUnitConversionFactor: true,\n                                    isPackingFactorEntryAllowed: true,\n                                },\n                            },\n                        },\n                    },\n                },\n                internalContainers: {\n                    query: {\n                        edges: {\n                            node: {\n                                internalContainer: {\n                                    code: true,\n                                },\n                            },\n                        },\n                    },\n                },\n                defaultInternalContainer: {\n                    code: true,\n                },\n            }, {\n                filter: {\n                    product: {\n                        code: productCode,\n                    },\n                    stockSite: {\n                        code: salesSite,\n                    },\n                },\n            }))\n                .execute();\n            const _productSite = typesLib.gt(_productSites.edges.length, 0) ? _productSites.edges[0].node : undefined;\n            if (_productSite) {\n                page.receiptUnits = [];\n                page.receiptUnits.push({\n                    node: {\n                        packingUnit: {\n                            code: _productSite.product.stockUnit.code,\n                            numberOfDecimals: _productSite.product.stockUnit.numberOfDecimals,\n                        },\n                        packingUnitToStockUnitConversionFactor: '1',\n                        isPackingFactorEntryAllowed: false,\n                    },\n                });\n                receiptUnitOptions.push(_productSite.product.stockUnit.code);\n                if (!page.receiptUnits.find(item => typesLib.strictEq(item.node.packingUnit.code, _productSite.product.purchaseUnit.code))) {\n                    page.receiptUnits.push({\n                        node: {\n                            packingUnit: {\n                                code: _productSite.product.purchaseUnit.code,\n                                numberOfDecimals: _productSite.product.purchaseUnit.numberOfDecimals,\n                            },\n                            packingUnitToStockUnitConversionFactor: '1',\n                            isPackingFactorEntryAllowed: false,\n                        },\n                    });\n                    receiptUnitOptions.push(_productSite.product.purchaseUnit.code);\n                }\n                _productSite.product.packingUnits.query.edges.forEach(line => {\n                    if (!page.receiptUnits.find(item => typesLib.strictEq(item.node.packingUnit.code, line.node.packingUnit.code))) {\n                        page.receiptUnits.push({\n                            node: {\n                                packingUnit: {\n                                    code: line.node.packingUnit.code,\n                                    numberOfDecimals: line.node.packingUnit.numberOfDecimals,\n                                },\n                                packingUnitToStockUnitConversionFactor: line.node.packingUnitToStockUnitConversionFactor,\n                                isPackingFactorEntryAllowed: line.node.isPackingFactorEntryAllowed,\n                            },\n                        });\n                        receiptUnitOptions.push(line.node.packingUnit.code);\n                    }\n                });\n                page.receiptUnit.options = receiptUnitOptions;\n            }\n            return _productSite;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-product-site', 'Error loading product site'), String(e));\n            return undefined;\n        }\n    }\n    static async _getStatuses(page) {\n        const selectedStatus = [];\n        page.intersiteSession?.purchaseStockManagementRules?.authorizedSubstatus.split(',').forEach(function (status) {\n            selectedStatus.push({ _regex: (0, pat_converter_1.getRegExp)(status).source });\n        });\n        try {\n            return (0, xtrem_client_1.extractEdges)(await page.$.graph\n                .node('@sage/x3-stock-data/StockStatus')\n                .query(ui.queryUtils.edgesSelector({\n                code: true,\n            }, {\n                filter: {\n                    code: { _or: selectedStatus },\n                },\n            }))\n                .execute()).map(status => status.code);\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-stock-statuses', 'Error loading stock statuses'), String(e));\n            return [];\n        }\n    }\n    static async _getStockJournals(page, product, salesSite) {\n        try {\n            const stockJournals = await page.$.graph\n                .node('@sage/x3-stock-data/StockJournal')\n                .query(ui.queryUtils.edgesSelector({\n                stockSite: {\n                    code: true,\n                },\n                documentId: true,\n                documentLine: true,\n                sequence: true,\n                product: {\n                    code: true,\n                },\n                quantityInStockUnit: true,\n                isUpdated: true,\n                lot: true,\n                sublot: true,\n                supplierLot: true,\n                lotCustomField1: true,\n                lotCustomField2: true,\n                lotCustomField3: true,\n                lotCustomField4: true,\n                identifier1: true,\n                identifier2: true,\n                majorVersion: {\n                    code: true,\n                },\n                minorVersion: true,\n                expirationDate: true,\n                useByDate: true,\n                status: {\n                    code: true,\n                },\n                serialNumber: true,\n                startingSerialNumber: true,\n                endingSerialNumber: true,\n            }, {\n                filter: {\n                    stockSite: {\n                        code: salesSite,\n                    },\n                    documentType: 'delivery',\n                    documentId: page.salesDeliveryId,\n                    documentLine: page.salesDeliveryLineNumber,\n                    product: { code: product },\n                    quantityInStockUnit: { _lt: 0 },\n                    isUpdated: true,\n                    isAdjustedMovement: false,\n                },\n                orderBy: {\n                    documentId: 1,\n                    documentLine: 1,\n                    sequence: -1,\n                },\n            }))\n                .execute();\n            page.stockJournalNodeResponses = [];\n            stockJournals.edges.forEach(stockJournal => {\n                page.stockJournalNodeResponses.push({\n                    stockSite: {\n                        code: stockJournal.node.stockSite.code,\n                    },\n                    documentId: stockJournal.node.documentId,\n                    documentLine: stockJournal.node.documentLine,\n                    sequence: stockJournal.node.sequence,\n                    product: {\n                        code: stockJournal.node.product.code,\n                    },\n                    quantityInStockUnit: Number(stockJournal.node.quantityInStockUnit),\n                    isUpdated: stockJournal.node.isUpdated,\n                    lot: stockJournal.node.lot,\n                    sublot: stockJournal.node.sublot,\n                    supplierLot: stockJournal.node.supplierLot,\n                    lotCustomField1: stockJournal.node.lotCustomField1,\n                    lotCustomField2: stockJournal.node.lotCustomField2,\n                    lotCustomField3: stockJournal.node.lotCustomField3,\n                    lotCustomField4: stockJournal.node.lotCustomField4,\n                    identifier1: stockJournal.node.identifier1,\n                    identifier2: stockJournal.node.identifier2,\n                    majorVersion: stockJournal.node.majorVersion?.code,\n                    minorVersion: stockJournal.node.minorVersion,\n                    expirationDate: stockJournal.node.expirationDate,\n                    useByDate: stockJournal.node.useByDate,\n                    status: stockJournal.node.status?.code,\n                    serialNumber: stockJournal.node.serialNumber,\n                    startingSerialNumber: stockJournal.node.startingSerialNumber,\n                    endingSerialNumber: stockJournal.node.endingSerialNumber,\n                });\n            });\n            page.currStockJournal = 0;\n        }\n        catch (e) {\n            await (0, dialogs_1.dialogMessage)(page, 'error', ui.localize('@sage/x3-purchasing-sales/error-loading-stock-journals', 'Error loading stock journals'), String(e));\n        }\n    }\n    static initHeader(page, productSiteNode, salesDeliveryLine) {\n        page.product.value = productSiteNode.product.code;\n        page.description.value = productSiteNode.product.localizedDescription1;\n        if (page.salesDeliveryId && page.salesDeliveryLineNumber) {\n            page.headerTitleLeft.value = page.salesDeliveryId;\n            page.headerTitleRight.value = page.salesDeliveryLineNumber.toString();\n            page.headerTitleRight.prefix = ui.localize('@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_header_detail__line_no', 'Line No.');\n            page.headerLine2Left.value = page.product.value;\n            page.headerLine2Right.value = page.description.value;\n            page.headerLine3Left.value = ui.localize('@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_header_detail__expected_quantity', 'Expected quantity:');\n            page.headerLine3Right.value = `${Number(salesDeliveryLine.quantityInSalesUnitDelivered)} ${salesDeliveryLine.salesUnit.code}`;\n        }\n        else {\n            page.headerTitleLeft.value = page.product.value;\n            page.headerTitleRight.value = '';\n            page.headerLine2Left.value = page.description.value;\n            page.headerLine2Right.value = '';\n            page.headerLine3Left.value = page.supplier.value;\n            page.headerLine3Right.value = '';\n        }\n    }\n}\nexports.IntersiteReceiptDetailsInitializer = IntersiteReceiptDetailsInitializer;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/intersite-receipt-details-initializer.ts\n");

/***/ }),

/***/ "./lib/client-functions/read-parameter.ts":
/*!************************************************!*\
  !*** ./lib/client-functions/read-parameter.ts ***!
  \************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.readParameterValue = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function readParameterValue(parameter, user, stockSite, pageInstance) {\n    try {\n        let resp;\n        const response = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph\n            .node('@sage/x3-system/GeneralParameter')\n            .query(ui.queryUtils.edgesSelector({\n            _id: true,\n            definitionLevel: true,\n            valueType: true,\n        }, {\n            filter: {\n                code: parameter,\n            },\n        }))\n            .execute());\n        // Call appropriate function depending on parameter level\n        if (typesLib.strictEq(response[0].definitionLevel, 'user') && typesLib.strictEq(response[0].folderValue, false)) {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        code: user,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        code: user,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/UserParameterValue')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        code: user,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n        }\n        else {\n            if (typesLib.strictEq(response[0].valueType, 'alphanumeric')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueString({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'numeric') || typesLib.strictEq(response[0].valueType, 'localMenu')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueInteger({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            else if (typesLib.strictEq(response[0].valueType, 'date')) {\n                resp = await pageInstance.$.graph\n                    .node('@sage/x3-system/GeneralParametersData')\n                    .mutations.readParameterValueDate({ value: true }, {\n                    parameters: {\n                        company: '',\n                        site: stockSite,\n                        code: parameter,\n                    },\n                })\n                    .execute();\n                return resp.value;\n            }\n            return '';\n        }\n    }\n    catch (e) {\n        await (0, dialogs_1.dialogMessage)(pageInstance, 'error', ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing-sales/utils-error-reading-parameter-value', 'Error reading parameter value: {{ param }}', { param: parameter }));\n        return '';\n    }\n}\nexports.readParameterValue = readParameterValue;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/read-parameter.ts\n");

/***/ }),

/***/ "./lib/client-functions/stock-management-rules.ts":
/*!********************************************************!*\
  !*** ./lib/client-functions/stock-management-rules.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.findDefaultLocation = exports.findStockManagementRules = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nasync function _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance) {\n    try {\n        //read the stock management rules\n        const stockManagementRules = await pageInstance.$.graph\n            .node('@sage/x3-stock-data/StockManagementRules')\n            .query(ui.queryUtils.edgesSelector({\n            productCategory: { code: true },\n            stockSite: { code: true },\n            transactionType: true,\n            stockMovementCode: { code: true },\n            defaultStatus: true,\n            locationNumber: true,\n            locationNumber2: true,\n            locationNumber3: true,\n            authorizedStatus: true,\n            authorizedSubstatus: true,\n            hasAnalysisRequest: true,\n            lotEntry: true,\n            lotByDefault: true,\n            outputLot: true,\n            isExclusiveEntryVersion: true,\n            activeVersion: true,\n            licensePlateNumberEntry: true,\n            versionStopped: true,\n            prototypeVersion: true,\n        }, {\n            filter: {\n                productCategory: { code: productCategory },\n                stockSite: { code: stockSite },\n                transactionType: transactionType,\n                stockMovementCode: { code: stockMovementCode },\n            },\n        }))\n            .execute();\n        if (typesLib.gt(stockManagementRules.edges.length, 0))\n            return stockManagementRules.edges[0].node;\n        else\n            return null;\n    }\n    catch (e) { }\n}\nasync function findStockManagementRules(stockSite, productCategory, transactionType, //TRSTYP, menu 704\nstockMovementCode, //TRSCOD\npageInstance) {\n    // for the stock site, the product category and the movement code\n    let stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for stock site and product category\n    stockManagementRules = await _readStockManagementRules(stockSite, productCategory, transactionType, undefined, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category and movement code\n    stockManagementRules = await _readStockManagementRules(undefined, productCategory, transactionType, stockMovementCode, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // for product category\n    stockManagementRules = await _readStockManagementRules(undefined, productCategory, transactionType, undefined, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    // general rules\n    stockManagementRules = await _readStockManagementRules(undefined, undefined, transactionType, undefined, pageInstance);\n    if (stockManagementRules)\n        return stockManagementRules;\n    throw new Error(ui.localize('@sage/x3-purchasing-sales/stock_management_rules__notification__no_management_rules_error', `Could not retrieve the management rules for your product category {{ productCategory }} and for the site {{ siteCode }}`, { productCategory: productCategory, siteCode: stockSite }));\n}\nexports.findStockManagementRules = findStockManagementRules;\nasync function _readProductCategorySite(stockSite, productCategory, pageInstance) {\n    try {\n        //read the product category site\n        const productCategorySite = await pageInstance.$.graph\n            .node('@sage/x3-master-data/productCategory')\n            .read({\n            stockSite: { code: true },\n            code: true,\n            defaultLocations: {\n                query: {\n                    edges: {\n                        node: {\n                            defaultLocation: { code: true },\n                            locationNumber: true,\n                            defaultLocationType: true,\n                        },\n                    },\n                },\n            },\n        }, \n        // TODO: find a better way if possible\n        `${stockSite}|${productCategory}`)\n            .execute();\n        return productCategorySite ?? null;\n    }\n    catch (e) {\n        return null;\n    }\n}\nasync function findDefaultLocation(productSite, stockManagementRules, pageInstance) {\n    // find the default location for the product site\n    const defaultLocation = productSite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n    if (defaultLocation &&\n        defaultLocation.node.defaultLocation &&\n        !defaultLocation.node.defaultLocation.match(/[* ! # ?]/))\n        return defaultLocation.node.defaultLocation;\n    // find the default location for the product category site\n    const ProductCategorySite = await _readProductCategorySite(productSite.stockSite.code, productSite.product.productCategory.code, pageInstance);\n    if (ProductCategorySite) {\n        const defaultLocationCateg = ProductCategorySite.defaultLocations.query.edges.find(loc => typesLib.strictEq(loc.node.locationNumber, stockManagementRules.locationNumber));\n        if (defaultLocationCateg &&\n            defaultLocationCateg.node.defaultLocation &&\n            !defaultLocationCateg.node.defaultLocation.match(/[* ! # ?]/))\n            return defaultLocationCateg.node.defaultLocation;\n    }\n    return null;\n}\nexports.findDefaultLocation = findDefaultLocation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/client-functions/stock-management-rules.ts\n");

/***/ }),

/***/ "./lib/pages/mobile-intersite-receipt-enter-receipt-detail.ts":
/*!********************************************************************!*\
  !*** ./lib/pages/mobile-intersite-receipt-enter-receipt-detail.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileIntersiteReceiptEnterReceiptDetail = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nconst dialogs_1 = __webpack_require__(/*! @sage/x3-master-data/lib/client-functions/dialogs */ \"../../shared/x3-master-data/lib/client-functions/dialogs.ts\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nconst intersite_receipt_details_control_1 = __webpack_require__(/*! ../client-functions/intersite-receipt-details-control */ \"./lib/client-functions/intersite-receipt-details-control.ts\");\nconst intersite_receipt_details_initializer_1 = __webpack_require__(/*! ../client-functions/intersite-receipt-details-initializer */ \"./lib/client-functions/intersite-receipt-details-initializer.ts\");\nconst read_parameter_1 = __webpack_require__(/*! ../client-functions/read-parameter */ \"./lib/client-functions/read-parameter.ts\");\nlet MobileIntersiteReceiptEnterReceiptDetail = class MobileIntersiteReceiptEnterReceiptDetail extends ui.Page {\n    _getNextStockJournal() {\n        const startingCurrStockJournal = this.currStockJournal;\n        let lookForStockJournals;\n        lookForStockJournals = true;\n        let nextStockJournal;\n        nextStockJournal = null;\n        while (lookForStockJournals) {\n            if (typesLib.lt(this.currStockJournal, typesLib.sub(this.stockJournalNodeResponses.length, 1))) {\n                this.currStockJournal = typesLib.add(this.currStockJournal, 1);\n            }\n            else {\n                this.currStockJournal = 0;\n            }\n            if (typesLib.strictNe(this._calculateRemainingQuantity(this.stockJournalNodeResponses[this.currStockJournal]), 0)) {\n                lookForStockJournals = false;\n                nextStockJournal = this.stockJournalNodeResponses[this.currStockJournal];\n            }\n            if (typesLib.strictEq(this.currStockJournal, startingCurrStockJournal)) {\n                lookForStockJournals = false;\n            }\n        }\n        if (!nextStockJournal) {\n            this.currStockJournal = startingCurrStockJournal;\n        }\n        return nextStockJournal;\n    }\n    _getNextButtonHidden() {\n        let stockJournalWithRemainingQuantityNotNullCount;\n        stockJournalWithRemainingQuantityNotNullCount = 0;\n        this.stockJournalNodeResponses.forEach(stockJournal => {\n            if (typesLib.strictNe(this._calculateRemainingQuantity(stockJournal), 0)) {\n                stockJournalWithRemainingQuantityNotNullCount = typesLib.add(stockJournalWithRemainingQuantityNotNullCount, 1);\n            }\n        });\n        return typesLib.lte(stockJournalWithRemainingQuantityNotNullCount, 1);\n    }\n    async _updatePurchaseReceiptLine() {\n        if (this.intersiteSession &&\n            this.intersiteSession.purchaseReceipt &&\n            this.intersiteSession.purchaseReceipt.lines) {\n            this.intersiteSession.purchaseReceipt.lines[typesLib.sub(this.intersiteSession.purchaseReceipt.lines.length, 1)] = {\n                ...this.intersiteSession.purchaseReceipt.lines[typesLib.sub(this.intersiteSession.purchaseReceipt.lines.length, 1)],\n                lineNumber: Number(typesLib.mul(this.intersiteSession.purchaseReceipt.lines.length, 1000)),\n                receiptUnit: this.receiptUnit.value ?? '',\n                receiptUnitToStockUnitConversionFactor: this.salesUnitToStockUnitConversionFactor,\n                // container: this.container.value?.code,\n            };\n            let quantityInReceiveUnit;\n            quantityInReceiveUnit = 0;\n            this.intersiteSession.purchaseReceipt.lines[typesLib.sub(this.intersiteSession.purchaseReceipt.lines.length, 1)].stockDetails?.forEach(item => {\n                quantityInReceiveUnit = typesLib.add(quantityInReceiveUnit, Number(item.quantityInPackingUnit));\n            });\n            this.intersiteSession.purchaseReceipt.lines[typesLib.sub(this.intersiteSession.purchaseReceipt.lines.length, 1)].quantityInReceiptUnitReceived = quantityInReceiveUnit;\n            this._intersiteReceiptRecordManager.intersiteSession = this.intersiteSession;\n            const lineIndex = this.salesDeliveryLines.findIndex(lineNumber => typesLib.strictEq(lineNumber, this.salesDeliveryLineNumber));\n            if (typesLib.gte(lineIndex, 0)) {\n                this.salesDeliveryLines.splice(lineIndex, 1);\n            }\n            if (typesLib.gt(this.salesDeliveryLines.length, 0)) {\n                await this._goToPageTwo();\n            }\n            else {\n                await this._goToPageOne();\n            }\n        }\n    }\n    async _goToPageTwo() {\n        const errors = await this.$.page.validate();\n        if (typesLib.strictEq(errors.length, 0)) {\n            this.$.setPageClean();\n            this.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceiptSelectFromDelivery', {\n                _id: this.salesDeliveryId,\n                deliveryLineNumber: this.salesDeliveryLineNumber,\n                deliveryLines: JSON.stringify(this.salesDeliveryLines),\n                isLocationPreloaded: `${this.isLocationPreloaded ? '1' : '0'}`,\n            });\n        }\n        else {\n            this.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error')}: ${errors[0]}`, {\n                type: 'error',\n                timeout: 30000,\n            });\n        }\n    }\n    async _goToPageOne() {\n        const errors = await this.$.page.validate();\n        if (typesLib.strictEq(errors.length, 0)) {\n            this.$.setPageClean();\n            this.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {\n                _id: this.salesDeliveryId,\n            });\n        }\n        else {\n            this.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error')}: ${errors[0]}`, {\n                type: 'error',\n                timeout: 30000,\n            });\n        }\n    }\n    _displayStockJournal(stockJournal) {\n        this.sequence = stockJournal.sequence;\n        this.remainingQuantity.value = this._calculateRemainingQuantity(stockJournal);\n        this.quantityToReceive.value = this.remainingQuantity.value;\n        this.packingUnitToStockUnitConversionFactor.value = Number(this.salesUnitToStockUnitConversionFactor);\n        if (stockJournal.startingSerialNumber) {\n            this.serialNumber.value = stockJournal.startingSerialNumber;\n        }\n        else {\n            this.serialNumber.value = stockJournal.serialNumber;\n        }\n        this.supplierLot.value = stockJournal.supplierLot;\n        this.lot.value = stockJournal.lot;\n        this.sublot.value = stockJournal.sublot;\n        this.majorVersion.value = stockJournal.majorVersion;\n        this.minorVersion.value = stockJournal.minorVersion;\n        this.lotCustomField1.value = stockJournal.lotCustomField1;\n        this.lotCustomField2.value = stockJournal.lotCustomField2;\n        this.lotCustomField3.value = Number(stockJournal.lotCustomField3);\n        this.lotCustomField4.value = stockJournal.lotCustomField4?.startsWith('1599')\n            ? null\n            : stockJournal.lotCustomField4;\n        this.identifier1.value = stockJournal.identifier1;\n        this.identifier2.value = stockJournal.identifier2;\n        this.expirationDate.value = stockJournal.expirationDate;\n        this.useByDate.value = stockJournal.useByDate;\n        this._showSubmit();\n    }\n    _calculateRemainingQuantity(stockJournal) {\n        let pendingQuantityInReceiptUnitReceived = 0;\n        if (this.intersiteSession?.purchaseReceipt?.lines) {\n            this.intersiteSession.purchaseReceipt.lines.forEach(line => {\n                if (typesLib.strictEq(line.salesDelivery, this.salesDeliveryId) && typesLib.strictEq(line.salesDeliveryLine, this.salesDeliveryLineNumber)) {\n                    line.stockDetails?.forEach(stockDetail => {\n                        if (typesLib.strictEq(stockDetail.sequence, stockJournal.sequence)) {\n                            pendingQuantityInReceiptUnitReceived = typesLib.add(pendingQuantityInReceiptUnitReceived, Number(stockDetail.quantityInPackingUnit));\n                        }\n                    });\n                }\n            });\n        }\n        let _remainingQuantity;\n        _remainingQuantity = typesLib.max(0, typesLib.sub(typesLib.negated((typesLib.strictNe(Number(this.salesUnitToStockUnitConversionFactor), 0) ? typesLib.div(stockJournal.quantityInStockUnit, Number(this.salesUnitToStockUnitConversionFactor)) : 0)), pendingQuantityInReceiptUnitReceived));\n        const selectedUnit = this.receiptUnits.find(line => typesLib.strictEq(line.node.packingUnit.code, this.receiptUnit.value));\n        const tmp = typesLib.pow(10, Number(selectedUnit?.node?.packingUnit?.numberOfDecimals));\n        if (typesLib.strictNe(tmp, 0)) {\n            _remainingQuantity = typesLib.div(typesLib.round(typesLib.mul(_remainingQuantity, tmp)), tmp);\n        }\n        return _remainingQuantity;\n    }\n    async _focusToNextField(field) {\n        switch (field?.id) {\n            case this.quantityToReceive.id:\n                if (!this.status.isHidden && !this.status.isDisabled && !this.status.isReadOnly) {\n                    this.status.focus();\n                }\n                break;\n            case this.status.id:\n                if (!this.container.isHidden && !this.container.isDisabled && !this.container.isReadOnly) {\n                    this.container.focus();\n                }\n                break;\n            case this.container.id:\n                if (!this.licensePlateNumber.isHidden &&\n                    !this.licensePlateNumber.isDisabled &&\n                    !this.licensePlateNumber.isReadOnly) {\n                    this.licensePlateNumber.focus();\n                }\n                break;\n            case this.licensePlateNumber.id:\n                if (!this.location.isHidden && !this.location.isDisabled && !this.location.isReadOnly) {\n                    this.location.focus();\n                }\n                break;\n            case this.location.id:\n                break;\n            default:\n                if (!this.quantityToReceive.isHidden &&\n                    !this.quantityToReceive.isDisabled &&\n                    !this.quantityToReceive.isReadOnly) {\n                    this.quantityToReceive.focus();\n                }\n                break;\n        }\n    }\n    async _validate() {\n        const fieldErrors = [];\n        if ((!this.receiptUnit.isHidden && !this.receiptUnit.value) || !!(await this.receiptUnit.validate()))\n            fieldErrors.push(this.receiptUnit.title ?? '');\n        if (!this.quantityToReceive.value || !!(await this.quantityToReceive.validate()))\n            fieldErrors.push(this.quantityToReceive.title ?? '');\n        const validationStatus = await this.status.validate();\n        if (validationStatus) {\n            fieldErrors.push(this.status.title ?? '');\n        }\n        const validationLicensePlateNumber = await this.licensePlateNumber.validate();\n        if (validationLicensePlateNumber) {\n            fieldErrors.push(this.licensePlateNumber.title ?? '');\n        }\n        const validationLocation = await this.location.validate();\n        if (validationLocation) {\n            fieldErrors.push(this.location.title ?? '');\n        }\n        const validationContainer = await this.container.validate();\n        if (validationContainer) {\n            fieldErrors.push(this.container.title ?? '');\n        }\n        if (typesLib.gt(fieldErrors.length, 0)) {\n            this.$.removeToasts();\n            this.$.showToast(ui.localize('@sage/x3-purchasing-sales/pages__utils__notification__invalid_inputs_error', `Please check your inputs for {{#each fieldNames}}\\n - {{this}}{{/each}}`, { fieldNames: fieldErrors }), { type: 'error', timeout: 5000 });\n            await this.$.page.validate();\n        }\n        return typesLib.strictEq(fieldErrors.length, 0);\n    }\n    _showSubmit() {\n        this.submitButton.isDisabled =\n            !this.receiptUnit.value || typesLib.lte(Number(this.quantityToReceive.value), 0) ||\n                (!this.container.isHidden &&\n                    !this.licensePlateNumber.isHidden &&\n                    (!this.licensePlateNumber.value || typesLib.strictEq(this.licensePlateNumber.value?.code, '')) &&\n                    (!this.container.value || typesLib.strictEq(this.container.value?.code, '')));\n    }\n    _initDirty() {\n        if (typesLib.gt((this.intersiteSession?.purchaseReceipt?.lines ?? []).length, 1)) {\n            this.product.isDirty = true;\n        }\n    }\n    _getPayloadFieldString(value) {\n        if (value && typesLib.strictNe(value, '')) {\n            return value;\n        }\n        else {\n            return undefined;\n        }\n    }\n    _getPayloadFieldDate(value) {\n        if (value && typesLib.strictNe(value, '') && !value.startsWith('1599') && !value.startsWith('2999')) {\n            return value;\n        }\n        else {\n            return undefined;\n        }\n    }\n    _getPayloadFieldNumber(value) {\n        if (value && typesLib.strictNe(value, 0)) {\n            return value;\n        }\n        else {\n            return undefined;\n        }\n    }\n};\nexports.MobileIntersiteReceiptEnterReceiptDetail = MobileIntersiteReceiptEnterReceiptDetail;\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerTitleLeft\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerTitleRight\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerLine2Left\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerLine2Right\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerLine3Left\", void 0);\n__decorate([\n    ui.decorators.textField({\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"headerLine3Right\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__product____title\", \"Product\"),\n        isReadOnly: true,\n        size: 'large',\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"product\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__description____title\", \"Description\"),\n        isReadOnly: true,\n        size: 'small',\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"description\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__site____title\", \"Site\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"site\", void 0);\n__decorate([\n    ui.decorators.textField({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__supplier____title\", \"Supplier\"),\n        isReadOnly: true,\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"supplier\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__submitButton____title\", \"Submit\"),\n        shortcut: ['f3'],\n        buttonType: 'primary',\n        async onClick() {\n            await this.$.commitValueAndPropertyChanges();\n            if (await this._validate()) {\n                if (this.intersiteSession?.purchaseReceipt?.lines) {\n                    this.intersiteSession.purchaseReceipt.lines[typesLib.sub(this.intersiteSession.purchaseReceipt.lines.length, 1)].stockDetails?.push({\n                        product: this.product.value ?? undefined,\n                        quantityInPackingUnit: this.quantityToReceive.value ?? undefined,\n                        packingUnit: this.receiptUnit.value ?? undefined,\n                        packingUnitToStockUnitConversionFactor: this.packingUnitToStockUnitConversionFactor.value ?? undefined,\n                        location: this.location.value?.code,\n                        licensePlateNumber: this.licensePlateNumber.value?.code ?? undefined,\n                        status: this.status.value ?? undefined,\n                        serialNumber: this._getPayloadFieldString(this.serialNumber.value),\n                        supplierLot: this._getPayloadFieldString(this.supplierLot.value),\n                        lot: this._getPayloadFieldString(this.lot.value),\n                        sublot: this._getPayloadFieldString(this.sublot.value),\n                        lotCustomField1: this._getPayloadFieldString(this.lotCustomField1.value),\n                        lotCustomField2: this._getPayloadFieldString(this.lotCustomField2.value),\n                        lotCustomField3: this._getPayloadFieldNumber(this.lotCustomField3.value),\n                        lotCustomField4: this._getPayloadFieldDate(this.lotCustomField4.value),\n                        majorVersion: this._getPayloadFieldString(this.majorVersion.value),\n                        minorVersion: this._getPayloadFieldString(this.minorVersion.value),\n                        identifier1: this._getPayloadFieldString(this.identifier1.value),\n                        identifier2: this._getPayloadFieldString(this.identifier2.value),\n                        expirationDate: this._getPayloadFieldDate(this.expirationDate.value),\n                        useByDate: this._getPayloadFieldDate(this.useByDate.value),\n                        sequence: this.sequence,\n                    });\n                }\n                this.remainingQuantity.value = this._calculateRemainingQuantity(this.stockJournalNodeResponses[this.currStockJournal]);\n                if (typesLib.strictEq(this.remainingQuantity.value, 0)) {\n                    if (this._getNextStockJournal()) {\n                        this._displayStockJournal(this.stockJournalNodeResponses[this.currStockJournal]);\n                        this.receiptUnit.isDisabled = true;\n                        this.container.isDisabled = true;\n                        this.licensePlateNumber.isDisabled = true;\n                        this.nextButton.isHidden = this._getNextButtonHidden();\n                        this.quantityToReceive.focus();\n                    }\n                    else {\n                        await this._updatePurchaseReceiptLine();\n                    }\n                }\n                else {\n                    this._displayStockJournal(this.stockJournalNodeResponses[this.currStockJournal]);\n                    this.receiptUnit.isDisabled = true;\n                    this.container.isDisabled = true;\n                    this.licensePlateNumber.isDisabled = true;\n                    this.quantityToReceive.focus();\n                }\n            }\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"submitButton\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__nextButton____title\", \"Next\"),\n        shortcut: ['f2'],\n        buttonType: 'secondary',\n        async onClick() {\n            if (this._getNextStockJournal()) {\n                this._displayStockJournal(this.stockJournalNodeResponses[this.currStockJournal]);\n                this.nextButton.isHidden = this._getNextButtonHidden();\n                this.quantityToReceive.focus();\n            }\n            else {\n                if (this.intersiteSession?.purchaseReceipt?.lines && typesLib.strictNe(this.intersiteSession?.purchaseReceipt?.lines[typesLib.sub(this.intersiteSession?.purchaseReceipt?.lines?.length, 1)].stockDetails?.length, 0)) {\n                    await this._updatePurchaseReceiptLine();\n                }\n                else {\n                    this.intersiteSession?.purchaseReceipt?.lines?.splice(typesLib.sub(this.intersiteSession?.purchaseReceipt?.lines.length, 1));\n                    this._intersiteReceiptRecordManager.intersiteSession = this.intersiteSession;\n                    this.$.setPageClean();\n                    this.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceiptSelectFromDelivery', {\n                        _id: this.salesDeliveryId,\n                        deliveryLineNumber: this.salesDeliveryLineNumber,\n                        deliveryLines: JSON.stringify(this.salesDeliveryLines),\n                        isLocationPreloaded: `${this.isLocationPreloaded ? '1' : '0'}`,\n                    });\n                }\n            }\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"nextButton\", void 0);\n__decorate([\n    ui.decorators.section({\n        isTitleHidden: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"sectionHeader\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.sectionHeader;\n        },\n        isTitleHidden: false,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"blockProduct\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__receiptUnit____title\", \"Unit\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__receiptUnit____placeholder\", \"Enter unit\"),\n        options: ['UN'],\n        isMandatory: true,\n        onChange() {\n            if (this.receiptUnit.value) {\n                const selectedUnit = this.receiptUnits.find(packingUnit => typesLib.strictEq(packingUnit.node.packingUnit.code, this.receiptUnit.value));\n                if (selectedUnit) {\n                    this.packingUnitToStockUnitConversionFactor.value = Number(selectedUnit.node.packingUnitToStockUnitConversionFactor);\n                    this.packingUnitToStockUnitConversionFactor.isDisabled =\n                        !selectedUnit.node.isPackingFactorEntryAllowed;\n                }\n                else {\n                    this.packingUnitToStockUnitConversionFactor.value = 1;\n                    this.packingUnitToStockUnitConversionFactor.isDisabled = true;\n                }\n                this.quantityToReceive.scale = selectedUnit?.node.packingUnit.numberOfDecimals;\n                this.salesUnitToStockUnitConversionFactor = String(this.packingUnitToStockUnitConversionFactor.value);\n                this.quantityToReceiveNoRounded = typesLib.div((typesLib.mul(Number(this.quantityToReceive.value), Number(this.previousSalesUnitToStockUnitConversionFactor))), this.packingUnitToStockUnitConversionFactor.value);\n                const tmp = typesLib.pow(10, Number(selectedUnit?.node?.packingUnit?.numberOfDecimals));\n                if (typesLib.strictNe(tmp, 0)) {\n                    this.quantityToReceiveRounded = typesLib.div(typesLib.round(typesLib.mul(this.quantityToReceiveNoRounded, tmp)), tmp);\n                }\n                else {\n                    this.quantityToReceiveRounded = this.quantityToReceiveNoRounded;\n                }\n                this.quantityToReceive.value = this.quantityToReceiveRounded;\n                this.quantityToReceive.focus();\n                this.previousReceiptUnit.value = this.receiptUnit.value;\n                this.previousSalesUnitToStockUnitConversionFactor = this.salesUnitToStockUnitConversionFactor;\n            }\n            this._showSubmit();\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"receiptUnit\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isHidden: true,\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"receiptUnitCode\", void 0);\n__decorate([\n    ui.decorators.labelField({\n        isHidden: true,\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"previousReceiptUnit\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__quantityToReceive____title\", \"Quantity\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__quantityToReceive____placeholder\", \"Enter quantity\"),\n        isMandatory: true,\n        validation(value) {\n            const regex = /^([1-9][0-9]*(\\.[0-9]+)?|[0]+\\.[0-9]*[1-9][0-9]*)$/; // reg ex for any positive numbers (integers or decimals) excluding 0\n            if (typesLib.strictEq((value.toString().match(regex)?.length ?? 0), 0)) {\n                return ui.localize('@sage/x3-purchasing-sales/validate-error-invalid-value', 'invalid value');\n            }\n            if (this.salesDeliveryId &&\n                this.salesDeliveryLineNumber && typesLib.gt((this.quantityToReceive.value ?? 0), (this.remainingQuantity.value ?? 0)) &&\n                !this._isOverReceiptAllowed) {\n                return ui.localize('@sage/x3-purchasing-sales/validation-error-intersite-receipt-details-quantity-received-is-greater-than-the-ordered-quantity', 'The quantity received is greater than the ordered quantity.');\n            }\n            return undefined;\n        },\n        scale() {\n            const selectedUnit = this.receiptUnits.find(unit => typesLib.strictEq(unit.node.packingUnit.code, this.receiptUnit.value));\n            return selectedUnit?.node.packingUnit.numberOfDecimals ?? 0;\n        },\n        min: 0,\n        async onChange() {\n            if (this.salesDeliveryId && this.salesDeliveryLineNumber) {\n                if (typesLib.gt((this.quantityToReceive.value ?? 0), (this.remainingQuantity.value ?? 0))) {\n                    if (!this._isOverReceiptAllowed) {\n                        await (0, dialogs_1.dialogMessage)(this, 'error', ui.localize('@sage/x3-purchasing-sales/dialog-error-title', 'Error'), ui.localize('@sage/x3-purchasing-sales/dialog-error-intersite-receipt-details-quantity-received-is-greater-than-the-ordered-quantity', `The quantity received is greater than the ordered quantity.`), {\n                            fullScreen: false,\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-purchasing-sales/button-accept-ok', 'OK'),\n                            },\n                        });\n                        this.quantityToReceive.focus();\n                        return;\n                    }\n                    else {\n                        if (!(await (0, dialogs_1.dialogConfirmation)(this, 'warn', ui.localize('@sage/x3-purchasing-sales/dialog-warning-title', 'Warning'), ui.localize('@sage/x3-purchasing-sales/dialog-warn-intersite-receipt-details-quantity-message', 'Quantity larger than expected. Validate ?'), {\n                            fullScreen: false,\n                            acceptButton: {\n                                text: ui.localize('@sage/x3-purchasing-sales/button-accept-yes', 'Yes'),\n                            },\n                            cancelButton: {\n                                text: ui.localize('@sage/x3-purchasing-sales/button-cancel-no', 'No'),\n                            },\n                        }))) {\n                            this.quantityToReceive.value = 0;\n                            await this.$.commitValueAndPropertyChanges();\n                            this.quantityToReceive.focus();\n                        }\n                    }\n                }\n            }\n            if (!this.quantityToReceive.value) {\n                this.quantityToReceive.value = 0;\n            }\n            if (typesLib.strictNe(this.quantityToReceive.value, this.quantityToReceiveRounded)) {\n                this.quantityToReceiveNoRounded = this.quantityToReceive.value;\n            }\n            this.quantityToReceiveRounded = this.quantityToReceive.value;\n            this._showSubmit();\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"quantityToReceive\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        isReadOnly: true,\n        isHidden: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"remainingQuantity\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__packingUnitToStockUnitConversionFactor____title\", \"Conversion factor\"),\n        isDisabled: true,\n        isHidden: false,\n        onChange() {\n            if (this.intersiteSession?.purchaseReceipt?.lines) {\n                this.intersiteSession.purchaseReceipt.lines.forEach(line => {\n                    if (typesLib.strictEq(line.salesDelivery, this.salesDeliveryId) && typesLib.strictEq(line.salesDeliveryLine, this.salesDeliveryLineNumber)) {\n                        line.stockDetails?.forEach(stockDetail => {\n                            if (typesLib.strictNe(this.packingUnitToStockUnitConversionFactor.value, stockDetail.packingUnitToStockUnitConversionFactor)) {\n                                this.packingUnitToStockUnitConversionFactor.value = Number(stockDetail.packingUnitToStockUnitConversionFactor);\n                                this.packingUnitToStockUnitConversionFactor.focus();\n                                this.$.showToast(`${ui.localize('@sage/x3-purchasing-sales/notification-The-conversion-factor-can-t-be-different-as-the-one-entered-previously-on-the-same-stock-line', \"The conversion factor can't be different as the one entered previously on the same stock line.\")}`, { type: 'error', timeout: 5000 });\n                            }\n                        });\n                    }\n                });\n            }\n            this.salesUnitToStockUnitConversionFactor = String(this.packingUnitToStockUnitConversionFactor.value);\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"packingUnitToStockUnitConversionFactor\", void 0);\n__decorate([\n    ui.decorators.selectField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__status____title\", \"Status\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__status____placeholder\", \"Enter status\"),\n        isMandatory: true,\n        onChange() {\n            this.status.getNextField(true)?.focus();\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"status\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__container____title\", \"Container\"),\n        node: '@sage/x3-master-data/Container',\n        valueField: 'code',\n        isAutoSelectEnabled: true,\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__container____placeholder\", \"Scan or select...\"),\n        width: 'large',\n        isTransient: true,\n        canFilter: false,\n        filter() {\n            return {\n                isInternal: { _eq: true },\n                isActive: { _eq: true },\n            };\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__container____columns__title__code\", \"Code\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'containerType',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__container____columns__title__containerType\", \"Type\"),\n            }),\n            ui.nestedFields.text({\n                bind: 'description',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__container____columns__title__description\", \"Description\"),\n            }),\n        ],\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"container\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____title\", \"License plate number\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____placeholder\", \"Scan or select...\"),\n        isFullWidth: true,\n        node: '@sage/x3-stock-data/LicensePlateNumber',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            let licensePlateNumberFilter = {\n                stockSite: { code: this.site.value ?? undefined },\n                isActive: { _eq: true },\n                _or: [\n                    {\n                        isSingleProduct: { _eq: true },\n                        stock: { _atLeast: 1, product: { product: { code: this.product.value ?? undefined } } },\n                    },\n                    { isSingleProduct: { _eq: true }, stock: { _none: true } },\n                    { isSingleProduct: { _eq: false } },\n                ],\n            };\n            if (this.location.value?.code) {\n                licensePlateNumberFilter._or = [\n                    {\n                        location: { code: this.location.value.code },\n                    },\n                    {\n                        _and: [{ location: { code: undefined } }, { status: 'free' }],\n                    },\n                ];\n            }\n            if (this.container.value) {\n                licensePlateNumberFilter = {\n                    ...licensePlateNumberFilter,\n                    container: { code: this.container.value?.code },\n                };\n            }\n            return licensePlateNumberFilter;\n        },\n        async onChange() {\n            if (!this.licensePlateNumber.value) {\n                this.location.isDisabled = false;\n                this.location.value = null;\n                this.container.isDisabled = false;\n                await this.$.commitValueAndPropertyChanges(); // without this, when you clear out LPN and then, without tabbing out, click Location's lookup button directly, nothing will happen\n                return;\n            }\n            if (!!this.licensePlateNumber?.value?.location?.code) {\n                this.location.isDisabled = true;\n                this.location.value = this.licensePlateNumber.value.location;\n                if (this.licensePlateNumber.value.container) {\n                    this.container.value = this.licensePlateNumber.value.container;\n                    this.container.isDisabled = true;\n                }\n                else {\n                    this.container.isDisabled = false;\n                }\n            }\n            else {\n                if (this.location.isDisabled) {\n                    this.location.value = null;\n                    this.location.isDisabled = false;\n                }\n                this.container.isDisabled = false;\n            }\n            await this.$.commitValueAndPropertyChanges();\n            this._showSubmit();\n            this.licensePlateNumber.getNextField(true)?.focus();\n        },\n        isTransient: true,\n        isMandatory: false,\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____columns__title__code\", \"License Plate Number\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Location',\n                bind: 'location',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____columns__title__location__code\", \"Location\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-master-data/Container',\n                bind: 'container',\n                valueField: 'code',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____columns__title__container__code\", \"Container\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.label({\n                bind: 'status',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__licensePlateNumber____columns__title__status\", \"Status\"),\n                map(value) {\n                    switch (value) {\n                        case 'free':\n                            return 'Free';\n                        case 'inStock':\n                            return 'In Stock';\n                        default:\n                            return '';\n                    }\n                },\n                borderColor: ui.tokens.colorsYang100,\n                optionType: '@sage/x3-stock-data/ContainerStatus',\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isActive',\n                isHidden: true,\n            }),\n            ui.nestedFields.checkbox({\n                bind: 'isSingleProduct',\n                isHidden: true,\n            }),\n        ],\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"licensePlateNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__suggestedLocation____title\", \"Suggested Location\"),\n        //node: '@sage/xtrem-x3-stock/Location',\n        //valueField: 'code',\n        isReadOnly: true,\n        width: 'large',\n        isTransient: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"suggestedLocation\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__location____title\", \"Location\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__location____placeholder\", \"Scan or select...\"),\n        node: '@sage/x3-stock-data/Location',\n        isAutoSelectEnabled: true,\n        valueField: 'code',\n        canFilter: false,\n        filter() {\n            return {\n                stockSite: { code: this.site.value ?? undefined },\n            };\n        },\n        onChange() {\n            this._showSubmit();\n            if (this.location.value)\n                this.location.getNextField(true)?.focus();\n            this.warehouse.value = !this.location.value?.warehouse ? '' : this.location.value.warehouse.code;\n        },\n        columns: [\n            ui.nestedFields.text({\n                bind: 'code',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__location____columns__title__code\", \"Code\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.text({\n                bind: 'type',\n                title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__location____columns__title__type\", \"Type\"),\n                isReadOnly: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-system/Site',\n                bind: 'stockSite',\n                valueField: 'code',\n                isHidden: true,\n            }),\n            ui.nestedFields.reference({\n                node: '@sage/x3-stock-data/Warehouse',\n                bind: 'warehouse',\n                valueField: 'code',\n                isHidden: true,\n            }),\n        ],\n        minLookupCharacters: 1,\n        isFullWidth: true,\n        isMandatory: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"location\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        isHidden: true,\n        isReadOnly: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"warehouse\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__serialNumber____title\", \"Serial number\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__serialNumber____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"serialNumber\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__supplierLot____title\", \"Supplier lot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__supplierLot____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"supplierLot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lot____title\", \"Lot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lot____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isTransient: true,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"lot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__sublot____title\", \"Sublot\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__sublot____placeholder\", \"Scan...\"),\n        isFullWidth: true,\n        validation: /^$|^[^|]+$/,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"sublot\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__majorVersion____title\", \"Major version\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__majorVersion____placeholder\", \"Scan...\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"majorVersion\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__minorVersion____title\", \"Minor version\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__minorVersion____placeholder\", \"Scan...\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"minorVersion\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__expirationDate____title\", \"Expiration date\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__expirationDate____placeholder\", \"Enter an expiration date\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"expirationDate\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__useByDate____placeholder\", \"Enter a use-by date\"),\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__useByDate____title\", \"Use-by date\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"useByDate\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField1____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField1____title\", \"Lot custom text 1\"),\n        validation: /^$|^[^|]+$/,\n        maxLength: 20,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"lotCustomField1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField2____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField2____title\", \"Lot custom text 2\"),\n        validation: /^$|^[^|]+$/,\n        maxLength: 10,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"lotCustomField2\", void 0);\n__decorate([\n    ui.decorators.numericField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField3____placeholder\", \"Scan...\"),\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField3____title\", \"Lot custom number\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"lotCustomField3\", void 0);\n__decorate([\n    ui.decorators.dateField({\n        parent() {\n            return this.blockProduct;\n        },\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField4____placeholder\", \"Enter a date\"),\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__lotCustomField4____title\", \"Lot custom date\"),\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"lotCustomField4\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__identifier1____title\", \"Identifier 1\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__identifier1____placeholder\", \"Scan...\"),\n        isMandatory: false,\n        validation: /^$|^[^|]+$/,\n        maxLength: 10,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"identifier1\", void 0);\n__decorate([\n    ui.decorators.textField({\n        parent() {\n            return this.blockProduct;\n        },\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__identifier2____title\", \"Identifier 2\"),\n        placeholder: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail__identifier2____placeholder\", \"Scan...\"),\n        validation: /^$|^[^|]+$/,\n        isMandatory: false,\n        maxLength: 10,\n        isDisabled: true,\n    })\n], MobileIntersiteReceiptEnterReceiptDetail.prototype, \"identifier2\", void 0);\nexports.MobileIntersiteReceiptEnterReceiptDetail = MobileIntersiteReceiptEnterReceiptDetail = __decorate([\n    ui.decorators.page({\n        title: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail____title\", \"Intersite receipt\"),\n        subtitle: ui.localize(\"@sage/x3-purchasing-sales/pages__mobile_intersite_receipt_enter_receipt_detail____subtitle\", \"Enter details\"),\n        module: 'x3-purchasing-sales',\n        mode: 'default',\n        isTransient: true,\n        isTitleHidden: true,\n        headerCard() {\n            return {\n                title: this.headerTitleLeft,\n                titleRight: this.headerTitleRight,\n                line2: this.headerLine2Left,\n                line2Right: this.headerLine2Right,\n                line3: this.headerLine3Left,\n                line3Right: this.headerLine3Right,\n            };\n        },\n        businessActions() {\n            return [this.nextButton, this.submitButton];\n        },\n        async onLoad() {\n            this.isLocationPreloaded = typesLib.strictEq(this.$.queryParameters?.isLocationPreloaded, '1');\n            this.salesDeliveryId = this.$.queryParameters._id;\n            this.salesDeliveryLineNumber = this.$.queryParameters.deliveryLineNumber;\n            this.salesDeliveryLines = JSON.parse(this.$.queryParameters.deliveryLines);\n            this._intersiteReceiptRecordManager = new intersite_receipt_details_control_1.IntersiteReceiptDetailsRecordManager(this);\n            this.intersiteSession = this._intersiteReceiptRecordManager.intersiteSession;\n            if (!this.intersiteSession) {\n                this.submitButton.isHidden = true;\n                this.nextButton.isHidden = true;\n                this.blockProduct.isHidden = true;\n            }\n            else if (!(await intersite_receipt_details_initializer_1.IntersiteReceiptDetailsInitializer.initializePage(this))) {\n                this.$.router.goTo('@sage/x3-purchasing-sales/MobileIntersiteReceipt', {\n                    _id: this.salesDeliveryId,\n                });\n            }\n            else {\n                this._displayStockJournal(this.stockJournalNodeResponses[this.currStockJournal]);\n                this.nextButton.isHidden = typesLib.strictEq(this.stockJournalNodeResponses.length, 1);\n                this._isOverReceiptAllowed = typesLib.strictEq((await (0, read_parameter_1.readParameterValue)('RCPORD', this.$.userCode ?? '', this.site.value ?? '', this)), 2);\n                this._initDirty();\n                await this._focusToNextField(undefined);\n            }\n        },\n    })\n], MobileIntersiteReceiptEnterReceiptDetail);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/pages/mobile-intersite-receipt-enter-receipt-detail.ts\n");

/***/ }),

/***/ "../../shared/x3-master-data/lib/client-functions/dialogs.ts":
/*!*******************************************************************!*\
  !*** ../../shared/x3-master-data/lib/client-functions/dialogs.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.dialogConfirmation = exports.dialogMessage = void 0;\n/**\n * Display a dialog typed info with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogMessage(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .message(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogMessage = dialogMessage;\n/**\n * Display a inquiry dialog with given page instance, dialog level, message and optionals options and title\n * @param pageInstance\n * @param dialogLevel must be error, info, success or warn.\n * @param title current title\n * @param message message to display.\n * @param options optional options.\n * @returns\n */\nasync function dialogConfirmation(pageInstance, dialogLevel, title, message, options) {\n    return (await pageInstance.$.dialog\n        .confirmation(dialogLevel, title, message, options)\n        .then(() => true)\n        .catch(() => false));\n}\nexports.dialogConfirmation = dialogConfirmation;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-master-data/lib/client-functions/dialogs.ts\n");

/***/ }),

/***/ "../../shared/x3-system/lib/shared-functions/pat-converter.ts":
/*!********************************************************************!*\
  !*** ../../shared/x3-system/lib/shared-functions/pat-converter.ts ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.pat = exports.getRegExpForMultiplePat = exports.getRegExp = void 0;\n/**\n * Get the RegExp equivalent for the 4GL pattern given\n *\n * @param pattern The 4GL pattern you want to get the RegExp equivalent\n * @returns The RegExp\n */\nfunction getRegExp(pattern) {\n    const rule = \n    // escape RegExp spécial chars\n    pattern\n        .replace(/[-[\\]{}()+.,\\\\^$|\\s]/g, '\\\\$&')\n        // translate the pattern\n        .replace(/\\*/g, '.*')\n        .replace(/\\?/g, '.')\n        .replace(/#/g, '\\\\d')\n        .replace(/!/g, '[A-Za-z]');\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExp = getRegExp;\nfunction getRegExpForMultiplePat(multiplePattern) {\n    // const str1 = '(';\n    const rule = `${`(${\n    // convert each pattern individually and join them using |\n    multiplePattern\n        .split(',')\n        .map(multPat => getRegExp(multPat).source.replace(/\\^/g, '').replace(/\\$/g, ''))\n        .join('|')}`})`;\n    return new RegExp(`^${rule}$`);\n}\nexports.getRegExpForMultiplePat = getRegExpForMultiplePat;\n/**\n * Perform a 4GL pattern check\n *\n * @param text The text to be tested\n * @param pat The 4GL pattern to apply\n * @returns The result of the test as a boolean\n */\nfunction pat(text, pattern) {\n    return getRegExp(pattern).test(text);\n}\nexports.pat = pat;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///../../shared/x3-system/lib/shared-functions/pat-converter.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/pages/mobile-intersite-receipt-enter-receipt-detail.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;