/// <reference types="@sage/x3-master-data/api" />
import { ProductSite } from '@sage/x3-master-data-api';
import { GraphApi } from '@sage/x3-purchasing-api';
import * as ui from '@sage/xtrem-ui';
import { IntersiteReceiptSession } from '../client-functions/intersite-receipt-details-control';
import { StockJournalNodeResponse } from '../client-functions/intersite-receipt-details-initializer';
export type packingUnit = {
    node: {
        packingUnit: {
            code: string;
            numberOfDecimals: number;
        };
        packingUnitToStockUnitConversionFactor: string;
        isPackingFactorEntryAllowed: boolean;
    };
};
export declare class MobileIntersiteReceiptEnterReceiptDetail extends ui.Page<GraphApi> {
    private _intersiteReceiptRecordManager;
    intersiteSession: IntersiteReceiptSession;
    private _isOverReceiptAllowed;
    receiptUnits: packingUnit[];
    stockJournalNodeResponses: StockJournalNodeResponse[];
    currStockJournal: number;
    productSite: ProductSite;
    salesDeliveryId: string;
    salesDeliveryLineNumber: string | number | boolean;
    salesDeliveryLines: string[];
    sequence: number;
    isExpirationManaged: boolean;
    salesUnitToStockUnitConversionFactor: string;
    previousSalesUnitToStockUnitConversionFactor: string;
    quantityToReceiveNoRounded: number;
    quantityToReceiveRounded: number;
    remainingQuantityNoRounded: number;
    remainingQuantityRounded: number;
    remainingQuantityInitial: number;
    isLocationPreloaded: boolean;
    headerTitleLeft: ui.fields.Text;
    headerTitleRight: ui.fields.Text;
    headerLine2Left: ui.fields.Text;
    headerLine2Right: ui.fields.Text;
    headerLine3Left: ui.fields.Text;
    headerLine3Right: ui.fields.Text;
    product: ui.fields.Text;
    description: ui.fields.Text;
    site: ui.fields.Text;
    supplier: ui.fields.Text;
    submitButton: ui.PageAction;
    nextButton: ui.PageAction;
    private _getNextStockJournal;
    private _getNextButtonHidden;
    private _updatePurchaseReceiptLine;
    private _goToPageTwo;
    private _goToPageOne;
    private _displayStockJournal;
    private _calculateRemainingQuantity;
    sectionHeader: ui.containers.Section;
    blockProduct: ui.containers.Block;
    receiptUnit: ui.fields.Select;
    receiptUnitCode: ui.fields.Label;
    previousReceiptUnit: ui.fields.Label;
    quantityToReceive: ui.fields.Numeric;
    remainingQuantity: ui.fields.Numeric;
    packingUnitToStockUnitConversionFactor: ui.fields.Numeric;
    status: ui.fields.Select;
    container: ui.fields.Reference;
    licensePlateNumber: ui.fields.Reference;
    suggestedLocation: ui.fields.Text;
    location: ui.fields.Reference;
    warehouse: ui.fields.Text;
    serialNumber: ui.fields.Text;
    supplierLot: ui.fields.Text;
    lot: ui.fields.Text;
    sublot: ui.fields.Text;
    majorVersion: ui.fields.Text;
    minorVersion: ui.fields.Text;
    expirationDate: ui.fields.Date;
    useByDate: ui.fields.Date;
    lotCustomField1: ui.fields.Text;
    lotCustomField2: ui.fields.Text;
    lotCustomField3: ui.fields.Numeric;
    lotCustomField4: ui.fields.Date;
    identifier1: ui.fields.Text;
    identifier2: ui.fields.Text;
    private _focusToNextField;
    private _validate;
    private _showSubmit;
    private _initDirty;
    private _getPayloadFieldString;
    private _getPayloadFieldDate;
    private _getPayloadFieldNumber;
}
//# sourceMappingURL=mobile-intersite-receipt-enter-receipt-detail.d.ts.map