"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNumberOfDecimal = exports.getUnitNumberOfDecimalList = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const xtrem_client_1 = require("@sage/xtrem-client");
const ui = require("@sage/xtrem-ui");
async function getUnitNumberOfDecimalList(pageInstance) {
    try {
        const numberOfDecimalList = (0, xtrem_client_1.extractEdges)(await pageInstance.$.graph
            .node('@sage/x3-master-data/UnitOfMeasure')
            .query(ui.queryUtils.edgesSelector({
            code: true,
            numberOfDecimals: true,
        }, {
            first: 1000,
        }))
            .execute());
        return numberOfDecimalList;
    }
    catch (e) {
        pageInstance.$.dialog.message('error', ui.localize('@sage/x3-purchasing-sales/pages__utils__get_unit_number_decimals_error', 'Error loading unit'), String(e));
        return [];
    }
}
exports.getUnitNumberOfDecimalList = getUnitNumberOfDecimalList;
function getNumberOfDecimal(list, unit) {
    if (unit && list) {
        const _unitOfMeasure = list.filter(uom => typesLib.strictEq(uom.code, unit));
        return _unitOfMeasure[0]?.numberOfDecimals ?? 0;
    }
    return 0;
}
exports.getNumberOfDecimal = getNumberOfDecimal;
//# sourceMappingURL=get-unit-number-decimals.js.map