declare module '@sage/x3-purchasing-sales-api-partial' {
    import type {
        AutomaticJournal,
        BankAccount,
        CustomerInvoiceHeaderCurrencyRates,
        CustomerInvoiceHeaderCurrencyRatesInput,
        CustomerInvoiceHeaderDimensions,
        CustomerInvoiceHeaderDimensionsInput,
        EntryType,
        Factor,
        Journal,
        Package as SageX3FinanceData$Package,
        SupplierInvoiceHeaderCurrencyRates,
        SupplierInvoiceHeaderCurrencyRatesInput,
        SupplierInvoiceHeaderDimensions,
        SupplierInvoiceHeaderDimensionsInput,
    } from '@sage/x3-finance-data-api';
    import type {
        CustomerInvoiceHeader,
        CustomerInvoiceHeaderBillToCustomerAddressLines,
        CustomerInvoiceHeaderBillToCustomerAddressLinesInput,
        CustomerInvoiceHeaderComments,
        CustomerInvoiceHeaderCommentsInput,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLines,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput,
        CustomerInvoiceHeaderTaxes,
        EarlyDiscountLateCharge,
        InvoicingTerm,
        Mandate,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        PriceStructure,
        SupplierInvoiceHeader,
        SupplierInvoiceHeaderBillBySupplierAddressLines,
        SupplierInvoiceHeaderBillBySupplierAddressLinesInput,
        SupplierInvoiceHeaderBillBySupplierCompanyNames,
        SupplierInvoiceHeaderBillBySupplierCompanyNamesInput,
        SupplierInvoiceHeaderComments,
        SupplierInvoiceHeaderCommentsInput,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLines,
        SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames,
        SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput,
        SupplierInvoiceHeaderTaxes,
        SupplierInvoiceHeaderTaxesInput,
        Tax,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type { Package as SageX3ManufacturingData$Package } from '@sage/x3-manufacturing-data-api';
    import type {
        BusinessPartner,
        BusinessPartnerAddress,
        Carrier,
        Container,
        Currency,
        Customer,
        CustomerAddress,
        CustomerContact,
        Incoterm,
        Package as SageX3MasterData$Package,
        Product,
        SalesRep,
        ShipToCustomerAddress,
        SiteAddress,
        Supplier,
        SupplierAddress,
        SupplierProduct,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type {
        IntrastatStatisticalRule,
        IntrastatTransactionNature,
        Package as SageX3PhysicalFlowsData$Package,
        Packaging,
    } from '@sage/x3-physical-flows-data-api';
    import type {
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type {
        Cost,
        Package as SageX3Purchasing$Package,
        PurchaseInvoice,
        PurchaseInvoiceHeaderInvoiceLineAllocationElements,
        PurchaseInvoiceHeaderInvoiceLineAllocationElementsBinding,
        PurchaseInvoiceHeaderInvoiceLineAllocationElementsInput,
        PurchaseInvoiceHeaderInvoiceLineElements,
        PurchaseInvoiceHeaderInvoiceLineElementsBinding,
        PurchaseInvoiceHeaderInvoiceLineElementsInput,
        PurchaseInvoiceInput,
        PurchaseInvoiceLine,
        PurchaseInvoiceLineInput,
        PurchaseInvoiceLineProductStatisticalGroups,
        PurchaseInvoiceLineProductStatisticalGroupsBinding,
        PurchaseInvoiceLineProductStatisticalGroupsInput,
        PurchaseInvoiceLineTaxes,
        PurchaseInvoiceLineTaxesBinding,
        PurchaseInvoiceLineTaxesInput,
        PurchaseInvoiceSupplierStatisticalGroups,
        PurchaseInvoiceSupplierStatisticalGroupsBinding,
        PurchaseInvoiceSupplierStatisticalGroupsInput,
        PurchaseOrder,
        PurchaseOrderCompanyNames,
        PurchaseOrderCompanyNamesBinding,
        PurchaseOrderCompanyNamesInput,
        PurchaseOrderDimensions,
        PurchaseOrderDimensionsBinding,
        PurchaseOrderDimensionsInput,
        PurchaseOrderDiscountOrChargeCalculationRules,
        PurchaseOrderDiscountOrChargeCalculationRulesBinding,
        PurchaseOrderDiscountOrChargeCalculationRulesInput,
        PurchaseOrderFromSupplierAddressLines,
        PurchaseOrderFromSupplierAddressLinesBinding,
        PurchaseOrderFromSupplierAddressLinesInput,
        PurchaseOrderFromSupplierCompanyNames,
        PurchaseOrderFromSupplierCompanyNamesBinding,
        PurchaseOrderFromSupplierCompanyNamesInput,
        PurchaseOrderHeaderInvoiceLineAllocationElements,
        PurchaseOrderHeaderInvoiceLineAllocationElementsBinding,
        PurchaseOrderHeaderInvoiceLineAllocationElementsInput,
        PurchaseOrderLine,
        PurchaseOrderLineInput,
        PurchaseOrderLineProductStatisticalGroups,
        PurchaseOrderLineProductStatisticalGroupsBinding,
        PurchaseOrderLineProductStatisticalGroupsInput,
        PurchaseOrderLineTaxes,
        PurchaseOrderLineTaxesBinding,
        PurchaseOrderLineTaxesInput,
        PurchaseOrderShipFromSupplierAddressLines,
        PurchaseOrderShipFromSupplierAddressLinesBinding,
        PurchaseOrderShipFromSupplierAddressLinesInput,
        PurchaseOrderSupplierStatisticalGroups,
        PurchaseOrderSupplierStatisticalGroupsBinding,
        PurchaseOrderSupplierStatisticalGroupsInput,
        PurchaseReceipt,
        PurchaseReceiptLine,
        PurchaseReceiptLineInput,
        PurchaseReceiptLineProductStatisticalGroups,
        PurchaseReceiptLineProductStatisticalGroupsBinding,
        PurchaseReceiptLineProductStatisticalGroupsInput,
        PurchaseReceiptLineTaxes,
        PurchaseReceiptLineTaxesBinding,
        PurchaseReceiptLineTaxesInput,
        PurchaseReturn,
        PurchaseReturnLine,
        PurchaseShipment,
        PurchaseShipmentLine,
    } from '@sage/x3-purchasing-api';
    import type {
        DeliveryMode,
        FreightCostStructure,
        MatchingTolerance,
        Package as SageX3PurchasingData$Package,
        PurchaseInvoiceType,
        PurchasePriceReason,
    } from '@sage/x3-purchasing-data-api';
    import type {
        Package as SageX3Sales$Package,
        SalesDelivery,
        SalesDeliveryLine,
        SalesInvoice,
        SalesInvoiceBillToCustomerCompanyNames,
        SalesInvoiceBillToCustomerCompanyNamesBinding,
        SalesInvoiceBillToCustomerCompanyNamesInput,
        SalesInvoiceCustomerStatisticalGroups,
        SalesInvoiceCustomerStatisticalGroupsBinding,
        SalesInvoiceCustomerStatisticalGroupsInput,
        SalesInvoiceDiscountOrChargeCalculationRules,
        SalesInvoiceDiscountOrChargeCalculationRulesBinding,
        SalesInvoiceDiscountOrChargeCalculationRulesInput,
        SalesInvoiceInput,
        SalesInvoiceInvoicingElements,
        SalesInvoiceInvoicingElementsBinding,
        SalesInvoiceInvoicingElementsInput,
        SalesInvoiceLine,
        SalesInvoiceLineDistributedInvoicingElements,
        SalesInvoiceLineDistributedInvoicingElementsBinding,
        SalesInvoiceLineDistributedInvoicingElementsInput,
        SalesInvoiceLineInput,
        SalesInvoiceLineProductStatisticalGroups,
        SalesInvoiceLineProductStatisticalGroupsBinding,
        SalesInvoiceLineProductStatisticalGroupsInput,
        SalesInvoiceLineTaxBasisAmounts,
        SalesInvoiceLineTaxBasisAmountsBinding,
        SalesInvoiceLineTaxBasisAmountsInput,
        SalesInvoiceLineTaxes,
        SalesInvoiceLineTaxesBinding,
        SalesInvoiceLineTaxesInput,
        SalesInvoiceSalesOrderOfPrepayments,
        SalesInvoiceSalesOrderOfPrepaymentsBinding,
        SalesInvoiceSalesOrderOfPrepaymentsInput,
        SalesInvoiceSalesReps,
        SalesInvoiceSalesRepsBinding,
        SalesInvoiceSalesRepsInput,
        SalesInvoiceShipToCustomerAddressLines,
        SalesInvoiceShipToCustomerAddressLinesBinding,
        SalesInvoiceShipToCustomerAddressLinesInput,
        SalesInvoiceShipToCustomerCompanyNames,
        SalesInvoiceShipToCustomerCompanyNamesBinding,
        SalesInvoiceShipToCustomerCompanyNamesInput,
        SalesOrder,
        SalesOrderLine,
        SalesOrderLineDimensionDimensions,
        SalesOrderLineDimensionDimensionsInput,
        SalesOrderLineInput,
        SalesOrderLineProductStatisticalGroups,
        SalesOrderLineProductStatisticalGroupsBinding,
        SalesOrderLineProductStatisticalGroupsInput,
        SalesOrderLineTaxes,
        SalesOrderLineTaxesBinding,
        SalesOrderLineTaxesInput,
        SalesOrderQuantityLineDistributedInvoicingElements,
        SalesOrderQuantityLineDistributedInvoicingElementsInput,
        SalesQuote,
        SalesQuoteLine,
        SalesReturn,
        SalesReturnLine,
        SalesReturnLineInput,
    } from '@sage/x3-sales-api';
    import type {
        Package as SageX3SalesData$Package,
        SalesInvoiceType,
        SalesPriceReason,
    } from '@sage/x3-sales-data-api';
    import type { Package as SageX3Stock$Package } from '@sage/x3-stock-api';
    import type {
        Location,
        MajorVersionStatus,
        Package as SageX3StockData$Package,
        StockJournal,
        StockJournalInput,
        Warehouse,
    } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Company,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type { ClientCollection, QueryOperation, TextStream, decimal, integer } from '@sage/xtrem-client';
    export interface PurchaseInvoiceExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: SupplierInvoiceHeader;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        billBySupplier: Supplier;
        currency: Currency;
        numberOfLines: integer;
        numberOfLinesWithDifferentQuantity: integer;
        numberOfLinesWithDifferentPrice: integer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalQuantityOfLines: string;
        amountOfLinesExcludingTax: string;
        calculatedLineAmountExcludingTax: string;
        totalTaxAmount: string;
        billBySupplierLanguage: Language;
        companyLanguage: Language;
        company: Company;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        isIntercompany: boolean;
        billToCustomer: Customer;
        purchaseInvoiceLines: ClientCollection<PurchaseInvoiceLine>;
        supplierInvoiceHeader: SupplierInvoiceHeader;
        accountingDate: string;
        billBySupplierAddress: SupplierAddress;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCity: string;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        billBySupplierPostalCode: string;
        billBySupplierState: string;
        cashVatTaxRule: boolean;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        control: string;
        currencyRates: ClientCollection<SupplierInvoiceHeaderCurrencyRates>;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<SupplierInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entryType: EntryType;
        europeanUnionIdentification: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        internalNumber: integer;
        internalReference: string;
        intrastatProcessingNumber: integer;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDas2Submitted: boolean;
        isEuropeanUnionInvoice: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        matchStatus: MatchStatusEnum;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerState: string;
        paymentApproval: PaymentApprovalType;
        paymentTerm: PaymentTerm;
        period: integer;
        priceOrAmountType: PriceAmountTaxTax;
        project: ProjectLink;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        site: Site;
        sourceDocumentDate: string;
        sourceModule: ModuleTable;
        status: PurchasingInvoiceStatus;
        supplierSourceDocument: string;
        taxReferenceDate: string;
        taxRule: TaxRule;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        versionControlSystemNumber: string;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineAllocationElements>;
        headerInvoiceLineElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineElements>;
        supplierStatisticalGroups: ClientCollection<PurchaseInvoiceSupplierStatisticalGroups>;
        salesInvoice: SalesInvoice;
    }
    export interface PurchaseInvoiceInputExtension {
        id?: string;
        category?: InvoiceType;
        invoiceType?: string;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        billBySupplier?: string;
        currency?: string;
        numberOfLines?: integer | string;
        numberOfLinesWithDifferentQuantity?: integer | string;
        numberOfLinesWithDifferentPrice?: integer | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        totalWeightOfLines?: decimal | string;
        totalVolumeOfLines?: decimal | string;
        totalQuantityOfLines?: decimal | string;
        amountOfLinesExcludingTax?: decimal | string;
        calculatedLineAmountExcludingTax?: decimal | string;
        totalTaxAmount?: decimal | string;
        billBySupplierLanguage?: string;
        companyLanguage?: string;
        company?: string;
        earlyDiscountOrLateCharge?: string;
        isIntercompany?: boolean | string;
        billToCustomer?: string;
        purchaseInvoiceLines?: Partial<PurchaseInvoiceLineInput>[];
        supplierInvoiceHeader?: string;
        accountingDate?: string;
        billBySupplierAddress?: string;
        billBySupplierAddressLines?: Partial<SupplierInvoiceHeaderBillBySupplierAddressLinesInput>[];
        billBySupplierCity?: string;
        billBySupplierCompanyNames?: Partial<SupplierInvoiceHeaderBillBySupplierCompanyNamesInput>[];
        billBySupplierCountry?: string;
        billBySupplierCountryName?: string;
        billBySupplierPostalCode?: string;
        billBySupplierState?: string;
        cashVatTaxRule?: boolean | string;
        comments?: Partial<SupplierInvoiceHeaderCommentsInput>[];
        control?: string;
        currencyRates?: Partial<SupplierInvoiceHeaderCurrencyRatesInput>[];
        debitOrCredit?: integer | string;
        derCode?: string;
        dimensions?: Partial<SupplierInvoiceHeaderDimensionsInput>[];
        dueDateCalculationStartDate?: string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        entryType?: string;
        europeanUnionIdentification?: string;
        field40Reason?: string;
        field41Reason?: string;
        fiscalYear?: integer | string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        incoterm?: string;
        incotermTown?: string;
        internalNumber?: integer | string;
        internalReference?: string;
        intrastatProcessingNumber?: integer | string;
        intrastatStatisticalRule?: string;
        intrastatTransactionNature?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        invoiceFooterText?: TextStream;
        invoiceHeaderText?: TextStream;
        isDas2Submitted?: boolean | string;
        isEuropeanUnionInvoice?: boolean | string;
        journal?: string;
        lastServiceAccountedDate?: string;
        matchStatus?: MatchStatusEnum;
        numberOfTaxes?: integer | string;
        originalDocumentNumber?: string;
        originalInvoiceNumber?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        payToBusinessPartnerAddressLines?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerAddressLinesInput>[];
        payToBusinessPartnerCity?: string;
        payToBusinessPartnerCompanyNames?: Partial<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNamesInput>[];
        payToBusinessPartnerCountry?: string;
        payToBusinessPartnerCountryName?: string;
        payToBusinessPartnerPostalCode?: string;
        payToBusinessPartnerState?: string;
        paymentApproval?: PaymentApprovalType;
        paymentTerm?: string;
        period?: integer | string;
        priceOrAmountType?: PriceAmountTaxTax;
        project?: string;
        rateDate?: string;
        rateType?: ExchangeRateType;
        serviceEndDate?: string;
        serviceStartDate?: string;
        singleCustomsDocumentBusinessPartnerCode?: string;
        singleCustomsDocumentDate?: string;
        singleCustomsDocumentReference?: string;
        site?: string;
        sourceDocumentDate?: string;
        sourceModule?: ModuleTable;
        status?: PurchasingInvoiceStatus;
        supplierSourceDocument?: string;
        taxReferenceDate?: string;
        taxRule?: string;
        taxes?: Partial<SupplierInvoiceHeaderTaxesInput>[];
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        versionControlSystemNumber?: string;
        headerInvoiceLineAllocationElements?: Partial<PurchaseInvoiceHeaderInvoiceLineAllocationElementsInput>[];
        headerInvoiceLineElements?: Partial<PurchaseInvoiceHeaderInvoiceLineElementsInput>[];
        supplierStatisticalGroups?: Partial<PurchaseInvoiceSupplierStatisticalGroupsInput>[];
        salesInvoice?: string;
    }
    export interface PurchaseInvoiceBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: SupplierInvoiceHeader;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        billBySupplier: Supplier;
        currency: Currency;
        numberOfLines: integer;
        numberOfLinesWithDifferentQuantity: integer;
        numberOfLinesWithDifferentPrice: integer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalQuantityOfLines: string;
        amountOfLinesExcludingTax: string;
        calculatedLineAmountExcludingTax: string;
        totalTaxAmount: string;
        billBySupplierLanguage: Language;
        companyLanguage: Language;
        company: Company;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        isIntercompany: boolean;
        billToCustomer: Customer;
        purchaseInvoiceLines: ClientCollection<PurchaseInvoiceLine>;
        supplierInvoiceHeader: SupplierInvoiceHeader;
        accountingDate: string;
        billBySupplierAddress: SupplierAddress;
        billBySupplierAddressLines: ClientCollection<SupplierInvoiceHeaderBillBySupplierAddressLines>;
        billBySupplierCity: string;
        billBySupplierCompanyNames: ClientCollection<SupplierInvoiceHeaderBillBySupplierCompanyNames>;
        billBySupplierCountry: Country;
        billBySupplierCountryName: string;
        billBySupplierPostalCode: string;
        billBySupplierState: string;
        cashVatTaxRule: boolean;
        comments: ClientCollection<SupplierInvoiceHeaderComments>;
        control: string;
        currencyRates: ClientCollection<SupplierInvoiceHeaderCurrencyRates>;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<SupplierInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entryType: EntryType;
        europeanUnionIdentification: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        internalNumber: integer;
        internalReference: string;
        intrastatProcessingNumber: integer;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDas2Submitted: boolean;
        isEuropeanUnionInvoice: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        matchStatus: MatchStatusEnum;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        payToBusinessPartnerAddressLines: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerAddressLines>;
        payToBusinessPartnerCity: string;
        payToBusinessPartnerCompanyNames: ClientCollection<SupplierInvoiceHeaderPayToBusinessPartnerCompanyNames>;
        payToBusinessPartnerCountry: Country;
        payToBusinessPartnerCountryName: string;
        payToBusinessPartnerPostalCode: string;
        payToBusinessPartnerState: string;
        paymentApproval: PaymentApprovalType;
        paymentTerm: PaymentTerm;
        period: integer;
        priceOrAmountType: PriceAmountTaxTax;
        project: ProjectLink;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        singleCustomsDocumentBusinessPartnerCode: Supplier;
        singleCustomsDocumentDate: string;
        singleCustomsDocumentReference: string;
        site: Site;
        sourceDocumentDate: string;
        sourceModule: ModuleTable;
        status: PurchasingInvoiceStatus;
        supplierSourceDocument: string;
        taxReferenceDate: string;
        taxRule: TaxRule;
        taxes: ClientCollection<SupplierInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        versionControlSystemNumber: string;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineAllocationElementsBinding>;
        headerInvoiceLineElements: ClientCollection<PurchaseInvoiceHeaderInvoiceLineElementsBinding>;
        supplierStatisticalGroups: ClientCollection<PurchaseInvoiceSupplierStatisticalGroupsBinding>;
        salesInvoice: SalesInvoice;
    }
    export interface PurchaseInvoiceExtension$Lookups {
        salesInvoice: QueryOperation<SalesInvoice>;
    }
    export interface PurchaseInvoiceExtension$Operations {
        lookups(dataOrId: string | { data: PurchaseInvoiceInput }): PurchaseInvoiceExtension$Lookups;
    }
    export interface PurchaseInvoiceLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseInvoice: SupplierInvoiceHeader;
        lineNumber: integer;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        company: Company;
        site: Site;
        accountingDate: string;
        billBySupplier: Supplier;
        lineSite: Site;
        sourceLine: PurchaseInvoiceSource;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        invoicingUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        stockUnitToPurchaseUnitConversionFactor: string;
        quantityInInvoiceUnitInvoiced: string;
        quantityInPurchaseUnitInvoiced: string;
        sourceQuantity: string;
        quantityInStockUnitInvoiced: string;
        weight: string;
        sourceWeight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        sourceVolume: string;
        volumeUnit: UnitOfMeasure;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        sourceNetPrice: string;
        purchaseType: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        currency: Currency;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        sourcePurchaseInvoice: SupplierInvoiceHeader;
        sourcePurchaseInvoiceLine: PurchaseInvoiceLine;
        supplier: Supplier;
        receiptDate: string;
        project: ProjectLink;
        issueRegion: MiscellaneousTable;
        receiptRegion: MiscellaneousTable;
        lineAmountExcludingTax: string;
        lineAmountIncludingTax: string;
        discountAmount: string;
        distributedInvoicingElementEarlyDiscountAmount1: string;
        distributedInvoicingElementEarlyDiscountAmount2: string;
        distributedInvoicingElementEarlyDiscountAmount3: string;
        distributedInvoicingElementEarlyDiscountAmount4: string;
        distributedInvoicingElementEarlyDiscountAmount5: string;
        distributedInvoicingElementEarlyDiscountAmount6: string;
        distributedInvoicingElementEarlyDiscountAmount7: string;
        distributedInvoicingElementEarlyDiscountAmount8: string;
        distributedInvoicingElementEarlyDiscountAmount9: string;
        quantityUncommitted: string;
        quantityActualCommitted: string;
        nonFinancialUnit: UnitOfMeasure;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculationBasisForReceiptTax: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1amount: string;
        tax2amount: string;
        tax3amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        lineStockCostInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        costStructure: string;
        companyCurrency: Currency;
        totalStockCostInCompanyCurrency: string;
        totalPurchaseCostInCompanyCurrency: string;
        isPartiallyInvoiced: boolean;
        isExtractedLineFromIntrastat: boolean;
        isIntrastatPhysicalFlow: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        lineType: OrderLineType;
        linkQuantityCoefficientForSubcontract: string;
        calculatedTaxExcludedLineAmount: string;
        vatDeclarationNumber: string;
        costUpdatedIfAdditionalInvoice: boolean;
        cost: Cost;
        isReconciled: boolean;
        productType: PurchasingProductType;
        invoiceLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseInvoiceLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseInvoiceLineTaxes>;
        salesInvoiceLineNumber: integer;
    }
    export interface PurchaseInvoiceLineInputExtension {
        purchaseInvoice?: string;
        lineNumber?: integer | string;
        category?: InvoiceType;
        invoiceType?: string;
        purchaseInvoiceCategory?: PurchaseInvoiceCategory;
        company?: string;
        site?: string;
        accountingDate?: string;
        billBySupplier?: string;
        lineSite?: string;
        sourceLine?: PurchaseInvoiceSource;
        sourceDocument?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentSequenceNumber?: integer | string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        invoicingUnit?: string;
        purchaseUnit?: string;
        stockUnit?: string;
        stockUnitToPurchaseUnitConversionFactor?: decimal | string;
        quantityInInvoiceUnitInvoiced?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        sourceQuantity?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        weight?: decimal | string;
        sourceWeight?: decimal | string;
        weightUnit?: string;
        volume?: decimal | string;
        sourceVolume?: decimal | string;
        volumeUnit?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        sourceNetPrice?: decimal | string;
        purchaseType?: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        currency?: string;
        purchaseOrder?: string;
        purchaseOrderLine?: integer | string;
        purchaseOrderSequenceNumber?: integer | string;
        purchaseReceipt?: string;
        purchaseReceiptLine?: integer | string;
        purchaseReturn?: string;
        purchaseReturnLine?: integer | string;
        purchaseShipment?: string;
        purchaseShipmentLine?: integer | string;
        sourcePurchaseInvoice?: string;
        sourcePurchaseInvoiceLine?: integer | string;
        supplier?: string;
        receiptDate?: string;
        project?: string;
        issueRegion?: string;
        receiptRegion?: string;
        lineAmountExcludingTax?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        discountAmount?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount1?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount2?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount3?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount4?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount5?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount6?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount7?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount8?: decimal | string;
        distributedInvoicingElementEarlyDiscountAmount9?: decimal | string;
        quantityUncommitted?: decimal | string;
        quantityActualCommitted?: decimal | string;
        nonFinancialUnit?: string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        calculatedTaxableBase3?: decimal | string;
        calculationBasisForReceiptTax?: decimal | string;
        calculationBasisForIssueTax?: decimal | string;
        calculationBasisForOtherTax1?: decimal | string;
        calculationBasisForOtherTax2?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        taxableBase1Amount?: decimal | string;
        tax1amount?: decimal | string;
        tax2amount?: decimal | string;
        tax3amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        issueTaxAmount?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax2Amount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        costPriceInCompanyCurrency?: decimal | string;
        purchaseCostInCompanyCurrency?: decimal | string;
        lineStockCostInCompanyCurrency?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        costStructure?: string;
        companyCurrency?: string;
        totalStockCostInCompanyCurrency?: decimal | string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        isPartiallyInvoiced?: boolean | string;
        isExtractedLineFromIntrastat?: boolean | string;
        isIntrastatPhysicalFlow?: boolean | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        servicePeriodNumber?: integer | string;
        servicePeriodType?: PeriodicityType;
        lineType?: OrderLineType;
        linkQuantityCoefficientForSubcontract?: decimal | string;
        calculatedTaxExcludedLineAmount?: decimal | string;
        vatDeclarationNumber?: string;
        costUpdatedIfAdditionalInvoice?: boolean | string;
        cost?: string;
        isReconciled?: boolean | string;
        productType?: PurchasingProductType;
        invoiceLineText?: TextStream;
        productStatisticalGroups?: Partial<PurchaseInvoiceLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseInvoiceLineTaxesInput>[];
        salesInvoiceLineNumber?: integer | string;
    }
    export interface PurchaseInvoiceLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseInvoice: SupplierInvoiceHeader;
        lineNumber: integer;
        category: InvoiceType;
        invoiceType: PurchaseInvoiceType;
        purchaseInvoiceCategory: PurchaseInvoiceCategory;
        company: Company;
        site: Site;
        accountingDate: string;
        billBySupplier: Supplier;
        lineSite: Site;
        sourceLine: PurchaseInvoiceSource;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        invoicingUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        stockUnitToPurchaseUnitConversionFactor: string;
        quantityInInvoiceUnitInvoiced: string;
        quantityInPurchaseUnitInvoiced: string;
        sourceQuantity: string;
        quantityInStockUnitInvoiced: string;
        weight: string;
        sourceWeight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        sourceVolume: string;
        volumeUnit: UnitOfMeasure;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        sourceNetPrice: string;
        purchaseType: PurchaseType;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        currency: Currency;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        sourcePurchaseInvoice: SupplierInvoiceHeader;
        sourcePurchaseInvoiceLine: PurchaseInvoiceLine;
        supplier: Supplier;
        receiptDate: string;
        project: ProjectLink;
        issueRegion: MiscellaneousTable;
        receiptRegion: MiscellaneousTable;
        lineAmountExcludingTax: string;
        lineAmountIncludingTax: string;
        discountAmount: string;
        distributedInvoicingElementEarlyDiscountAmount1: string;
        distributedInvoicingElementEarlyDiscountAmount2: string;
        distributedInvoicingElementEarlyDiscountAmount3: string;
        distributedInvoicingElementEarlyDiscountAmount4: string;
        distributedInvoicingElementEarlyDiscountAmount5: string;
        distributedInvoicingElementEarlyDiscountAmount6: string;
        distributedInvoicingElementEarlyDiscountAmount7: string;
        distributedInvoicingElementEarlyDiscountAmount8: string;
        distributedInvoicingElementEarlyDiscountAmount9: string;
        quantityUncommitted: string;
        quantityActualCommitted: string;
        nonFinancialUnit: UnitOfMeasure;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculationBasisForReceiptTax: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1amount: string;
        tax2amount: string;
        tax3amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        lineStockCostInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        costStructure: string;
        companyCurrency: Currency;
        totalStockCostInCompanyCurrency: string;
        totalPurchaseCostInCompanyCurrency: string;
        isPartiallyInvoiced: boolean;
        isExtractedLineFromIntrastat: boolean;
        isIntrastatPhysicalFlow: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        lineType: OrderLineType;
        linkQuantityCoefficientForSubcontract: string;
        calculatedTaxExcludedLineAmount: string;
        vatDeclarationNumber: string;
        costUpdatedIfAdditionalInvoice: boolean;
        cost: Cost;
        isReconciled: boolean;
        productType: PurchasingProductType;
        invoiceLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseInvoiceLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseInvoiceLineTaxesBinding>;
        salesInvoiceLineNumber: integer;
    }
    export interface PurchaseOrderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        purchaseSite: Site;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        orderDate: string;
        internalOrderReference: string;
        project: ProjectLink;
        orderFromSupplier: Supplier;
        orderFromSupplierAddress: SupplierAddress;
        orderFromSupplierAddressZipCode: string;
        orderFromSupplierAddressCity: string;
        orderFromSupplierAddressState: string;
        orderFromSupplierAddressCountry: Country;
        orderFromSupplierAddressCountryName: string;
        shipFromSupplierAddress: SupplierAddress;
        shipFromSupplierAddressZipCode: string;
        shipFromSupplierAddressCity: string;
        shipFromSupplierAddressState: string;
        shipFromSupplierAddressCountry: Country;
        shipFromSupplierAddressCountryName: string;
        invoiceSite: Site;
        receiptSite: Site;
        expectedReceiptDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        carrier: Carrier;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        groupingCode: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        buyer: User;
        orderFromSupplierLanguage: Language;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        numberOfLines: integer;
        numberOfBudgetOverrunLines: integer;
        numberOfReceivedLines: integer;
        numberOfClosedLines: integer;
        numberOfInvoicedLines: integer;
        numberOfReceipts: integer;
        numberOfInvoices: integer;
        signatureStatus: NoInPartInFull;
        isClosed: boolean;
        receiptStatus: NoInPartInFull;
        invoicedStatus: NoInPartInFull;
        isPrinted: boolean;
        numberOfCopies: integer;
        acknowledgmentDate: string;
        acknowledgmentNumber: string;
        acknowledgmentNote: string;
        isPrintedAcknowledgmentReminder: boolean;
        mustSendDeliveryReminder: boolean;
        isIntercompany: boolean;
        isIntersite: boolean;
        purchaseSiteForIntersite: Site;
        shippingSite: Site;
        salesSite: Site;
        soldToCustomer: Customer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesIncludingTax: string;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalTaxAmount: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        expectedTotalAmountExcludingTax: string;
        serviceStartDate: string;
        serviceEndDate: string;
        container: Container;
        numberOfContainers: integer;
        maximumAmountExcludingTax: string;
        availableWeightOfContainer: string;
        availableVolumeOfContainer: string;
        purchaseOrderLines: ClientCollection<PurchaseOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        companyNames: ClientCollection<PurchaseOrderCompanyNames>;
        dimensions: ClientCollection<PurchaseOrderDimensions>;
        discountOrChargeCalculationRules: ClientCollection<PurchaseOrderDiscountOrChargeCalculationRules>;
        fromSupplierAddressLines: ClientCollection<PurchaseOrderFromSupplierAddressLines>;
        fromSupplierCompanyNames: ClientCollection<PurchaseOrderFromSupplierCompanyNames>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseOrderHeaderInvoiceLineAllocationElements>;
        shipFromSupplierAddressLines: ClientCollection<PurchaseOrderShipFromSupplierAddressLines>;
        supplierStatisticalGroups: ClientCollection<PurchaseOrderSupplierStatisticalGroups>;
        salesOrderCategory: OrderCategory;
        partialDelivery: PartialDelivery;
    }
    export interface PurchaseOrderInputExtension {
        id?: string;
        company?: string;
        purchaseSite?: string;
        orderType?: PurchaseOrderType;
        revisionNumber?: integer | string;
        orderDate?: string;
        internalOrderReference?: string;
        project?: string;
        orderFromSupplier?: string;
        orderFromSupplierAddress?: string;
        orderFromSupplierAddressZipCode?: string;
        orderFromSupplierAddressCity?: string;
        orderFromSupplierAddressState?: string;
        orderFromSupplierAddressCountry?: string;
        orderFromSupplierAddressCountryName?: string;
        shipFromSupplierAddress?: string;
        shipFromSupplierAddressZipCode?: string;
        shipFromSupplierAddressCity?: string;
        shipFromSupplierAddressState?: string;
        shipFromSupplierAddressCountry?: string;
        shipFromSupplierAddressCountryName?: string;
        invoiceSite?: string;
        receiptSite?: string;
        expectedReceiptDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        deliveryMode?: string;
        carrier?: string;
        payToBusinessPartner?: string;
        payToBusinessPartnerAddress?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        incoterm?: string;
        incotermTown?: string;
        groupingCode?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        intrastatTransportLocation?: CountryLocation;
        europeanUnionIdentification?: string;
        buyer?: string;
        orderFromSupplierLanguage?: string;
        currency?: string;
        currencyRateType?: ExchangeRateType;
        currencyRate?: decimal | string;
        taxRule?: string;
        taxRuleType?: integer | string;
        numberOfLines?: integer | string;
        numberOfBudgetOverrunLines?: integer | string;
        numberOfReceivedLines?: integer | string;
        numberOfClosedLines?: integer | string;
        numberOfInvoicedLines?: integer | string;
        numberOfReceipts?: integer | string;
        numberOfInvoices?: integer | string;
        signatureStatus?: NoInPartInFull;
        isClosed?: boolean | string;
        receiptStatus?: NoInPartInFull;
        invoicedStatus?: NoInPartInFull;
        isPrinted?: boolean | string;
        numberOfCopies?: integer | string;
        acknowledgmentDate?: string;
        acknowledgmentNumber?: string;
        acknowledgmentNote?: string;
        isPrintedAcknowledgmentReminder?: boolean | string;
        mustSendDeliveryReminder?: boolean | string;
        isIntercompany?: boolean | string;
        isIntersite?: boolean | string;
        purchaseSiteForIntersite?: string;
        shippingSite?: string;
        salesSite?: string;
        soldToCustomer?: string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        amountOfLinesIncludingTax?: decimal | string;
        amountOfLinesExcludingTax?: decimal | string;
        totalQuantityOfLines?: decimal | string;
        totalWeightOfLines?: decimal | string;
        totalVolumeOfLines?: decimal | string;
        totalTaxAmount?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        expectedTotalAmountExcludingTax?: decimal | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        container?: string;
        numberOfContainers?: integer | string;
        maximumAmountExcludingTax?: decimal | string;
        availableWeightOfContainer?: decimal | string;
        availableVolumeOfContainer?: decimal | string;
        purchaseOrderLines?: Partial<PurchaseOrderLineInput>[];
        orderFooterText?: TextStream;
        orderHeaderText?: TextStream;
        companyNames?: Partial<PurchaseOrderCompanyNamesInput>[];
        dimensions?: Partial<PurchaseOrderDimensionsInput>[];
        discountOrChargeCalculationRules?: Partial<PurchaseOrderDiscountOrChargeCalculationRulesInput>[];
        fromSupplierAddressLines?: Partial<PurchaseOrderFromSupplierAddressLinesInput>[];
        fromSupplierCompanyNames?: Partial<PurchaseOrderFromSupplierCompanyNamesInput>[];
        headerInvoiceLineAllocationElements?: Partial<PurchaseOrderHeaderInvoiceLineAllocationElementsInput>[];
        shipFromSupplierAddressLines?: Partial<PurchaseOrderShipFromSupplierAddressLinesInput>[];
        supplierStatisticalGroups?: Partial<PurchaseOrderSupplierStatisticalGroupsInput>[];
        salesOrderCategory?: OrderCategory;
        partialDelivery?: PartialDelivery;
    }
    export interface PurchaseOrderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        company: Company;
        purchaseSite: Site;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        orderDate: string;
        internalOrderReference: string;
        project: ProjectLink;
        orderFromSupplier: Supplier;
        orderFromSupplierAddress: SupplierAddress;
        orderFromSupplierAddressZipCode: string;
        orderFromSupplierAddressCity: string;
        orderFromSupplierAddressState: string;
        orderFromSupplierAddressCountry: Country;
        orderFromSupplierAddressCountryName: string;
        shipFromSupplierAddress: SupplierAddress;
        shipFromSupplierAddressZipCode: string;
        shipFromSupplierAddressCity: string;
        shipFromSupplierAddressState: string;
        shipFromSupplierAddressCountry: Country;
        shipFromSupplierAddressCountryName: string;
        invoiceSite: Site;
        receiptSite: Site;
        expectedReceiptDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        deliveryMode: DeliveryMode;
        carrier: Carrier;
        payToBusinessPartner: BusinessPartner;
        payToBusinessPartnerAddress: BusinessPartnerAddress;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        incoterm: Incoterm;
        incotermTown: string;
        groupingCode: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: SupplierAddress;
        intrastatTransportLocation: CountryLocation;
        europeanUnionIdentification: string;
        buyer: User;
        orderFromSupplierLanguage: Language;
        currency: Currency;
        currencyRateType: ExchangeRateType;
        currencyRate: string;
        taxRule: TaxRule;
        taxRuleType: integer;
        numberOfLines: integer;
        numberOfBudgetOverrunLines: integer;
        numberOfReceivedLines: integer;
        numberOfClosedLines: integer;
        numberOfInvoicedLines: integer;
        numberOfReceipts: integer;
        numberOfInvoices: integer;
        signatureStatus: NoInPartInFull;
        isClosed: boolean;
        receiptStatus: NoInPartInFull;
        invoicedStatus: NoInPartInFull;
        isPrinted: boolean;
        numberOfCopies: integer;
        acknowledgmentDate: string;
        acknowledgmentNumber: string;
        acknowledgmentNote: string;
        isPrintedAcknowledgmentReminder: boolean;
        mustSendDeliveryReminder: boolean;
        isIntercompany: boolean;
        isIntersite: boolean;
        purchaseSiteForIntersite: Site;
        shippingSite: Site;
        salesSite: Site;
        soldToCustomer: Customer;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        amountOfLinesIncludingTax: string;
        amountOfLinesExcludingTax: string;
        totalQuantityOfLines: string;
        totalWeightOfLines: string;
        totalVolumeOfLines: string;
        totalTaxAmount: string;
        totalAmountExcludingTax: string;
        totalAmountIncludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        expectedTotalAmountExcludingTax: string;
        serviceStartDate: string;
        serviceEndDate: string;
        container: Container;
        numberOfContainers: integer;
        maximumAmountExcludingTax: string;
        availableWeightOfContainer: string;
        availableVolumeOfContainer: string;
        purchaseOrderLines: ClientCollection<PurchaseOrderLine>;
        orderFooterText: TextStream;
        orderHeaderText: TextStream;
        companyNames: ClientCollection<PurchaseOrderCompanyNamesBinding>;
        dimensions: ClientCollection<PurchaseOrderDimensionsBinding>;
        discountOrChargeCalculationRules: ClientCollection<PurchaseOrderDiscountOrChargeCalculationRulesBinding>;
        fromSupplierAddressLines: ClientCollection<PurchaseOrderFromSupplierAddressLinesBinding>;
        fromSupplierCompanyNames: ClientCollection<PurchaseOrderFromSupplierCompanyNamesBinding>;
        headerInvoiceLineAllocationElements: ClientCollection<PurchaseOrderHeaderInvoiceLineAllocationElementsBinding>;
        shipFromSupplierAddressLines: ClientCollection<PurchaseOrderShipFromSupplierAddressLinesBinding>;
        supplierStatisticalGroups: ClientCollection<PurchaseOrderSupplierStatisticalGroupsBinding>;
        salesOrderCategory: OrderCategory;
        partialDelivery: PartialDelivery;
    }
    export interface PurchaseOrderLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseOrderLineTaxes>;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        salesOrderSequenceNumber: integer;
    }
    export interface PurchaseOrderLineInputExtension {
        purchaseOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        orderType?: PurchaseOrderType;
        revisionNumber?: integer | string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        buyer?: string;
        receiptSite?: string;
        receiptAddress?: string;
        project?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        countryOfOrigin?: string;
        hasQualityControlManagement?: boolean | string;
        receiptTax?: string;
        issueTax?: string;
        otherTax1?: string;
        otherTax2?: string;
        matchingTolerance?: string;
        acknowledgementDate?: string;
        acknowledgementNumber?: string;
        acknowledgementUpdate?: integer | string;
        actualPurchaseCostInCompanyCurrency?: decimal | string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        calculatedBasisForTax3?: decimal | string;
        calculatedTaxBasis1?: decimal | string;
        calculatedTaxBasis2?: decimal | string;
        calculationBasisForIssueTax?: decimal | string;
        calculationBasisForOtherTax1?: decimal | string;
        calculationBasisForOtherTax2?: decimal | string;
        calculationBasisForReceiptTax?: decimal | string;
        commitmentGenerated?: integer | string;
        commitmentType?: CommitmentType;
        companyCurrency?: string;
        costPriceWithoutLandedCost?: decimal | string;
        costStructure?: string;
        currency?: string;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        expectedReceiptDate?: string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        interCompanySalesOrderLineNumber?: integer | string;
        interCompanySalesOrderSequenceNumber?: integer | string;
        isBudgetOverrun?: boolean | string;
        isClosed?: boolean | string;
        isClosedByReceipt?: boolean | string;
        isInOrderUnit?: boolean | string;
        isInvoiced?: boolean | string;
        isPrinted?: boolean | string;
        issueTaxAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        landedCostCoefficient?: decimal | string;
        lastReceiptDate?: string;
        lastSalesInvoiceDate?: string;
        lineAmountIncludingTax?: decimal | string;
        lineAndSequenceIndex?: string;
        lineOrderAmountIncludingTax?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        lineStatus?: LineStatus;
        lineStockCostInCompanyCurrency?: decimal | string;
        lineType?: OrderLineType;
        linkCoefficientForSubcontract?: decimal | string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        numberOfInvoicedReceipts?: integer | string;
        numberOfInvoices?: integer | string;
        numberOfReceipts?: integer | string;
        orderDate?: string;
        orderFromSupplier?: string;
        orderLineText?: TextStream;
        orderUnit?: string;
        orderUnitToPurchaseUnitConversionFactor?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2Amount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        productType?: PurchasingProductType;
        purchaseCostInCompanyCurrency?: decimal | string;
        purchaseReceipt?: string;
        purchaseReceiptLine?: integer | string;
        purchaseSite?: string;
        purchaseType?: PurchaseType;
        purchaseUnit?: string;
        quantityInOrderUnitOrdered?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        quantityInPurchaseUnitOrdered?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInPurchaseUnitRequired?: decimal | string;
        quantityInPurchaseUnitShippedNotReceived?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitReceived?: decimal | string;
        quantityInStockUnitRequired?: decimal | string;
        quantityInStockUnitShippedNotReceived?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        releasedProduct?: string;
        reorderLeadTime?: decimal | string;
        requestForQuotation?: string;
        requestForQuotationResponseLineNumber?: integer | string;
        requestedDeliveryEndDate?: string;
        requestedDeliveryEndTime?: integer | string;
        requestedDeliveryStartDate?: string;
        requestedDeliveryStartTime?: integer | string;
        requirementDate?: string;
        shippingSite?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentNumber?: string;
        sourceDocumentSequenceNumber?: integer | string;
        sourceDocumentType?: EntryTypeEnum;
        sourceRequest?: RequestSource;
        stockCostInCompanyCurrency?: decimal | string;
        stockUnit?: string;
        subcontractAddress?: string;
        supplierProduct?: string;
        tax1BasisAmount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax1amount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax2amount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        tax3amount?: decimal | string;
        taxExcludedLineAmount?: decimal | string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        totalStockCostInCompanyCurrency?: decimal | string;
        volume?: decimal | string;
        volumeUnit?: string;
        weight?: decimal | string;
        weightUnit?: string;
        workInProgressOrderNumber?: string;
        workOrderInProgressStatus?: StatusInProgress;
        workOrderInProgressType?: WorkOrderType;
        productStatisticalGroups?: Partial<PurchaseOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseOrderLineTaxesInput>[];
        salesDelivery?: string;
        salesDeliveryLine?: integer | string;
        salesOrder?: string;
        salesOrderLine?: integer | string;
        salesOrderSequenceNumber?: integer | string;
    }
    export interface PurchaseOrderLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseOrder: PurchaseOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        orderType: PurchaseOrderType;
        revisionNumber: integer;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: PurchasePriceReason;
        discountOrCharge2Reason: PurchasePriceReason;
        discountOrCharge3Reason: PurchasePriceReason;
        discountOrCharge4Reason: PurchasePriceReason;
        discountOrCharge5Reason: PurchasePriceReason;
        discountOrCharge6Reason: PurchasePriceReason;
        discountOrCharge7Reason: PurchasePriceReason;
        discountOrCharge8Reason: PurchasePriceReason;
        discountOrCharge9Reason: PurchasePriceReason;
        netPrice: string;
        buyer: User;
        receiptSite: Site;
        receiptAddress: SiteAddress;
        project: ProjectLink;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        hasQualityControlManagement: boolean;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        matchingTolerance: MatchingTolerance;
        acknowledgementDate: string;
        acknowledgementNumber: string;
        acknowledgementUpdate: integer;
        actualPurchaseCostInCompanyCurrency: string;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        calculatedBasisForTax3: string;
        calculatedTaxBasis1: string;
        calculatedTaxBasis2: string;
        calculationBasisForIssueTax: string;
        calculationBasisForOtherTax1: string;
        calculationBasisForOtherTax2: string;
        calculationBasisForReceiptTax: string;
        commitmentGenerated: integer;
        commitmentType: CommitmentType;
        companyCurrency: Currency;
        costPriceWithoutLandedCost: string;
        costStructure: FreightCostStructure;
        currency: Currency;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        expectedReceiptDate: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        interCompanySalesOrderLineNumber: integer;
        interCompanySalesOrderSequenceNumber: integer;
        isBudgetOverrun: boolean;
        isClosed: boolean;
        isClosedByReceipt: boolean;
        isInOrderUnit: boolean;
        isInvoiced: boolean;
        isPrinted: boolean;
        issueTaxAmount: string;
        issueTaxDeductibleAmount: string;
        landedCostCoefficient: string;
        lastReceiptDate: string;
        lastSalesInvoiceDate: string;
        lineAmountIncludingTax: string;
        lineAndSequenceIndex: string;
        lineOrderAmountIncludingTax: string;
        linePurchaseCostInCompanyCurrency: string;
        lineStatus: LineStatus;
        lineStockCostInCompanyCurrency: string;
        lineType: OrderLineType;
        linkCoefficientForSubcontract: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        numberOfInvoicedReceipts: integer;
        numberOfInvoices: integer;
        numberOfReceipts: integer;
        orderDate: string;
        orderFromSupplier: Supplier;
        orderLineText: TextStream;
        orderUnit: UnitOfMeasure;
        orderUnitToPurchaseUnitConversionFactor: string;
        otherTax1Amount: string;
        otherTax1DeductibleAmount: string;
        otherTax2Amount: string;
        otherTax2DeductibleAmount: string;
        productType: PurchasingProductType;
        purchaseCostInCompanyCurrency: string;
        purchaseReceipt: PurchaseReceipt;
        purchaseReceiptLine: PurchaseReceiptLine;
        purchaseSite: Site;
        purchaseType: PurchaseType;
        purchaseUnit: UnitOfMeasure;
        quantityInOrderUnitOrdered: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInPurchaseUnitOrdered: string;
        quantityInPurchaseUnitReceived: string;
        quantityInPurchaseUnitRequired: string;
        quantityInPurchaseUnitShippedNotReceived: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitReceived: string;
        quantityInStockUnitRequired: string;
        quantityInStockUnitShippedNotReceived: string;
        rebateOnTax1Amount: string;
        receiptTaxAmount: string;
        receiptTaxDeductibleAmount: string;
        releasedProduct: Product;
        reorderLeadTime: string;
        requestForQuotation: string;
        requestForQuotationResponseLineNumber: integer;
        requestedDeliveryEndDate: string;
        requestedDeliveryEndTime: integer;
        requestedDeliveryStartDate: string;
        requestedDeliveryStartTime: integer;
        requirementDate: string;
        shippingSite: Site;
        sourceDocumentLineNumber: integer;
        sourceDocumentNumber: string;
        sourceDocumentSequenceNumber: integer;
        sourceDocumentType: EntryTypeEnum;
        sourceRequest: RequestSource;
        stockCostInCompanyCurrency: string;
        stockUnit: UnitOfMeasure;
        subcontractAddress: SupplierAddress;
        supplierProduct: SupplierProduct;
        tax1BasisAmount: string;
        tax1DeductibleAmount: string;
        tax1amount: string;
        tax2DeductibleAmount: string;
        tax2amount: string;
        tax3DeductibleAmount: string;
        tax3amount: string;
        taxExcludedLineAmount: string;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        volume: string;
        volumeUnit: UnitOfMeasure;
        weight: string;
        weightUnit: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workOrderInProgressStatus: StatusInProgress;
        workOrderInProgressType: WorkOrderType;
        productStatisticalGroups: ClientCollection<PurchaseOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseOrderLineTaxesBinding>;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        salesOrder: SalesOrder;
        salesOrderLine: SalesOrderLine;
        salesOrderSequenceNumber: integer;
    }
    export interface PurchaseOrderLineExtension$Lookups {
        salesDelivery: QueryOperation<SalesDelivery>;
        salesDeliveryLine: QueryOperation<SalesDeliveryLine>;
        salesOrder: QueryOperation<SalesOrder>;
        salesOrderLine: QueryOperation<SalesOrderLine>;
    }
    export interface PurchaseOrderLineExtension$Operations {
        lookups(dataOrId: string | { data: PurchaseOrderLineInput }): PurchaseOrderLineExtension$Lookups;
    }
    export interface PurchaseReceiptLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReceipt: PurchaseReceipt;
        lineNumber: integer;
        company: Company;
        receiptSite: Site;
        receiptDate: string;
        purchaseSite: Site;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderLine: PurchaseOrderLine;
        orderType: PurchaseOrderType;
        supplier: Supplier;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        project: ProjectLink;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountCharge1: string;
        discountCharge2: string;
        discountCharge3: string;
        discountCharge4: string;
        discountCharge5: string;
        discountCharge6: string;
        discountCharge7: string;
        discountCharge8: string;
        discountCharge9: string;
        discountCharge1Reason: PurchasePriceReason;
        discountCharge2Reason: PurchasePriceReason;
        discountCharge3Reason: PurchasePriceReason;
        discountCharge4Reason: PurchasePriceReason;
        discountCharge5Reason: PurchasePriceReason;
        discountCharge6Reason: PurchasePriceReason;
        discountCharge7Reason: PurchasePriceReason;
        discountCharge8Reason: PurchasePriceReason;
        discountCharge9Reason: PurchasePriceReason;
        netPrice: string;
        netPriceInPurchaseUnit: string;
        lineAmountExcludingTax: string;
        lineCostPriceInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        lineAmountIncludingTax: string;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculatedTaxableBase4: string;
        calculatedTaxableBase5: string;
        calculatedTaxableBase6: string;
        calculatedTaxableBase7: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1Amount: string;
        tax2Amount: string;
        tax3Amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        netPriceIncludingInvoicingElementInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        theoreticalStockCostInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costStructure: string;
        currency: Currency;
        companyCurrency: Currency;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        totalPostedStockCostInCompanyCurrency: string;
        quantityInReceiptUnitReceived: string;
        quantityInPurchaseUnitReceived: string;
        quantityInStockUnitReceived: string;
        weight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        volumeUnit: UnitOfMeasure;
        receiptUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        receiptUnitToPurchaseUnitConversionFactor: string;
        receiptUnitToStockUnitConversionFactor: string;
        quantityInPurchaseUnitRejected: string;
        quantityInStockUnitRejected: string;
        quantityInPurchaseUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        isPrinted: boolean;
        isInvoiced: boolean;
        isExtractedIntrastatLine: boolean;
        isPosted: boolean;
        reversalDate: string;
        qualityControlManagementMode: SubjectToControl;
        isControlledByQuality: boolean;
        purchaseType: PurchaseType;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        shipFromCountry: Country;
        issueState: MiscellaneousTable;
        stockMovementGroup: MiscellaneousTable;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        shippingSite: Site;
        releasedProduct: Product;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        productStockManagement: StockManagement;
        billableIntercompanyStatus: integer;
        lineType: OrderLineType;
        movementCategory: MovementCategory;
        linkCoefficientForSubcontract: string;
        warehouse: Warehouse;
        matchingTolerance: MatchingTolerance;
        postedSubcontractCost: string;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        productType: PurchasingProductType;
        stockDetails: ClientCollection<StockJournal>;
        receiptLineText: TextStream;
        productStatisticalGroups: ClientCollection<PurchaseReceiptLineProductStatisticalGroups>;
        taxes: ClientCollection<PurchaseReceiptLineTaxes>;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
    }
    export interface PurchaseReceiptLineInputExtension {
        purchaseReceipt?: string;
        lineNumber?: integer | string;
        company?: string;
        receiptSite?: string;
        receiptDate?: string;
        purchaseSite?: string;
        purchaseOrder?: string;
        purchaseOrderLineNumber?: integer | string;
        purchaseOrderLine?: integer | string;
        orderType?: PurchaseOrderType;
        supplier?: string;
        billBySupplier?: string;
        billBySupplierAddress?: string;
        project?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInSupplierLanguage?: string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        discountCharge1?: decimal | string;
        discountCharge2?: decimal | string;
        discountCharge3?: decimal | string;
        discountCharge4?: decimal | string;
        discountCharge5?: decimal | string;
        discountCharge6?: decimal | string;
        discountCharge7?: decimal | string;
        discountCharge8?: decimal | string;
        discountCharge9?: decimal | string;
        discountCharge1Reason?: integer | string;
        discountCharge2Reason?: integer | string;
        discountCharge3Reason?: integer | string;
        discountCharge4Reason?: integer | string;
        discountCharge5Reason?: integer | string;
        discountCharge6Reason?: integer | string;
        discountCharge7Reason?: integer | string;
        discountCharge8Reason?: integer | string;
        discountCharge9Reason?: integer | string;
        netPrice?: decimal | string;
        netPriceInPurchaseUnit?: decimal | string;
        lineAmountExcludingTax?: decimal | string;
        lineCostPriceInCompanyCurrency?: decimal | string;
        linePurchaseCostInCompanyCurrency?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        distributedInvoicingElement1AmountExcludingTax?: decimal | string;
        distributedInvoicingElement2AmountExcludingTax?: decimal | string;
        distributedInvoicingElement3AmountExcludingTax?: decimal | string;
        distributedInvoicingElement4AmountExcludingTax?: decimal | string;
        distributedInvoicingElement5AmountExcludingTax?: decimal | string;
        distributedInvoicingElement6AmountExcludingTax?: decimal | string;
        distributedInvoicingElement7AmountExcludingTax?: decimal | string;
        distributedInvoicingElement8AmountExcludingTax?: decimal | string;
        distributedInvoicingElement9AmountExcludingTax?: decimal | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        calculatedTaxableBase3?: decimal | string;
        calculatedTaxableBase4?: decimal | string;
        calculatedTaxableBase5?: decimal | string;
        calculatedTaxableBase6?: decimal | string;
        calculatedTaxableBase7?: decimal | string;
        rebateOnTax1Amount?: decimal | string;
        taxableBase1Amount?: decimal | string;
        tax1Amount?: decimal | string;
        tax2Amount?: decimal | string;
        tax3Amount?: decimal | string;
        receiptTaxAmount?: decimal | string;
        issueTaxAmount?: decimal | string;
        otherTax1Amount?: decimal | string;
        otherTax2Amount?: decimal | string;
        tax1DeductibleAmount?: decimal | string;
        tax2DeductibleAmount?: decimal | string;
        tax3DeductibleAmount?: decimal | string;
        receiptTaxDeductibleAmount?: decimal | string;
        issueTaxDeductibleAmount?: decimal | string;
        otherTax1DeductibleAmount?: decimal | string;
        otherTax2DeductibleAmount?: decimal | string;
        netPriceIncludingInvoicingElementInCompanyCurrency?: decimal | string;
        costPriceInCompanyCurrency?: decimal | string;
        theoreticalStockCostInCompanyCurrency?: decimal | string;
        purchaseCostInCompanyCurrency?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnitInCompanyCurrency?: decimal | string;
        costStructure?: string;
        currency?: string;
        companyCurrency?: string;
        totalPurchaseCostInCompanyCurrency?: decimal | string;
        totalStockCostInCompanyCurrency?: decimal | string;
        totalPostedStockCostInCompanyCurrency?: decimal | string;
        quantityInReceiptUnitReceived?: decimal | string;
        quantityInPurchaseUnitReceived?: decimal | string;
        quantityInStockUnitReceived?: decimal | string;
        weight?: decimal | string;
        weightUnit?: string;
        volume?: decimal | string;
        volumeUnit?: string;
        receiptUnit?: string;
        purchaseUnit?: string;
        stockUnit?: string;
        receiptUnitToPurchaseUnitConversionFactor?: decimal | string;
        receiptUnitToStockUnitConversionFactor?: decimal | string;
        quantityInPurchaseUnitRejected?: decimal | string;
        quantityInStockUnitRejected?: decimal | string;
        quantityInPurchaseUnitReturned?: decimal | string;
        quantityInStockUnitReturned?: decimal | string;
        quantityInPurchaseUnitInvoiced?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        isPrinted?: boolean | string;
        isInvoiced?: boolean | string;
        isExtractedIntrastatLine?: boolean | string;
        isPosted?: boolean | string;
        reversalDate?: string;
        qualityControlManagementMode?: SubjectToControl;
        isControlledByQuality?: boolean | string;
        purchaseType?: PurchaseType;
        intrastatIncreaseCoefficient?: decimal | string;
        countryOfOrigin?: string;
        shipFromCountry?: string;
        issueState?: string;
        stockMovementGroup?: string;
        receiptTax?: string;
        issueTax?: string;
        otherTax1?: string;
        otherTax2?: string;
        shippingSite?: string;
        releasedProduct?: string;
        sourceDocumentType?: EntryTypeEnum;
        sourceDocument?: string;
        sourceDocumentLineNumber?: integer | string;
        sourceDocumentSequenceNumber?: integer | string;
        productStockManagement?: StockManagement;
        billableIntercompanyStatus?: integer | string;
        lineType?: OrderLineType;
        movementCategory?: MovementCategory;
        linkCoefficientForSubcontract?: decimal | string;
        warehouse?: string;
        matchingTolerance?: string;
        postedSubcontractCost?: decimal | string;
        purchaseShipment?: string;
        purchaseShipmentLine?: integer | string;
        productType?: PurchasingProductType;
        stockDetails?: Partial<StockJournalInput>[];
        receiptLineText?: TextStream;
        balance?: string;
        container?: string;
        productStatisticalGroups?: Partial<PurchaseReceiptLineProductStatisticalGroupsInput>[];
        taxes?: Partial<PurchaseReceiptLineTaxesInput>[];
        salesDelivery?: string;
        salesDeliveryLine?: integer | string;
    }
    export interface PurchaseReceiptLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        purchaseReceipt: PurchaseReceipt;
        lineNumber: integer;
        company: Company;
        receiptSite: Site;
        receiptDate: string;
        purchaseSite: Site;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLineNumber: integer;
        purchaseOrderLine: PurchaseOrderLine;
        orderType: PurchaseOrderType;
        supplier: Supplier;
        billBySupplier: Supplier;
        billBySupplierAddress: SupplierAddress;
        project: ProjectLink;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInSupplierLanguage: string;
        grossPrice: string;
        priceReason: PurchasePriceReason;
        discountCharge1: string;
        discountCharge2: string;
        discountCharge3: string;
        discountCharge4: string;
        discountCharge5: string;
        discountCharge6: string;
        discountCharge7: string;
        discountCharge8: string;
        discountCharge9: string;
        discountCharge1Reason: PurchasePriceReason;
        discountCharge2Reason: PurchasePriceReason;
        discountCharge3Reason: PurchasePriceReason;
        discountCharge4Reason: PurchasePriceReason;
        discountCharge5Reason: PurchasePriceReason;
        discountCharge6Reason: PurchasePriceReason;
        discountCharge7Reason: PurchasePriceReason;
        discountCharge8Reason: PurchasePriceReason;
        discountCharge9Reason: PurchasePriceReason;
        netPrice: string;
        netPriceInPurchaseUnit: string;
        lineAmountExcludingTax: string;
        lineCostPriceInCompanyCurrency: string;
        linePurchaseCostInCompanyCurrency: string;
        lineAmountIncludingTax: string;
        distributedInvoicingElement1AmountExcludingTax: string;
        distributedInvoicingElement2AmountExcludingTax: string;
        distributedInvoicingElement3AmountExcludingTax: string;
        distributedInvoicingElement4AmountExcludingTax: string;
        distributedInvoicingElement5AmountExcludingTax: string;
        distributedInvoicingElement6AmountExcludingTax: string;
        distributedInvoicingElement7AmountExcludingTax: string;
        distributedInvoicingElement8AmountExcludingTax: string;
        distributedInvoicingElement9AmountExcludingTax: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        calculatedTaxableBase3: string;
        calculatedTaxableBase4: string;
        calculatedTaxableBase5: string;
        calculatedTaxableBase6: string;
        calculatedTaxableBase7: string;
        rebateOnTax1Amount: string;
        taxableBase1Amount: string;
        tax1Amount: string;
        tax2Amount: string;
        tax3Amount: string;
        receiptTaxAmount: string;
        issueTaxAmount: string;
        otherTax1Amount: string;
        otherTax2Amount: string;
        tax1DeductibleAmount: string;
        tax2DeductibleAmount: string;
        tax3DeductibleAmount: string;
        receiptTaxDeductibleAmount: string;
        issueTaxDeductibleAmount: string;
        otherTax1DeductibleAmount: string;
        otherTax2DeductibleAmount: string;
        netPriceIncludingInvoicingElementInCompanyCurrency: string;
        costPriceInCompanyCurrency: string;
        theoreticalStockCostInCompanyCurrency: string;
        purchaseCostInCompanyCurrency: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnitInCompanyCurrency: string;
        costStructure: string;
        currency: Currency;
        companyCurrency: Currency;
        totalPurchaseCostInCompanyCurrency: string;
        totalStockCostInCompanyCurrency: string;
        totalPostedStockCostInCompanyCurrency: string;
        quantityInReceiptUnitReceived: string;
        quantityInPurchaseUnitReceived: string;
        quantityInStockUnitReceived: string;
        weight: string;
        weightUnit: UnitOfMeasure;
        volume: string;
        volumeUnit: UnitOfMeasure;
        receiptUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        receiptUnitToPurchaseUnitConversionFactor: string;
        receiptUnitToStockUnitConversionFactor: string;
        quantityInPurchaseUnitRejected: string;
        quantityInStockUnitRejected: string;
        quantityInPurchaseUnitReturned: string;
        quantityInStockUnitReturned: string;
        quantityInPurchaseUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        isPrinted: boolean;
        isInvoiced: boolean;
        isExtractedIntrastatLine: boolean;
        isPosted: boolean;
        reversalDate: string;
        qualityControlManagementMode: SubjectToControl;
        isControlledByQuality: boolean;
        purchaseType: PurchaseType;
        intrastatIncreaseCoefficient: string;
        countryOfOrigin: Country;
        shipFromCountry: Country;
        issueState: MiscellaneousTable;
        stockMovementGroup: MiscellaneousTable;
        receiptTax: Tax;
        issueTax: Tax;
        otherTax1: Tax;
        otherTax2: Tax;
        shippingSite: Site;
        releasedProduct: Product;
        sourceDocumentType: EntryTypeEnum;
        sourceDocument: string;
        sourceDocumentLineNumber: integer;
        sourceDocumentSequenceNumber: integer;
        productStockManagement: StockManagement;
        billableIntercompanyStatus: integer;
        lineType: OrderLineType;
        movementCategory: MovementCategory;
        linkCoefficientForSubcontract: string;
        warehouse: Warehouse;
        matchingTolerance: MatchingTolerance;
        postedSubcontractCost: string;
        purchaseShipment: PurchaseShipment;
        purchaseShipmentLine: PurchaseShipmentLine;
        productType: PurchasingProductType;
        stockDetails: ClientCollection<StockJournal>;
        receiptLineText: TextStream;
        balance: string;
        container: string;
        productStatisticalGroups: ClientCollection<PurchaseReceiptLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<PurchaseReceiptLineTaxesBinding>;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
    }
    export interface PurchaseReceiptLineExtension$Lookups {
        salesDelivery: QueryOperation<SalesDelivery>;
        salesDeliveryLine: QueryOperation<SalesDeliveryLine>;
    }
    export interface PurchaseReceiptLineExtension$Operations {
        lookups(dataOrId: string | { data: PurchaseReceiptLineInput }): PurchaseReceiptLineExtension$Lookups;
    }
    export interface SalesInvoiceExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: CustomerInvoiceHeader;
        company: Company;
        salesSite: Site;
        shippingSite: Site;
        billToCustomer: Customer;
        soldToCustomer: Customer;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        payByBusinessPartner: BusinessPartner;
        factor: Factor;
        invoiceType: SalesInvoiceType;
        category: InvoiceType;
        sourceDocumentCategory: SalesInvoiceSource;
        sourceDocumentNumber: string;
        sourceDocumentDate: string;
        invoiceDate: string;
        currency: Currency;
        status: InvoiceStatus;
        isOnCreditMemo: boolean;
        hasStockTransaction: boolean;
        internalReference: string;
        project: ProjectLink;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        creditMemoReason: MiscellaneousTable;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        billToCustomerLanguage: Language;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        numberOfLines: integer;
        numberOfInvoiceCopies: integer;
        numberOfCreditMemoCopies: integer;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatAdjustmentTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatAdjustmentStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        marketingCampaign: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isPrinted: boolean;
        isValidatedAddress: boolean;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        sourceDocumentType: SalesDocumentType;
        finalSequenceNumber: SalesInvoice;
        hasElectronicSignature: boolean;
        salesInvoiceLines: ClientCollection<SalesInvoiceLine>;
        customerInvoiceHeader: CustomerInvoiceHeader;
        accountingDate: string;
        billToCustomerAddress: CustomerAddress;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCity: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerPostalCode: string;
        billToCustomerState: string;
        businessProcessType: MiscellaneousTable;
        cancellationStatus: integer;
        cashVatTaxRule: boolean;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        control: string;
        correctionMethod: CorrectionMethod;
        creditMemoReferenceEndDate: string;
        creditMemoReferenceStartDate: string;
        currencyRates: ClientCollection<CustomerInvoiceHeaderCurrencyRates>;
        customerSourceDocument: string;
        customerSourceDocumentDate: string;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<CustomerInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entityUserCode: MiscellaneousTable;
        entryType: EntryType;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        inPaymentSlipWithReferenceNumber: string;
        internalNumber: integer;
        intrastatProcessingNumber: integer;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDirectInvoice: boolean;
        isExternalDocument: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        mandate: Mandate;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerState: string;
        paymentBank: BankAccount;
        paymentTerm: PaymentTerm;
        period: integer;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        siteIdentificationNumber: string;
        sourceModule: ModuleTable;
        spanishInvoiceType: SpanishInvoiceType;
        stockMovementGroup: MiscellaneousTable;
        taxReferenceDate: string;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        vatDeclarationNumber: string;
        versionControlSystemNumber: string;
        warehouse: Warehouse;
        billToCustomerCompanyNames: ClientCollection<SalesInvoiceBillToCustomerCompanyNames>;
        customerStatisticalGroups: ClientCollection<SalesInvoiceCustomerStatisticalGroups>;
        discountOrChargeCalculationRules: ClientCollection<SalesInvoiceDiscountOrChargeCalculationRules>;
        invoicingElements: ClientCollection<SalesInvoiceInvoicingElements>;
        salesOrderOfPrepayments: ClientCollection<SalesInvoiceSalesOrderOfPrepayments>;
        salesReps: ClientCollection<SalesInvoiceSalesReps>;
        shipToCustomerAddressLines: ClientCollection<SalesInvoiceShipToCustomerAddressLines>;
        shipToCustomerCompanyNames: ClientCollection<SalesInvoiceShipToCustomerCompanyNames>;
        purchaseInvoice: PurchaseInvoice;
    }
    export interface SalesInvoiceInputExtension {
        id?: string;
        company?: string;
        salesSite?: string;
        shippingSite?: string;
        billToCustomer?: string;
        soldToCustomer?: string;
        groupCustomer?: string;
        shipToCustomerAddress?: string;
        billToCustomerEuropeanUnionVatNumber?: string;
        billToCustomerContact?: string;
        shipToCustomerPostalCode?: string;
        shipToCustomerCity?: string;
        shipToCustomerState?: string;
        shipToCustomerCountry?: string;
        shipToCustomerCountryName?: string;
        shipToCustomerContact?: string;
        payByBusinessPartner?: string;
        factor?: string;
        invoiceType?: string;
        category?: InvoiceType;
        sourceDocumentCategory?: SalesInvoiceSource;
        sourceDocumentNumber?: string;
        sourceDocumentDate?: string;
        invoiceDate?: string;
        currency?: string;
        status?: InvoiceStatus;
        isOnCreditMemo?: boolean | string;
        hasStockTransaction?: boolean | string;
        internalReference?: string;
        project?: string;
        priceIncludingOrExcludingTax?: PriceAmountTaxTax;
        creditMemoReason?: string;
        earlyDiscountOrLateCharge?: string;
        billToCustomerLanguage?: string;
        isIntersite?: boolean | string;
        isIntercompany?: boolean | string;
        sourceSite?: string;
        numberOfLines?: integer | string;
        numberOfInvoiceCopies?: integer | string;
        numberOfCreditMemoCopies?: integer | string;
        stockMovementCode?: string;
        stockAutomaticJournal?: string;
        dockLocation?: string;
        intrastatTransactionNature?: string;
        intrastatAdjustmentTransactionNature?: string;
        intrastatStatisticalRule?: string;
        intrastatAdjustmentStatisticalRule?: string;
        intrastatTransportLocation?: CountryLocation;
        intrastatTransportMode?: IntrastatTransportMode;
        incoterm?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        marketingCampaign?: string;
        priceStructure?: string;
        totalQuantityDistributedOnLines?: decimal | string;
        totalWeightDistributedOnLines?: decimal | string;
        totalVolumeDistributedOnLines?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        isPrinted?: boolean | string;
        isValidatedAddress?: boolean | string;
        departureDate?: string;
        arrivalDate?: string;
        departureTime?: string;
        arrivalTime?: string;
        vehicleLicensePlate?: string;
        trailerLicensePlate?: string;
        sourceDocumentType?: SalesDocumentType;
        finalSequenceNumber?: string;
        hasElectronicSignature?: boolean | string;
        salesInvoiceLines?: Partial<SalesInvoiceLineInput>[];
        customerInvoiceHeader?: string;
        accountingDate?: string;
        billToCustomerAddress?: string;
        billToCustomerAddressLines?: Partial<CustomerInvoiceHeaderBillToCustomerAddressLinesInput>[];
        billToCustomerCity?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        billToCustomerPostalCode?: string;
        billToCustomerState?: string;
        businessProcessType?: string;
        cancellationStatus?: integer | string;
        cashVatTaxRule?: boolean | string;
        comments?: Partial<CustomerInvoiceHeaderCommentsInput>[];
        control?: string;
        correctionMethod?: CorrectionMethod;
        creditMemoReferenceEndDate?: string;
        creditMemoReferenceStartDate?: string;
        currencyRates?: Partial<CustomerInvoiceHeaderCurrencyRatesInput>[];
        customerSourceDocument?: string;
        customerSourceDocumentDate?: string;
        debitOrCredit?: integer | string;
        derCode?: string;
        dimensions?: Partial<CustomerInvoiceHeaderDimensionsInput>[];
        dueDateCalculationStartDate?: string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        entityUserCode?: string;
        entryType?: string;
        field40Reason?: string;
        field41Reason?: string;
        fiscalYear?: integer | string;
        inPaymentSlipWithReferenceNumber?: string;
        internalNumber?: integer | string;
        intrastatProcessingNumber?: integer | string;
        invoiceFooterText?: TextStream;
        invoiceHeaderText?: TextStream;
        isDirectInvoice?: boolean | string;
        isExternalDocument?: boolean | string;
        journal?: string;
        lastServiceAccountedDate?: string;
        mandate?: string;
        numberOfTaxes?: integer | string;
        originalDocumentNumber?: string;
        originalInvoiceNumber?: string;
        payByBusinessPartnerAddress?: string;
        payByBusinessPartnerAddressLines?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput>[];
        payByBusinessPartnerCity?: string;
        payByBusinessPartnerCompanyNames?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput>[];
        payByBusinessPartnerCountry?: string;
        payByBusinessPartnerCountryName?: string;
        payByBusinessPartnerPostalCode?: string;
        payByBusinessPartnerState?: string;
        paymentBank?: string;
        paymentTerm?: string;
        period?: integer | string;
        rateDate?: string;
        rateType?: ExchangeRateType;
        serviceEndDate?: string;
        serviceStartDate?: string;
        siteIdentificationNumber?: string;
        sourceModule?: ModuleTable;
        spanishInvoiceType?: SpanishInvoiceType;
        stockMovementGroup?: string;
        taxReferenceDate?: string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        vatDeclarationNumber?: string;
        versionControlSystemNumber?: string;
        warehouse?: string;
        billToCustomerCompanyNames?: Partial<SalesInvoiceBillToCustomerCompanyNamesInput>[];
        customerStatisticalGroups?: Partial<SalesInvoiceCustomerStatisticalGroupsInput>[];
        discountOrChargeCalculationRules?: Partial<SalesInvoiceDiscountOrChargeCalculationRulesInput>[];
        invoicingElements?: Partial<SalesInvoiceInvoicingElementsInput>[];
        salesOrderOfPrepayments?: Partial<SalesInvoiceSalesOrderOfPrepaymentsInput>[];
        salesReps?: Partial<SalesInvoiceSalesRepsInput>[];
        shipToCustomerAddressLines?: Partial<SalesInvoiceShipToCustomerAddressLinesInput>[];
        shipToCustomerCompanyNames?: Partial<SalesInvoiceShipToCustomerCompanyNamesInput>[];
        purchaseInvoice?: string;
    }
    export interface SalesInvoiceBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: CustomerInvoiceHeader;
        company: Company;
        salesSite: Site;
        shippingSite: Site;
        billToCustomer: Customer;
        soldToCustomer: Customer;
        groupCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        billToCustomerEuropeanUnionVatNumber: string;
        billToCustomerContact: CustomerContact;
        shipToCustomerPostalCode: string;
        shipToCustomerCity: string;
        shipToCustomerState: string;
        shipToCustomerCountry: Country;
        shipToCustomerCountryName: string;
        shipToCustomerContact: CustomerContact;
        payByBusinessPartner: BusinessPartner;
        factor: Factor;
        invoiceType: SalesInvoiceType;
        category: InvoiceType;
        sourceDocumentCategory: SalesInvoiceSource;
        sourceDocumentNumber: string;
        sourceDocumentDate: string;
        invoiceDate: string;
        currency: Currency;
        status: InvoiceStatus;
        isOnCreditMemo: boolean;
        hasStockTransaction: boolean;
        internalReference: string;
        project: ProjectLink;
        priceIncludingOrExcludingTax: PriceAmountTaxTax;
        creditMemoReason: MiscellaneousTable;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        billToCustomerLanguage: Language;
        isIntersite: boolean;
        isIntercompany: boolean;
        sourceSite: Site;
        numberOfLines: integer;
        numberOfInvoiceCopies: integer;
        numberOfCreditMemoCopies: integer;
        stockMovementCode: MiscellaneousTable;
        stockAutomaticJournal: AutomaticJournal;
        dockLocation: Location;
        intrastatTransactionNature: IntrastatTransactionNature;
        intrastatAdjustmentTransactionNature: IntrastatTransactionNature;
        intrastatStatisticalRule: IntrastatStatisticalRule;
        intrastatAdjustmentStatisticalRule: IntrastatStatisticalRule;
        intrastatTransportLocation: CountryLocation;
        intrastatTransportMode: IntrastatTransportMode;
        incoterm: Incoterm;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: CustomerAddress;
        geographicCode: string;
        insideCityLimits: string;
        marketingCampaign: string;
        priceStructure: PriceStructure;
        totalQuantityDistributedOnLines: string;
        totalWeightDistributedOnLines: string;
        totalVolumeDistributedOnLines: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        isPrinted: boolean;
        isValidatedAddress: boolean;
        departureDate: string;
        arrivalDate: string;
        departureTime: string;
        arrivalTime: string;
        vehicleLicensePlate: string;
        trailerLicensePlate: string;
        sourceDocumentType: SalesDocumentType;
        finalSequenceNumber: SalesInvoice;
        hasElectronicSignature: boolean;
        salesInvoiceLines: ClientCollection<SalesInvoiceLine>;
        customerInvoiceHeader: CustomerInvoiceHeader;
        accountingDate: string;
        billToCustomerAddress: CustomerAddress;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCity: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        billToCustomerPostalCode: string;
        billToCustomerState: string;
        businessProcessType: MiscellaneousTable;
        cancellationStatus: integer;
        cashVatTaxRule: boolean;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        control: string;
        correctionMethod: CorrectionMethod;
        creditMemoReferenceEndDate: string;
        creditMemoReferenceStartDate: string;
        currencyRates: ClientCollection<CustomerInvoiceHeaderCurrencyRates>;
        customerSourceDocument: string;
        customerSourceDocumentDate: string;
        debitOrCredit: integer;
        derCode: string;
        dimensions: ClientCollection<CustomerInvoiceHeaderDimensions>;
        dueDateCalculationStartDate: string;
        earlyDiscountOrLateChargeBasis: string;
        earlyDiscountOrLateChargeRate: string;
        entityUserCode: MiscellaneousTable;
        entryType: EntryType;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        fiscalYear: integer;
        inPaymentSlipWithReferenceNumber: string;
        internalNumber: integer;
        intrastatProcessingNumber: integer;
        invoiceFooterText: TextStream;
        invoiceHeaderText: TextStream;
        isDirectInvoice: boolean;
        isExternalDocument: boolean;
        journal: Journal;
        lastServiceAccountedDate: string;
        mandate: Mandate;
        numberOfTaxes: integer;
        originalDocumentNumber: string;
        originalInvoiceNumber: string;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerState: string;
        paymentBank: BankAccount;
        paymentTerm: PaymentTerm;
        period: integer;
        rateDate: string;
        rateType: ExchangeRateType;
        serviceEndDate: string;
        serviceStartDate: string;
        siteIdentificationNumber: string;
        sourceModule: ModuleTable;
        spanishInvoiceType: SpanishInvoiceType;
        stockMovementGroup: MiscellaneousTable;
        taxReferenceDate: string;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTax: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        vatDeclarationNumber: string;
        versionControlSystemNumber: string;
        warehouse: Warehouse;
        billToCustomerCompanyNames: ClientCollection<SalesInvoiceBillToCustomerCompanyNamesBinding>;
        customerStatisticalGroups: ClientCollection<SalesInvoiceCustomerStatisticalGroupsBinding>;
        discountOrChargeCalculationRules: ClientCollection<SalesInvoiceDiscountOrChargeCalculationRulesBinding>;
        invoicingElements: ClientCollection<SalesInvoiceInvoicingElementsBinding>;
        salesOrderOfPrepayments: ClientCollection<SalesInvoiceSalesOrderOfPrepaymentsBinding>;
        salesReps: ClientCollection<SalesInvoiceSalesRepsBinding>;
        shipToCustomerAddressLines: ClientCollection<SalesInvoiceShipToCustomerAddressLinesBinding>;
        shipToCustomerCompanyNames: ClientCollection<SalesInvoiceShipToCustomerCompanyNamesBinding>;
        purchaseInvoice: PurchaseInvoice;
    }
    export interface SalesInvoiceExtension$Lookups {
        purchaseInvoice: QueryOperation<PurchaseInvoice>;
    }
    export interface SalesInvoiceExtension$Operations {
        lookups(dataOrId: string | { data: SalesInvoiceInput }): SalesInvoiceExtension$Lookups;
    }
    export interface SalesInvoiceLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElements>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroups>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmounts>;
        taxes: ClientCollection<SalesInvoiceLineTaxes>;
        purchaseInvoiceLineNumber: integer;
    }
    export interface SalesInvoiceLineInputExtension {
        salesInvoice?: string;
        lineNumber?: integer | string;
        company?: string;
        salesOrderNumber?: string;
        salesOrderLineNumber?: integer | string;
        salesOrderLine?: integer | string;
        salesDelivery?: string;
        salesDeliveryLine?: integer | string;
        sourceSalesInvoice?: string;
        sourceSalesInvoiceLine?: integer | string;
        salesReturn?: string;
        salesReturnLine?: integer | string;
        billToCustomer?: string;
        product?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRep1CommissionBase?: decimal | string;
        salesRep2CommissionBase?: decimal | string;
        salesRep1CommissionAmount?: decimal | string;
        salesRep2CommissionAmount?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        lineAmountEnteredManually?: decimal | string;
        lineAmountExcludingTax?: decimal | string;
        discountLineAmount?: decimal | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        taxRate?: decimal | string;
        lineAmountIncludingTax?: decimal | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        shippingSite?: string;
        productStockManagement?: StockManagement;
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        preferentialStockLocationFilter?: string;
        stockPriceInCreditMemoWithStockMovement?: decimal | string;
        allocationType?: TypeOfAllocation;
        salesSite?: string;
        invoiceDate?: string;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        isExtractedIntrastatLine?: boolean | string;
        isIntrastatPhysicalFlow?: boolean | string;
        geographicCode?: string;
        insideCityLimits?: string;
        isTaxedGeographically?: string;
        isTaxable?: boolean | string;
        isRecordedTax?: boolean | string;
        isPrintedOnInvoice?: boolean | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        servicePeriodNumber?: integer | string;
        servicePeriodType?: PeriodicityType;
        tokenManagement?: decimal | string;
        weightDistributedOnLine?: decimal | string;
        volumeDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        volumeUnitForDistributionOnLines?: string;
        warehouse?: string;
        project?: string;
        importLineNumber?: integer | string;
        sourceDocumentType?: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice?: decimal | string;
        scheduledInvoiceLineNumber?: integer | string;
        scheduledinvoiceSource?: SalesDocumentType;
        invoiceLineText?: TextStream;
        distributedInvoicingElements?: Partial<SalesInvoiceLineDistributedInvoicingElementsInput>[];
        productStatisticalGroups?: Partial<SalesInvoiceLineProductStatisticalGroupsInput>[];
        taxBasisAmounts?: Partial<SalesInvoiceLineTaxBasisAmountsInput>[];
        taxes?: Partial<SalesInvoiceLineTaxesInput>[];
        purchaseInvoiceLineNumber?: integer | string;
    }
    export interface SalesInvoiceLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesInvoice: SalesInvoice;
        lineNumber: integer;
        company: Company;
        salesOrderNumber: SalesOrder;
        salesOrderLineNumber: integer;
        salesOrderLine: SalesOrderLine;
        salesDelivery: SalesDelivery;
        salesDeliveryLine: SalesDeliveryLine;
        sourceSalesInvoice: SalesInvoice;
        sourceSalesInvoiceLine: SalesInvoiceLine;
        salesReturn: SalesReturn;
        salesReturnLine: SalesReturnLine;
        billToCustomer: Customer;
        product: Product;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRep1CommissionBase: string;
        salesRep2CommissionBase: string;
        salesRep1CommissionAmount: string;
        salesRep2CommissionAmount: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        lineAmountEnteredManually: string;
        lineAmountExcludingTax: string;
        discountLineAmount: string;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        taxRate: string;
        lineAmountIncludingTax: string;
        isLineWithDistributedInvoicingElement: boolean;
        quantityInSalesUnitInvoiced: string;
        quantityInStockUnitInvoiced: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        shippingSite: Site;
        productStockManagement: StockManagement;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        preferentialStockLocationFilter: Location;
        stockPriceInCreditMemoWithStockMovement: string;
        allocationType: TypeOfAllocation;
        salesSite: Site;
        invoiceDate: string;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesInvoiceLine;
        isExtractedIntrastatLine: boolean;
        isIntrastatPhysicalFlow: boolean;
        geographicCode: string;
        insideCityLimits: string;
        isTaxedGeographically: string;
        isTaxable: boolean;
        isRecordedTax: boolean;
        isPrintedOnInvoice: boolean;
        serviceStartDate: string;
        serviceEndDate: string;
        servicePeriodNumber: integer;
        servicePeriodType: PeriodicityType;
        tokenManagement: string;
        weightDistributedOnLine: string;
        volumeDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        warehouse: Warehouse;
        project: ProjectLink;
        importLineNumber: integer;
        sourceDocumentType: SalesInvoiceSource;
        invoicePercentageForScheduledInvoice: string;
        scheduledInvoiceLineNumber: integer;
        scheduledinvoiceSource: SalesDocumentType;
        invoiceLineText: TextStream;
        distributedInvoicingElements: ClientCollection<SalesInvoiceLineDistributedInvoicingElementsBinding>;
        productStatisticalGroups: ClientCollection<SalesInvoiceLineProductStatisticalGroupsBinding>;
        taxBasisAmounts: ClientCollection<SalesInvoiceLineTaxBasisAmountsBinding>;
        taxes: ClientCollection<SalesInvoiceLineTaxesBinding>;
        purchaseInvoiceLineNumber: integer;
    }
    export interface SalesOrderLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroups>;
        taxes: ClientCollection<SalesOrderLineTaxes>;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
    }
    export interface SalesOrderLineInputExtension {
        salesOrder?: string;
        lineNumber?: integer | string;
        sequenceNumber?: integer | string;
        company?: string;
        category?: OrderCategory;
        soldToCustomer?: string;
        shipToCustomerAddress?: string;
        shipToCustomerContact?: string;
        billToCustomer?: string;
        shippingSite?: string;
        salesSite?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        customerProduct?: string;
        salesRep1?: string;
        salesRep2?: string;
        salesRep1CommissionRate?: decimal | string;
        salesRep2CommissionRate?: decimal | string;
        salesRepCommissionFactor?: decimal | string;
        grossPrice?: decimal | string;
        priceReason?: integer | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        margin?: decimal | string;
        costPrice?: decimal | string;
        discountOrCharge1?: decimal | string;
        discountOrCharge2?: decimal | string;
        discountOrCharge3?: decimal | string;
        discountOrCharge4?: decimal | string;
        discountOrCharge5?: decimal | string;
        discountOrCharge6?: decimal | string;
        discountOrCharge7?: decimal | string;
        discountOrCharge8?: decimal | string;
        discountOrCharge9?: decimal | string;
        discountOrCharge1Reason?: integer | string;
        discountOrCharge2Reason?: integer | string;
        discountOrCharge3Reason?: integer | string;
        discountOrCharge4Reason?: integer | string;
        discountOrCharge5Reason?: integer | string;
        discountOrCharge6Reason?: integer | string;
        discountOrCharge7Reason?: integer | string;
        discountOrCharge8Reason?: integer | string;
        discountOrCharge9Reason?: integer | string;
        calculatedTaxableBase1?: decimal | string;
        calculatedTaxableBase2?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        lineStatus?: LineStatus;
        lineType?: LineType;
        freeProduct?: Free;
        freeProductLineSource?: integer | string;
        salesQuote?: string;
        salesQuoteLineNumber?: integer | string;
        lineRevisionNumber?: integer | string;
        sageSalesTax?: string;
        consumerSalesPrice?: decimal | string;
        invoicingTerm?: string;
        allocationType?: AllocationType;
        backToBackOrderLineNumber?: integer | string;
        backToBackOrderNumber?: string;
        backToBackOrderSequenceNumber?: integer | string;
        carrier?: string;
        closingDate?: string;
        closingReason?: string;
        completeDeliveryPriority?: integer | string;
        deliveryLeadTime?: integer | string;
        deliveryMode?: string;
        deliveryPriority?: DeliveryPriority;
        dimensions?: Partial<SalesOrderLineDimensionDimensionsInput>[];
        distributedInvoicingElements?: Partial<SalesOrderQuantityLineDistributedInvoicingElementsInput>[];
        exclusiveLotFilter?: string;
        exclusiveStockStatusFilter?: string;
        expectedDeliveryDate?: string;
        geographicCode?: string;
        importLineNumber?: integer | string;
        insideCityLimits?: string;
        invoicedAmount?: decimal | string;
        isComponentPrintedOnAcknowledgement?: boolean | string;
        isComponentPrintedOnInvoice?: boolean | string;
        isComponentPrintedOnPackingSlip?: boolean | string;
        isDeliverable?: boolean | string;
        isInvoiced?: boolean | string;
        isLineWithDistributedInvoicingElement?: boolean | string;
        isRecordedTax?: boolean | string;
        isTaxable?: boolean | string;
        isTaxedGeographically?: string;
        latestDeliveryDate?: string;
        latestDeliveryTime?: string;
        locationReference?: string;
        majorProductVersion?: string;
        minorProductVersion?: string;
        orderDate?: string;
        orderLineText?: TextStream;
        packaging?: string;
        packagingCapacity?: decimal | string;
        preferentialStockLocationFilter?: string;
        preparationCode?: string;
        productSource?: SourceOfShipment;
        productStockManagement?: StockManagement;
        project?: string;
        quantityInSalesUnitAllocated?: decimal | string;
        quantityInSalesUnitDelivered?: decimal | string;
        quantityInSalesUnitInPreparation?: decimal | string;
        quantityInSalesUnitInitiallyOrdered?: decimal | string;
        quantityInSalesUnitInvoiced?: decimal | string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInSalesUnitOnPickList?: decimal | string;
        quantityInSalesUnitOrdered?: decimal | string;
        quantityInSalesUnitPrepared?: decimal | string;
        quantityInSalesUnitShortage?: decimal | string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        quantityInStockUnitAllocated?: decimal | string;
        quantityInStockUnitDelivered?: decimal | string;
        quantityInStockUnitInPreparation?: decimal | string;
        quantityInStockUnitInvoiced?: decimal | string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice?: decimal | string;
        quantityInStockUnitOnPickList?: decimal | string;
        quantityInStockUnitOrdered?: decimal | string;
        quantityInStockUnitPrepared?: decimal | string;
        quantityInStockUnitShortage?: decimal | string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock?: decimal | string;
        requestedDeliveryDate?: string;
        requestedDeliveryReference?: string;
        requestedDeliveryTime?: string;
        routeNumber?: RouteCode;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        shipmentDate?: string;
        shipmentTime?: string;
        taxRate?: decimal | string;
        taxableAmount?: decimal | string;
        tokenManagement?: decimal | string;
        useByDate?: string;
        volumeDistributedOnLine?: decimal | string;
        volumeUnitForDistributionOnLines?: string;
        weightDistributedOnLine?: decimal | string;
        weightUnitForDistributionOnLines?: string;
        workInProgressOrderNumber?: string;
        workInProgressStatus?: StatusInProgress;
        productStatisticalGroups?: Partial<SalesOrderLineProductStatisticalGroupsInput>[];
        taxes?: Partial<SalesOrderLineTaxesInput>[];
        purchaseOrder?: string;
        purchaseOrderLine?: integer | string;
        purchaseOrderSequenceNumber?: integer | string;
    }
    export interface SalesOrderLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesOrder: SalesOrder;
        lineNumber: integer;
        sequenceNumber: integer;
        company: Company;
        category: OrderCategory;
        soldToCustomer: Customer;
        shipToCustomerAddress: ShipToCustomerAddress;
        shipToCustomerContact: CustomerContact;
        billToCustomer: Customer;
        shippingSite: Site;
        salesSite: Site;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        customerProduct: string;
        salesRep1: SalesRep;
        salesRep2: SalesRep;
        salesRep1CommissionRate: string;
        salesRep2CommissionRate: string;
        salesRepCommissionFactor: string;
        grossPrice: string;
        priceReason: SalesPriceReason;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        margin: string;
        costPrice: string;
        discountOrCharge1: string;
        discountOrCharge2: string;
        discountOrCharge3: string;
        discountOrCharge4: string;
        discountOrCharge5: string;
        discountOrCharge6: string;
        discountOrCharge7: string;
        discountOrCharge8: string;
        discountOrCharge9: string;
        discountOrCharge1Reason: SalesPriceReason;
        discountOrCharge2Reason: SalesPriceReason;
        discountOrCharge3Reason: SalesPriceReason;
        discountOrCharge4Reason: SalesPriceReason;
        discountOrCharge5Reason: SalesPriceReason;
        discountOrCharge6Reason: SalesPriceReason;
        discountOrCharge7Reason: SalesPriceReason;
        discountOrCharge8Reason: SalesPriceReason;
        discountOrCharge9Reason: SalesPriceReason;
        calculatedTaxableBase1: string;
        calculatedTaxableBase2: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        lineStatus: LineStatus;
        lineType: LineType;
        freeProduct: Free;
        freeProductLineSource: SalesOrderLine;
        salesQuote: SalesQuote;
        salesQuoteLineNumber: SalesQuoteLine;
        lineRevisionNumber: integer;
        sageSalesTax: MiscellaneousTable;
        consumerSalesPrice: string;
        invoicingTerm: InvoicingTerm;
        allocationType: AllocationType;
        backToBackOrderLineNumber: integer;
        backToBackOrderNumber: string;
        backToBackOrderSequenceNumber: integer;
        carrier: Carrier;
        closingDate: string;
        closingReason: MiscellaneousTable;
        completeDeliveryPriority: integer;
        deliveryLeadTime: integer;
        deliveryMode: DeliveryMode;
        deliveryPriority: DeliveryPriority;
        dimensions: ClientCollection<SalesOrderLineDimensionDimensions>;
        distributedInvoicingElements: ClientCollection<SalesOrderQuantityLineDistributedInvoicingElements>;
        exclusiveLotFilter: string;
        exclusiveStockStatusFilter: string;
        expectedDeliveryDate: string;
        geographicCode: string;
        importLineNumber: integer;
        insideCityLimits: string;
        invoicedAmount: string;
        isComponentPrintedOnAcknowledgement: boolean;
        isComponentPrintedOnInvoice: boolean;
        isComponentPrintedOnPackingSlip: boolean;
        isDeliverable: boolean;
        isInvoiced: boolean;
        isLineWithDistributedInvoicingElement: boolean;
        isRecordedTax: boolean;
        isTaxable: boolean;
        isTaxedGeographically: string;
        latestDeliveryDate: string;
        latestDeliveryTime: string;
        locationReference: string;
        majorProductVersion: MajorVersionStatus;
        minorProductVersion: string;
        orderDate: string;
        orderLineText: TextStream;
        packaging: Packaging;
        packagingCapacity: string;
        preferentialStockLocationFilter: Location;
        preparationCode: string;
        productSource: SourceOfShipment;
        productStockManagement: StockManagement;
        project: ProjectLink;
        quantityInSalesUnitAllocated: string;
        quantityInSalesUnitDelivered: string;
        quantityInSalesUnitInPreparation: string;
        quantityInSalesUnitInitiallyOrdered: string;
        quantityInSalesUnitInvoiced: string;
        quantityInSalesUnitOnDeliveryOrScheduledInvoice: string;
        quantityInSalesUnitOnPickList: string;
        quantityInSalesUnitOrdered: string;
        quantityInSalesUnitPrepared: string;
        quantityInSalesUnitShortage: string;
        quantityInSalesUnitToDeliverForProductsNotManagedInStock: string;
        quantityInStockUnitAllocated: string;
        quantityInStockUnitDelivered: string;
        quantityInStockUnitInPreparation: string;
        quantityInStockUnitInvoiced: string;
        quantityInStockUnitOnDeliveryOrScheduledInvoice: string;
        quantityInStockUnitOnPickList: string;
        quantityInStockUnitOrdered: string;
        quantityInStockUnitPrepared: string;
        quantityInStockUnitShortage: string;
        quantityInStockUnitToDeliverForProductsNotManagedInStock: string;
        requestedDeliveryDate: string;
        requestedDeliveryReference: string;
        requestedDeliveryTime: string;
        routeNumber: RouteCode;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        shipmentDate: string;
        shipmentTime: string;
        taxRate: string;
        taxableAmount: string;
        tokenManagement: string;
        useByDate: string;
        volumeDistributedOnLine: string;
        volumeUnitForDistributionOnLines: UnitOfMeasure;
        weightDistributedOnLine: string;
        weightUnitForDistributionOnLines: UnitOfMeasure;
        workInProgressOrderNumber: string;
        workInProgressStatus: StatusInProgress;
        productStatisticalGroups: ClientCollection<SalesOrderLineProductStatisticalGroupsBinding>;
        taxes: ClientCollection<SalesOrderLineTaxesBinding>;
        purchaseOrder: PurchaseOrder;
        purchaseOrderLine: PurchaseOrderLine;
        purchaseOrderSequenceNumber: integer;
    }
    export interface SalesOrderLineExtension$Lookups {
        purchaseOrder: QueryOperation<PurchaseOrder>;
        purchaseOrderLine: QueryOperation<PurchaseOrderLine>;
    }
    export interface SalesOrderLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesOrderLineInput }): SalesOrderLineExtension$Lookups;
    }
    export interface SalesReturnLineExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesReturn: SalesReturn;
        lineNumber: integer;
        company: Company;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        quantityInSalesUnitDelivered: string;
        expectedReturnQuantity: string;
        expectedReturnQuantityInStockUnit: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        currency: Currency;
        returnReason: MiscellaneousTable;
        returnDate: string;
        actualStockReturn: boolean;
        returnDeductedFromTheInvoice: boolean;
        isToBeLinkedToCreditMemo: boolean;
        reactivatedOrder: boolean;
        creditMemo: SalesInvoice;
        creditMemoLineNumber: SalesInvoiceLine;
        creditMemoToBeIssued: SalesInvoice;
        creditMemoLineNumberToBeIssued: SalesInvoiceLine;
        reversalDocumentDate: string;
        receivingSite: Site;
        orderPrice: string;
        warehouse: Warehouse;
        project: ProjectLink;
        category: ReturnCategory;
        returnLineText: TextStream;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
    }
    export interface SalesReturnLineInputExtension {
        salesReturn?: string;
        lineNumber?: integer | string;
        company?: string;
        product?: string;
        productDescriptionInUserLanguage?: string;
        productDescriptionInCustomerLanguage?: string;
        salesDelivery?: string;
        salesDeliveryLineNumber?: integer | string;
        quantityInSalesUnitDelivered?: decimal | string;
        expectedReturnQuantity?: decimal | string;
        expectedReturnQuantityInStockUnit?: decimal | string;
        quantityInSalesUnitReturned?: decimal | string;
        quantityInStockUnitReturned?: decimal | string;
        salesUnit?: string;
        stockUnit?: string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        netPrice?: decimal | string;
        netPriceExcludingTax?: decimal | string;
        netPriceIncludingTax?: decimal | string;
        currency?: string;
        returnReason?: string;
        returnDate?: string;
        actualStockReturn?: boolean | string;
        returnDeductedFromTheInvoice?: boolean | string;
        isToBeLinkedToCreditMemo?: boolean | string;
        reactivatedOrder?: boolean | string;
        creditMemo?: string;
        creditMemoLineNumber?: integer | string;
        creditMemoToBeIssued?: string;
        creditMemoLineNumberToBeIssued?: integer | string;
        reversalDocumentDate?: string;
        receivingSite?: string;
        orderPrice?: decimal | string;
        warehouse?: string;
        project?: string;
        category?: ReturnCategory;
        returnLineText?: TextStream;
        purchaseReturn?: string;
        purchaseReturnLine?: integer | string;
    }
    export interface SalesReturnLineBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        salesReturn: SalesReturn;
        lineNumber: integer;
        company: Company;
        product: Product;
        productDescriptionInUserLanguage: string;
        productDescriptionInCustomerLanguage: string;
        salesDelivery: SalesDelivery;
        salesDeliveryLineNumber: SalesDeliveryLine;
        quantityInSalesUnitDelivered: string;
        expectedReturnQuantity: string;
        expectedReturnQuantityInStockUnit: string;
        quantityInSalesUnitReturned: string;
        quantityInStockUnitReturned: string;
        salesUnit: UnitOfMeasure;
        stockUnit: UnitOfMeasure;
        salesUnitToStockUnitConversionFactor: string;
        netPrice: string;
        netPriceExcludingTax: string;
        netPriceIncludingTax: string;
        currency: Currency;
        returnReason: MiscellaneousTable;
        returnDate: string;
        actualStockReturn: boolean;
        returnDeductedFromTheInvoice: boolean;
        isToBeLinkedToCreditMemo: boolean;
        reactivatedOrder: boolean;
        creditMemo: SalesInvoice;
        creditMemoLineNumber: SalesInvoiceLine;
        creditMemoToBeIssued: SalesInvoice;
        creditMemoLineNumberToBeIssued: SalesInvoiceLine;
        reversalDocumentDate: string;
        receivingSite: Site;
        orderPrice: string;
        warehouse: Warehouse;
        project: ProjectLink;
        category: ReturnCategory;
        returnLineText: TextStream;
        purchaseReturn: PurchaseReturn;
        purchaseReturnLine: PurchaseReturnLine;
    }
    export interface SalesReturnLineExtension$Lookups {
        purchaseReturn: QueryOperation<PurchaseReturn>;
        purchaseReturnLine: QueryOperation<PurchaseReturnLine>;
    }
    export interface SalesReturnLineExtension$Operations {
        lookups(dataOrId: string | { data: SalesReturnLineInput }): SalesReturnLineExtension$Lookups;
    }
    export interface Package {}
    export interface GraphApi
        extends Package,
            SageX3FinanceData$Package,
            SageX3InvoicingData$Package,
            SageX3ManufacturingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3Purchasing$Package,
            SageX3PurchasingData$Package,
            SageX3Sales$Package,
            SageX3SalesData$Package,
            SageX3Stock$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-purchasing-sales-api' {
    export type * from '@sage/x3-purchasing-sales-api-partial';
}
declare module '@sage/x3-finance-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-manufacturing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-sales-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-purchasing-sales-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-purchasing-api-partial' {
    import type {
        PurchaseInvoiceBindingExtension,
        PurchaseInvoiceExtension,
        PurchaseInvoiceExtension$Lookups,
        PurchaseInvoiceExtension$Operations,
        PurchaseInvoiceInputExtension,
        PurchaseInvoiceLineBindingExtension,
        PurchaseInvoiceLineExtension,
        PurchaseInvoiceLineInputExtension,
        PurchaseOrderBindingExtension,
        PurchaseOrderExtension,
        PurchaseOrderInputExtension,
        PurchaseOrderLineBindingExtension,
        PurchaseOrderLineExtension,
        PurchaseOrderLineExtension$Lookups,
        PurchaseOrderLineExtension$Operations,
        PurchaseOrderLineInputExtension,
        PurchaseReceiptLineBindingExtension,
        PurchaseReceiptLineExtension,
        PurchaseReceiptLineExtension$Lookups,
        PurchaseReceiptLineExtension$Operations,
        PurchaseReceiptLineInputExtension,
    } from '@sage/x3-purchasing-sales-api';
    export interface PurchaseInvoice extends PurchaseInvoiceExtension {}
    export interface PurchaseInvoiceBinding extends PurchaseInvoiceBindingExtension {}
    export interface PurchaseInvoiceInput extends PurchaseInvoiceInputExtension {}
    export interface PurchaseInvoice$Lookups extends PurchaseInvoiceExtension$Lookups {}
    export interface PurchaseInvoice$Operations extends PurchaseInvoiceExtension$Operations {}
    export interface PurchaseInvoiceLine extends PurchaseInvoiceLineExtension {}
    export interface PurchaseInvoiceLineBinding extends PurchaseInvoiceLineBindingExtension {}
    export interface PurchaseInvoiceLineInput extends PurchaseInvoiceLineInputExtension {}
    export interface PurchaseOrder extends PurchaseOrderExtension {}
    export interface PurchaseOrderBinding extends PurchaseOrderBindingExtension {}
    export interface PurchaseOrderInput extends PurchaseOrderInputExtension {}
    export interface PurchaseOrderLine extends PurchaseOrderLineExtension {}
    export interface PurchaseOrderLineBinding extends PurchaseOrderLineBindingExtension {}
    export interface PurchaseOrderLineInput extends PurchaseOrderLineInputExtension {}
    export interface PurchaseOrderLine$Lookups extends PurchaseOrderLineExtension$Lookups {}
    export interface PurchaseOrderLine$Operations extends PurchaseOrderLineExtension$Operations {}
    export interface PurchaseReceiptLine extends PurchaseReceiptLineExtension {}
    export interface PurchaseReceiptLineBinding extends PurchaseReceiptLineBindingExtension {}
    export interface PurchaseReceiptLineInput extends PurchaseReceiptLineInputExtension {}
    export interface PurchaseReceiptLine$Lookups extends PurchaseReceiptLineExtension$Lookups {}
    export interface PurchaseReceiptLine$Operations extends PurchaseReceiptLineExtension$Operations {}
}
declare module '@sage/x3-sales-api-partial' {
    import type {
        SalesInvoiceBindingExtension,
        SalesInvoiceExtension,
        SalesInvoiceExtension$Lookups,
        SalesInvoiceExtension$Operations,
        SalesInvoiceInputExtension,
        SalesInvoiceLineBindingExtension,
        SalesInvoiceLineExtension,
        SalesInvoiceLineInputExtension,
        SalesOrderLineBindingExtension,
        SalesOrderLineExtension,
        SalesOrderLineExtension$Lookups,
        SalesOrderLineExtension$Operations,
        SalesOrderLineInputExtension,
        SalesReturnLineBindingExtension,
        SalesReturnLineExtension,
        SalesReturnLineExtension$Lookups,
        SalesReturnLineExtension$Operations,
        SalesReturnLineInputExtension,
    } from '@sage/x3-purchasing-sales-api';
    export interface SalesInvoice extends SalesInvoiceExtension {}
    export interface SalesInvoiceBinding extends SalesInvoiceBindingExtension {}
    export interface SalesInvoiceInput extends SalesInvoiceInputExtension {}
    export interface SalesInvoice$Lookups extends SalesInvoiceExtension$Lookups {}
    export interface SalesInvoice$Operations extends SalesInvoiceExtension$Operations {}
    export interface SalesInvoiceLine extends SalesInvoiceLineExtension {}
    export interface SalesInvoiceLineBinding extends SalesInvoiceLineBindingExtension {}
    export interface SalesInvoiceLineInput extends SalesInvoiceLineInputExtension {}
    export interface SalesOrderLine extends SalesOrderLineExtension {}
    export interface SalesOrderLineBinding extends SalesOrderLineBindingExtension {}
    export interface SalesOrderLineInput extends SalesOrderLineInputExtension {}
    export interface SalesOrderLine$Lookups extends SalesOrderLineExtension$Lookups {}
    export interface SalesOrderLine$Operations extends SalesOrderLineExtension$Operations {}
    export interface SalesReturnLine extends SalesReturnLineExtension {}
    export interface SalesReturnLineBinding extends SalesReturnLineBindingExtension {}
    export interface SalesReturnLineInput extends SalesReturnLineInputExtension {}
    export interface SalesReturnLine$Lookups extends SalesReturnLineExtension$Lookups {}
    export interface SalesReturnLine$Operations extends SalesReturnLineExtension$Operations {}
}
