# xtrem-x3-sync

XTreeM synchronization service

# API

## Synchronization feed

### Request

```http
GET /xtrem/sync/{{table}}?countHint={{count}}&raw={{bool}}&columns={{columns}}&where={{filter}}&since={{stamp}}
```

where:

-   `{{endpoint}}`:the endpoint name
-   `{{table}}`: the table code (`BPARTNER` for example).
-   `countHint`: optional parameter to specify the page size.
-   `raw`: optional parameter to control the record format.
-   `columns`: optional parameter to control the columns returned in the feed..
-   `where`: optional filter (sdata syntax)
-   `since`: optional feed timestamp start, for incremental sync (and paging).

Parameters are optional so you can start the first synchronization pass with:

```http
GET /xtrem/sync/{{table}}
```

### Header information

If is possible to activate compression on the feed. You need to add in your http request header the following value:

```
accept-encoding:gzip
```

The data feed will be returned with the header :

```
content-encoding:gzip
```

### Response

```json
{
    "rows": [{ "COLUMN1": "val1", "COLUMN2": "val2", "...": "..." }],
    "done": false,
    "links": {
        "next": {
            "url": "http://host:port//xtrem//sync//{{table}}?since={{stamp}}/countHint={{count}}&..."
        },
        "count": {
            "url": "http://host:port//xtrem//sync//{{table}}/count?since={{stamp}}"
        }
    }
}
```

-   `rows`: the table rows that have been selected.
-   `done`: a boolean that indicates if the end of the feed has been reached.
-   `links.next.url`: the URL to get the next page of the feed. Same format with an additional `since` parameter.
-   `links.count.url`: the URL to get the number of records in the remaining pages of the feed.

### Paging and incremental passes

The response is broken into pages.

The `countHint` url parameter can be used to specify the page size (number of records per page). This value is only a hint. The return `rows` array may be larger than `countHint` if the table contains records with identical `UPDDATTIM_0` values. In this case, the synchronization service will read records beyond `countHint` until it finds a change in `UPDDATTIM_0` value.

A default value will be used if `countHint` is not specified (1000 to start with but may change as we tune)

The feed is iterated by calling GET on the URL returned as `links.next.url`, until `done` is set to `true` in the response.

The `links.next.url` is also set on the last page, when `done` becomes `true`. This URL can be used to start another incrementatl synchronization pass, at a later time.

### Response format

The optional `raw` parameter controls how the rows are formatted. By default, the trailing `_0` is stripped from column names (`FOO_0` is returned as `FOO`), and denormalized arrays of values (`BAR_0`, `BAR_1`, `BAR_2`, ...) are returned as a single `BAR` property containing the array of values. On the other hand, if `raw` is set to true, the columns are returned with their original names.

Default format:

```json
{
    "rows": [
        { "FOO": "v1", "BAR": [3, 5, 8] }
        { "FOO": "v2", "BAR": [7, 1] }
    ],
    "...": "..."
}
```

Raw format:

```json
{
    "rows": [
        { "FOO_0": "v1", "BAR_0": 3, "BAR_1": 5, "BAR_2": 8 }
        { "FOO_0": "v2", "BAR_0": 7, "BAR_1": 1, "BAR_2": 0 }
    ],
    "...": "..."
}
```

Note: trailing placeholder values (`""` or `0`) are stripped in default format.

You can also control the list of columns with the `columns` parameters. The value is a comma separated list of column names (with `_0` prefix in raw mode, without this prefix in default mode).

### Filtering

You can pass an optional filter with the `where` parameter. Filters are expressed in [_sdata_ syntax](http://sage.github.io/SData-2.0/pages/core/0212/).

For example:

```http
GET /xtrem/sync/{{table}}?where=CODFIC%20like%20'A%45'
```

In `raw` format, the column names of the filter must carry their `_0` suffix. In normal mode, the suffix must be stripped.

## Count request

### Request

```http
GET /xtrem/sync/{{table}/count}?since={{stamp}}
```

where:

-   `{{endpoint}}`:the endpoint name
-   `{{table}}`: the table code (`BPARTNER` for example).
-   `raw`: optional parameter to control the record format.
-   `where`: optional filter (sdata syntax)
-   `since`: optional feed timestamp start, for incremental sync (and paging).

Note: the `raw` parameter is only meaningful together with a `where` parameter. It controls whether column names will carry a `_0` suffix or not.

### Response

```json
{
    "count": 603
}
```

-   `count`: the number of rows in the table.

Note: this request has a cost but it is handy to provide feedback to the user on the progress of a synchronization operation. The recommendation is to call it once at the beginning of a synchronization pass, and then decrement by `rows.length` after every page. There is no guarantee that count will exactly match the total number of records returned in the synchronization feed, as transactions may proceeed concurrently with synchronization.

## Listing all tables

### Request

```http
GET /xtrem/sync
```

where:

-   `{{endpoint}}`:the endpoint name

### Response

```json
{
    "tables": [
        {
            "name": "TABLE1'",
            "url": "/xtrem/sync/TABLE1'"
        },
        {
            "name": "TABLE2'",
            "url": "/xtrem/sync/TABLE2'"
        },
        "..."
    ]
}
```

Each table entry has the following properties:

-   `name`: the name of the table
-   `url`: the table's synchronization URL.

# Synchronizing views

The sync service works with views but the view must expose `ROWID` and `UPDDATTIM_0` columns.

The `ROWID` column is special because this is a _system_ column on Oracle and a _supervisor_ column on SQL Server (without `_0` suffix).

On Oracle the view should be created without any `ROWID` column as Oracle adds this column systematically (except if the view does not map to an actual table) and automatically.

On SQL server the view should be defined through an explicit `create view ...` directive rather than through the X3 _views dictionary_, at least until we enhance the supervisor to handle `ROWID` in view definitions.
This gives the freedom to map the ROWID column correctly (to `ROWID`, not `ROWID_0`).
See https://jira-sage.valiantyscloud.net/secure/RapidBoard.jspa?rapidView=1282&projectKey=X3&view=detail&selectedIssue=X3-69360.

# Gotchas

The synchronization API does not cater for deleted records. It only returns inserted and updated records. This can be mitigated by performing a full (non-incremental) synchronization once in a while.

The page size may dramatically exceed `countHint` if a very large number of records have the same `UPDDATTIM_0` timestamp. We may increase the precision of timestamps (from second to millis, or even smaller), to mitigate this.
