// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/index.d.ts
declare module '@sage/x3-sales-data/index' {
	export * from '@sage/x3-sales-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/index.d.ts
declare module '@sage/x3-sales-data/lib/index' {
	export * as enums from '@sage/x3-sales-data/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-sales-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-sales-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-sales-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-sales-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-return-type.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-return-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SalesReturnType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-return-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-quote-type.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-quote-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SalesQuoteType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-quote-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-price-reason.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-price-reason' {
	import { Node, integer } from '@sage/xtrem-core';
	export class SalesPriceReason extends Node {
	    readonly code: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-price-reason.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-order-type.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-order-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SalesOrderType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-order-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-invoice-type.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-invoice-type' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SalesInvoiceType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly invoiceCategory: Promise<sageX3InvoicingData.enums.InvoiceType | null>;
	}
	//# sourceMappingURL=sales-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/sales-delivery-type.d.ts
declare module '@sage/x3-sales-data/lib/nodes/sales-delivery-type' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class SalesDeliveryType extends Node {
	    readonly code: Promise<string>;
	    readonly legislation: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	}
	//# sourceMappingURL=sales-delivery-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/product-sales.d.ts
declare module '@sage/x3-sales-data/lib/nodes/product-sales' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import { Node, Reference, date, decimal, TextStream } from '@sage/xtrem-core';
	export class ProductSales extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly substitutionProduct: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly substitutionDate: Promise<date | null>;
	    readonly productSalesTextKey: Promise<string>;
	    readonly productPickingTextKey: Promise<string>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly basePrice: Promise<decimal | null>;
	    readonly productPickingTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly productSalesTextRef: Reference<sageX3MasterData.nodes.CommonText | null>;
	    readonly productPickingText: Promise<TextStream>;
	    readonly productSalesText: Promise<TextStream>;
	}
	//# sourceMappingURL=product-sales.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-sales-data/lib/nodes/index' {
	export * from '@sage/x3-sales-data/lib/nodes/product-sales';
	export * from '@sage/x3-sales-data/lib/nodes/sales-delivery-type';
	export * from '@sage/x3-sales-data/lib/nodes/sales-invoice-type';
	export * from '@sage/x3-sales-data/lib/nodes/sales-order-type';
	export * from '@sage/x3-sales-data/lib/nodes/sales-price-reason';
	export * from '@sage/x3-sales-data/lib/nodes/sales-quote-type';
	export * from '@sage/x3-sales-data/lib/nodes/sales-return-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/node-extensions/ship-to-customer-address-extension.d.ts
declare module '@sage/x3-sales-data/lib/node-extensions/ship-to-customer-address-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3SalesData from '@sage/x3-sales-data/lib/index';
	import { NodeExtension } from '@sage/xtrem-core';
	export class ShipToCustomerAddressExtension extends NodeExtension<sageX3MasterData.nodes.ShipToCustomerAddress> {
	    readonly routeCode: Promise<sageX3SalesData.enums.RouteCode | null>;
	    readonly deliveryPriority: Promise<sageX3SalesData.enums.DeliveryPriority | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/ship-to-customer-address' {
	    interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {
	    }
	}
	//# sourceMappingURL=ship-to-customer-address-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-sales-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3PhysicalFlowsData from '@sage/x3-physical-flows-data';
	import { NodeExtension, Reference, decimal, TextStream, date } from '@sage/xtrem-core';
	import * as sageX3SalesData from '@sage/x3-sales-data/lib/index';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly productSalesRef: Reference<sageX3SalesData.nodes.ProductSales | null>;
	    readonly basePrice: Promise<decimal | null>;
	    readonly packaging: Reference<sageX3PhysicalFlowsData.nodes.Packaging | null>;
	    readonly packagingCapacity: Promise<decimal | null>;
	    readonly productPickingText: Promise<TextStream>;
	    readonly productSalesText: Promise<TextStream>;
	    readonly substitutionDate: Promise<date | null>;
	    readonly substitutionProduct: Reference<sageX3MasterData.nodes.Product | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-sales-data/lib/node-extensions/index' {
	export * from '@sage/x3-sales-data/lib/node-extensions/customer-invoice-header-extension';
	export * from '@sage/x3-sales-data/lib/node-extensions/product-extension';
	export * from '@sage/x3-sales-data/lib/node-extensions/ship-to-customer-address-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/node-extensions/customer-invoice-header-extension.d.ts
declare module '@sage/x3-sales-data/lib/node-extensions/customer-invoice-header-extension' {
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3SalesData from '@sage/x3-sales-data/lib/index';
	export class CustomerInvoiceHeaderExtension extends NodeExtension<sageX3InvoicingData.nodes.CustomerInvoiceHeader> {
	    readonly invoiceType: Reference<sageX3SalesData.nodes.SalesInvoiceType | null>;
	}
	declare module '@sage/x3-invoicing-data/lib/nodes/customer-invoice-header' {
	    interface CustomerInvoiceHeader extends CustomerInvoiceHeaderExtension {
	    }
	}
	//# sourceMappingURL=customer-invoice-header-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/url-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/url-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum UrlTypeEnum {
	    test = 1,
	    production = 2
	}
	export interface UrlType$EnumInterface {
	    test: 1;
	    production: 2;
	}
	export type UrlType = keyof UrlType$EnumInterface;
	export const urlTypeDatatype: X3EnumDataType<keyof UrlType$EnumInterface, unknown>;
	//# sourceMappingURL=url-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/type-of-sales-document.d.ts
declare module '@sage/x3-sales-data/lib/enums/type-of-sales-document' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfSalesDocumentEnum {
	    quote = 1,
	    delivery = 2,
	    return = 3,
	    invoice = 4,
	    creditNote = 5,
	    proforma = 6,
	    loanDelivery = 7,
	    loanReturn = 8,
	    priceRecord = 9,
	    normalOrder = 10,
	    loanOrder = 11,
	    directInvoiceOrder = 12,
	    contract = 13,
	    firmDelivery = 14,
	    deliveryForSubcontracting = 15,
	    intracompanyIntercompanyDelivery = 16,
	    intracompanyIntercompanyReturn = 17,
	    subcontractMaterialReturn = 18,
	    scheduledInvoice = 19
	}
	export interface TypeOfSalesDocument$EnumInterface {
	    quote: 1;
	    delivery: 2;
	    return: 3;
	    invoice: 4;
	    creditNote: 5;
	    proforma: 6;
	    loanDelivery: 7;
	    loanReturn: 8;
	    priceRecord: 9;
	    normalOrder: 10;
	    loanOrder: 11;
	    directInvoiceOrder: 12;
	    contract: 13;
	    firmDelivery: 14;
	    deliveryForSubcontracting: 15;
	    intracompanyIntercompanyDelivery: 16;
	    intracompanyIntercompanyReturn: 17;
	    subcontractMaterialReturn: 18;
	    scheduledInvoice: 19;
	}
	export type TypeOfSalesDocument = keyof TypeOfSalesDocument$EnumInterface;
	export const typeOfSalesDocumentDatatype: X3EnumDataType<keyof TypeOfSalesDocument$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-sales-document.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/transaction-type-435.d.ts
declare module '@sage/x3-sales-data/lib/enums/transaction-type-435' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionType435Enum {
	    quote = 1,
	    order = 2,
	    contractOrder = 3,
	    delivery = 4,
	    invoice = 5,
	    customerReturn = 6,
	    loanReturn = 7,
	    subcontractMaterialReturn = 8
	}
	export interface TransactionType435$EnumInterface {
	    quote: 1;
	    order: 2;
	    contractOrder: 3;
	    delivery: 4;
	    invoice: 5;
	    customerReturn: 6;
	    loanReturn: 7;
	    subcontractMaterialReturn: 8;
	}
	export type TransactionType435 = keyof TransactionType435$EnumInterface;
	export const transactionType435Datatype: X3EnumDataType<keyof TransactionType435$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-type-435.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/transaction-invoice-types.d.ts
declare module '@sage/x3-sales-data/lib/enums/transaction-invoice-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionInvoiceTypesEnum {
	    invoice = 1,
	    creditMemo = 2,
	    proforma = 3,
	    allTypes = 4
	}
	export interface TransactionInvoiceTypes$EnumInterface {
	    invoice: 1;
	    creditMemo: 2;
	    proforma: 3;
	    allTypes: 4;
	}
	export type TransactionInvoiceTypes = keyof TransactionInvoiceTypes$EnumInterface;
	export const transactionInvoiceTypesDatatype: X3EnumDataType<keyof TransactionInvoiceTypes$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-invoice-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/transaction-invoice-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/transaction-invoice-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionInvoiceTypeEnum {
	    invoice = 1,
	    proforma = 2,
	    allTypes = 3
	}
	export interface TransactionInvoiceType$EnumInterface {
	    invoice: 1;
	    proforma: 2;
	    allTypes: 3;
	}
	export type TransactionInvoiceType = keyof TransactionInvoiceType$EnumInterface;
	export const transactionInvoiceTypeDatatype: X3EnumDataType<keyof TransactionInvoiceType$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-invoice-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/tracking-of-product-text.d.ts
declare module '@sage/x3-sales-data/lib/enums/tracking-of-product-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TrackingOfProductTextEnum {
	    onTheOrder = 1,
	    onTheShipment = 2,
	    onTheInvoice = 3,
	    onTheShipmentAndInvoice = 4,
	    onOrderShipmentInvoice = 5
	}
	export interface TrackingOfProductText$EnumInterface {
	    onTheOrder: 1;
	    onTheShipment: 2;
	    onTheInvoice: 3;
	    onTheShipmentAndInvoice: 4;
	    onOrderShipmentInvoice: 5;
	}
	export type TrackingOfProductText = keyof TrackingOfProductText$EnumInterface;
	export const trackingOfProductTextDatatype: X3EnumDataType<keyof TrackingOfProductText$EnumInterface, unknown>;
	//# sourceMappingURL=tracking-of-product-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/tracking-of-customer-text.d.ts
declare module '@sage/x3-sales-data/lib/enums/tracking-of-customer-text' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TrackingOfCustomerTextEnum {
	    headerText = 1,
	    footerText = 2
	}
	export interface TrackingOfCustomerText$EnumInterface {
	    headerText: 1;
	    footerText: 2;
	}
	export type TrackingOfCustomerText = keyof TrackingOfCustomerText$EnumInterface;
	export const trackingOfCustomerTextDatatype: X3EnumDataType<keyof TrackingOfCustomerText$EnumInterface, unknown>;
	//# sourceMappingURL=tracking-of-customer-text.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sundry-rules-std.d.ts
declare module '@sage/x3-sales-data/lib/enums/sundry-rules-std' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SundryRulesStdEnum {
	    none = 1,
	    discountOnTax = 2
	}
	export interface SundryRulesStd$EnumInterface {
	    none: 1;
	    discountOnTax: 2;
	}
	export type SundryRulesStd = keyof SundryRulesStd$EnumInterface;
	export const sundryRulesStdDatatype: X3EnumDataType<keyof SundryRulesStd$EnumInterface, unknown>;
	//# sourceMappingURL=sundry-rules-std.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sundry-rules-personalized.d.ts
declare module '@sage/x3-sales-data/lib/enums/sundry-rules-personalized' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SundryRulesPersonalizedEnum {
	    none = 1
	}
	export interface SundryRulesPersonalized$EnumInterface {
	    none: 1;
	}
	export type SundryRulesPersonalized = keyof SundryRulesPersonalized$EnumInterface;
	export const sundryRulesPersonalizedDatatype: X3EnumDataType<"none", unknown>;
	//# sourceMappingURL=sundry-rules-personalized.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/status-of-invoice.d.ts
declare module '@sage/x3-sales-data/lib/enums/status-of-invoice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatusOfInvoiceEnum {
	    notPrinted = 1,
	    printed = 2,
	    validated = 3
	}
	export interface StatusOfInvoice$EnumInterface {
	    notPrinted: 1;
	    printed: 2;
	    validated: 3;
	}
	export type StatusOfInvoice = keyof StatusOfInvoice$EnumInterface;
	export const statusOfInvoiceDatatype: X3EnumDataType<keyof StatusOfInvoice$EnumInterface, unknown>;
	//# sourceMappingURL=status-of-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/status-2419.d.ts
declare module '@sage/x3-sales-data/lib/enums/status-2419' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Status2419Enum {
	    toBeInvoiced = 1,
	    invoiced = 2,
	    creditMemo = 3,
	    closed = 4,
	    invoicedNotPosted = 5,
	    includedOnCreditMemo = 6
	}
	export interface Status2419$EnumInterface {
	    toBeInvoiced: 1;
	    invoiced: 2;
	    creditMemo: 3;
	    closed: 4;
	    invoicedNotPosted: 5;
	    includedOnCreditMemo: 6;
	}
	export type Status2419 = keyof Status2419$EnumInterface;
	export const status2419Datatype: X3EnumDataType<keyof Status2419$EnumInterface, unknown>;
	//# sourceMappingURL=status-2419.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/statement-period.d.ts
declare module '@sage/x3-sales-data/lib/enums/statement-period' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StatementPeriodEnum {
	    perRequest = 1,
	    weekly = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    monthly = 5
	}
	export interface StatementPeriod$EnumInterface {
	    perRequest: 1;
	    weekly: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    monthly: 5;
	}
	export type StatementPeriod = keyof StatementPeriod$EnumInterface;
	export const statementPeriodDatatype: X3EnumDataType<keyof StatementPeriod$EnumInterface, unknown>;
	//# sourceMappingURL=statement-period.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/split-rules.d.ts
declare module '@sage/x3-sales-data/lib/enums/split-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SplitRulesEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    allOrders = 5,
	    allDeliveries = 6,
	    allInvoices = 7,
	    allCreditMemos = 8,
	    amountProRata = 9,
	    quantityProRata = 10,
	    weightProRata = 11,
	    volumeProRata = 12
	}
	export interface SplitRules$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    allOrders: 5;
	    allDeliveries: 6;
	    allInvoices: 7;
	    allCreditMemos: 8;
	    amountProRata: 9;
	    quantityProRata: 10;
	    weightProRata: 11;
	    volumeProRata: 12;
	}
	export type SplitRules = keyof SplitRules$EnumInterface;
	export const splitRulesDatatype: X3EnumDataType<keyof SplitRules$EnumInterface, unknown>;
	//# sourceMappingURL=split-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/source-of-shipment.d.ts
declare module '@sage/x3-sales-data/lib/enums/source-of-shipment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SourceOfShipmentEnum {
	    normal = 1,
	    poDirectToCustomer = 2,
	    poReceiveAndShip = 3,
	    transfer = 4,
	    workOrder = 5
	}
	export interface SourceOfShipment$EnumInterface {
	    normal: 1;
	    poDirectToCustomer: 2;
	    poReceiveAndShip: 3;
	    transfer: 4;
	    workOrder: 5;
	}
	export type SourceOfShipment = keyof SourceOfShipment$EnumInterface;
	export const sourceOfShipmentDatatype: X3EnumDataType<keyof SourceOfShipment$EnumInterface, unknown>;
	//# sourceMappingURL=source-of-shipment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/signature.d.ts
declare module '@sage/x3-sales-data/lib/enums/signature' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SignatureEnum {
	    no = 1,
	    yesOptional = 2,
	    yesMandatory = 3
	}
	export interface Signature$EnumInterface {
	    no: 1;
	    yesOptional: 2;
	    yesMandatory: 3;
	}
	export type Signature = keyof Signature$EnumInterface;
	export const signatureDatatype: X3EnumDataType<keyof Signature$EnumInterface, unknown>;
	//# sourceMappingURL=signature.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/shipment-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/shipment-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentTypeEnum {
	    regularOrder = 1,
	    loanOrder = 2,
	    contract = 3,
	    directDelivery = 4,
	    directLoanDelivery = 5
	}
	export interface ShipmentType$EnumInterface {
	    regularOrder: 1;
	    loanOrder: 2;
	    contract: 3;
	    directDelivery: 4;
	    directLoanDelivery: 5;
	}
	export type ShipmentType = keyof ShipmentType$EnumInterface;
	export const shipmentTypeDatatype: X3EnumDataType<keyof ShipmentType$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/shipment-transaction-types.d.ts
declare module '@sage/x3-sales-data/lib/enums/shipment-transaction-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentTransactionTypesEnum {
	    normal = 1,
	    loan = 2,
	    subcontract = 3,
	    allTypes = 4,
	    nonbillable = 5
	}
	export interface ShipmentTransactionTypes$EnumInterface {
	    normal: 1;
	    loan: 2;
	    subcontract: 3;
	    allTypes: 4;
	    nonbillable: 5;
	}
	export type ShipmentTransactionTypes = keyof ShipmentTransactionTypes$EnumInterface;
	export const shipmentTransactionTypesDatatype: X3EnumDataType<keyof ShipmentTransactionTypes$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-transaction-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/shipment-date-initialization.d.ts
declare module '@sage/x3-sales-data/lib/enums/shipment-date-initialization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ShipmentDateInitializationEnum {
	    currentDate = 1,
	    originalDocumentShipmentDate = 2
	}
	export interface ShipmentDateInitialization$EnumInterface {
	    currentDate: 1;
	    originalDocumentShipmentDate: 2;
	}
	export type ShipmentDateInitialization = keyof ShipmentDateInitialization$EnumInterface;
	export const shipmentDateInitializationDatatype: X3EnumDataType<keyof ShipmentDateInitialization$EnumInterface, unknown>;
	//# sourceMappingURL=shipment-date-initialization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/schedule-type-2420.d.ts
declare module '@sage/x3-sales-data/lib/enums/schedule-type-2420' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScheduleType2420Enum {
	    normal = 1,
	    fixedPercentage = 2,
	    frequency = 3
	}
	export interface ScheduleType2420$EnumInterface {
	    normal: 1;
	    fixedPercentage: 2;
	    frequency: 3;
	}
	export type ScheduleType2420 = keyof ScheduleType2420$EnumInterface;
	export const scheduleType2420Datatype: X3EnumDataType<keyof ScheduleType2420$EnumInterface, unknown>;
	//# sourceMappingURL=schedule-type-2420.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-sort-order.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-sort-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesSortOrderEnum {
	    journalNumber = 1,
	    date = 2,
	    customer = 3
	}
	export interface SalesSortOrder$EnumInterface {
	    journalNumber: 1;
	    date: 2;
	    customer: 3;
	}
	export type SalesSortOrder = keyof SalesSortOrder$EnumInterface;
	export const salesSortOrderDatatype: X3EnumDataType<keyof SalesSortOrder$EnumInterface, unknown>;
	//# sourceMappingURL=sales-sort-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-sort-order-2408.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-sort-order-2408' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesSortOrder2408Enum {
	    journalNumber = 1,
	    date = 2,
	    validityDate = 3,
	    customer = 4
	}
	export interface SalesSortOrder2408$EnumInterface {
	    journalNumber: 1;
	    date: 2;
	    validityDate: 3;
	    customer: 4;
	}
	export type SalesSortOrder2408 = keyof SalesSortOrder2408$EnumInterface;
	export const salesSortOrder2408Datatype: X3EnumDataType<keyof SalesSortOrder2408$EnumInterface, unknown>;
	//# sourceMappingURL=sales-sort-order-2408.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-sort-order-2407.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-sort-order-2407' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesSortOrder2407Enum {
	    siteJournalNumber = 1,
	    siteDate = 2,
	    siteValidityDate = 3,
	    siteCustomer = 4,
	    journalNumber = 5,
	    date = 6,
	    validityDate = 7,
	    customer = 8
	}
	export interface SalesSortOrder2407$EnumInterface {
	    siteJournalNumber: 1;
	    siteDate: 2;
	    siteValidityDate: 3;
	    siteCustomer: 4;
	    journalNumber: 5;
	    date: 6;
	    validityDate: 7;
	    customer: 8;
	}
	export type SalesSortOrder2407 = keyof SalesSortOrder2407$EnumInterface;
	export const salesSortOrder2407Datatype: X3EnumDataType<keyof SalesSortOrder2407$EnumInterface, unknown>;
	//# sourceMappingURL=sales-sort-order-2407.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-sort-order-2405.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-sort-order-2405' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesSortOrder2405Enum {
	    siteJournalNumber = 1,
	    siteDate = 2,
	    siteCustomer = 3,
	    journalNumber = 4,
	    date = 5,
	    customer = 6
	}
	export interface SalesSortOrder2405$EnumInterface {
	    siteJournalNumber: 1;
	    siteDate: 2;
	    siteCustomer: 3;
	    journalNumber: 4;
	    date: 5;
	    customer: 6;
	}
	export type SalesSortOrder2405 = keyof SalesSortOrder2405$EnumInterface;
	export const salesSortOrder2405Datatype: X3EnumDataType<keyof SalesSortOrder2405$EnumInterface, unknown>;
	//# sourceMappingURL=sales-sort-order-2405.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-rep-commission-base.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-rep-commission-base' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesRepCommissionBaseEnum {
	    onNetPrice = 1,
	    onMargin = 2,
	    onCalculationFormula = 3
	}
	export interface SalesRepCommissionBase$EnumInterface {
	    onNetPrice: 1;
	    onMargin: 2;
	    onCalculationFormula: 3;
	}
	export type SalesRepCommissionBase = keyof SalesRepCommissionBase$EnumInterface;
	export const salesRepCommissionBaseDatatype: X3EnumDataType<keyof SalesRepCommissionBase$EnumInterface, unknown>;
	//# sourceMappingURL=sales-rep-commission-base.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-document-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-document-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesDocumentTypeEnum {
	    quote = 1,
	    delivery = 2,
	    return = 3,
	    invoice = 4,
	    creditMemo = 5,
	    proforma = 6,
	    loanDelivery = 7,
	    loanReturn = 8,
	    priceListRecord = 9,
	    normalOrder = 10,
	    loanOrder = 11,
	    directInvoiceOrder = 12,
	    contract = 13,
	    finalDelivery = 14,
	    deliveryForSubcontracting = 15,
	    intracompanyDelivery = 16,
	    intracompanyReturn = 17,
	    orderInvoice = 18,
	    deliveryInvoice = 19,
	    order = 20,
	    subcontractMaterialReturn = 21,
	    transportNote = 22,
	    serviceContracts = 23
	}
	export interface SalesDocumentType$EnumInterface {
	    quote: 1;
	    delivery: 2;
	    return: 3;
	    invoice: 4;
	    creditMemo: 5;
	    proforma: 6;
	    loanDelivery: 7;
	    loanReturn: 8;
	    priceListRecord: 9;
	    normalOrder: 10;
	    loanOrder: 11;
	    directInvoiceOrder: 12;
	    contract: 13;
	    finalDelivery: 14;
	    deliveryForSubcontracting: 15;
	    intracompanyDelivery: 16;
	    intracompanyReturn: 17;
	    orderInvoice: 18;
	    deliveryInvoice: 19;
	    order: 20;
	    subcontractMaterialReturn: 21;
	    transportNote: 22;
	    serviceContracts: 23;
	}
	export type SalesDocumentType = keyof SalesDocumentType$EnumInterface;
	export const salesDocumentTypeDatatype: X3EnumDataType<keyof SalesDocumentType$EnumInterface, unknown>;
	//# sourceMappingURL=sales-document-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/sales-credit-memo.d.ts
declare module '@sage/x3-sales-data/lib/enums/sales-credit-memo' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SalesCreditMemoEnum {
	    invoice = 1,
	    creditNote = 2,
	    proforma = 3
	}
	export interface SalesCreditMemo$EnumInterface {
	    invoice: 1;
	    creditNote: 2;
	    proforma: 3;
	}
	export type SalesCreditMemo = keyof SalesCreditMemo$EnumInterface;
	export const salesCreditMemoDatatype: X3EnumDataType<keyof SalesCreditMemo$EnumInterface, unknown>;
	//# sourceMappingURL=sales-credit-memo.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/route-view-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/route-view-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RouteViewTypeEnum {
	    order = 1,
	    delivery = 2
	}
	export interface RouteViewType$EnumInterface {
	    order: 1;
	    delivery: 2;
	}
	export type RouteViewType = keyof RouteViewType$EnumInterface;
	export const routeViewTypeDatatype: X3EnumDataType<keyof RouteViewType$EnumInterface, unknown>;
	//# sourceMappingURL=route-view-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/route-code.d.ts
declare module '@sage/x3-sales-data/lib/enums/route-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RouteCodeEnum {
	    routeCode1 = 1,
	    routeCode2 = 2,
	    routeCode3 = 3,
	    routeCode4 = 4
	}
	export interface RouteCode$EnumInterface {
	    routeCode1: 1;
	    routeCode2: 2;
	    routeCode3: 3;
	    routeCode4: 4;
	}
	export type RouteCode = keyof RouteCode$EnumInterface;
	export const routeCodeDatatype: X3EnumDataType<keyof RouteCode$EnumInterface, unknown>;
	//# sourceMappingURL=route-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/return-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/return-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReturnStatusEnum {
	    notReturned = 1,
	    partiallyReturned = 2,
	    returned = 3
	}
	export interface ReturnStatus$EnumInterface {
	    notReturned: 1;
	    partiallyReturned: 2;
	    returned: 3;
	}
	export type ReturnStatus = keyof ReturnStatus$EnumInterface;
	export const returnStatusDatatype: X3EnumDataType<keyof ReturnStatus$EnumInterface, unknown>;
	//# sourceMappingURL=return-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/return-category.d.ts
declare module '@sage/x3-sales-data/lib/enums/return-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReturnCategoryEnum {
	    normal = 1,
	    loan = 2,
	    forSubcontract = 3
	}
	export interface ReturnCategory$EnumInterface {
	    normal: 1;
	    loan: 2;
	    forSubcontract: 3;
	}
	export type ReturnCategory = keyof ReturnCategory$EnumInterface;
	export const returnCategoryDatatype: X3EnumDataType<keyof ReturnCategory$EnumInterface, unknown>;
	//# sourceMappingURL=return-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/report-code.d.ts
declare module '@sage/x3-sales-data/lib/enums/report-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReportCodeEnum {
	    customer = 1,
	    product = 2
	}
	export interface ReportCode$EnumInterface {
	    customer: 1;
	    product: 2;
	}
	export type ReportCode = keyof ReportCode$EnumInterface;
	export const reportCodeDatatype: X3EnumDataType<keyof ReportCode$EnumInterface, unknown>;
	//# sourceMappingURL=report-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/refacturation-chancier.d.ts
declare module '@sage/x3-sales-data/lib/enums/refacturation-chancier' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RefacturationChancierEnum {
	    noByDefaultWithQuestion = 1,
	    yesByDefaultWithQuestion = 2,
	    noWithoutQuestion = 3,
	    yesWithoutQuestion = 4
	}
	export interface RefacturationChancier$EnumInterface {
	    noByDefaultWithQuestion: 1;
	    yesByDefaultWithQuestion: 2;
	    noWithoutQuestion: 3;
	    yesWithoutQuestion: 4;
	}
	export type RefacturationChancier = keyof RefacturationChancier$EnumInterface;
	export const refacturationChancierDatatype: X3EnumDataType<keyof RefacturationChancier$EnumInterface, unknown>;
	//# sourceMappingURL=refacturation-chancier.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/quote-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/quote-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuoteStatusEnum {
	    notOrdered = 1,
	    partiallyOrdered = 2,
	    completelyOrdered = 3
	}
	export interface QuoteStatus$EnumInterface {
	    notOrdered: 1;
	    partiallyOrdered: 2;
	    completelyOrdered: 3;
	}
	export type QuoteStatus = keyof QuoteStatus$EnumInterface;
	export const quoteStatusDatatype: X3EnumDataType<keyof QuoteStatus$EnumInterface, unknown>;
	//# sourceMappingURL=quote-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/purchase-journal-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/purchase-journal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PurchaseJournalTypeEnum {
	    invoice = 1,
	    creditMemo = 2,
	    return = 3,
	    receipt = 4,
	    openOrder = 5,
	    order = 6,
	    subcontractOrder = 7,
	    purchaseRequest = 8,
	    callForTender = 9,
	    document = 10
	}
	export interface PurchaseJournalType$EnumInterface {
	    invoice: 1;
	    creditMemo: 2;
	    return: 3;
	    receipt: 4;
	    openOrder: 5;
	    order: 6;
	    subcontractOrder: 7;
	    purchaseRequest: 8;
	    callForTender: 9;
	    document: 10;
	}
	export type PurchaseJournalType = keyof PurchaseJournalType$EnumInterface;
	export const purchaseJournalTypeDatatype: X3EnumDataType<keyof PurchaseJournalType$EnumInterface, unknown>;
	//# sourceMappingURL=purchase-journal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/proforma-source.d.ts
declare module '@sage/x3-sales-data/lib/enums/proforma-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProformaSourceEnum {
	    direct = 1,
	    quote = 2
	}
	export interface ProformaSource$EnumInterface {
	    direct: 1;
	    quote: 2;
	}
	export type ProformaSource = keyof ProformaSource$EnumInterface;
	export const proformaSourceDatatype: X3EnumDataType<keyof ProformaSource$EnumInterface, unknown>;
	//# sourceMappingURL=proforma-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/product-description-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/product-description-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductDescriptionTypeEnum {
	    translatedDescription = 1,
	    openItemInvoiced = 2
	}
	export interface ProductDescriptionType$EnumInterface {
	    translatedDescription: 1;
	    openItemInvoiced: 2;
	}
	export type ProductDescriptionType = keyof ProductDescriptionType$EnumInterface;
	export const productDescriptionTypeDatatype: X3EnumDataType<keyof ProductDescriptionType$EnumInterface, unknown>;
	//# sourceMappingURL=product-description-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/pro-forma-source.d.ts
declare module '@sage/x3-sales-data/lib/enums/pro-forma-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProFormaSourceEnum {
	    quote = 1,
	    fromOrderNo = 2,
	    fromDelivery = 3
	}
	export interface ProFormaSource$EnumInterface {
	    quote: 1;
	    fromOrderNo: 2;
	    fromDelivery: 3;
	}
	export type ProFormaSource = keyof ProFormaSource$EnumInterface;
	export const proFormaSourceDatatype: X3EnumDataType<keyof ProFormaSource$EnumInterface, unknown>;
	//# sourceMappingURL=pro-forma-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/printing-currency.d.ts
declare module '@sage/x3-sales-data/lib/enums/printing-currency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrintingCurrencyEnum {
	    documentCurrency = 1,
	    companyCurrency = 2
	}
	export interface PrintingCurrency$EnumInterface {
	    documentCurrency: 1;
	    companyCurrency: 2;
	}
	export type PrintingCurrency = keyof PrintingCurrency$EnumInterface;
	export const printingCurrencyDatatype: X3EnumDataType<keyof PrintingCurrency$EnumInterface, unknown>;
	//# sourceMappingURL=printing-currency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/price-increase.d.ts
declare module '@sage/x3-sales-data/lib/enums/price-increase' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceIncreaseEnum {
	    copyRecord = 1,
	    modifyRecord = 2,
	    currencyChange = 3
	}
	export interface PriceIncrease$EnumInterface {
	    copyRecord: 1;
	    modifyRecord: 2;
	    currencyChange: 3;
	}
	export type PriceIncrease = keyof PriceIncrease$EnumInterface;
	export const priceIncreaseDatatype: X3EnumDataType<keyof PriceIncrease$EnumInterface, unknown>;
	//# sourceMappingURL=price-increase.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/picking-loc-selection.d.ts
declare module '@sage/x3-sales-data/lib/enums/picking-loc-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickingLocSelectionEnum {
	    priorityPickingLocation = 1,
	    exclusivePickingLocation = 2,
	    no = 3
	}
	export interface PickingLocSelection$EnumInterface {
	    priorityPickingLocation: 1;
	    exclusivePickingLocation: 2;
	    no: 3;
	}
	export type PickingLocSelection = keyof PickingLocSelection$EnumInterface;
	export const pickingLocSelectionDatatype: X3EnumDataType<keyof PickingLocSelection$EnumInterface, unknown>;
	//# sourceMappingURL=picking-loc-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/partial-delivery.d.ts
declare module '@sage/x3-sales-data/lib/enums/partial-delivery' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PartialDeliveryEnum {
	    authorized = 1,
	    completeLine = 2,
	    completeOrder = 3
	}
	export interface PartialDelivery$EnumInterface {
	    authorized: 1;
	    completeLine: 2;
	    completeOrder: 3;
	}
	export type PartialDelivery = keyof PartialDelivery$EnumInterface;
	export const partialDeliveryDatatype: X3EnumDataType<keyof PartialDelivery$EnumInterface, unknown>;
	//# sourceMappingURL=partial-delivery.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/page-break.d.ts
declare module '@sage/x3-sales-data/lib/enums/page-break' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PageBreakEnum {
	    no = 1,
	    yes = 2,
	    yesWithPageBreak = 3
	}
	export interface PageBreak$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesWithPageBreak: 3;
	}
	export type PageBreak = keyof PageBreak$EnumInterface;
	export const pageBreakDatatype: X3EnumDataType<keyof PageBreak$EnumInterface, unknown>;
	//# sourceMappingURL=page-break.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/packing-slip.d.ts
declare module '@sage/x3-sales-data/lib/enums/packing-slip' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingSlipEnum {
	    normal = 1,
	    ready = 2
	}
	export interface PackingSlip$EnumInterface {
	    normal: 1;
	    ready: 2;
	}
	export type PackingSlip = keyof PackingSlip$EnumInterface;
	export const packingSlipDatatype: X3EnumDataType<keyof PackingSlip$EnumInterface, unknown>;
	//# sourceMappingURL=packing-slip.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/origin-date-for-invoicing.d.ts
declare module '@sage/x3-sales-data/lib/enums/origin-date-for-invoicing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginDateForInvoicingEnum {
	    dispatchDate = 1,
	    deliveryDate = 2
	}
	export interface OriginDateForInvoicing$EnumInterface {
	    dispatchDate: 1;
	    deliveryDate: 2;
	}
	export type OriginDateForInvoicing = keyof OriginDateForInvoicing$EnumInterface;
	export const originDateForInvoicingDatatype: X3EnumDataType<keyof OriginDateForInvoicing$EnumInterface, unknown>;
	//# sourceMappingURL=origin-date-for-invoicing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/order-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/order-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderStatusEnum {
	    open = 1,
	    closed = 2
	}
	export interface OrderStatus$EnumInterface {
	    open: 1;
	    closed: 2;
	}
	export type OrderStatus = keyof OrderStatus$EnumInterface;
	export const orderStatusDatatype: X3EnumDataType<keyof OrderStatus$EnumInterface, unknown>;
	//# sourceMappingURL=order-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/order-category.d.ts
declare module '@sage/x3-sales-data/lib/enums/order-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderCategoryEnum {
	    normal = 1,
	    loan = 2,
	    directInvoicing = 3,
	    contract = 4
	}
	export interface OrderCategory$EnumInterface {
	    normal: 1;
	    loan: 2;
	    directInvoicing: 3;
	    contract: 4;
	}
	export type OrderCategory = keyof OrderCategory$EnumInterface;
	export const orderCategoryDatatype: X3EnumDataType<keyof OrderCategory$EnumInterface, unknown>;
	//# sourceMappingURL=order-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/order-category-in-transactions.d.ts
declare module '@sage/x3-sales-data/lib/enums/order-category-in-transactions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderCategoryInTransactionsEnum {
	    normal = 1,
	    loan = 2,
	    directInvoice = 3,
	    allCategories = 4
	}
	export interface OrderCategoryInTransactions$EnumInterface {
	    normal: 1;
	    loan: 2;
	    directInvoice: 3;
	    allCategories: 4;
	}
	export type OrderCategoryInTransactions = keyof OrderCategoryInTransactions$EnumInterface;
	export const orderCategoryInTransactionsDatatype: X3EnumDataType<keyof OrderCategoryInTransactions$EnumInterface, unknown>;
	//# sourceMappingURL=order-category-in-transactions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/order-categorie.d.ts
declare module '@sage/x3-sales-data/lib/enums/order-categorie' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderCategorieEnum {
	    normal = 1,
	    directInvoice = 2
	}
	export interface OrderCategorie$EnumInterface {
	    normal: 1;
	    directInvoice: 2;
	}
	export type OrderCategorie = keyof OrderCategorie$EnumInterface;
	export const orderCategorieDatatype: X3EnumDataType<keyof OrderCategorie$EnumInterface, unknown>;
	//# sourceMappingURL=order-categorie.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/order-cat-except-open.d.ts
declare module '@sage/x3-sales-data/lib/enums/order-cat-except-open' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrderCatExceptOpenEnum {
	    normal = 1,
	    loan = 2,
	    directInvoice = 3
	}
	export interface OrderCatExceptOpen$EnumInterface {
	    normal: 1;
	    loan: 2;
	    directInvoice: 3;
	}
	export type OrderCatExceptOpen = keyof OrderCatExceptOpen$EnumInterface;
	export const orderCatExceptOpenDatatype: X3EnumDataType<keyof OrderCatExceptOpen$EnumInterface, unknown>;
	//# sourceMappingURL=order-cat-except-open.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/open-item-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/open-item-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OpenItemStatusEnum {
	    notPaid = 1,
	    partiallyPaid = 2,
	    totallyPaid = 3
	}
	export interface OpenItemStatus$EnumInterface {
	    notPaid: 1;
	    partiallyPaid: 2;
	    totallyPaid: 3;
	}
	export type OpenItemStatus = keyof OpenItemStatus$EnumInterface;
	export const openItemStatusDatatype: X3EnumDataType<keyof OpenItemStatus$EnumInterface, unknown>;
	//# sourceMappingURL=open-item-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/modification.d.ts
declare module '@sage/x3-sales-data/lib/enums/modification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModificationEnum {
	    no = 1,
	    price = 2,
	    quantity = 3,
	    splitting = 4,
	    grouping = 5,
	    generation = 6
	}
	export interface Modification$EnumInterface {
	    no: 1;
	    price: 2;
	    quantity: 3;
	    splitting: 4;
	    grouping: 5;
	    generation: 6;
	}
	export type Modification = keyof Modification$EnumInterface;
	export const modificationDatatype: X3EnumDataType<keyof Modification$EnumInterface, unknown>;
	//# sourceMappingURL=modification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/line-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineTypeEnum {
	    normal = 1,
	    fixedKit = 2,
	    kitComponent = 3,
	    kitOption = 4,
	    kitVariant = 5,
	    flexKit = 6,
	    bomComponent = 7,
	    bomOption = 8,
	    bomVariant = 9,
	    subcontracted = 10,
	    service = 11,
	    suppliedMaterial = 12,
	    fixedAmountService = 13
	}
	export interface LineType$EnumInterface {
	    normal: 1;
	    fixedKit: 2;
	    kitComponent: 3;
	    kitOption: 4;
	    kitVariant: 5;
	    flexKit: 6;
	    bomComponent: 7;
	    bomOption: 8;
	    bomVariant: 9;
	    subcontracted: 10;
	    service: 11;
	    suppliedMaterial: 12;
	    fixedAmountService: 13;
	}
	export type LineType = keyof LineType$EnumInterface;
	export const lineTypeDatatype: X3EnumDataType<keyof LineType$EnumInterface, unknown>;
	//# sourceMappingURL=line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/line-type-2415.d.ts
declare module '@sage/x3-sales-data/lib/enums/line-type-2415' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineType2415Enum {
	    documentLine = 1,
	    invoicingElement = 2,
	    openItem = 3
	}
	export interface LineType2415$EnumInterface {
	    documentLine: 1;
	    invoicingElement: 2;
	    openItem: 3;
	}
	export type LineType2415 = keyof LineType2415$EnumInterface;
	export const lineType2415Datatype: X3EnumDataType<keyof LineType2415$EnumInterface, unknown>;
	//# sourceMappingURL=line-type-2415.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/line-category.d.ts
declare module '@sage/x3-sales-data/lib/enums/line-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineCategoryEnum {
	    standardAndProduct = 1,
	    componentAndOptionAndVariant = 2
	}
	export interface LineCategory$EnumInterface {
	    standardAndProduct: 1;
	    componentAndOptionAndVariant: 2;
	}
	export type LineCategory = keyof LineCategory$EnumInterface;
	export const lineCategoryDatatype: X3EnumDataType<keyof LineCategory$EnumInterface, unknown>;
	//# sourceMappingURL=line-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/label-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/label-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelTypeEnum {
	    detailLabel = 1,
	    globalLabel = 2
	}
	export interface LabelType$EnumInterface {
	    detailLabel: 1;
	    globalLabel: 2;
	}
	export type LabelType = keyof LabelType$EnumInterface;
	export const labelTypeDatatype: X3EnumDataType<keyof LabelType$EnumInterface, unknown>;
	//# sourceMappingURL=label-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/label-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/label-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelStatusEnum {
	    inProduction = 1,
	    inShipment = 2
	}
	export interface LabelStatus$EnumInterface {
	    inProduction: 1;
	    inShipment: 2;
	}
	export type LabelStatus = keyof LabelStatus$EnumInterface;
	export const labelStatusDatatype: X3EnumDataType<keyof LabelStatus$EnumInterface, unknown>;
	//# sourceMappingURL=label-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/label-format.d.ts
declare module '@sage/x3-sales-data/lib/enums/label-format' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelFormatEnum {
	    large = 1,
	    small = 2
	}
	export interface LabelFormat$EnumInterface {
	    large: 1;
	    small: 2;
	}
	export type LabelFormat = keyof LabelFormat$EnumInterface;
	export const labelFormatDatatype: X3EnumDataType<keyof LabelFormat$EnumInterface, unknown>;
	//# sourceMappingURL=label-format.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoicing-mode.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoicing-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingModeEnum {
	    oneSlip = 1,
	    oneClosedOrder = 2,
	    oneOrder = 3,
	    oneShipTo = 4,
	    onePeriod = 5,
	    manual = 6
	}
	export interface InvoicingMode$EnumInterface {
	    oneSlip: 1;
	    oneClosedOrder: 2;
	    oneOrder: 3;
	    oneShipTo: 4;
	    onePeriod: 5;
	    manual: 6;
	}
	export type InvoicingMode = keyof InvoicingMode$EnumInterface;
	export const invoicingModeDatatype: X3EnumDataType<keyof InvoicingMode$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoicing-method.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoicing-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingMethodEnum {
	    singleOpenItem = 1,
	    oneInvoiceOpenItem = 2,
	    oneInvoiceContract = 3,
	    oneInvoiceCustomer = 4
	}
	export interface InvoicingMethod$EnumInterface {
	    singleOpenItem: 1;
	    oneInvoiceOpenItem: 2;
	    oneInvoiceContract: 3;
	    oneInvoiceCustomer: 4;
	}
	export type InvoicingMethod = keyof InvoicingMethod$EnumInterface;
	export const invoicingMethodDatatype: X3EnumDataType<keyof InvoicingMethod$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoicing-method-2429.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoicing-method-2429' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingMethod2429Enum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface InvoicingMethod2429$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type InvoicingMethod2429 = keyof InvoicingMethod2429$EnumInterface;
	export const invoicingMethod2429Datatype: X3EnumDataType<keyof InvoicingMethod2429$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-method-2429.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoicing-frequency.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoicing-frequency' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoicingFrequencyEnum {
	    perRequest = 1,
	    daily = 2,
	    weekly = 3,
	    substituteValue4 = 4,
	    substituteValue5 = 5,
	    monthly = 6
	}
	export interface InvoicingFrequency$EnumInterface {
	    perRequest: 1;
	    daily: 2;
	    weekly: 3;
	    substituteValue4: 4;
	    substituteValue5: 5;
	    monthly: 6;
	}
	export type InvoicingFrequency = keyof InvoicingFrequency$EnumInterface;
	export const invoicingFrequencyDatatype: X3EnumDataType<keyof InvoicingFrequency$EnumInterface, unknown>;
	//# sourceMappingURL=invoicing-frequency.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoice-validated-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoice-validated-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceValidatedStatusEnum {
	    notValidated = 1,
	    validated = 2
	}
	export interface InvoiceValidatedStatus$EnumInterface {
	    notValidated: 1;
	    validated: 2;
	}
	export type InvoiceValidatedStatus = keyof InvoiceValidatedStatus$EnumInterface;
	export const invoiceValidatedStatusDatatype: X3EnumDataType<keyof InvoiceValidatedStatus$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-validated-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoice-sort.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoice-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceSortEnum {
	    number = 1,
	    dateBillToCustomer = 2
	}
	export interface InvoiceSort$EnumInterface {
	    number: 1;
	    dateBillToCustomer: 2;
	}
	export type InvoiceSort = keyof InvoiceSort$EnumInterface;
	export const invoiceSortDatatype: X3EnumDataType<keyof InvoiceSort$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoice-mode.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoice-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceModeEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4
	}
	export interface InvoiceMode$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	}
	export type InvoiceMode = keyof InvoiceMode$EnumInterface;
	export const invoiceModeDatatype: X3EnumDataType<keyof InvoiceMode$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoice-date.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoice-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceDateEnum {
	    referenceDate = 1,
	    nextInvoiceDate = 2
	}
	export interface InvoiceDate$EnumInterface {
	    referenceDate: 1;
	    nextInvoiceDate: 2;
	}
	export type InvoiceDate = keyof InvoiceDate$EnumInterface;
	export const invoiceDateDatatype: X3EnumDataType<keyof InvoiceDate$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/invoice-date-466.d.ts
declare module '@sage/x3-sales-data/lib/enums/invoice-date-466' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvoiceDate466Enum {
	    referenceDate = 1,
	    closingDate = 2
	}
	export interface InvoiceDate466$EnumInterface {
	    referenceDate: 1;
	    closingDate: 2;
	}
	export type InvoiceDate466 = keyof InvoiceDate466$EnumInterface;
	export const invoiceDate466Datatype: X3EnumDataType<keyof InvoiceDate466$EnumInterface, unknown>;
	//# sourceMappingURL=invoice-date-466.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/inv-elt-trf-ord-to-ship-inv.d.ts
declare module '@sage/x3-sales-data/lib/enums/inv-elt-trf-ord-to-ship-inv' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InvEltTrfOrdToShipInvEnum {
	    first = 1,
	    all = 2
	}
	export interface InvEltTrfOrdToShipInv$EnumInterface {
	    first: 1;
	    all: 2;
	}
	export type InvEltTrfOrdToShipInv = keyof InvEltTrfOrdToShipInv$EnumInterface;
	export const invEltTrfOrdToShipInvDatatype: X3EnumDataType<keyof InvEltTrfOrdToShipInv$EnumInterface, unknown>;
	//# sourceMappingURL=inv-elt-trf-ord-to-ship-inv.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/inquiry-sort.d.ts
declare module '@sage/x3-sales-data/lib/enums/inquiry-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InquirySortEnum {
	    number = 1,
	    date = 2
	}
	export interface InquirySort$EnumInterface {
	    number: 1;
	    date: 2;
	}
	export type InquirySort = keyof InquirySort$EnumInterface;
	export const inquirySortDatatype: X3EnumDataType<keyof InquirySort$EnumInterface, unknown>;
	//# sourceMappingURL=inquiry-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/index.d.ts
declare module '@sage/x3-sales-data/lib/enums/index' {
	export * from '@sage/x3-sales-data/lib/enums/allocation-method-440';
	export * from '@sage/x3-sales-data/lib/enums/allocation-method';
	export * from '@sage/x3-sales-data/lib/enums/amount-type';
	export * from '@sage/x3-sales-data/lib/enums/automatic-shipment-generation-type';
	export * from '@sage/x3-sales-data/lib/enums/category-line-of-component';
	export * from '@sage/x3-sales-data/lib/enums/category-line-of-product';
	export * from '@sage/x3-sales-data/lib/enums/center-role';
	export * from '@sage/x3-sales-data/lib/enums/credit-memo-invoice-control';
	export * from '@sage/x3-sales-data/lib/enums/credit-memo-source-449';
	export * from '@sage/x3-sales-data/lib/enums/credit-memo-source';
	export * from '@sage/x3-sales-data/lib/enums/credit-status';
	export * from '@sage/x3-sales-data/lib/enums/crystal-reports-sales';
	export * from '@sage/x3-sales-data/lib/enums/customer-type';
	export * from '@sage/x3-sales-data/lib/enums/delivery-category';
	export * from '@sage/x3-sales-data/lib/enums/delivery-flow';
	export * from '@sage/x3-sales-data/lib/enums/delivery-priority';
	export * from '@sage/x3-sales-data/lib/enums/distribution-on-lines';
	export * from '@sage/x3-sales-data/lib/enums/due-date-calculation-source';
	export * from '@sage/x3-sales-data/lib/enums/early-late-management-mode';
	export * from '@sage/x3-sales-data/lib/enums/effect-on-the-detail';
	export * from '@sage/x3-sales-data/lib/enums/free';
	export * from '@sage/x3-sales-data/lib/enums/freight-invoicing';
	export * from '@sage/x3-sales-data/lib/enums/grouping-rules';
	export * from '@sage/x3-sales-data/lib/enums/grouping';
	export * from '@sage/x3-sales-data/lib/enums/hold-code-messages';
	export * from '@sage/x3-sales-data/lib/enums/hold-status';
	export * from '@sage/x3-sales-data/lib/enums/increase-type';
	export * from '@sage/x3-sales-data/lib/enums/inquiry-sort';
	export * from '@sage/x3-sales-data/lib/enums/inv-elt-trf-ord-to-ship-inv';
	export * from '@sage/x3-sales-data/lib/enums/invoice-date-466';
	export * from '@sage/x3-sales-data/lib/enums/invoice-date';
	export * from '@sage/x3-sales-data/lib/enums/invoice-mode';
	export * from '@sage/x3-sales-data/lib/enums/invoice-sort';
	export * from '@sage/x3-sales-data/lib/enums/invoice-validated-status';
	export * from '@sage/x3-sales-data/lib/enums/invoicing-frequency';
	export * from '@sage/x3-sales-data/lib/enums/invoicing-method-2429';
	export * from '@sage/x3-sales-data/lib/enums/invoicing-method';
	export * from '@sage/x3-sales-data/lib/enums/invoicing-mode';
	export * from '@sage/x3-sales-data/lib/enums/label-format';
	export * from '@sage/x3-sales-data/lib/enums/label-status';
	export * from '@sage/x3-sales-data/lib/enums/label-type';
	export * from '@sage/x3-sales-data/lib/enums/line-category';
	export * from '@sage/x3-sales-data/lib/enums/line-type-2415';
	export * from '@sage/x3-sales-data/lib/enums/line-type';
	export * from '@sage/x3-sales-data/lib/enums/modification';
	export * from '@sage/x3-sales-data/lib/enums/open-item-status';
	export * from '@sage/x3-sales-data/lib/enums/order-cat-except-open';
	export * from '@sage/x3-sales-data/lib/enums/order-categorie';
	export * from '@sage/x3-sales-data/lib/enums/order-category-in-transactions';
	export * from '@sage/x3-sales-data/lib/enums/order-category';
	export * from '@sage/x3-sales-data/lib/enums/order-status';
	export * from '@sage/x3-sales-data/lib/enums/origin-date-for-invoicing';
	export * from '@sage/x3-sales-data/lib/enums/packing-slip';
	export * from '@sage/x3-sales-data/lib/enums/page-break';
	export * from '@sage/x3-sales-data/lib/enums/partial-delivery';
	export * from '@sage/x3-sales-data/lib/enums/picking-loc-selection';
	export * from '@sage/x3-sales-data/lib/enums/price-increase';
	export * from '@sage/x3-sales-data/lib/enums/printing-currency';
	export * from '@sage/x3-sales-data/lib/enums/pro-forma-source';
	export * from '@sage/x3-sales-data/lib/enums/product-description-type';
	export * from '@sage/x3-sales-data/lib/enums/proforma-source';
	export * from '@sage/x3-sales-data/lib/enums/purchase-journal-type';
	export * from '@sage/x3-sales-data/lib/enums/quote-status';
	export * from '@sage/x3-sales-data/lib/enums/refacturation-chancier';
	export * from '@sage/x3-sales-data/lib/enums/report-code';
	export * from '@sage/x3-sales-data/lib/enums/return-category';
	export * from '@sage/x3-sales-data/lib/enums/return-status';
	export * from '@sage/x3-sales-data/lib/enums/route-code';
	export * from '@sage/x3-sales-data/lib/enums/route-view-type';
	export * from '@sage/x3-sales-data/lib/enums/sales-credit-memo';
	export * from '@sage/x3-sales-data/lib/enums/sales-document-type';
	export * from '@sage/x3-sales-data/lib/enums/sales-rep-commission-base';
	export * from '@sage/x3-sales-data/lib/enums/sales-sort-order-2405';
	export * from '@sage/x3-sales-data/lib/enums/sales-sort-order-2407';
	export * from '@sage/x3-sales-data/lib/enums/sales-sort-order-2408';
	export * from '@sage/x3-sales-data/lib/enums/sales-sort-order';
	export * from '@sage/x3-sales-data/lib/enums/schedule-type-2420';
	export * from '@sage/x3-sales-data/lib/enums/shipment-date-initialization';
	export * from '@sage/x3-sales-data/lib/enums/shipment-transaction-types';
	export * from '@sage/x3-sales-data/lib/enums/shipment-type';
	export * from '@sage/x3-sales-data/lib/enums/signature';
	export * from '@sage/x3-sales-data/lib/enums/source-of-shipment';
	export * from '@sage/x3-sales-data/lib/enums/split-rules';
	export * from '@sage/x3-sales-data/lib/enums/statement-period';
	export * from '@sage/x3-sales-data/lib/enums/status-2419';
	export * from '@sage/x3-sales-data/lib/enums/status-of-invoice';
	export * from '@sage/x3-sales-data/lib/enums/sundry-rules-personalized';
	export * from '@sage/x3-sales-data/lib/enums/sundry-rules-std';
	export * from '@sage/x3-sales-data/lib/enums/tracking-of-customer-text';
	export * from '@sage/x3-sales-data/lib/enums/tracking-of-product-text';
	export * from '@sage/x3-sales-data/lib/enums/transaction-invoice-type';
	export * from '@sage/x3-sales-data/lib/enums/transaction-invoice-types';
	export * from '@sage/x3-sales-data/lib/enums/transaction-type-435';
	export * from '@sage/x3-sales-data/lib/enums/type-of-sales-document';
	export * from '@sage/x3-sales-data/lib/enums/url-type';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/increase-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/increase-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum IncreaseTypeEnum {
	    notModified = 1,
	    variationIn = 2,
	    variationInValue = 3,
	    assignment = 4
	}
	export interface IncreaseType$EnumInterface {
	    notModified: 1;
	    variationIn: 2;
	    variationInValue: 3;
	    assignment: 4;
	}
	export type IncreaseType = keyof IncreaseType$EnumInterface;
	export const increaseTypeDatatype: X3EnumDataType<keyof IncreaseType$EnumInterface, unknown>;
	//# sourceMappingURL=increase-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/hold-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/hold-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HoldStatusEnum {
	    ok = 1,
	    onHold = 2
	}
	export interface HoldStatus$EnumInterface {
	    ok: 1;
	    onHold: 2;
	}
	export type HoldStatus = keyof HoldStatus$EnumInterface;
	export const holdStatusDatatype: X3EnumDataType<keyof HoldStatus$EnumInterface, unknown>;
	//# sourceMappingURL=hold-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/hold-code-messages.d.ts
declare module '@sage/x3-sales-data/lib/enums/hold-code-messages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum HoldCodeMessagesEnum {
	    unableToUpdateOrderHoldStatus = 1,
	    invalidOrderHoldCode = 2,
	    unableToReadOrderHoldCode = 3,
	    holdWasReleased = 4,
	    orderPartiallyShippedOrInvoicedContinueWithHold = 5,
	    holdCancelledByUser = 6,
	    automaticDeallocationDueToOrderHold = 7,
	    unableToReadSalesOrder = 8,
	    errorRewritingSoh = 9,
	    heldOn = 10,
	    releasedOn = 11,
	    releaseFromOrderHold = 12,
	    manualOrderHoldCannotAllocate = 13,
	    manualOrderHold = 14,
	    manualOrderHoldCannotShip = 15,
	    manualOrderHoldCannotInvoice = 16,
	    manualOrderHoldNoProformaAllowed = 17,
	    manualOrderHoldNoPreparationAllowed = 18,
	    releaseFromCreditHold = 19,
	    unableToUpdateOrderCreditStatus = 20,
	    creditStatusUpdated = 21,
	    youDoNotHaveAccessRightsToReleaseThisOrder = 22,
	    thisOrderIsNotBlocked = 23,
	    thisOrderIsNotBlockedDueToAnExceededCreditLevel = 24,
	    thisOrderIsNotBlockedDueToAnUnpaidPrepayment = 25
	}
	export interface HoldCodeMessages$EnumInterface {
	    unableToUpdateOrderHoldStatus: 1;
	    invalidOrderHoldCode: 2;
	    unableToReadOrderHoldCode: 3;
	    holdWasReleased: 4;
	    orderPartiallyShippedOrInvoicedContinueWithHold: 5;
	    holdCancelledByUser: 6;
	    automaticDeallocationDueToOrderHold: 7;
	    unableToReadSalesOrder: 8;
	    errorRewritingSoh: 9;
	    heldOn: 10;
	    releasedOn: 11;
	    releaseFromOrderHold: 12;
	    manualOrderHoldCannotAllocate: 13;
	    manualOrderHold: 14;
	    manualOrderHoldCannotShip: 15;
	    manualOrderHoldCannotInvoice: 16;
	    manualOrderHoldNoProformaAllowed: 17;
	    manualOrderHoldNoPreparationAllowed: 18;
	    releaseFromCreditHold: 19;
	    unableToUpdateOrderCreditStatus: 20;
	    creditStatusUpdated: 21;
	    youDoNotHaveAccessRightsToReleaseThisOrder: 22;
	    thisOrderIsNotBlocked: 23;
	    thisOrderIsNotBlockedDueToAnExceededCreditLevel: 24;
	    thisOrderIsNotBlockedDueToAnUnpaidPrepayment: 25;
	}
	export type HoldCodeMessages = keyof HoldCodeMessages$EnumInterface;
	export const holdCodeMessagesDatatype: X3EnumDataType<keyof HoldCodeMessages$EnumInterface, unknown>;
	//# sourceMappingURL=hold-code-messages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/grouping.d.ts
declare module '@sage/x3-sales-data/lib/enums/grouping' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupingEnum {
	    yes = 1,
	    noIfDifferent = 2
	}
	export interface Grouping$EnumInterface {
	    yes: 1;
	    noIfDifferent: 2;
	}
	export type Grouping = keyof Grouping$EnumInterface;
	export const groupingDatatype: X3EnumDataType<keyof Grouping$EnumInterface, unknown>;
	//# sourceMappingURL=grouping.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/grouping-rules.d.ts
declare module '@sage/x3-sales-data/lib/enums/grouping-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum GroupingRulesEnum {
	    substituteValue1 = 1,
	    substituteValue2 = 2,
	    substituteValue3 = 3,
	    substituteValue4 = 4,
	    quoteAmountSum = 5,
	    orderAmountSum = 6,
	    deliveryAmountSum = 7,
	    invoiceAmountSum = 8,
	    minAmount = 9,
	    maxAmount = 10,
	    minPercentage = 11,
	    maxPercentage = 12,
	    averagePercentage = 13,
	    substituteValue14 = 14,
	    returnAmountSum = 15,
	    substituteValue16 = 16,
	    serviceContractAmountSum = 17
	}
	export interface GroupingRules$EnumInterface {
	    substituteValue1: 1;
	    substituteValue2: 2;
	    substituteValue3: 3;
	    substituteValue4: 4;
	    quoteAmountSum: 5;
	    orderAmountSum: 6;
	    deliveryAmountSum: 7;
	    invoiceAmountSum: 8;
	    minAmount: 9;
	    maxAmount: 10;
	    minPercentage: 11;
	    maxPercentage: 12;
	    averagePercentage: 13;
	    substituteValue14: 14;
	    returnAmountSum: 15;
	    substituteValue16: 16;
	    serviceContractAmountSum: 17;
	}
	export type GroupingRules = keyof GroupingRules$EnumInterface;
	export const groupingRulesDatatype: X3EnumDataType<keyof GroupingRules$EnumInterface, unknown>;
	//# sourceMappingURL=grouping-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/freight-invoicing.d.ts
declare module '@sage/x3-sales-data/lib/enums/freight-invoicing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreightInvoicingEnum {
	    invoiced = 1,
	    notInvoiced = 2,
	    upToThreshold1 = 3,
	    upToThreshold2 = 4,
	    upToThreshold3 = 5,
	    upToThreshold4 = 6,
	    upToThreshold5 = 7
	}
	export interface FreightInvoicing$EnumInterface {
	    invoiced: 1;
	    notInvoiced: 2;
	    upToThreshold1: 3;
	    upToThreshold2: 4;
	    upToThreshold3: 5;
	    upToThreshold4: 6;
	    upToThreshold5: 7;
	}
	export type FreightInvoicing = keyof FreightInvoicing$EnumInterface;
	export const freightInvoicingDatatype: X3EnumDataType<keyof FreightInvoicing$EnumInterface, unknown>;
	//# sourceMappingURL=freight-invoicing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/free.d.ts
declare module '@sage/x3-sales-data/lib/enums/free' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FreeEnum {
	    no = 1,
	    source = 2,
	    yes = 3
	}
	export interface Free$EnumInterface {
	    no: 1;
	    source: 2;
	    yes: 3;
	}
	export type Free = keyof Free$EnumInterface;
	export const freeDatatype: X3EnumDataType<keyof Free$EnumInterface, unknown>;
	//# sourceMappingURL=free.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/effect-on-the-detail.d.ts
declare module '@sage/x3-sales-data/lib/enums/effect-on-the-detail' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EffectOnTheDetailEnum {
	    no = 1,
	    yes = 2,
	    onlyIfSameValue = 3
	}
	export interface EffectOnTheDetail$EnumInterface {
	    no: 1;
	    yes: 2;
	    onlyIfSameValue: 3;
	}
	export type EffectOnTheDetail = keyof EffectOnTheDetail$EnumInterface;
	export const effectOnTheDetailDatatype: X3EnumDataType<keyof EffectOnTheDetail$EnumInterface, unknown>;
	//# sourceMappingURL=effect-on-the-detail.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/early-late-management-mode.d.ts
declare module '@sage/x3-sales-data/lib/enums/early-late-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EarlyLateManagementModeEnum {
	    updateTotalEarlyLate = 1,
	    updateNextDeliveryRequest = 2
	}
	export interface EarlyLateManagementMode$EnumInterface {
	    updateTotalEarlyLate: 1;
	    updateNextDeliveryRequest: 2;
	}
	export type EarlyLateManagementMode = keyof EarlyLateManagementMode$EnumInterface;
	export const earlyLateManagementModeDatatype: X3EnumDataType<keyof EarlyLateManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=early-late-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/due-date-calculation-source.d.ts
declare module '@sage/x3-sales-data/lib/enums/due-date-calculation-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DueDateCalculationSourceEnum {
	    invoiceDate = 1,
	    shipmentDate = 2
	}
	export interface DueDateCalculationSource$EnumInterface {
	    invoiceDate: 1;
	    shipmentDate: 2;
	}
	export type DueDateCalculationSource = keyof DueDateCalculationSource$EnumInterface;
	export const dueDateCalculationSourceDatatype: X3EnumDataType<keyof DueDateCalculationSource$EnumInterface, unknown>;
	//# sourceMappingURL=due-date-calculation-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/distribution-on-lines.d.ts
declare module '@sage/x3-sales-data/lib/enums/distribution-on-lines' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DistributionOnLinesEnum {
	    no = 1,
	    quantityProRata = 2,
	    amountProRata = 3,
	    weightProRata = 4,
	    volumeProRata = 5
	}
	export interface DistributionOnLines$EnumInterface {
	    no: 1;
	    quantityProRata: 2;
	    amountProRata: 3;
	    weightProRata: 4;
	    volumeProRata: 5;
	}
	export type DistributionOnLines = keyof DistributionOnLines$EnumInterface;
	export const distributionOnLinesDatatype: X3EnumDataType<keyof DistributionOnLines$EnumInterface, unknown>;
	//# sourceMappingURL=distribution-on-lines.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/delivery-priority.d.ts
declare module '@sage/x3-sales-data/lib/enums/delivery-priority' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryPriorityEnum {
	    normal = 1,
	    urgent = 2,
	    critical = 3
	}
	export interface DeliveryPriority$EnumInterface {
	    normal: 1;
	    urgent: 2;
	    critical: 3;
	}
	export type DeliveryPriority = keyof DeliveryPriority$EnumInterface;
	export const deliveryPriorityDatatype: X3EnumDataType<keyof DeliveryPriority$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-priority.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/delivery-flow.d.ts
declare module '@sage/x3-sales-data/lib/enums/delivery-flow' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryFlowEnum {
	    delivery = 1,
	    return = 2
	}
	export interface DeliveryFlow$EnumInterface {
	    delivery: 1;
	    return: 2;
	}
	export type DeliveryFlow = keyof DeliveryFlow$EnumInterface;
	export const deliveryFlowDatatype: X3EnumDataType<keyof DeliveryFlow$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-flow.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/delivery-category.d.ts
declare module '@sage/x3-sales-data/lib/enums/delivery-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DeliveryCategoryEnum {
	    normal = 1,
	    loan = 2,
	    forSubcontract = 3,
	    nonbillable = 4
	}
	export interface DeliveryCategory$EnumInterface {
	    normal: 1;
	    loan: 2;
	    forSubcontract: 3;
	    nonbillable: 4;
	}
	export type DeliveryCategory = keyof DeliveryCategory$EnumInterface;
	export const deliveryCategoryDatatype: X3EnumDataType<keyof DeliveryCategory$EnumInterface, unknown>;
	//# sourceMappingURL=delivery-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/customer-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/customer-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CustomerTypeEnum {
	    normal = 1,
	    miscellaneous = 2,
	    intraCompany = 3,
	    prospect = 4
	}
	export interface CustomerType$EnumInterface {
	    normal: 1;
	    miscellaneous: 2;
	    intraCompany: 3;
	    prospect: 4;
	}
	export type CustomerType = keyof CustomerType$EnumInterface;
	export const customerTypeDatatype: X3EnumDataType<keyof CustomerType$EnumInterface, unknown>;
	//# sourceMappingURL=customer-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/crystal-reports-sales.d.ts
declare module '@sage/x3-sales-data/lib/enums/crystal-reports-sales' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportsSalesEnum {
	    free = 1,
	    option = 2,
	    kit = 3,
	    netAmountTaxExcluded = 4,
	    netAmountTaxIncluded = 5,
	    netPriceTaxExcluded = 6,
	    netPriTaxIncluded = 7,
	    totalTaxExcluded = 8,
	    totalTaxIncluded = 9,
	    taxExcludedProduct = 10,
	    taxIncludedProduct = 11,
	    invoice = 12,
	    creditMemo = 13,
	    proforma = 14,
	    taxExcludedTotal = 15,
	    taxIncludedTotal = 16,
	    upTo = 17,
	    startingFrom = 18,
	    from = 19,
	    to = 20,
	    grossPriTaxExcluded = 21,
	    grossPriceTaxIncluded = 22,
	    phone = 23,
	    fax = 24,
	    euTaxNumber = 25,
	    entryNumber = 26,
	    date = 27,
	    customer = 28,
	    reference = 29,
	    orderNumber = 30,
	    deliveryMode = 31,
	    carrier = 32,
	    product = 33,
	    quantity = 34,
	    tax = 35,
	    transfer = 36,
	    deliveryNumber = 37,
	    deliveredOn = 38,
	    toBeTransferred = 39,
	    vatAmount = 40,
	    requestedPrepayments41 = 41,
	    netPayable = 42,
	    openItem = 43,
	    paymentMethod = 44,
	    remainToPay = 45,
	    paidAmount = 46,
	    amount = 47,
	    vatBasis = 48,
	    rate = 49,
	    seeGeneralSalesConditions = 50,
	    latePaymentPenaltiesYearlyRate = 51,
	    discountForEarlyPaymentMonthlyRate = 52,
	    orderReceiptAcknowledgement = 53,
	    paymentTerms = 54,
	    deliveryDate = 55,
	    packingSlip = 56,
	    shippingDate = 57,
	    taxExemptionArticle262Ter1OfTheGeneralTaxCode = 58,
	    withACapitalOf = 59,
	    noDiscountForEarlyPayment = 60,
	    numberOfParcels = 61,
	    totalGrossWeight62 = 62,
	    totalNetWeight = 63,
	    quote = 64,
	    validityDate = 65,
	    acknowledgementOfReceiptOpenOrder = 66,
	    productCustomer = 67,
	    plannedQuantity = 68,
	    plannedAmount = 69,
	    consumptionPlace = 70,
	    shippedTo = 71,
	    sic = 72,
	    orderedQuantity = 73,
	    receivedQuantity = 74,
	    receivedOn = 75,
	    priceListTerms = 76,
	    deliveryProgram = 77,
	    priceListApplicationDates = 78,
	    start = 79,
	    end = 80,
	    grossPrice = 81,
	    netPrice = 82,
	    deliveryDates = 83,
	    requested = 84,
	    planned = 85,
	    status = 86,
	    report = 87,
	    recipient = 88,
	    sender = 89,
	    yourReference = 90,
	    parcelType = 91,
	    parcelNumber = 92,
	    totalGrossWeight = 93,
	    prepaymentRequest = 94,
	    dated = 95,
	    in = 96,
	    pursuantToTheOrder = 97,
	    payableOn = 98,
	    requestedPrepayments = 99,
	    expenseDiscount = 100,
	    taxExcludedLineTotal = 101,
	    taxIncludedLineTotal = 102,
	    includeVat = 103,
	    lot = 104,
	    sublot = 105,
	    serialNumber = 106,
	    originalInvoice = 107,
	    taxBasis = 108,
	    taxAmount = 109,
	    taxesAmount = 110,
	    amountOfSubmittedTax = 111,
	    vatAmountInEuros = 112,
	    amountOfNonSubmittedTax = 113,
	    ofWhichSubmittedTax = 114,
	    ofWhichNonSubmittedTax = 115,
	    ofWhichVatInEuros = 116,
	    otherOpenItems = 117,
	    sepaCreditorId = 118,
	    mandatRef = 119,
	    taxInvoice = 120,
	    computerGenerated = 121,
	    endingSerialNumber = 122,
	    rexNumber = 123
	}
	export interface CrystalReportsSales$EnumInterface {
	    free: 1;
	    option: 2;
	    kit: 3;
	    netAmountTaxExcluded: 4;
	    netAmountTaxIncluded: 5;
	    netPriceTaxExcluded: 6;
	    netPriTaxIncluded: 7;
	    totalTaxExcluded: 8;
	    totalTaxIncluded: 9;
	    taxExcludedProduct: 10;
	    taxIncludedProduct: 11;
	    invoice: 12;
	    creditMemo: 13;
	    proforma: 14;
	    taxExcludedTotal: 15;
	    taxIncludedTotal: 16;
	    upTo: 17;
	    startingFrom: 18;
	    from: 19;
	    to: 20;
	    grossPriTaxExcluded: 21;
	    grossPriceTaxIncluded: 22;
	    phone: 23;
	    fax: 24;
	    euTaxNumber: 25;
	    entryNumber: 26;
	    date: 27;
	    customer: 28;
	    reference: 29;
	    orderNumber: 30;
	    deliveryMode: 31;
	    carrier: 32;
	    product: 33;
	    quantity: 34;
	    tax: 35;
	    transfer: 36;
	    deliveryNumber: 37;
	    deliveredOn: 38;
	    toBeTransferred: 39;
	    vatAmount: 40;
	    requestedPrepayments41: 41;
	    netPayable: 42;
	    openItem: 43;
	    paymentMethod: 44;
	    remainToPay: 45;
	    paidAmount: 46;
	    amount: 47;
	    vatBasis: 48;
	    rate: 49;
	    seeGeneralSalesConditions: 50;
	    latePaymentPenaltiesYearlyRate: 51;
	    discountForEarlyPaymentMonthlyRate: 52;
	    orderReceiptAcknowledgement: 53;
	    paymentTerms: 54;
	    deliveryDate: 55;
	    packingSlip: 56;
	    shippingDate: 57;
	    taxExemptionArticle262Ter1OfTheGeneralTaxCode: 58;
	    withACapitalOf: 59;
	    noDiscountForEarlyPayment: 60;
	    numberOfParcels: 61;
	    totalGrossWeight62: 62;
	    totalNetWeight: 63;
	    quote: 64;
	    validityDate: 65;
	    acknowledgementOfReceiptOpenOrder: 66;
	    productCustomer: 67;
	    plannedQuantity: 68;
	    plannedAmount: 69;
	    consumptionPlace: 70;
	    shippedTo: 71;
	    sic: 72;
	    orderedQuantity: 73;
	    receivedQuantity: 74;
	    receivedOn: 75;
	    priceListTerms: 76;
	    deliveryProgram: 77;
	    priceListApplicationDates: 78;
	    start: 79;
	    end: 80;
	    grossPrice: 81;
	    netPrice: 82;
	    deliveryDates: 83;
	    requested: 84;
	    planned: 85;
	    status: 86;
	    report: 87;
	    recipient: 88;
	    sender: 89;
	    yourReference: 90;
	    parcelType: 91;
	    parcelNumber: 92;
	    totalGrossWeight: 93;
	    prepaymentRequest: 94;
	    dated: 95;
	    in: 96;
	    pursuantToTheOrder: 97;
	    payableOn: 98;
	    requestedPrepayments: 99;
	    expenseDiscount: 100;
	    taxExcludedLineTotal: 101;
	    taxIncludedLineTotal: 102;
	    includeVat: 103;
	    lot: 104;
	    sublot: 105;
	    serialNumber: 106;
	    originalInvoice: 107;
	    taxBasis: 108;
	    taxAmount: 109;
	    taxesAmount: 110;
	    amountOfSubmittedTax: 111;
	    vatAmountInEuros: 112;
	    amountOfNonSubmittedTax: 113;
	    ofWhichSubmittedTax: 114;
	    ofWhichNonSubmittedTax: 115;
	    ofWhichVatInEuros: 116;
	    otherOpenItems: 117;
	    sepaCreditorId: 118;
	    mandatRef: 119;
	    taxInvoice: 120;
	    computerGenerated: 121;
	    endingSerialNumber: 122;
	    rexNumber: 123;
	}
	export type CrystalReportsSales = keyof CrystalReportsSales$EnumInterface;
	export const crystalReportsSalesDatatype: X3EnumDataType<keyof CrystalReportsSales$EnumInterface, unknown>;
	//# sourceMappingURL=crystal-reports-sales.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/credit-status.d.ts
declare module '@sage/x3-sales-data/lib/enums/credit-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreditStatusEnum {
	    ok = 1,
	    onHold = 2,
	    limitExceeded = 3,
	    prepaymentNotPaid = 4,
	    creditCard = 5
	}
	export interface CreditStatus$EnumInterface {
	    ok: 1;
	    onHold: 2;
	    limitExceeded: 3;
	    prepaymentNotPaid: 4;
	    creditCard: 5;
	}
	export type CreditStatus = keyof CreditStatus$EnumInterface;
	export const creditStatusDatatype: X3EnumDataType<keyof CreditStatus$EnumInterface, unknown>;
	//# sourceMappingURL=credit-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/credit-memo-source.d.ts
declare module '@sage/x3-sales-data/lib/enums/credit-memo-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreditMemoSourceEnum {
	    direct = 1,
	    invoice = 2,
	    return = 3
	}
	export interface CreditMemoSource$EnumInterface {
	    direct: 1;
	    invoice: 2;
	    return: 3;
	}
	export type CreditMemoSource = keyof CreditMemoSource$EnumInterface;
	export const creditMemoSourceDatatype: X3EnumDataType<keyof CreditMemoSource$EnumInterface, unknown>;
	//# sourceMappingURL=credit-memo-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/credit-memo-source-449.d.ts
declare module '@sage/x3-sales-data/lib/enums/credit-memo-source-449' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreditMemoSource449Enum {
	    direct = 1,
	    invoice = 2
	}
	export interface CreditMemoSource449$EnumInterface {
	    direct: 1;
	    invoice: 2;
	}
	export type CreditMemoSource449 = keyof CreditMemoSource449$EnumInterface;
	export const creditMemoSource449Datatype: X3EnumDataType<keyof CreditMemoSource449$EnumInterface, unknown>;
	//# sourceMappingURL=credit-memo-source-449.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/credit-memo-invoice-control.d.ts
declare module '@sage/x3-sales-data/lib/enums/credit-memo-invoice-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CreditMemoInvoiceControlEnum {
	    noControl = 1,
	    nonblockingControl = 2,
	    blockingControl = 3
	}
	export interface CreditMemoInvoiceControl$EnumInterface {
	    noControl: 1;
	    nonblockingControl: 2;
	    blockingControl: 3;
	}
	export type CreditMemoInvoiceControl = keyof CreditMemoInvoiceControl$EnumInterface;
	export const creditMemoInvoiceControlDatatype: X3EnumDataType<keyof CreditMemoInvoiceControl$EnumInterface, unknown>;
	//# sourceMappingURL=credit-memo-invoice-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/center-role.d.ts
declare module '@sage/x3-sales-data/lib/enums/center-role' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CenterRoleEnum {
	    accountingOffice = 1,
	    managementOrgan = 2,
	    processingUnit = 3,
	    proposingOrgan = 4
	}
	export interface CenterRole$EnumInterface {
	    accountingOffice: 1;
	    managementOrgan: 2;
	    processingUnit: 3;
	    proposingOrgan: 4;
	}
	export type CenterRole = keyof CenterRole$EnumInterface;
	export const centerRoleDatatype: X3EnumDataType<keyof CenterRole$EnumInterface, unknown>;
	//# sourceMappingURL=center-role.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/category-line-of-product.d.ts
declare module '@sage/x3-sales-data/lib/enums/category-line-of-product' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CategoryLineOfProductEnum {
	    standardLine = 1,
	    kitLine = 2,
	    bomLine = 3
	}
	export interface CategoryLineOfProduct$EnumInterface {
	    standardLine: 1;
	    kitLine: 2;
	    bomLine: 3;
	}
	export type CategoryLineOfProduct = keyof CategoryLineOfProduct$EnumInterface;
	export const categoryLineOfProductDatatype: X3EnumDataType<keyof CategoryLineOfProduct$EnumInterface, unknown>;
	//# sourceMappingURL=category-line-of-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/category-line-of-component.d.ts
declare module '@sage/x3-sales-data/lib/enums/category-line-of-component' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CategoryLineOfComponentEnum {
	    component = 1,
	    option = 2,
	    variant = 3
	}
	export interface CategoryLineOfComponent$EnumInterface {
	    component: 1;
	    option: 2;
	    variant: 3;
	}
	export type CategoryLineOfComponent = keyof CategoryLineOfComponent$EnumInterface;
	export const categoryLineOfComponentDatatype: X3EnumDataType<keyof CategoryLineOfComponent$EnumInterface, unknown>;
	//# sourceMappingURL=category-line-of-component.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/automatic-shipment-generation-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/automatic-shipment-generation-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AutomaticShipmentGenerationTypeEnum {
	    order = 1,
	    preparation = 2
	}
	export interface AutomaticShipmentGenerationType$EnumInterface {
	    order: 1;
	    preparation: 2;
	}
	export type AutomaticShipmentGenerationType = keyof AutomaticShipmentGenerationType$EnumInterface;
	export const automaticShipmentGenerationTypeDatatype: X3EnumDataType<keyof AutomaticShipmentGenerationType$EnumInterface, unknown>;
	//# sourceMappingURL=automatic-shipment-generation-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/amount-type.d.ts
declare module '@sage/x3-sales-data/lib/enums/amount-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AmountTypeEnum {
	    positive = 1,
	    negative = 2
	}
	export interface AmountType$EnumInterface {
	    positive: 1;
	    negative: 2;
	}
	export type AmountType = keyof AmountType$EnumInterface;
	export const amountTypeDatatype: X3EnumDataType<keyof AmountType$EnumInterface, unknown>;
	//# sourceMappingURL=amount-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/allocation-method.d.ts
declare module '@sage/x3-sales-data/lib/enums/allocation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationMethodEnum {
	    automatic = 1,
	    manual = 2,
	    bySelection = 3
	}
	export interface AllocationMethod$EnumInterface {
	    automatic: 1;
	    manual: 2;
	    bySelection: 3;
	}
	export type AllocationMethod = keyof AllocationMethod$EnumInterface;
	export const allocationMethodDatatype: X3EnumDataType<keyof AllocationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-sales-data/build/lib/enums/allocation-method-440.d.ts
declare module '@sage/x3-sales-data/lib/enums/allocation-method-440' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationMethod440Enum {
	    automatic = 1,
	    manual = 2
	}
	export interface AllocationMethod440$EnumInterface {
	    automatic: 1;
	    manual: 2;
	}
	export type AllocationMethod440 = keyof AllocationMethod440$EnumInterface;
	export const allocationMethod440Datatype: X3EnumDataType<keyof AllocationMethod440$EnumInterface, unknown>;
	//# sourceMappingURL=allocation-method-440.d.ts.map
}
declare module '@sage/x3-sales-data' {
	export * from '@sage/x3-sales-data/index';
}
