declare module '@sage/x3-sales-data-api-partial' {
    import type {
        CustomerInvoiceHeaderBillToCustomerAddressLines,
        CustomerInvoiceHeaderBillToCustomerAddressLinesBinding,
        CustomerInvoiceHeaderBillToCustomerAddressLinesInput,
        CustomerInvoiceHeaderBillToCustomerCompanyNames,
        CustomerInvoiceHeaderBillToCustomerCompanyNamesBinding,
        CustomerInvoiceHeaderBillToCustomerCompanyNamesInput,
        CustomerInvoiceHeaderComments,
        CustomerInvoiceHeaderCommentsBinding,
        CustomerInvoiceHeaderCommentsInput,
        CustomerInvoiceHeaderInput,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLines,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesBinding,
        CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesBinding,
        CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput,
        CustomerInvoiceHeaderTaxes,
        CustomerInvoiceHeaderTaxesBinding,
        CustomerInvoiceHeaderTaxesInput,
        EarlyDiscountLateCharge,
        Mandate,
        Package as SageX3InvoicingData$Package,
        PaymentTerm,
        ProductTaxLevels,
        ProductTaxLevelsBinding,
        ProductTaxLevelsInput,
        TaxRule,
    } from '@sage/x3-invoicing-data-api';
    import type {
        Address,
        BomCodes,
        BusinessPartner,
        BusinessPartnerAddress,
        Carrier,
        Currency,
        Customer,
        CustomerAddress,
        CustomerProduct,
        CustomerProductInput,
        Incoterm,
        Package as SageX3MasterData$Package,
        Product,
        ProductCategory,
        ProductInput,
        ProductPackingUnits,
        ProductPackingUnitsBinding,
        ProductPackingUnitsInput,
        ProductSite,
        ProductStatisticalGroups,
        ProductStatisticalGroupsBinding,
        ProductStatisticalGroupsInput,
        ShipToCustomerAddressCompanyNames,
        ShipToCustomerAddressCompanyNamesBinding,
        ShipToCustomerAddressCompanyNamesInput,
        ShipToCustomerAddressSalesReps,
        ShipToCustomerAddressSalesRepsBinding,
        ShipToCustomerAddressSalesRepsInput,
        SupplierProduct,
        SupplierProductInput,
        UnavailablePeriods,
        UnitOfMeasure,
    } from '@sage/x3-master-data-api';
    import type { Package as SageX3PhysicalFlowsData$Package, Packaging } from '@sage/x3-physical-flows-data-api';
    import type {
        CostType,
        Package as SageX3ProjectManagementData$Package,
        ProjectLink,
    } from '@sage/x3-project-management-data-api';
    import type { Package as SageX3StockData$Package, Warehouse } from '@sage/x3-stock-data-api';
    import type { Country, Package as SageX3Structure$Package } from '@sage/x3-structure-api';
    import type {
        Access,
        Company,
        GenericPrintReport,
        Language,
        MiscellaneousTable,
        Package as SageX3System$Package,
        Site,
        User,
    } from '@sage/x3-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        TextStream,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AllocationMethod440$Enum {
        automatic: 1;
        manual: 2;
    }
    export type AllocationMethod440 = keyof AllocationMethod440$Enum;
    export interface AllocationMethod$Enum {
        automatic: 1;
        manual: 2;
        bySelection: 3;
    }
    export type AllocationMethod = keyof AllocationMethod$Enum;
    export interface AmountType$Enum {
        positive: 1;
        negative: 2;
    }
    export type AmountType = keyof AmountType$Enum;
    export interface AutomaticShipmentGenerationType$Enum {
        order: 1;
        preparation: 2;
    }
    export type AutomaticShipmentGenerationType = keyof AutomaticShipmentGenerationType$Enum;
    export interface CategoryLineOfComponent$Enum {
        component: 1;
        option: 2;
        variant: 3;
    }
    export type CategoryLineOfComponent = keyof CategoryLineOfComponent$Enum;
    export interface CategoryLineOfProduct$Enum {
        standardLine: 1;
        kitLine: 2;
        bomLine: 3;
    }
    export type CategoryLineOfProduct = keyof CategoryLineOfProduct$Enum;
    export interface CenterRole$Enum {
        accountingOffice: 1;
        managementOrgan: 2;
        processingUnit: 3;
        proposingOrgan: 4;
    }
    export type CenterRole = keyof CenterRole$Enum;
    export interface CreditMemoInvoiceControl$Enum {
        noControl: 1;
        nonblockingControl: 2;
        blockingControl: 3;
    }
    export type CreditMemoInvoiceControl = keyof CreditMemoInvoiceControl$Enum;
    export interface CreditMemoSource449$Enum {
        direct: 1;
        invoice: 2;
    }
    export type CreditMemoSource449 = keyof CreditMemoSource449$Enum;
    export interface CreditMemoSource$Enum {
        direct: 1;
        invoice: 2;
        return: 3;
    }
    export type CreditMemoSource = keyof CreditMemoSource$Enum;
    export interface CreditStatus$Enum {
        ok: 1;
        onHold: 2;
        limitExceeded: 3;
        prepaymentNotPaid: 4;
        creditCard: 5;
    }
    export type CreditStatus = keyof CreditStatus$Enum;
    export interface CrystalReportsSales$Enum {
        free: 1;
        option: 2;
        kit: 3;
        netAmountTaxExcluded: 4;
        netAmountTaxIncluded: 5;
        netPriceTaxExcluded: 6;
        netPriTaxIncluded: 7;
        totalTaxExcluded: 8;
        totalTaxIncluded: 9;
        taxExcludedProduct: 10;
        taxIncludedProduct: 11;
        invoice: 12;
        creditMemo: 13;
        proforma: 14;
        taxExcludedTotal: 15;
        taxIncludedTotal: 16;
        upTo: 17;
        startingFrom: 18;
        from: 19;
        to: 20;
        grossPriTaxExcluded: 21;
        grossPriceTaxIncluded: 22;
        phone: 23;
        fax: 24;
        euTaxNumber: 25;
        entryNumber: 26;
        date: 27;
        customer: 28;
        reference: 29;
        orderNumber: 30;
        deliveryMode: 31;
        carrier: 32;
        product: 33;
        quantity: 34;
        tax: 35;
        transfer: 36;
        deliveryNumber: 37;
        deliveredOn: 38;
        toBeTransferred: 39;
        vatAmount: 40;
        requestedPrepayments41: 41;
        netPayable: 42;
        openItem: 43;
        paymentMethod: 44;
        remainToPay: 45;
        paidAmount: 46;
        amount: 47;
        vatBasis: 48;
        rate: 49;
        seeGeneralSalesConditions: 50;
        latePaymentPenaltiesYearlyRate: 51;
        discountForEarlyPaymentMonthlyRate: 52;
        orderReceiptAcknowledgement: 53;
        paymentTerms: 54;
        deliveryDate: 55;
        packingSlip: 56;
        shippingDate: 57;
        taxExemptionArticle262Ter1OfTheGeneralTaxCode: 58;
        withACapitalOf: 59;
        noDiscountForEarlyPayment: 60;
        numberOfParcels: 61;
        totalGrossWeight62: 62;
        totalNetWeight: 63;
        quote: 64;
        validityDate: 65;
        acknowledgementOfReceiptOpenOrder: 66;
        productCustomer: 67;
        plannedQuantity: 68;
        plannedAmount: 69;
        consumptionPlace: 70;
        shippedTo: 71;
        sic: 72;
        orderedQuantity: 73;
        receivedQuantity: 74;
        receivedOn: 75;
        priceListTerms: 76;
        deliveryProgram: 77;
        priceListApplicationDates: 78;
        start: 79;
        end: 80;
        grossPrice: 81;
        netPrice: 82;
        deliveryDates: 83;
        requested: 84;
        planned: 85;
        status: 86;
        report: 87;
        recipient: 88;
        sender: 89;
        yourReference: 90;
        parcelType: 91;
        parcelNumber: 92;
        totalGrossWeight: 93;
        prepaymentRequest: 94;
        dated: 95;
        in: 96;
        pursuantToTheOrder: 97;
        payableOn: 98;
        requestedPrepayments: 99;
        expenseDiscount: 100;
        taxExcludedLineTotal: 101;
        taxIncludedLineTotal: 102;
        includeVat: 103;
        lot: 104;
        sublot: 105;
        serialNumber: 106;
        originalInvoice: 107;
        taxBasis: 108;
        taxAmount: 109;
        taxesAmount: 110;
        amountOfSubmittedTax: 111;
        vatAmountInEuros: 112;
        amountOfNonSubmittedTax: 113;
        ofWhichSubmittedTax: 114;
        ofWhichNonSubmittedTax: 115;
        ofWhichVatInEuros: 116;
        otherOpenItems: 117;
        sepaCreditorId: 118;
        mandatRef: 119;
        taxInvoice: 120;
        computerGenerated: 121;
        endingSerialNumber: 122;
        rexNumber: 123;
    }
    export type CrystalReportsSales = keyof CrystalReportsSales$Enum;
    export interface CustomerType$Enum {
        normal: 1;
        miscellaneous: 2;
        intraCompany: 3;
        prospect: 4;
    }
    export type CustomerType = keyof CustomerType$Enum;
    export interface DeliveryCategory$Enum {
        normal: 1;
        loan: 2;
        forSubcontract: 3;
        nonbillable: 4;
    }
    export type DeliveryCategory = keyof DeliveryCategory$Enum;
    export interface DeliveryFlow$Enum {
        delivery: 1;
        return: 2;
    }
    export type DeliveryFlow = keyof DeliveryFlow$Enum;
    export interface DeliveryPriority$Enum {
        normal: 1;
        urgent: 2;
        critical: 3;
    }
    export type DeliveryPriority = keyof DeliveryPriority$Enum;
    export interface DistributionOnLines$Enum {
        no: 1;
        quantityProRata: 2;
        amountProRata: 3;
        weightProRata: 4;
        volumeProRata: 5;
    }
    export type DistributionOnLines = keyof DistributionOnLines$Enum;
    export interface DueDateCalculationSource$Enum {
        invoiceDate: 1;
        shipmentDate: 2;
    }
    export type DueDateCalculationSource = keyof DueDateCalculationSource$Enum;
    export interface EarlyLateManagementMode$Enum {
        updateTotalEarlyLate: 1;
        updateNextDeliveryRequest: 2;
    }
    export type EarlyLateManagementMode = keyof EarlyLateManagementMode$Enum;
    export interface EffectOnTheDetail$Enum {
        no: 1;
        yes: 2;
        onlyIfSameValue: 3;
    }
    export type EffectOnTheDetail = keyof EffectOnTheDetail$Enum;
    export interface Free$Enum {
        no: 1;
        source: 2;
        yes: 3;
    }
    export type Free = keyof Free$Enum;
    export interface FreightInvoicing$Enum {
        invoiced: 1;
        notInvoiced: 2;
        upToThreshold1: 3;
        upToThreshold2: 4;
        upToThreshold3: 5;
        upToThreshold4: 6;
        upToThreshold5: 7;
    }
    export type FreightInvoicing = keyof FreightInvoicing$Enum;
    export interface GroupingRules$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        quoteAmountSum: 5;
        orderAmountSum: 6;
        deliveryAmountSum: 7;
        invoiceAmountSum: 8;
        minAmount: 9;
        maxAmount: 10;
        minPercentage: 11;
        maxPercentage: 12;
        averagePercentage: 13;
        substituteValue14: 14;
        returnAmountSum: 15;
        substituteValue16: 16;
        serviceContractAmountSum: 17;
    }
    export type GroupingRules = keyof GroupingRules$Enum;
    export interface Grouping$Enum {
        yes: 1;
        noIfDifferent: 2;
    }
    export type Grouping = keyof Grouping$Enum;
    export interface HoldCodeMessages$Enum {
        unableToUpdateOrderHoldStatus: 1;
        invalidOrderHoldCode: 2;
        unableToReadOrderHoldCode: 3;
        holdWasReleased: 4;
        orderPartiallyShippedOrInvoicedContinueWithHold: 5;
        holdCancelledByUser: 6;
        automaticDeallocationDueToOrderHold: 7;
        unableToReadSalesOrder: 8;
        errorRewritingSoh: 9;
        heldOn: 10;
        releasedOn: 11;
        releaseFromOrderHold: 12;
        manualOrderHoldCannotAllocate: 13;
        manualOrderHold: 14;
        manualOrderHoldCannotShip: 15;
        manualOrderHoldCannotInvoice: 16;
        manualOrderHoldNoProformaAllowed: 17;
        manualOrderHoldNoPreparationAllowed: 18;
        releaseFromCreditHold: 19;
        unableToUpdateOrderCreditStatus: 20;
        creditStatusUpdated: 21;
        youDoNotHaveAccessRightsToReleaseThisOrder: 22;
        thisOrderIsNotBlocked: 23;
        thisOrderIsNotBlockedDueToAnExceededCreditLevel: 24;
        thisOrderIsNotBlockedDueToAnUnpaidPrepayment: 25;
    }
    export type HoldCodeMessages = keyof HoldCodeMessages$Enum;
    export interface HoldStatus$Enum {
        ok: 1;
        onHold: 2;
    }
    export type HoldStatus = keyof HoldStatus$Enum;
    export interface IncreaseType$Enum {
        notModified: 1;
        variationIn: 2;
        variationInValue: 3;
        assignment: 4;
    }
    export type IncreaseType = keyof IncreaseType$Enum;
    export interface InquirySort$Enum {
        number: 1;
        date: 2;
    }
    export type InquirySort = keyof InquirySort$Enum;
    export interface InvEltTrfOrdToShipInv$Enum {
        first: 1;
        all: 2;
    }
    export type InvEltTrfOrdToShipInv = keyof InvEltTrfOrdToShipInv$Enum;
    export interface InvoiceDate466$Enum {
        referenceDate: 1;
        closingDate: 2;
    }
    export type InvoiceDate466 = keyof InvoiceDate466$Enum;
    export interface InvoiceDate$Enum {
        referenceDate: 1;
        nextInvoiceDate: 2;
    }
    export type InvoiceDate = keyof InvoiceDate$Enum;
    export interface InvoiceMode$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type InvoiceMode = keyof InvoiceMode$Enum;
    export interface InvoiceSort$Enum {
        number: 1;
        dateBillToCustomer: 2;
    }
    export type InvoiceSort = keyof InvoiceSort$Enum;
    export interface InvoiceValidatedStatus$Enum {
        notValidated: 1;
        validated: 2;
    }
    export type InvoiceValidatedStatus = keyof InvoiceValidatedStatus$Enum;
    export interface InvoicingFrequency$Enum {
        perRequest: 1;
        daily: 2;
        weekly: 3;
        substituteValue4: 4;
        substituteValue5: 5;
        monthly: 6;
    }
    export type InvoicingFrequency = keyof InvoicingFrequency$Enum;
    export interface InvoicingMethod2429$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
    }
    export type InvoicingMethod2429 = keyof InvoicingMethod2429$Enum;
    export interface InvoicingMethod$Enum {
        singleOpenItem: 1;
        oneInvoiceOpenItem: 2;
        oneInvoiceContract: 3;
        oneInvoiceCustomer: 4;
    }
    export type InvoicingMethod = keyof InvoicingMethod$Enum;
    export interface InvoicingMode$Enum {
        oneSlip: 1;
        oneClosedOrder: 2;
        oneOrder: 3;
        oneShipTo: 4;
        onePeriod: 5;
        manual: 6;
    }
    export type InvoicingMode = keyof InvoicingMode$Enum;
    export interface LabelFormat$Enum {
        large: 1;
        small: 2;
    }
    export type LabelFormat = keyof LabelFormat$Enum;
    export interface LabelStatus$Enum {
        inProduction: 1;
        inShipment: 2;
    }
    export type LabelStatus = keyof LabelStatus$Enum;
    export interface LabelType$Enum {
        detailLabel: 1;
        globalLabel: 2;
    }
    export type LabelType = keyof LabelType$Enum;
    export interface LineCategory$Enum {
        standardAndProduct: 1;
        componentAndOptionAndVariant: 2;
    }
    export type LineCategory = keyof LineCategory$Enum;
    export interface LineType2415$Enum {
        documentLine: 1;
        invoicingElement: 2;
        openItem: 3;
    }
    export type LineType2415 = keyof LineType2415$Enum;
    export interface LineType$Enum {
        normal: 1;
        fixedKit: 2;
        kitComponent: 3;
        kitOption: 4;
        kitVariant: 5;
        flexKit: 6;
        bomComponent: 7;
        bomOption: 8;
        bomVariant: 9;
        subcontracted: 10;
        service: 11;
        suppliedMaterial: 12;
        fixedAmountService: 13;
    }
    export type LineType = keyof LineType$Enum;
    export interface Modification$Enum {
        no: 1;
        price: 2;
        quantity: 3;
        splitting: 4;
        grouping: 5;
        generation: 6;
    }
    export type Modification = keyof Modification$Enum;
    export interface OpenItemStatus$Enum {
        notPaid: 1;
        partiallyPaid: 2;
        totallyPaid: 3;
    }
    export type OpenItemStatus = keyof OpenItemStatus$Enum;
    export interface OrderCatExceptOpen$Enum {
        normal: 1;
        loan: 2;
        directInvoice: 3;
    }
    export type OrderCatExceptOpen = keyof OrderCatExceptOpen$Enum;
    export interface OrderCategorie$Enum {
        normal: 1;
        directInvoice: 2;
    }
    export type OrderCategorie = keyof OrderCategorie$Enum;
    export interface OrderCategoryInTransactions$Enum {
        normal: 1;
        loan: 2;
        directInvoice: 3;
        allCategories: 4;
    }
    export type OrderCategoryInTransactions = keyof OrderCategoryInTransactions$Enum;
    export interface OrderCategory$Enum {
        normal: 1;
        loan: 2;
        directInvoicing: 3;
        contract: 4;
    }
    export type OrderCategory = keyof OrderCategory$Enum;
    export interface OrderStatus$Enum {
        open: 1;
        closed: 2;
    }
    export type OrderStatus = keyof OrderStatus$Enum;
    export interface OriginDateForInvoicing$Enum {
        dispatchDate: 1;
        deliveryDate: 2;
    }
    export type OriginDateForInvoicing = keyof OriginDateForInvoicing$Enum;
    export interface PackingSlip$Enum {
        normal: 1;
        ready: 2;
    }
    export type PackingSlip = keyof PackingSlip$Enum;
    export interface PageBreak$Enum {
        no: 1;
        yes: 2;
        yesWithPageBreak: 3;
    }
    export type PageBreak = keyof PageBreak$Enum;
    export interface PartialDelivery$Enum {
        authorized: 1;
        completeLine: 2;
        completeOrder: 3;
    }
    export type PartialDelivery = keyof PartialDelivery$Enum;
    export interface PickingLocSelection$Enum {
        priorityPickingLocation: 1;
        exclusivePickingLocation: 2;
        no: 3;
    }
    export type PickingLocSelection = keyof PickingLocSelection$Enum;
    export interface PriceIncrease$Enum {
        copyRecord: 1;
        modifyRecord: 2;
        currencyChange: 3;
    }
    export type PriceIncrease = keyof PriceIncrease$Enum;
    export interface PrintingCurrency$Enum {
        documentCurrency: 1;
        companyCurrency: 2;
    }
    export type PrintingCurrency = keyof PrintingCurrency$Enum;
    export interface ProFormaSource$Enum {
        quote: 1;
        fromOrderNo: 2;
        fromDelivery: 3;
    }
    export type ProFormaSource = keyof ProFormaSource$Enum;
    export interface ProductDescriptionType$Enum {
        translatedDescription: 1;
        openItemInvoiced: 2;
    }
    export type ProductDescriptionType = keyof ProductDescriptionType$Enum;
    export interface ProformaSource$Enum {
        direct: 1;
        quote: 2;
    }
    export type ProformaSource = keyof ProformaSource$Enum;
    export interface PurchaseJournalType$Enum {
        invoice: 1;
        creditMemo: 2;
        return: 3;
        receipt: 4;
        openOrder: 5;
        order: 6;
        subcontractOrder: 7;
        purchaseRequest: 8;
        callForTender: 9;
        document: 10;
    }
    export type PurchaseJournalType = keyof PurchaseJournalType$Enum;
    export interface QuoteStatus$Enum {
        notOrdered: 1;
        partiallyOrdered: 2;
        completelyOrdered: 3;
    }
    export type QuoteStatus = keyof QuoteStatus$Enum;
    export interface RefacturationChancier$Enum {
        noByDefaultWithQuestion: 1;
        yesByDefaultWithQuestion: 2;
        noWithoutQuestion: 3;
        yesWithoutQuestion: 4;
    }
    export type RefacturationChancier = keyof RefacturationChancier$Enum;
    export interface ReportCode$Enum {
        customer: 1;
        product: 2;
    }
    export type ReportCode = keyof ReportCode$Enum;
    export interface ReturnCategory$Enum {
        normal: 1;
        loan: 2;
        forSubcontract: 3;
    }
    export type ReturnCategory = keyof ReturnCategory$Enum;
    export interface ReturnStatus$Enum {
        notReturned: 1;
        partiallyReturned: 2;
        returned: 3;
    }
    export type ReturnStatus = keyof ReturnStatus$Enum;
    export interface RouteCode$Enum {
        routeCode1: 1;
        routeCode2: 2;
        routeCode3: 3;
        routeCode4: 4;
    }
    export type RouteCode = keyof RouteCode$Enum;
    export interface RouteViewType$Enum {
        order: 1;
        delivery: 2;
    }
    export type RouteViewType = keyof RouteViewType$Enum;
    export interface SalesCreditMemo$Enum {
        invoice: 1;
        creditNote: 2;
        proforma: 3;
    }
    export type SalesCreditMemo = keyof SalesCreditMemo$Enum;
    export interface SalesDocumentType$Enum {
        quote: 1;
        delivery: 2;
        return: 3;
        invoice: 4;
        creditMemo: 5;
        proforma: 6;
        loanDelivery: 7;
        loanReturn: 8;
        priceListRecord: 9;
        normalOrder: 10;
        loanOrder: 11;
        directInvoiceOrder: 12;
        contract: 13;
        finalDelivery: 14;
        deliveryForSubcontracting: 15;
        intracompanyDelivery: 16;
        intracompanyReturn: 17;
        orderInvoice: 18;
        deliveryInvoice: 19;
        order: 20;
        subcontractMaterialReturn: 21;
        transportNote: 22;
        serviceContracts: 23;
    }
    export type SalesDocumentType = keyof SalesDocumentType$Enum;
    export interface SalesRepCommissionBase$Enum {
        onNetPrice: 1;
        onMargin: 2;
        onCalculationFormula: 3;
    }
    export type SalesRepCommissionBase = keyof SalesRepCommissionBase$Enum;
    export interface SalesSortOrder2405$Enum {
        siteJournalNumber: 1;
        siteDate: 2;
        siteCustomer: 3;
        journalNumber: 4;
        date: 5;
        customer: 6;
    }
    export type SalesSortOrder2405 = keyof SalesSortOrder2405$Enum;
    export interface SalesSortOrder2407$Enum {
        siteJournalNumber: 1;
        siteDate: 2;
        siteValidityDate: 3;
        siteCustomer: 4;
        journalNumber: 5;
        date: 6;
        validityDate: 7;
        customer: 8;
    }
    export type SalesSortOrder2407 = keyof SalesSortOrder2407$Enum;
    export interface SalesSortOrder2408$Enum {
        journalNumber: 1;
        date: 2;
        validityDate: 3;
        customer: 4;
    }
    export type SalesSortOrder2408 = keyof SalesSortOrder2408$Enum;
    export interface SalesSortOrder$Enum {
        journalNumber: 1;
        date: 2;
        customer: 3;
    }
    export type SalesSortOrder = keyof SalesSortOrder$Enum;
    export interface ScheduleType2420$Enum {
        normal: 1;
        fixedPercentage: 2;
        frequency: 3;
    }
    export type ScheduleType2420 = keyof ScheduleType2420$Enum;
    export interface ShipmentDateInitialization$Enum {
        currentDate: 1;
        originalDocumentShipmentDate: 2;
    }
    export type ShipmentDateInitialization = keyof ShipmentDateInitialization$Enum;
    export interface ShipmentTransactionTypes$Enum {
        normal: 1;
        loan: 2;
        subcontract: 3;
        allTypes: 4;
        nonbillable: 5;
    }
    export type ShipmentTransactionTypes = keyof ShipmentTransactionTypes$Enum;
    export interface ShipmentType$Enum {
        regularOrder: 1;
        loanOrder: 2;
        contract: 3;
        directDelivery: 4;
        directLoanDelivery: 5;
    }
    export type ShipmentType = keyof ShipmentType$Enum;
    export interface Signature$Enum {
        no: 1;
        yesOptional: 2;
        yesMandatory: 3;
    }
    export type Signature = keyof Signature$Enum;
    export interface SourceOfShipment$Enum {
        normal: 1;
        poDirectToCustomer: 2;
        poReceiveAndShip: 3;
        transfer: 4;
        workOrder: 5;
    }
    export type SourceOfShipment = keyof SourceOfShipment$Enum;
    export interface SplitRules$Enum {
        substituteValue1: 1;
        substituteValue2: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        allOrders: 5;
        allDeliveries: 6;
        allInvoices: 7;
        allCreditMemos: 8;
        amountProRata: 9;
        quantityProRata: 10;
        weightProRata: 11;
        volumeProRata: 12;
    }
    export type SplitRules = keyof SplitRules$Enum;
    export interface StatementPeriod$Enum {
        perRequest: 1;
        weekly: 2;
        substituteValue3: 3;
        substituteValue4: 4;
        monthly: 5;
    }
    export type StatementPeriod = keyof StatementPeriod$Enum;
    export interface Status2419$Enum {
        toBeInvoiced: 1;
        invoiced: 2;
        creditMemo: 3;
        closed: 4;
        invoicedNotPosted: 5;
        includedOnCreditMemo: 6;
    }
    export type Status2419 = keyof Status2419$Enum;
    export interface StatusOfInvoice$Enum {
        notPrinted: 1;
        printed: 2;
        validated: 3;
    }
    export type StatusOfInvoice = keyof StatusOfInvoice$Enum;
    export interface SundryRulesPersonalized$Enum {
        none: 1;
    }
    export type SundryRulesPersonalized = keyof SundryRulesPersonalized$Enum;
    export interface SundryRulesStd$Enum {
        none: 1;
        discountOnTax: 2;
    }
    export type SundryRulesStd = keyof SundryRulesStd$Enum;
    export interface TrackingOfCustomerText$Enum {
        headerText: 1;
        footerText: 2;
    }
    export type TrackingOfCustomerText = keyof TrackingOfCustomerText$Enum;
    export interface TrackingOfProductText$Enum {
        onTheOrder: 1;
        onTheShipment: 2;
        onTheInvoice: 3;
        onTheShipmentAndInvoice: 4;
        onOrderShipmentInvoice: 5;
    }
    export type TrackingOfProductText = keyof TrackingOfProductText$Enum;
    export interface TransactionInvoiceType$Enum {
        invoice: 1;
        proforma: 2;
        allTypes: 3;
    }
    export type TransactionInvoiceType = keyof TransactionInvoiceType$Enum;
    export interface TransactionInvoiceTypes$Enum {
        invoice: 1;
        creditMemo: 2;
        proforma: 3;
        allTypes: 4;
    }
    export type TransactionInvoiceTypes = keyof TransactionInvoiceTypes$Enum;
    export interface TransactionType435$Enum {
        quote: 1;
        order: 2;
        contractOrder: 3;
        delivery: 4;
        invoice: 5;
        customerReturn: 6;
        loanReturn: 7;
        subcontractMaterialReturn: 8;
    }
    export type TransactionType435 = keyof TransactionType435$Enum;
    export interface TypeOfSalesDocument$Enum {
        quote: 1;
        delivery: 2;
        return: 3;
        invoice: 4;
        creditNote: 5;
        proforma: 6;
        loanDelivery: 7;
        loanReturn: 8;
        priceRecord: 9;
        normalOrder: 10;
        loanOrder: 11;
        directInvoiceOrder: 12;
        contract: 13;
        firmDelivery: 14;
        deliveryForSubcontracting: 15;
        intracompanyIntercompanyDelivery: 16;
        intracompanyIntercompanyReturn: 17;
        subcontractMaterialReturn: 18;
        scheduledInvoice: 19;
    }
    export type TypeOfSalesDocument = keyof TypeOfSalesDocument$Enum;
    export interface UrlType$Enum {
        test: 1;
        production: 2;
    }
    export type UrlType = keyof UrlType$Enum;
    export interface SalesDeliveryType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesDeliveryTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SalesDeliveryTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesDeliveryType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesDeliveryType$Operations {
        query: QueryOperation<SalesDeliveryType>;
        read: ReadOperation<SalesDeliveryType>;
        aggregate: {
            read: AggregateReadOperation<SalesDeliveryType>;
            query: AggregateQueryOperation<SalesDeliveryType>;
        };
        lookups(dataOrId: string | { data: SalesDeliveryTypeInput }): SalesDeliveryType$Lookups;
        getDefaults: GetDefaultsOperation<SalesDeliveryType>;
    }
    export interface SalesInvoiceType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        invoiceCategory: InvoiceType;
    }
    export interface SalesInvoiceTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
        invoiceCategory?: InvoiceType;
    }
    export interface SalesInvoiceTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
        invoiceCategory: InvoiceType;
    }
    export interface SalesInvoiceType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesInvoiceType$Operations {
        query: QueryOperation<SalesInvoiceType>;
        read: ReadOperation<SalesInvoiceType>;
        aggregate: {
            read: AggregateReadOperation<SalesInvoiceType>;
            query: AggregateQueryOperation<SalesInvoiceType>;
        };
        lookups(dataOrId: string | { data: SalesInvoiceTypeInput }): SalesInvoiceType$Lookups;
        getDefaults: GetDefaultsOperation<SalesInvoiceType>;
    }
    export interface SalesOrderType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesOrderTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SalesOrderTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesOrderType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesOrderType$Operations {
        query: QueryOperation<SalesOrderType>;
        read: ReadOperation<SalesOrderType>;
        aggregate: {
            read: AggregateReadOperation<SalesOrderType>;
            query: AggregateQueryOperation<SalesOrderType>;
        };
        lookups(dataOrId: string | { data: SalesOrderTypeInput }): SalesOrderType$Lookups;
        getDefaults: GetDefaultsOperation<SalesOrderType>;
    }
    export interface SalesPriceReason extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
    }
    export interface SalesPriceReasonInput extends ClientNodeInput {
        code?: integer | string;
        localizedDescription?: string;
    }
    export interface SalesPriceReasonBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: integer;
        localizedDescription: string;
    }
    export interface SalesPriceReason$Operations {
        query: QueryOperation<SalesPriceReason>;
        read: ReadOperation<SalesPriceReason>;
        aggregate: {
            read: AggregateReadOperation<SalesPriceReason>;
            query: AggregateQueryOperation<SalesPriceReason>;
        };
        getDefaults: GetDefaultsOperation<SalesPriceReason>;
    }
    export interface SalesQuoteType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesQuoteTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SalesQuoteTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesQuoteType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesQuoteType$Operations {
        query: QueryOperation<SalesQuoteType>;
        read: ReadOperation<SalesQuoteType>;
        aggregate: {
            read: AggregateReadOperation<SalesQuoteType>;
            query: AggregateQueryOperation<SalesQuoteType>;
        };
        lookups(dataOrId: string | { data: SalesQuoteTypeInput }): SalesQuoteType$Lookups;
        getDefaults: GetDefaultsOperation<SalesQuoteType>;
    }
    export interface SalesReturnType extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesReturnTypeInput extends ClientNodeInput {
        code?: string;
        legislation?: string;
        localizedDescription?: string;
        localizedShortDescription?: string;
    }
    export interface SalesReturnTypeBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        legislation: MiscellaneousTable;
        localizedDescription: string;
        localizedShortDescription: string;
    }
    export interface SalesReturnType$Lookups {
        legislation: QueryOperation<MiscellaneousTable>;
    }
    export interface SalesReturnType$Operations {
        query: QueryOperation<SalesReturnType>;
        read: ReadOperation<SalesReturnType>;
        aggregate: {
            read: AggregateReadOperation<SalesReturnType>;
            query: AggregateQueryOperation<SalesReturnType>;
        };
        lookups(dataOrId: string | { data: SalesReturnTypeInput }): SalesReturnType$Lookups;
        getDefaults: GetDefaultsOperation<SalesReturnType>;
    }
    export interface CustomerInvoiceHeaderExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        sourceModule: ModuleTable;
        billToCustomer: Customer;
        control: string;
        company: Company;
        financialSite: Site;
        accountingDate: string;
        internalNumber: integer;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerState: string;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        entityUserCode: MiscellaneousTable;
        isDirectInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: InvoiceStatus;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        draftNumber: string;
        stockMovementGroup: MiscellaneousTable;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        warehouse: Warehouse;
        isPrinted: boolean;
        isExternalDocument: boolean;
        earlyDiscountOrLateChargeBasis: string;
        versionControlSystemNumber: string;
        isValidatedAddress: boolean;
        priceOrAmountTaxType: PriceAmountTaxTax;
        vatDeclarationNumber: string;
        exportDeclaration: string;
        mandate: Mandate;
        recurringNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        derCode: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        creditMemoReferenceStartDate: string;
        creditMemoReferenceEndDate: string;
        inPaymentSlipWithReferenceNumber: string;
        cancellationStatus: integer;
        project: ProjectLink;
        correctionMethod: CorrectionMethod;
        siteIdentificationNumber: string;
        spanishInvoiceType: SpanishInvoiceType;
        businessProcessType: MiscellaneousTable;
        operationType: TypeOfOperation;
        autoInvoicingSpanish: boolean;
        manualAutoInvoicingSpaGenerated: boolean;
        automaticAutoInvoicingSpaGenerated: boolean;
        destinationGeneration: AutoInvoiceRecipient;
        spanishTaxDate: string;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLines>;
        billToCustomerCompanyNames: ClientCollection<CustomerInvoiceHeaderBillToCustomerCompanyNames>;
        comments: ClientCollection<CustomerInvoiceHeaderComments>;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLines>;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNames>;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxes>;
        invoiceType: SalesInvoiceType;
    }
    export interface CustomerInvoiceHeaderInputExtension {
        id?: string;
        category?: InvoiceType;
        sourceModule?: ModuleTable;
        billToCustomer?: string;
        control?: string;
        company?: string;
        financialSite?: string;
        accountingDate?: string;
        internalNumber?: integer | string;
        sourceDocumentDate?: string;
        sourceDocument?: string;
        currency?: string;
        rateType?: ExchangeRateType;
        rateDate?: string;
        payByBusinessPartner?: string;
        payByBusinessPartnerAddress?: string;
        payByBusinessPartnerPostalCode?: string;
        payByBusinessPartnerCity?: string;
        payByBusinessPartnerState?: string;
        payByBusinessPartnerCountry?: string;
        payByBusinessPartnerCountryName?: string;
        dueDateCalculationStartDate?: string;
        paymentTerm?: string;
        earlyDiscountOrLateCharge?: string;
        earlyDiscountOrLateChargeRate?: decimal | string;
        taxRule?: string;
        entityUserCode?: string;
        isDirectInvoice?: boolean | string;
        intrastatProcessingNumber?: integer | string;
        status?: InvoiceStatus;
        originalInvoiceNumber?: string;
        debitOrCredit?: integer | string;
        totalAmountIncludingTax?: decimal | string;
        totalAmountExcludingTax?: decimal | string;
        totalAmountExcludingTaxInCompanyCurrency?: decimal | string;
        totalAmountIncludingTaxInCompanyCurrency?: decimal | string;
        taxReferenceDate?: string;
        numberOfTaxes?: integer | string;
        billToCustomerAddress?: string;
        billToCustomerPostalCode?: string;
        billToCustomerCity?: string;
        billToCustomerState?: string;
        billToCustomerCountry?: string;
        billToCustomerCountryName?: string;
        draftNumber?: string;
        stockMovementGroup?: string;
        fiscalYear?: integer | string;
        period?: integer | string;
        serviceStartDate?: string;
        serviceEndDate?: string;
        lastServiceAccountedDate?: string;
        warehouse?: string;
        isPrinted?: boolean | string;
        isExternalDocument?: boolean | string;
        earlyDiscountOrLateChargeBasis?: decimal | string;
        versionControlSystemNumber?: string;
        isValidatedAddress?: boolean | string;
        priceOrAmountTaxType?: PriceAmountTaxTax;
        vatDeclarationNumber?: string;
        exportDeclaration?: string;
        mandate?: string;
        recurringNumber?: string;
        recurringInvoicingDate?: string;
        numberOfCompanies?: integer | string;
        cashVatTaxRule?: boolean | string;
        derCode?: string;
        field40Reason?: string;
        field41Reason?: string;
        originalDocumentNumber?: string;
        creditMemoReferenceStartDate?: string;
        creditMemoReferenceEndDate?: string;
        inPaymentSlipWithReferenceNumber?: string;
        cancellationStatus?: integer | string;
        project?: string;
        correctionMethod?: CorrectionMethod;
        siteIdentificationNumber?: string;
        spanishInvoiceType?: SpanishInvoiceType;
        businessProcessType?: string;
        operationType?: TypeOfOperation;
        autoInvoicingSpanish?: boolean | string;
        manualAutoInvoicingSpaGenerated?: boolean | string;
        automaticAutoInvoicingSpaGenerated?: boolean | string;
        destinationGeneration?: AutoInvoiceRecipient;
        spanishTaxDate?: string;
        billToCustomerAddressLines?: Partial<CustomerInvoiceHeaderBillToCustomerAddressLinesInput>[];
        billToCustomerCompanyNames?: Partial<CustomerInvoiceHeaderBillToCustomerCompanyNamesInput>[];
        comments?: Partial<CustomerInvoiceHeaderCommentsInput>[];
        payByBusinessPartnerAddressLines?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesInput>[];
        payByBusinessPartnerCompanyNames?: Partial<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesInput>[];
        taxes?: Partial<CustomerInvoiceHeaderTaxesInput>[];
        invoiceType?: string;
    }
    export interface CustomerInvoiceHeaderBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        id: string;
        category: InvoiceType;
        sourceModule: ModuleTable;
        billToCustomer: Customer;
        control: string;
        company: Company;
        financialSite: Site;
        accountingDate: string;
        internalNumber: integer;
        sourceDocumentDate: string;
        sourceDocument: string;
        currency: Currency;
        rateType: ExchangeRateType;
        rateDate: string;
        payByBusinessPartner: BusinessPartner;
        payByBusinessPartnerAddress: BusinessPartnerAddress;
        payByBusinessPartnerPostalCode: string;
        payByBusinessPartnerCity: string;
        payByBusinessPartnerState: string;
        payByBusinessPartnerCountry: Country;
        payByBusinessPartnerCountryName: string;
        dueDateCalculationStartDate: string;
        paymentTerm: PaymentTerm;
        earlyDiscountOrLateCharge: EarlyDiscountLateCharge;
        earlyDiscountOrLateChargeRate: string;
        taxRule: TaxRule;
        entityUserCode: MiscellaneousTable;
        isDirectInvoice: boolean;
        intrastatProcessingNumber: integer;
        status: InvoiceStatus;
        originalInvoiceNumber: string;
        debitOrCredit: integer;
        totalAmountIncludingTax: string;
        totalAmountExcludingTax: string;
        totalAmountExcludingTaxInCompanyCurrency: string;
        totalAmountIncludingTaxInCompanyCurrency: string;
        taxReferenceDate: string;
        numberOfTaxes: integer;
        billToCustomerAddress: CustomerAddress;
        billToCustomerPostalCode: string;
        billToCustomerCity: string;
        billToCustomerState: string;
        billToCustomerCountry: Country;
        billToCustomerCountryName: string;
        draftNumber: string;
        stockMovementGroup: MiscellaneousTable;
        fiscalYear: integer;
        period: integer;
        serviceStartDate: string;
        serviceEndDate: string;
        lastServiceAccountedDate: string;
        warehouse: Warehouse;
        isPrinted: boolean;
        isExternalDocument: boolean;
        earlyDiscountOrLateChargeBasis: string;
        versionControlSystemNumber: string;
        isValidatedAddress: boolean;
        priceOrAmountTaxType: PriceAmountTaxTax;
        vatDeclarationNumber: string;
        exportDeclaration: string;
        mandate: Mandate;
        recurringNumber: string;
        recurringInvoicingDate: string;
        numberOfCompanies: integer;
        cashVatTaxRule: boolean;
        derCode: string;
        field40Reason: MiscellaneousTable;
        field41Reason: MiscellaneousTable;
        originalDocumentNumber: string;
        creditMemoReferenceStartDate: string;
        creditMemoReferenceEndDate: string;
        inPaymentSlipWithReferenceNumber: string;
        cancellationStatus: integer;
        project: ProjectLink;
        correctionMethod: CorrectionMethod;
        siteIdentificationNumber: string;
        spanishInvoiceType: SpanishInvoiceType;
        businessProcessType: MiscellaneousTable;
        operationType: TypeOfOperation;
        autoInvoicingSpanish: boolean;
        manualAutoInvoicingSpaGenerated: boolean;
        automaticAutoInvoicingSpaGenerated: boolean;
        destinationGeneration: AutoInvoiceRecipient;
        spanishTaxDate: string;
        billToCustomerAddressLines: ClientCollection<CustomerInvoiceHeaderBillToCustomerAddressLinesBinding>;
        billToCustomerCompanyNames: ClientCollection<CustomerInvoiceHeaderBillToCustomerCompanyNamesBinding>;
        comments: ClientCollection<CustomerInvoiceHeaderCommentsBinding>;
        payByBusinessPartnerAddressLines: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerAddressLinesBinding>;
        payByBusinessPartnerCompanyNames: ClientCollection<CustomerInvoiceHeaderPayByBusinessPartnerCompanyNamesBinding>;
        taxes: ClientCollection<CustomerInvoiceHeaderTaxesBinding>;
        invoiceType: SalesInvoiceType;
    }
    export interface CustomerInvoiceHeaderExtension$Lookups {
        invoiceType: QueryOperation<SalesInvoiceType>;
    }
    export interface CustomerInvoiceHeaderExtension$Operations {
        lookups(dataOrId: string | { data: CustomerInvoiceHeaderInput }): CustomerInvoiceHeaderExtension$Lookups;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnits>;
        statisticalGroups: ClientCollection<ProductStatisticalGroups>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevels>;
        basePrice: string;
        packaging: Packaging;
        packagingCapacity: string;
        productPickingText: TextStream;
        productSalesText: TextStream;
        substitutionDate: string;
        substitutionProduct: Product;
    }
    export interface ProductInputExtension {
        code?: string;
        company?: string;
        productCategory?: string;
        searchKey?: string;
        description1?: string;
        description2?: string;
        description3?: string;
        localizedDescription1?: string;
        localizedDescription2?: string;
        localizedDescription3?: string;
        managementMode?: StandardProductCode;
        standard?: string;
        upc?: string;
        productStatus?: ProductStatus;
        isPrototype?: boolean | string;
        defaultPotencyInPercentage?: decimal | string;
        defaultPotencyInInternationalUnit?: decimal | string;
        serviceLifeStartDate?: string;
        serviceLifeEndDate?: string;
        storageSheet?: string;
        stockUnit?: string;
        purchaseUnit?: string;
        salesUnit?: string;
        statisticalUnit?: string;
        eeUnit?: string;
        purchaseUnitToStockUnitConversionFactor?: decimal | string;
        isPurchaseFactorEntryAllowed?: boolean | string;
        salesUnitToStockUnitConversionFactor?: decimal | string;
        isSalesFactorEntryAllowed?: boolean | string;
        statisticalUnitToStockUnitConversionFactor?: decimal | string;
        eeUnitToStockUnitConversionFactor?: decimal | string;
        weightUnit?: string;
        productWeight?: decimal | string;
        volumeUnit?: string;
        productVolume?: decimal | string;
        lotSequenceNumber?: string;
        serialSequenceNumber?: string;
        serialNumberManagementMode?: SerialNumberManagement;
        expirationManagementMode?: ExpirationManagement;
        expirationStockStatus?: string;
        expirationLeadTime?: integer | string;
        checkLeadTime?: integer | string;
        isNegativeStockAuthorized?: boolean | string;
        costGroup?: string;
        userAccessCode?: string;
        alternateProduct?: string;
        isIntrastatDeclarationSubmitted?: boolean | string;
        intrastatCommodity?: string;
        purchasingPlanningHorizonTimeUnit?: LeadTimeUnit;
        purchasingPlanningHorizon?: integer | string;
        purchasingFirmHorizon?: integer | string;
        purchasingFirmHorizonTimeUnit?: LeadTimeUnit;
        buyer?: string;
        planner?: string;
        reorderLeadTime?: integer | string;
        purchaseBasePrice?: decimal | string;
        landedCostCoefficient?: decimal | string;
        fixedLandedCostPerUnit?: decimal | string;
        purchaseDeliveryTolerance?: decimal | string;
        isReceived?: boolean | string;
        isMandatoryPurchaseOrderRequest?: boolean | string;
        exemptionFlag?: string;
        taxFlagStatusLocal?: string;
        configuratorProductLine?: string;
        configuratorNumericField1?: decimal | string;
        configuratorNumericField2?: decimal | string;
        configuratorNumericField3?: decimal | string;
        configuratorNumericField4?: decimal | string;
        configuratorNumericField5?: decimal | string;
        configuratorNumericField6?: decimal | string;
        configuratorAlphaField1?: string;
        configuratorAlphaField2?: string;
        configuratorAlphaField3?: string;
        configuratorAlphaField4?: string;
        configuratorAlphaField5?: string;
        configuratorAlphaField6?: string;
        configurationJournal?: string;
        configuratorBusinessPartner?: string;
        configuratorBusinessPartnerReference?: string;
        configuratorReferenceProduct?: string;
        configuratorPurgeDate?: string;
        isInstalledBaseCreated?: boolean | string;
        voucherCategory?: string;
        tokensToBeCredited?: integer | string;
        creditUnit?: string;
        labelFormatForStockUnit?: string;
        bomCodeForAfterSales?: integer | string;
        productTypeForAfterSales?: TypeOfProduct;
        isAfterSalesProductIssuedByDefault?: boolean | string;
        daysUnit?: string;
        hourUnit?: string;
        minuteUnit?: string;
        productDensity?: decimal | string;
        isPurchased?: boolean | string;
        isManufactured?: boolean | string;
        isSubcontracted?: boolean | string;
        isService?: boolean | string;
        isPhantom?: boolean | string;
        isGeneric?: boolean | string;
        isTools?: boolean | string;
        isDeliverable?: boolean | string;
        isSold?: boolean | string;
        isIntermediary?: boolean | string;
        isCapitalized?: boolean | string;
        newStockStatusAfterRecontrol?: string;
        useByDateCoefficient?: decimal | string;
        intrastatFederalStateOrRegion?: string;
        plmProductReference?: string;
        plmLinkedDocuments?: string;
        plmProductHistory?: string;
        sageSalesTax?: string;
        allergens?: string;
        allergenChangeDate?: string;
        allergenBomCode?: integer | string;
        saftProductType?: SafTProductType;
        isVersionManaged?: boolean | string;
        minorVersionSequence?: string;
        majorVersionSequence?: string;
        isVersionPreloaded?: boolean | string;
        productType?: ProductType;
        globalTradeItemNumber?: string;
        supplierProduct?: Partial<SupplierProductInput>[];
        customerProduct?: Partial<CustomerProductInput>[];
        manufacturingText?: TextStream;
        picture?: BinaryStream;
        purchasingText?: TextStream;
        packingUnits?: Partial<ProductPackingUnitsInput>[];
        statisticalGroups?: Partial<ProductStatisticalGroupsInput>[];
        costType?: string;
        stockManagementMode?: StockManagement;
        lotManagementMode?: LotManagementMode;
        materialCostGroup?: MaterialCostGroup;
        traceabilityManagementMode?: TraceabilityManagementMode;
        traceabilityLevel?: TraceabilityLevel;
        expirationTimeUnit?: ExpirationLeadTimeUnits;
        recontrolTimeUnit?: ExpirationLeadTimeUnits;
        stockVersionMode?: StockVersionMode;
        taxLevels?: Partial<ProductTaxLevelsInput>[];
        basePrice?: decimal | string;
        packaging?: string;
        packagingCapacity?: decimal | string;
        productPickingText?: TextStream;
        productSalesText?: TextStream;
        substitutionDate?: string;
        substitutionProduct?: string;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        code: string;
        company: Company;
        productCategory: ProductCategory;
        searchKey: string;
        description1: string;
        description2: string;
        description3: string;
        localizedDescription1: string;
        localizedDescription2: string;
        localizedDescription3: string;
        managementMode: StandardProductCode;
        standard: string;
        upc: string;
        productStatus: ProductStatus;
        isPrototype: boolean;
        defaultPotencyInPercentage: string;
        defaultPotencyInInternationalUnit: string;
        serviceLifeStartDate: string;
        serviceLifeEndDate: string;
        storageSheet: string;
        stockUnit: UnitOfMeasure;
        purchaseUnit: UnitOfMeasure;
        salesUnit: UnitOfMeasure;
        statisticalUnit: UnitOfMeasure;
        eeUnit: UnitOfMeasure;
        purchaseUnitToStockUnitConversionFactor: string;
        isPurchaseFactorEntryAllowed: boolean;
        salesUnitToStockUnitConversionFactor: string;
        isSalesFactorEntryAllowed: boolean;
        statisticalUnitToStockUnitConversionFactor: string;
        eeUnitToStockUnitConversionFactor: string;
        weightUnit: UnitOfMeasure;
        productWeight: string;
        volumeUnit: UnitOfMeasure;
        productVolume: string;
        lotSequenceNumber: string;
        serialSequenceNumber: string;
        serialNumberManagementMode: SerialNumberManagement;
        expirationManagementMode: ExpirationManagement;
        expirationStockStatus: string;
        expirationLeadTime: integer;
        checkLeadTime: integer;
        isNegativeStockAuthorized: boolean;
        costGroup: string;
        userAccessCode: Access;
        alternateProduct: Product;
        isIntrastatDeclarationSubmitted: boolean;
        intrastatCommodity: string;
        purchasingPlanningHorizonTimeUnit: LeadTimeUnit;
        purchasingPlanningHorizon: integer;
        purchasingFirmHorizon: integer;
        purchasingFirmHorizonTimeUnit: LeadTimeUnit;
        buyer: User;
        planner: User;
        reorderLeadTime: integer;
        purchaseBasePrice: string;
        landedCostCoefficient: string;
        fixedLandedCostPerUnit: string;
        purchaseDeliveryTolerance: string;
        isReceived: boolean;
        isMandatoryPurchaseOrderRequest: boolean;
        exemptionFlag: string;
        taxFlagStatusLocal: string;
        configuratorProductLine: string;
        configuratorNumericField1: string;
        configuratorNumericField2: string;
        configuratorNumericField3: string;
        configuratorNumericField4: string;
        configuratorNumericField5: string;
        configuratorNumericField6: string;
        configuratorAlphaField1: string;
        configuratorAlphaField2: string;
        configuratorAlphaField3: string;
        configuratorAlphaField4: string;
        configuratorAlphaField5: string;
        configuratorAlphaField6: string;
        configurationJournal: string;
        configuratorBusinessPartner: BusinessPartner;
        configuratorBusinessPartnerReference: string;
        configuratorReferenceProduct: Product;
        configuratorPurgeDate: string;
        isInstalledBaseCreated: boolean;
        voucherCategory: MiscellaneousTable;
        tokensToBeCredited: integer;
        creditUnit: UnitOfMeasure;
        labelFormatForStockUnit: GenericPrintReport;
        bomCodeForAfterSales: BomCodes;
        productTypeForAfterSales: TypeOfProduct;
        isAfterSalesProductIssuedByDefault: boolean;
        daysUnit: UnitOfMeasure;
        hourUnit: UnitOfMeasure;
        minuteUnit: UnitOfMeasure;
        productDensity: string;
        isPurchased: boolean;
        isManufactured: boolean;
        isSubcontracted: boolean;
        isService: boolean;
        isPhantom: boolean;
        isGeneric: boolean;
        isTools: boolean;
        isDeliverable: boolean;
        isSold: boolean;
        isIntermediary: boolean;
        isCapitalized: boolean;
        newStockStatusAfterRecontrol: string;
        useByDateCoefficient: string;
        intrastatFederalStateOrRegion: MiscellaneousTable;
        plmProductReference: string;
        plmLinkedDocuments: string;
        plmProductHistory: string;
        sageSalesTax: MiscellaneousTable;
        allergens: string;
        allergenChangeDate: string;
        allergenBomCode: integer;
        saftProductType: SafTProductType;
        isVersionManaged: boolean;
        minorVersionSequence: string;
        majorVersionSequence: string;
        isVersionPreloaded: boolean;
        productType: ProductType;
        globalTradeItemNumber: string;
        productSites: ClientCollection<ProductSite>;
        supplierProduct: ClientCollection<SupplierProduct>;
        customerProduct: ClientCollection<CustomerProduct>;
        manufacturingText: TextStream;
        picture: BinaryStream;
        purchasingText: TextStream;
        packingUnits: ClientCollection<ProductPackingUnitsBinding>;
        statisticalGroups: ClientCollection<ProductStatisticalGroupsBinding>;
        costType: CostType;
        stockManagementMode: StockManagement;
        lotManagementMode: LotManagementMode;
        materialCostGroup: MaterialCostGroup;
        traceabilityManagementMode: TraceabilityManagementMode;
        traceabilityLevel: TraceabilityLevel;
        expirationTimeUnit: ExpirationLeadTimeUnits;
        recontrolTimeUnit: ExpirationLeadTimeUnits;
        stockVersionMode: StockVersionMode;
        taxLevels: ClientCollection<ProductTaxLevelsBinding>;
        basePrice: string;
        packaging: Packaging;
        packagingCapacity: string;
        productPickingText: TextStream;
        productSalesText: TextStream;
        substitutionDate: string;
        substitutionProduct: Product;
    }
    export interface ProductExtension$Lookups {
        packaging: QueryOperation<Packaging>;
        substitutionProduct: QueryOperation<Product>;
    }
    export interface ProductExtension$Operations {
        lookups(dataOrId: string | { data: ProductInput }): ProductExtension$Lookups;
    }
    export interface ShipToCustomerAddressExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNames>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesReps>;
        taxRule: TaxRule;
        routeCode: RouteCode;
        deliveryPriority: DeliveryPriority;
    }
    export interface ShipToCustomerAddressInputExtension {
        customer?: string;
        shipToAddress?: string;
        company?: string;
        isActive?: boolean | string;
        shippingSite?: string;
        receiptSite?: string;
        language?: string;
        carrier?: string;
        incoterm?: string;
        intrastatTransportLocation?: CountryLocation;
        deliveryLeadTime?: integer | string;
        isMondayWorkday?: boolean | string;
        isTuesdayWorkday?: boolean | string;
        isWednesdayWorkday?: boolean | string;
        isThursdayWorkday?: boolean | string;
        isFridayWorkday?: boolean | string;
        isSaturdayWorkday?: boolean | string;
        isSundayWorkday?: boolean | string;
        unavailablePeriod?: string;
        intrastatIncreaseCoefficient?: decimal | string;
        europeanUnionVatNumber?: string;
        incotermTown?: string;
        forwardingAgent?: string;
        forwardingAgentAddress?: string;
        geographicCode?: string;
        insideCityLimits?: string;
        taxExemptionNumber?: string;
        exemptionFlag?: string;
        mustPrintPickTicket?: boolean | string;
        mustPrintPackingSlip?: boolean | string;
        entityUse?: string;
        deliveryHeaderText?: TextStream;
        pickingHeaderText?: TextStream;
        companyNames?: Partial<ShipToCustomerAddressCompanyNamesInput>[];
        salesReps?: Partial<ShipToCustomerAddressSalesRepsInput>[];
        taxRule?: string;
        routeCode?: RouteCode;
        deliveryPriority?: DeliveryPriority;
    }
    export interface ShipToCustomerAddressBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        customer: Customer;
        shipToAddress: CustomerAddress;
        company: Company;
        isActive: boolean;
        shippingSite: Site;
        receiptSite: Site;
        language: Language;
        carrier: Carrier;
        incoterm: Incoterm;
        intrastatTransportLocation: CountryLocation;
        deliveryLeadTime: integer;
        isMondayWorkday: boolean;
        isTuesdayWorkday: boolean;
        isWednesdayWorkday: boolean;
        isThursdayWorkday: boolean;
        isFridayWorkday: boolean;
        isSaturdayWorkday: boolean;
        isSundayWorkday: boolean;
        unavailablePeriod: UnavailablePeriods;
        intrastatIncreaseCoefficient: string;
        europeanUnionVatNumber: string;
        incotermTown: string;
        forwardingAgent: Carrier;
        forwardingAgentAddress: Address;
        geographicCode: string;
        insideCityLimits: string;
        taxExemptionNumber: string;
        exemptionFlag: string;
        mustPrintPickTicket: boolean;
        mustPrintPackingSlip: boolean;
        entityUse: MiscellaneousTable;
        deliveryHeaderText: TextStream;
        pickingHeaderText: TextStream;
        companyNames: ClientCollection<ShipToCustomerAddressCompanyNamesBinding>;
        salesReps: ClientCollection<ShipToCustomerAddressSalesRepsBinding>;
        taxRule: TaxRule;
        routeCode: RouteCode;
        deliveryPriority: DeliveryPriority;
    }
    export interface Package {
        '@sage/x3-sales-data/SalesDeliveryType': SalesDeliveryType$Operations;
        '@sage/x3-sales-data/SalesInvoiceType': SalesInvoiceType$Operations;
        '@sage/x3-sales-data/SalesOrderType': SalesOrderType$Operations;
        '@sage/x3-sales-data/SalesPriceReason': SalesPriceReason$Operations;
        '@sage/x3-sales-data/SalesQuoteType': SalesQuoteType$Operations;
        '@sage/x3-sales-data/SalesReturnType': SalesReturnType$Operations;
    }
    export interface GraphApi
        extends Package,
            SageX3InvoicingData$Package,
            SageX3MasterData$Package,
            SageX3PhysicalFlowsData$Package,
            SageX3ProjectManagementData$Package,
            SageX3StockData$Package,
            SageX3Structure$Package,
            SageX3System$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/x3-sales-data-api' {
    export type * from '@sage/x3-sales-data-api-partial';
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-physical-flows-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-project-management-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/x3-sales-data-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/x3-invoicing-data-api-partial' {
    import type {
        CustomerInvoiceHeaderBindingExtension,
        CustomerInvoiceHeaderExtension,
        CustomerInvoiceHeaderExtension$Lookups,
        CustomerInvoiceHeaderExtension$Operations,
        CustomerInvoiceHeaderInputExtension,
    } from '@sage/x3-sales-data-api';
    export interface CustomerInvoiceHeader extends CustomerInvoiceHeaderExtension {}
    export interface CustomerInvoiceHeaderBinding extends CustomerInvoiceHeaderBindingExtension {}
    export interface CustomerInvoiceHeaderInput extends CustomerInvoiceHeaderInputExtension {}
    export interface CustomerInvoiceHeader$Lookups extends CustomerInvoiceHeaderExtension$Lookups {}
    export interface CustomerInvoiceHeader$Operations extends CustomerInvoiceHeaderExtension$Operations {}
}
declare module '@sage/x3-master-data-api-partial' {
    import type {
        ProductBindingExtension,
        ProductExtension,
        ProductExtension$Lookups,
        ProductExtension$Operations,
        ProductInputExtension,
        ShipToCustomerAddressBindingExtension,
        ShipToCustomerAddressExtension,
        ShipToCustomerAddressInputExtension,
    } from '@sage/x3-sales-data-api';
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface Product$Lookups extends ProductExtension$Lookups {}
    export interface Product$Operations extends ProductExtension$Operations {}
    export interface ShipToCustomerAddress extends ShipToCustomerAddressExtension {}
    export interface ShipToCustomerAddressBinding extends ShipToCustomerAddressBindingExtension {}
    export interface ShipToCustomerAddressInput extends ShipToCustomerAddressInputExtension {}
}
