"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretHandler = exports.recreateSecretHandler = exports.getSecretHandler = void 0;
const SecretHandler_1 = require("./SecretHandler");
exports.SecretHandler = SecretHandler_1.default;
let secretHandlerInstance;
/**
 * Return a secret handler instance or a cached version
 * Warning, if you call it with different config, use "recreateSecretHandler" instead
 * @param config
 * @param secretsManagerMock
 */
function getSecretHandler(config, secretsManagerMock) {
    if (!secretHandlerInstance) {
        secretHandlerInstance = new SecretHandler_1.default(config, secretsManagerMock);
    }
    return secretHandlerInstance;
}
exports.getSecretHandler = getSecretHandler;
/**
 * Replaces the secrethandler singleton instance we have in cache by a new one
 * Can be use if you need a differnt config than the one currently in place
 * @param config
 * @param secretsManagerMock
 */
function recreateSecretHandler(config, secretsManagerMock) {
    secretHandlerInstance = new SecretHandler_1.default(config, secretsManagerMock);
    return secretHandlerInstance;
}
exports.recreateSecretHandler = recreateSecretHandler;
