// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/index.d.ts
declare module '@sage/x3-finance/index' {
	export * from '@sage/x3-finance/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/index.d.ts
declare module '@sage/x3-finance/lib/index' {
	export * as enums from '@sage/x3-finance/lib/enums/index';
	export * as nodeExtensions from '@sage/x3-finance/lib/node-extensions/index';
	export * as nodes from '@sage/x3-finance/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-finance/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/service-options/index.d.ts
declare module '@sage/x3-finance/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/statement-creation.d.ts
declare module '@sage/x3-finance/lib/nodes/statement-creation' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class StatementCreation extends Node {
	    readonly id: Promise<string>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	}
	//# sourceMappingURL=statement-creation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/prepayment-invoice.d.ts
declare module '@sage/x3-finance/lib/nodes/prepayment-invoice' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, date, Reference } from '@sage/xtrem-core';
	export class PrepaymentInvoice extends Node {
	    readonly id: Promise<string>;
	    readonly date: Promise<date | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	}
	//# sourceMappingURL=prepayment-invoice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/journal-entry.d.ts
declare module '@sage/x3-finance/lib/nodes/journal-entry' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class JournalEntry extends Node {
	    readonly journalEntryType: Reference<sageX3FinanceData.nodes.EntryType>;
	    readonly journalEntryNumber: Promise<string>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal>;
	    readonly accountingDate: Promise<date | null>;
	    readonly journalEntryStatus: Promise<sageX3FinanceData.enums.AccountingJournalStatus | null>;
	    readonly journalEntryTransaction: Reference<sageX3FinanceData.nodes.JournalEntryTransaction>;
	    readonly transactionCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly journalEntryLines: Collection<sageX3Finance.nodes.JournalEntryLine>;
	}
	//# sourceMappingURL=journal-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/journal-entry-line.d.ts
declare module '@sage/x3-finance/lib/nodes/journal-entry-line' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class JournalEntryLine extends Node {
	    readonly journalEntryType: Reference<sageX3FinanceData.nodes.EntryType>;
	    readonly journalEntry: Reference<sageX3Finance.nodes.JournalEntry>;
	    readonly lineNumber: Promise<integer | null>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly accountingDate: Promise<date | null>;
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly controlAccount: Promise<string>;
	    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly sign: Promise<integer | null>;
	    readonly transactionCurrency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly transactionAmount: Promise<decimal | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly ledgerAmount: Promise<decimal | null>;
	    readonly quantity: Promise<decimal | null>;
	    readonly lineDescription: Promise<string>;
	    readonly matchingCode: Promise<string>;
	    readonly matchingDate: Promise<date | null>;
	    readonly maximumMatchingDate: Promise<date | null>;
	    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
	    readonly analyticalLines: Collection<sageX3Finance.nodes.JournalEntryAnalyticalLine>;
	}
	//# sourceMappingURL=journal-entry-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/journal-entry-analytical-line.d.ts
declare module '@sage/x3-finance/lib/nodes/journal-entry-analytical-line' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class JournalEntryAnalyticalLine extends Node {
	    readonly journalEntryType: Reference<sageX3FinanceData.nodes.EntryType>;
	    readonly journalEntryLine: Reference<sageX3Finance.nodes.JournalEntry>;
	    readonly lineNumber: Promise<integer>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly analyticalLineNumber: Promise<integer | null>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly transactionAmount: Promise<decimal | null>;
	    readonly quantity: Promise<decimal | null>;
	    readonly dimensions: Collection<sageX3Finance.nodes.JournalEntryAnalyticalLineDimensions>;
	}
	//# sourceMappingURL=journal-entry-analytical-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/journal-entry-analytical-line-dimensions.d.ts
declare module '@sage/x3-finance/lib/nodes/journal-entry-analytical-line-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class JournalEntryAnalyticalLineDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly journalEntryType: Promise<string>;
	    readonly journalEntryLine: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly analyticalLineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3Finance.nodes.JournalEntryAnalyticalLine>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=journal-entry-analytical-line-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/index.d.ts
declare module '@sage/x3-finance/lib/nodes/index' {
	export * from '@sage/x3-finance/lib/nodes/analytical-balance-amounts';
	export * from '@sage/x3-finance/lib/nodes/analytical-balance-dimension-types';
	export * from '@sage/x3-finance/lib/nodes/analytical-balance';
	export * from '@sage/x3-finance/lib/nodes/balance';
	export * from '@sage/x3-finance/lib/nodes/financial-commitment';
	export * from '@sage/x3-finance/lib/nodes/journal-entry-analytical-line-dimensions';
	export * from '@sage/x3-finance/lib/nodes/journal-entry-analytical-line';
	export * from '@sage/x3-finance/lib/nodes/journal-entry-line';
	export * from '@sage/x3-finance/lib/nodes/journal-entry';
	export * from '@sage/x3-finance/lib/nodes/prepayment-invoice';
	export * from '@sage/x3-finance/lib/nodes/statement-creation';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/financial-commitment.d.ts
declare module '@sage/x3-finance/lib/nodes/financial-commitment' {
	import { Node } from '@sage/xtrem-core';
	export class FinancialCommitment extends Node {
	    readonly id: Promise<string>;
	    readonly description: Promise<string>;
	}
	//# sourceMappingURL=financial-commitment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/balance.d.ts
declare module '@sage/x3-finance/lib/nodes/balance' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	export class Balance extends Node {
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly account: Reference<sageX3FinanceData.nodes.Account>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly ledger: Reference<sageX3FinanceData.nodes.Ledger>;
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	}
	//# sourceMappingURL=balance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/analytical-balance.d.ts
declare module '@sage/x3-finance/lib/nodes/analytical-balance' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, Collection } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class AnalyticalBalance extends Node {
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly company: Reference<sageX3System.nodes.Company>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly fiscalYear: Promise<integer | null>;
	    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly dimension1: Promise<string>;
	    readonly dimension2: Promise<string>;
	    readonly dimension3: Promise<string>;
	    readonly dimension4: Promise<string>;
	    readonly dimension5: Promise<string>;
	    readonly dimension6: Promise<string>;
	    readonly dimension7: Promise<string>;
	    readonly dimension8: Promise<string>;
	    readonly dimension9: Promise<string>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly id: Promise<integer | null>;
	    readonly ledger: Reference<sageX3FinanceData.nodes.Ledger>;
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly amounts: Collection<sageX3Finance.nodes.AnalyticalBalanceAmounts>;
	    readonly dimensionTypes: Collection<sageX3Finance.nodes.AnalyticalBalanceDimensionTypes>;
	}
	//# sourceMappingURL=analytical-balance.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/analytical-balance-dimension-types.d.ts
declare module '@sage/x3-finance/lib/nodes/analytical-balance-dimension-types' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class AnalyticalBalanceDimensionTypes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly company: Promise<string>;
	    readonly site: Promise<string>;
	    readonly fiscalYear: Promise<integer>;
	    readonly account: Promise<string>;
	    readonly businessPartner: Promise<string>;
	    readonly dimension1: Promise<string>;
	    readonly dimension2: Promise<string>;
	    readonly dimension3: Promise<string>;
	    readonly dimension4: Promise<string>;
	    readonly dimension5: Promise<string>;
	    readonly dimension6: Promise<string>;
	    readonly dimension7: Promise<string>;
	    readonly dimension8: Promise<string>;
	    readonly dimension9: Promise<string>;
	    readonly currency: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Finance.nodes.AnalyticalBalance>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	}
	//# sourceMappingURL=analytical-balance-dimension-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/nodes/analytical-balance-amounts.d.ts
declare module '@sage/x3-finance/lib/nodes/analytical-balance-amounts' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class AnalyticalBalanceAmounts extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
	    readonly company: Promise<string>;
	    readonly site: Promise<string>;
	    readonly fiscalYear: Promise<integer>;
	    readonly account: Promise<string>;
	    readonly businessPartner: Promise<string>;
	    readonly dimension1: Promise<string>;
	    readonly dimension2: Promise<string>;
	    readonly dimension3: Promise<string>;
	    readonly dimension4: Promise<string>;
	    readonly dimension5: Promise<string>;
	    readonly dimension6: Promise<string>;
	    readonly dimension7: Promise<string>;
	    readonly dimension8: Promise<string>;
	    readonly dimension9: Promise<string>;
	    readonly currency: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3Finance.nodes.AnalyticalBalance>;
	    readonly debitAmountInLedgerCurrency: Promise<decimal | null>;
	    readonly creditAmountInLedgerCurrency: Promise<decimal | null>;
	    readonly debitAmountInCurrency: Promise<decimal | null>;
	    readonly creditAmountInCurrency: Promise<decimal | null>;
	}
	//# sourceMappingURL=analytical-balance-amounts.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/node-extensions/stock-journal-import-extension.d.ts
declare module '@sage/x3-finance/lib/node-extensions/stock-journal-import-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class StockJournalImportExtension extends NodeExtension<sageX3ManufacturingData.nodes.StockJournalImport> {
	    readonly journalEntryDocument: Reference<sageX3Finance.nodes.JournalEntry | null>;
	}
	declare module '@sage/x3-manufacturing-data/lib/nodes/stock-journal-import' {
	    interface StockJournalImport extends StockJournalImportExtension {
	    }
	}
	//# sourceMappingURL=stock-journal-import-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/node-extensions/stock-journal-extension.d.ts
declare module '@sage/x3-finance/lib/node-extensions/stock-journal-extension' {
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class StockJournalExtension extends NodeExtension<sageX3StockData.nodes.StockJournal> {
	    readonly journalEntryDocument: Reference<sageX3Finance.nodes.JournalEntry | null>;
	}
	declare module '@sage/x3-stock-data/lib/nodes/stock-journal' {
	    interface StockJournal extends StockJournalExtension {
	    }
	}
	//# sourceMappingURL=stock-journal-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/node-extensions/open-item-extension.d.ts
declare module '@sage/x3-finance/lib/node-extensions/open-item-extension' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3Finance from '@sage/x3-finance/lib/index';
	export class OpenItemExtension extends NodeExtension<sageX3FinanceData.nodes.OpenItem> {
	    readonly statementNumber: Reference<sageX3Finance.nodes.StatementCreation | null>;
	}
	declare module '@sage/x3-finance-data/lib/nodes/open-item' {
	    interface OpenItem extends OpenItemExtension {
	    }
	}
	//# sourceMappingURL=open-item-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-finance/lib/node-extensions/index' {
	export * from '@sage/x3-finance/lib/node-extensions/open-item-extension';
	export * from '@sage/x3-finance/lib/node-extensions/stock-journal-extension';
	export * from '@sage/x3-finance/lib/node-extensions/stock-journal-import-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-finance/build/lib/enums/index.d.ts
declare module '@sage/x3-finance/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-finance' {
	export * from '@sage/x3-finance/index';
}
