"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatementCreation = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        businessPartner: {
            code: 'businessPartner',
        },
        company: {
            code: 'company',
        },
    },
};
let StatementCreation = class StatementCreation extends xtrem_core_1.Node {
};
exports.StatementCreation = StatementCreation;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SOINUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StatementCreation.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], StatementCreation.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], StatementCreation.prototype, "company", void 0);
exports.StatementCreation = StatementCreation = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SOI',
        keyPropertyNames: ['id'],
        indexes: [
            {
                orderBy: {
                    id: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StatementCreation);
//# sourceMappingURL=statement-creation.js.map