"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournalEntryLine = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3InvoicingData = require("@sage/x3-invoicing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const joins = {
    referenceJoins: {
        journalEntryType: {
            code: 'journalEntryType',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        journalEntry: {
            journalEntryType: 'journalEntryType',
            journalEntryNumber: 'journalEntry',
        },
        site: {
            code: 'site',
        },
        chartOfAccounts: {
            code: 'chartOfAccounts',
        },
        account: {
            chartOfAccounts: 'chartOfAccounts',
            code: 'account',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        transactionCurrency: {
            code: 'transactionCurrency',
        },
        ledgerCurrency: {
            code: 'ledgerCurrency',
        },
        tax: {
            code: 'tax',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
    },
    collectionJoins: {
        analyticalLines: {
            journalEntryType: 'journalEntryType',
            journalEntryLine: 'journalEntry',
            lineNumber: 'lineNumber',
            ledgerTypeNumber: 'ledgerTypeNumber',
        },
    },
};
let JournalEntryLine = class JournalEntryLine extends xtrem_core_1.Node {
};
exports.JournalEntryLine = JournalEntryLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], JournalEntryLine.prototype, "journalEntryType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3Finance.nodes.JournalEntry,
    })
], JournalEntryLine.prototype, "journalEntry", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LIN',
    })
], JournalEntryLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], JournalEntryLine.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYLIN',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], JournalEntryLine.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], JournalEntryLine.prototype, "accountingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], JournalEntryLine.prototype, "chartOfAccounts", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SAC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntryLine.prototype, "controlAccount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Account,
    })
], JournalEntryLine.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], JournalEntryLine.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SNS',
    })
], JournalEntryLine.prototype, "sign", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], JournalEntryLine.prototype, "transactionCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTCUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], JournalEntryLine.prototype, "transactionAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURLED',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], JournalEntryLine.prototype, "ledgerCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTLED',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], JournalEntryLine.prototype, "ledgerAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], JournalEntryLine.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntryLine.prototype, "lineDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MTC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntryLine.prototype, "matchingCode", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MTCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], JournalEntryLine.prototype, "matchingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MTCDATMAX',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], JournalEntryLine.prototype, "maximumMatchingDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TAX',
        columnType: 'string',
        node: () => sageX3InvoicingData.nodes.Tax,
    })
], JournalEntryLine.prototype, "tax", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3Finance.nodes.JournalEntryAnalyticalLine,
        isMutable: true,
        dependsOn: ['journalEntryType', 'journalEntry', 'lineNumber', 'ledgerTypeNumber'],
    })
], JournalEntryLine.prototype, "analyticalLines", void 0);
exports.JournalEntryLine = JournalEntryLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCENTRYD',
        keyPropertyNames: ['journalEntryType', 'journalEntry', 'lineNumber', 'ledgerTypeNumber'],
        indexes: [
            {
                orderBy: {
                    journalEntryType: 1,
                    journalEntry: 1,
                    lineNumber: 1,
                    ledgerTypeNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['lineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], JournalEntryLine);
//# sourceMappingURL=journal-entry-line.js.map