import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3InvoicingData from '@sage/x3-invoicing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3Finance from '..';
export declare class JournalEntryLine extends Node {
    readonly journalEntryType: Reference<sageX3FinanceData.nodes.EntryType>;
    readonly journalEntry: Reference<sageX3Finance.nodes.JournalEntry>;
    readonly lineNumber: Promise<integer | null>;
    readonly ledgerTypeNumber: Promise<sageX3MasterData.enums.GeneralLedgerTypes>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly accountingDate: Promise<date | null>;
    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
    readonly controlAccount: Promise<string>;
    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
    readonly sign: Promise<integer | null>;
    readonly transactionCurrency: Reference<sageX3MasterData.nodes.Currency>;
    readonly transactionAmount: Promise<decimal | null>;
    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly ledgerAmount: Promise<decimal | null>;
    readonly quantity: Promise<decimal | null>;
    readonly lineDescription: Promise<string>;
    readonly matchingCode: Promise<string>;
    readonly matchingDate: Promise<date | null>;
    readonly maximumMatchingDate: Promise<date | null>;
    readonly tax: Reference<sageX3InvoicingData.nodes.Tax | null>;
    readonly analyticalLines: Collection<sageX3Finance.nodes.JournalEntryAnalyticalLine>;
}
//# sourceMappingURL=journal-entry-line.d.ts.map