"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournalEntryAnalyticalLine = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const joins = {
    referenceJoins: {
        journalEntryType: {
            code: 'journalEntryType',
            async legislation() {
                return (await (await (await this.site).legalCompany).legislation)?.code;
            },
        },
        journalEntryLine: {
            journalEntryType: 'journalEntryType',
            journalEntryNumber: 'journalEntryLine',
        },
        site: {
            code: 'site',
        },
    },
};
let JournalEntryAnalyticalLine = class JournalEntryAnalyticalLine extends xtrem_core_1.Node {
};
exports.JournalEntryAnalyticalLine = JournalEntryAnalyticalLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TYP',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.EntryType,
    })
], JournalEntryAnalyticalLine.prototype, "journalEntryType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'NUM',
        columnType: 'string',
        node: () => sageX3Finance.nodes.JournalEntry,
    })
], JournalEntryAnalyticalLine.prototype, "journalEntryLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LIN',
    })
], JournalEntryAnalyticalLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], JournalEntryAnalyticalLine.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ANALIN',
    })
], JournalEntryAnalyticalLine.prototype, "analyticalLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCYLIN',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], JournalEntryAnalyticalLine.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AMTCUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], JournalEntryAnalyticalLine.prototype, "transactionAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'QTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], JournalEntryAnalyticalLine.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Finance.nodes.JournalEntryAnalyticalLineDimensions,
    })
], JournalEntryAnalyticalLine.prototype, "dimensions", void 0);
exports.JournalEntryAnalyticalLine = JournalEntryAnalyticalLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCENTRYA',
        keyPropertyNames: [
            'journalEntryType',
            'journalEntryLine',
            'lineNumber',
            'ledgerTypeNumber',
            'analyticalLineNumber',
        ],
        indexes: [
            {
                orderBy: {
                    journalEntryType: 1,
                    journalEntryLine: 1,
                    lineNumber: 1,
                    ledgerTypeNumber: 1,
                    analyticalLineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['analyticalLineNumber'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], JournalEntryAnalyticalLine);
//# sourceMappingURL=journal-entry-analytical-line.js.map