"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JournalEntryAnalyticalLineDimensions = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const denormalized = { maxRepeat: 9 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            journalEntryType: 'journalEntryType',
            journalEntryLine: 'journalEntryLine',
            lineNumber: 'lineNumber',
            ledgerTypeNumber: 'ledgerTypeNumber',
            analyticalLineNumber: 'analyticalLineNumber',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
        dimension: {
            dimensionType: 'dimensionType',
            dimension: 'dimension',
        },
    },
};
let JournalEntryAnalyticalLineDimensions = class JournalEntryAnalyticalLineDimensions extends xtrem_core_1.Node {
};
exports.JournalEntryAnalyticalLineDimensions = JournalEntryAnalyticalLineDimensions;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "journalEntryType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'NUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "journalEntryLine", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LIN',
    })
], JournalEntryAnalyticalLineDimensions.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ANALIN',
    })
], JournalEntryAnalyticalLineDimensions.prototype, "analyticalLineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Finance.nodes.JournalEntryAnalyticalLine,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "dimensionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CCE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Dimension,
    })
], JournalEntryAnalyticalLineDimensions.prototype, "dimension", void 0);
exports.JournalEntryAnalyticalLineDimensions = JournalEntryAnalyticalLineDimensions = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'GACCENTRYA',
        keyPropertyNames: [
            'denormalizedIndex',
            'journalEntryType',
            'journalEntryLine',
            'lineNumber',
            'ledgerTypeNumber',
            'analyticalLineNumber',
        ],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], JournalEntryAnalyticalLineDimensions);
//# sourceMappingURL=journal-entry-analytical-line-dimensions.js.map