"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Balance = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        account: {
            chartOfAccounts: 'chartOfAccounts',
            code: 'account',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        currency: {
            code: 'currency',
        },
        ledger: {
            code: 'ledger',
        },
        chartOfAccounts: {
            code: 'chartOfAccounts',
        },
        ledgerCurrency: {
            code: 'ledgerCurrency',
        },
    },
};
let Balance = class Balance extends xtrem_core_1.Node {
};
exports.Balance = Balance;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], Balance.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], Balance.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Balance.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], Balance.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ACC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Account,
    })
], Balance.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], Balance.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Balance.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LED',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Ledger,
    })
], Balance.prototype, "ledger", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], Balance.prototype, "chartOfAccounts", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURLED',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], Balance.prototype, "ledgerCurrency", void 0);
exports.Balance = Balance = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BALANCE',
        keyPropertyNames: ['ledgerTypeNumber', 'company', 'site', 'fiscalYear', 'account', 'businessPartner', 'currency'],
        indexes: [
            {
                orderBy: {
                    ledgerTypeNumber: 1,
                    company: 1,
                    site: 1,
                    fiscalYear: 1,
                    account: 1,
                    businessPartner: 1,
                    currency: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['site', 'fiscalYear', 'businessPartner'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Balance);
//# sourceMappingURL=balance.js.map