"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyticalBalance = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const joins = {
    referenceJoins: {
        company: {
            code: 'company',
        },
        site: {
            code: 'site',
        },
        account: {
            chartOfAccounts: 'chartOfAccounts',
            code: 'account',
        },
        businessPartner: {
            code: 'businessPartner',
        },
        currency: {
            code: 'currency',
        },
        ledger: {
            code: 'ledger',
        },
        chartOfAccounts: {
            code: 'chartOfAccounts',
        },
        ledgerCurrency: {
            code: 'ledgerCurrency',
        },
    },
};
let AnalyticalBalance = class AnalyticalBalance extends xtrem_core_1.Node {
};
exports.AnalyticalBalance = AnalyticalBalance;
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], AnalyticalBalance.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPY',
        columnType: 'string',
        node: () => sageX3System.nodes.Company,
    })
], AnalyticalBalance.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], AnalyticalBalance.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'FIY',
    })
], AnalyticalBalance.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACC',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Account,
    })
], AnalyticalBalance.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BPR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.BusinessPartner,
    })
], AnalyticalBalance.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension5", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension6", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension7", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension8", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CCE9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalance.prototype, "dimension9", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], AnalyticalBalance.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ACCNUM',
    })
], AnalyticalBalance.prototype, "id", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LED',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.Ledger,
    })
], AnalyticalBalance.prototype, "ledger", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'COA',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.ChartOfAccounts,
    })
], AnalyticalBalance.prototype, "chartOfAccounts", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CURLED',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], AnalyticalBalance.prototype, "ledgerCurrency", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Finance.nodes.AnalyticalBalanceAmounts,
    })
], AnalyticalBalance.prototype, "amounts", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageX3Finance.nodes.AnalyticalBalanceDimensionTypes,
    })
], AnalyticalBalance.prototype, "dimensionTypes", void 0);
exports.AnalyticalBalance = AnalyticalBalance = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BALANA',
        keyPropertyNames: [
            'ledgerTypeNumber',
            'company',
            'site',
            'fiscalYear',
            'account',
            'businessPartner',
            'dimension1',
            'dimension2',
            'dimension3',
            'dimension4',
            'dimension5',
            'dimension6',
            'dimension7',
            'dimension8',
            'dimension9',
            'currency',
        ],
        indexes: [
            {
                orderBy: {
                    ledgerTypeNumber: 1,
                    company: 1,
                    site: 1,
                    fiscalYear: 1,
                    account: 1,
                    businessPartner: 1,
                    dimension1: 1,
                    dimension2: 1,
                    dimension3: 1,
                    dimension4: 1,
                    dimension5: 1,
                    dimension6: 1,
                    dimension7: 1,
                    dimension8: 1,
                    dimension9: 1,
                    currency: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: [
                'fiscalYear',
                'account',
                'businessPartner',
                'dimension1',
                'dimension2',
                'dimension3',
                'dimension4',
                'dimension5',
                'dimension6',
                'dimension7',
                'dimension8',
                'dimension9',
            ],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AnalyticalBalance);
//# sourceMappingURL=analytical-balance.js.map