"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AnalyticalBalanceDimensionTypes = void 0;
const sageX3FinanceData = require("@sage/x3-finance-data");
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3Finance = require("..");
const denormalized = { maxRepeat: 9 };
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            ledgerTypeNumber: 'ledgerTypeNumber',
            company: 'company',
            site: 'site',
            fiscalYear: 'fiscalYear',
            account: 'account',
            businessPartner: 'businessPartner',
            dimension1: 'dimension1',
            dimension2: 'dimension2',
            dimension3: 'dimension3',
            dimension4: 'dimension4',
            dimension5: 'dimension5',
            dimension6: 'dimension6',
            dimension7: 'dimension7',
            dimension8: 'dimension8',
            dimension9: 'dimension9',
            currency: 'currency',
        },
        dimensionType: {
            dimensionType: 'dimensionType',
        },
    },
};
let AnalyticalBalanceDimensionTypes = class AnalyticalBalanceDimensionTypes extends xtrem_core_1.Node {
};
exports.AnalyticalBalanceDimensionTypes = AnalyticalBalanceDimensionTypes;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], AnalyticalBalanceDimensionTypes.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LEDTYP',
        dataType: () => sageX3MasterData.enums.generalLedgerTypesDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "ledgerTypeNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CPY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "company", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'FCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FIY',
    })
], AnalyticalBalanceDimensionTypes.prototype, "fiscalYear", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ACC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "account", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BPR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "businessPartner", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension1", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE2',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE3',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension3", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE4',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension4", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE5',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension5", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE6',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension6", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE7',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension7", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE8',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension8", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CCE9',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimension9", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CUR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], AnalyticalBalanceDimensionTypes.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3Finance.nodes.AnalyticalBalance,
    })
], AnalyticalBalanceDimensionTypes.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DIE',
        columnType: 'string',
        node: () => sageX3FinanceData.nodes.DimensionType,
    })
], AnalyticalBalanceDimensionTypes.prototype, "dimensionType", void 0);
exports.AnalyticalBalanceDimensionTypes = AnalyticalBalanceDimensionTypes = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BALANA',
        keyPropertyNames: [
            'denormalizedIndex',
            'ledgerTypeNumber',
            'company',
            'site',
            'fiscalYear',
            'account',
            'businessPartner',
            'dimension1',
            'dimension2',
            'dimension3',
            'dimension4',
            'dimension5',
            'dimension6',
            'dimension7',
            'dimension8',
            'dimension9',
            'currency',
        ],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], AnalyticalBalanceDimensionTypes);
//# sourceMappingURL=analytical-balance-dimension-types.js.map