import { Command } from '@ckeditor/ckeditor5-core';
import { Position } from '@ckeditor/ckeditor5-engine';
import { ATTR_ALIAS, ATTR_CONTEXT_FILTER, ATTR_CONTEXT_LIST_ORDER, ATTR_CONTEXT_OBJECT_PATH, ATTR_CONTEXT_OBJECT_TYPE, } from '@sage/xtrem-shared';
import { generateQueryAlias } from '../utils';
export default class InsertRecordContext extends Command {
    get htmlCommentPlugin() {
        return this.editor.plugins.get('HtmlComment');
    }
    execute({ lookupResult, selectedItem, remapInfo, }) {
        this.editor.model.change(writer => {
            const alias = generateQueryAlias();
            const recordContextElement = writer.createElement('recordContext', {
                [ATTR_CONTEXT_OBJECT_TYPE]: selectedItem.data.type,
                [ATTR_CONTEXT_OBJECT_PATH]: remapInfo.path,
                [ATTR_CONTEXT_FILTER]: JSON.stringify(lookupResult.filters || {}),
                [ATTR_CONTEXT_LIST_ORDER]: JSON.stringify(lookupResult.orderBy || {}),
                [ATTR_ALIAS]: alias,
            });
            this.editor.model.insertObject(recordContextElement);
            const recordContextBodyElement = writer.createElement('recordContextBody');
            writer.append(recordContextBodyElement, recordContextElement);
            const recordContextFooterElement = writer.createElement('recordContextFooter');
            writer.appendElement('paragraph', recordContextBodyElement);
            writer.append(recordContextFooterElement, recordContextElement);
            this.htmlCommentPlugin.createHtmlComment(new Position(recordContextFooterElement.root, recordContextFooterElement.getPath(), 'toNext'), '{{/with}}');
            const remapInfoWithAlias = remapInfo.path.split('.');
            remapInfoWithAlias[0] = alias;
            this.htmlCommentPlugin.createHtmlComment(new Position(recordContextBodyElement.root, recordContextBodyElement.getPath(), 'toPrevious'), `{{#with ${remapInfoWithAlias.join('.')}}}`);
        });
    }
    refresh() {
        const model = this.editor.model;
        const selection = model.document.selection;
        const allowedIn = model.schema.findAllowedParent(selection.getFirstPosition(), 'recordContext');
        this.isEnabled = allowedIn !== null;
    }
}
//# sourceMappingURL=insert-record-context-command.js.map