import { View, LabelView } from '@ckeditor/ckeditor5-ui';
import { OBJECT_TYPE_GLOBAL_PROPERTIES } from '../../constants';
import { BLOCK_AGGREGATION_PROPERTY_NAME } from '@sage/xtrem-shared';
export default class PropertyTooltipView extends View {
    constructor(locale) {
        super(locale);
        this.contextView = new LabelView();
        this.typeView = new LabelView();
        this.propertyPath = new LabelView();
        this.typeView = new LabelView();
        this.childViews = this.createCollection([this.contextView, this.typeView, this.propertyPath]);
        this.setTemplate({
            tag: 'div',
            children: this.childViews,
            attributes: {
                class: 'ck-property-tooltip',
            },
        });
    }
    setPropertyInformation(localize, context, type, propertyPath) {
        const globalPropertiesLabel = localize('@sage/xtrem-document-editor/global-properties', 'Document properties');
        const isGlobalProperty = context === OBJECT_TYPE_GLOBAL_PROPERTIES;
        this.contextView.text = isGlobalProperty ? globalPropertiesLabel : context;
        this.typeView.text = localize('@sage/xtrem-document-editor/tooltip-data-type', 'Type: {{type}}', { type });
        this.propertyPath.text = localize('@sage/xtrem-document-editor/tooltip-data-path', 'Path: {{path}}', {
            path: propertyPath
                .replace('@root.', '')
                .replace('#', '')
                .replace(`${BLOCK_AGGREGATION_PROPERTY_NAME}.`, ''),
        });
    }
}
//# sourceMappingURL=property-tooltip-view.js.map