import * as React from 'react';
import { ButtonToggle, ButtonToggleGroup } from 'carbon-react/esm/components/button-toggle';
import { useQueryTableCellPropertyCommand } from './use-table-cell-property-command';
import { GridColumn } from '@sage/xtrem-ui-components';
export function VerticalCellAlignment({ title, editor, commandName, tableUtilsPluginConstructor, localize, isEnabled, }) {
    const { value, onChange } = useQueryTableCellPropertyCommand({
        commandName,
        editor,
        tableUtilsPluginConstructor,
        defaultValue: 'top',
    });
    const onSelectChange = React.useCallback((_ev, alignment) => {
        onChange(alignment);
    }, [onChange]);
    if (!isEnabled || !editor) {
        return null;
    }
    return (React.createElement(GridColumn, { columnSpan: 4 },
        React.createElement(ButtonToggleGroup, { id: "button-toggle-group-id", label: title, value: value, onChange: onSelectChange, "data-testid": `control-vertical-alignment-${commandName}` },
            React.createElement(ButtonToggle, { value: "top", grouped: true }, localize('@sage/xtrem-document-editor/horizontal-vertical-top', 'Top')),
            React.createElement(ButtonToggle, { value: "middle", grouped: true }, localize('@sage/xtrem-document-editor/horizontal-vertical-middle', 'Middle')),
            React.createElement(ButtonToggle, { value: "bottom", grouped: true }, localize('@sage/xtrem-document-editor/horizontal-vertical-bottom', 'Bottom')))));
}
//# sourceMappingURL=vertical-alignment.js.map