import * as React from 'react';
export const useQueryTableRowPropertyCommand = ({ commandName, editor, tableUtilsPluginConstructor, defaultValue = false, attrName, }) => {
    const [value, setValue] = React.useState(defaultValue);
    const onEditorChange = React.useCallback(() => {
        const tableUtils = editor?.plugins.get(tableUtilsPluginConstructor);
        if (editor) {
            const selectedTableRows = tableUtils?.getSelectionAffectedTableRows(editor.model.document.selection);
            if (selectedTableRows?.[0]) {
                const currentValue = selectedTableRows[0].getAttribute(attrName);
                if (currentValue !== value) {
                    setValue(currentValue || defaultValue);
                }
            }
        }
    }, [editor, attrName, value, tableUtilsPluginConstructor, defaultValue]);
    React.useEffect(() => {
        onEditorChange();
        editor?.model.document.on('change', onEditorChange);
        return () => {
            editor?.model.document.off('change', onEditorChange);
        };
    }, [editor, commandName, onEditorChange]);
    const onChange = React.useCallback((changeValue) => {
        setValue(changeValue);
        editor?.execute(commandName, { value: changeValue });
    }, [editor, commandName]);
    return { value, onChange };
};
//# sourceMappingURL=use-table-row-attr-command.js.map